<?php
// Load WordPress environment safely
require_once dirname(__FILE__) . '/index.php';
require_once dirname(__FILE__) . '/wps-score-helpers.php';

class WPSScoreFieldSetJob
{

    public function __construct()
    {

        // Check & acquire lock
        if (! wp_job_lock()) {
            echo "already running";
            return; // already running
        }

        try {
            // Call core function ONLY after lock
            $this->setWPSScoreFields();
        } finally {
            // Always release lock
            wp_job_unlock();
        }
    }

    /**
     * Main process — updates active_installs in cron_scraped_plugins_log
     */
    private function setWPSScoreFields()
    {
        global $wpdb;
        $plugin_metric_settings = get_option('plugin_metric_settings');
        //dd(WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "business_fit_woocommerce_support"));
        //exit;
        $table_scraped = $wpdb->prefix . "cron_scraped_plugins_log";
        $table_core    = $wpdb->prefix . "plugins_core_information";

        // 1️⃣ Fetch 50 plugins with JOIN (exactly like your SQL)
        $wps_score_field_plugins = $wpdb->get_results("
        SELECT l.plugin_slug, p.*
        FROM {$table_scraped} AS l
        INNER JOIN {$table_core} AS p
                ON p.slug = l.plugin_slug
        WHERE l.is_wps_score_field_set = 1
        AND l.is_wps_score_calculated = 0
        AND p.is_wps_metric_group_done = 1
        LIMIT 100
    ");
        //dd($wps_score_field_plugins);
        //exit;
        // 2️⃣ Process each result
        if (! empty($wps_score_field_plugins)) {

            foreach ($wps_score_field_plugins as $plugin) {
                if (empty($plugin->wps_metric_group_info)) {
                    continue;
                }

                $scores[] = $plugin->wps_active_install_score;
                $scores[] = $plugin->wps_installation_growth_score;
                $scores[] = $plugin->wps_update_recency_score;
                $scores[] = $plugin->wps_update_frequency_score;
                $scores[] = $plugin->wps_compatibility_with_latest_wp_score;
                $scores[] = $plugin->wps_support_responsiveness_score;
                $scores[] = $plugin->wps_average_rating_score;
                $scores[] = $plugin->wps_number_of_ratings_score;
                $scores[] = $plugin->wps_maturity_score;
                $scores[] = $plugin->wps_license_score;
                $scores[] = $plugin->wps_has_lifetime_license_score;
                $scores[] = $plugin->wps_woocommerce_support_score;
                $scores[] = $plugin->wps_agency_license_score;
                $scores[] = $plugin->wps_performance_impact_score;
                $scores[] = $plugin->wps_php_version_support_score;
                $scores[] = $plugin->wps_multisite_support_score;
                $scores[] = $plugin->wps_localization_languages_score;
                $scores[] = $plugin->wps_developer_reputation_score;
                $scores[] = $plugin->wps_documentation_quality_score;
                $scores[] = $plugin->wps_youtube_tutorials_score;
                $scores[] = $plugin->wps_community_page_score;

                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "core_performance_active_installs");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "core_performance_installation_growth");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "core_performance_update_recency");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "core_performance_update_frequency");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "core_performance_wp_compatibility");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "core_performance_support_responsiveness");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "core_performance_average_rating");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "core_performance_number_of_ratings");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "core_performance_plugin_age_maturity");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "business_fit_pricing_model");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "business_fit_lifetime_license");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "business_fit_woocommerce_support");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "business_fit_agency_license");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "ux_technical_performance_impact");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "ux_technical_php_version");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "ux_technical_multisite_support");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "ux_technical_localization");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "social_proof_developer_reputation");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "social_proof_documentation_quality");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "social_proof_youtube_tutorials");
                $weights[] = WPS_score_helpers::get_weight_by_attribute($plugin_metric_settings, "social_proof_community_presence");

                //WPS_score_helpers::weighted_score_1_to_10
                $wpdb->update(
                    $table_core,
                    [
                        'overall_wpscore' => WPS_score_helpers::weighted_score_1_to_10($scores, $weights),
                    ],
                    ['id' => $plugin->id],
                );

                $wpdb->update(
                    $table_scraped,
                    [
                        'is_wps_score_calculated' => 1,
                    ],
                    ['plugin_slug' => $plugin->slug],
                );
            }
        } else {
            echo "NO Plugin Found";
        }

        update_option('wps_score_set_job_last_run', current_time('mysql'), false);

    }

}

// Instantiate the class
new WPSScoreFieldSetJob();
