<?php
// Load WordPress environment safely
require_once dirname(__FILE__) . '/index.php';
require_once dirname(__FILE__) . '/wps-score-helpers.php';

class WPSScoreFieldSetJob
{

    public function __construct()
    {

        // Check & acquire lock
        if (! wp_job_lock()) {
            echo "already running";
            return; // already running
        }

        try {
            // Call core function ONLY after lock
            $this->setWPSScoreFields();
        } finally {
            // Always release lock
            wp_job_unlock();
        }
    }

    /**
     * Main process — updates active_installs in cron_scraped_plugins_log
     */
    private function setWPSScoreFields()
    {
        global $wpdb;
        $wp_latest_version = WPS_score_helpers::get_latest_wordpress_version();
        $table_scraped     = $wpdb->prefix . "cron_scraped_plugins_log";
        $table_core        = $wpdb->prefix . "plugins_core_information";

        // 1️⃣ Fetch 50 plugins with JOIN (exactly like your SQL)
        $wps_score_field_plugins = $wpdb->get_results("
        SELECT l.plugin_slug, p.*
        FROM {$table_scraped} AS l
        INNER JOIN {$table_core} AS p
                ON p.slug = l.plugin_slug
        WHERE l.is_wps_score_field_set = 0
        AND p.is_wps_metric_group_done = 1
        LIMIT 100
    ");
        //dd($wps_score_field_plugins);
        //exit;
        // 2️⃣ Process each result
        if (! empty($wps_score_field_plugins)) {

            foreach ($wps_score_field_plugins as $plugin) {
                if (empty($plugin->wps_metric_group_info)) {
                    continue;
                }

                $wps_metric_group_info_json_t_array = json_decode($plugin->wps_metric_group_info, true);
                //dd($wps_metric_group_info_json_t_array);

                //metric_with_avg_max_min
                $wps_installation_growth_score = WPS_score_helpers::metric_with_avg_max_min($wps_metric_group_info_json_t_array['installation_growth']['min'], $wps_metric_group_info_json_t_array['installation_growth']['max'], $wps_metric_group_info_json_t_array['installation_growth']['avg'], WPS_score_helpers::calculateRMSGrowthDownloaded($plugin->installation_growth));

                //metric_with_avg_max_min
                $wps_update_recency_score = WPS_score_helpers::metric_with_avg_max_min($wps_metric_group_info_json_t_array['update_regency']['min'], $wps_metric_group_info_json_t_array['update_regency']['max'], $wps_metric_group_info_json_t_array['update_regency']['avg'], $plugin->last_update_days, true);

                //metric_with_avg_max_min
                $wps_update_frequency_score = WPS_score_helpers::metric_with_avg_max_min($wps_metric_group_info_json_t_array['update_frequency']['min'], $wps_metric_group_info_json_t_array['update_frequency']['max'], $wps_metric_group_info_json_t_array['update_frequency']['avg'], $plugin->version_release_count);

                $wps_compatibility_with_latest_wp_score = WPS_score_helpers::get_floating_score_by_key_value_count_compare_with_key($wps_metric_group_info_json_t_array['wp_compatibility'], ($plugin->tested == $wp_latest_version) ? 1 : 0);

                //metric_with_avg_max_min
                $wps_support_responsiveness_score = WPS_score_helpers::metric_with_avg_max_min($wps_metric_group_info_json_t_array['support_resolved_score']['min'], $wps_metric_group_info_json_t_array['support_resolved_score']['max'], $wps_metric_group_info_json_t_array['support_resolved_score']['avg'], WPS_score_helpers::calculate_support_responsiveness(
                    $plugin->support_threads,
                    $plugin->support_threads_resolved
                ));

                $wps_average_rating_score = WPS_score_helpers::percent_to_rating_10($plugin->rating);

                //metric_with_avg_max_min
                $wps_number_of_ratings_score = WPS_score_helpers::metric_with_avg_max_min($wps_metric_group_info_json_t_array['ratings_count']['min'], $wps_metric_group_info_json_t_array['ratings_count']['max'], $wps_metric_group_info_json_t_array['ratings_count']['avg'], $plugin->num_ratings);

                //metric_with_avg_max_min
                $wps_maturity_score = WPS_score_helpers::metric_with_avg_max_min($wps_metric_group_info_json_t_array['plugin_age']['min'], $wps_metric_group_info_json_t_array['plugin_age']['max'], $wps_metric_group_info_json_t_array['plugin_age']['avg'], $plugin->plugin_age_days);

                //get_floating_score_by_key_value_count_compare_with_key
                $wps_license_score = WPS_score_helpers::get_floating_score_by_key_value_count_compare_with_key($wps_metric_group_info_json_t_array['license_type'], $plugin->license_type);

                //get_floating_score_by_key_value_count_compare_with_key
                $wps_has_lifetime_license_score = WPS_score_helpers::get_floating_score_by_key_value_count_compare_with_key($wps_metric_group_info_json_t_array['lifetime_license'], $plugin->has_lifetime_license);

                //metric_with_avg_max_min
                $wps_php_version_support_score = WPS_score_helpers::metric_with_avg_max_min($wps_metric_group_info_json_t_array['required_php']['min'], $wps_metric_group_info_json_t_array['required_php']['max'], $wps_metric_group_info_json_t_array['required_php']['avg'], WPS_score_helpers::count_supported_php_versions(empty(trim($plugin->requires_php)) ? null : $plugin->requires_php));

                //metric_with_avg_max_min
                $wps_localization_languages_score = WPS_score_helpers::metric_with_avg_max_min($wps_metric_group_info_json_t_array['localization_count']['min'], $wps_metric_group_info_json_t_array['localization_count']['max'], $wps_metric_group_info_json_t_array['localization_count']['avg'], $plugin->localization_count);

                //metric_with_avg_max_min
                $wps_active_install_score = WPS_score_helpers::average_floats(WPS_score_helpers::metric_with_avg_max_min($wps_metric_group_info_json_t_array['active_installs']['min'], $wps_metric_group_info_json_t_array['active_installs']['max'], $wps_metric_group_info_json_t_array['active_installs']['avg'], $plugin->active_installs), WPS_score_helpers::metric_with_avg_max_min($wps_metric_group_info_json_t_array['downloaded']['min'], $wps_metric_group_info_json_t_array['downloaded']['max'], $wps_metric_group_info_json_t_array['downloaded']['avg'], $plugin->downloaded));

                //get_floating_score_by_key_value_count_compare_with_key
                $wps_youtube_tutorials_score = WPS_score_helpers::get_floating_score_by_key_value_count_compare_with_key($wps_metric_group_info_json_t_array['youtube_tutorials'], (! empty($plugin->best_youtube_tutorials_link) ? 1 : 0));

                //get_floating_score_by_key_value_count_compare_with_key
                $wps_community_page_score = WPS_score_helpers::get_floating_score_by_key_value_count_compare_with_key($wps_metric_group_info_json_t_array['community_page_present'], (! empty($plugin->community_page_link) ? 1 : 0));

                //get_floating_score_by_key_value_count_compare_with_key
                $wps_agency_license_score = WPS_score_helpers::get_floating_score_by_key_value_count_compare_with_key($wps_metric_group_info_json_t_array['agency_license'], $plugin->has_agency_friendly_license);

                //get_floating_score_by_key_value_count_compare_with_key
                $wps_woocommerce_support_score = WPS_score_helpers::get_floating_score_by_key_value_count_compare_with_key($wps_metric_group_info_json_t_array['woocommerce_support'], $plugin->woocommerce_support);

                //get_floating_score_by_key_value_count_compare_with_key
                $wps_multisite_support_score = WPS_score_helpers::get_floating_score_by_key_value_count_compare_with_key($wps_metric_group_info_json_t_array['multisite_support'], $plugin->is_multisite_support);

                //metric_with_avg_max_min
                $performance_package_size_kb = WPS_score_helpers::metric_with_avg_max_min($wps_metric_group_info_json_t_array['performance_package_size_kb']['min'], $wps_metric_group_info_json_t_array['performance_package_size_kb']['max'], $wps_metric_group_info_json_t_array['performance_package_size_kb']['avg'], $plugin->package_size_kb);

                //metric_with_avg_max_min
                $performance_avg_rating = WPS_score_helpers::metric_with_avg_max_min($wps_metric_group_info_json_t_array['performance_avg_rating']['min'], $wps_metric_group_info_json_t_array['performance_avg_rating']['max'], $wps_metric_group_info_json_t_array['performance_avg_rating']['avg'], $plugin->rating);

                $wps_performance_impact_score = WPS_score_helpers::average_floats($performance_package_size_kb, $performance_avg_rating, $wps_active_install_score);

                $wps_developer_reputation_score = (float) WPS_score_helpers::get_the_reputation_score($plugin->author_profile);

                $performance_impact = WPS_score_helpers::score_to_performance_level_enum($wps_performance_impact_score);

                $user_review_sentiment = WPS_score_helpers::weighted_score_to_sentiment(json_decode($plugin->plugin_ratings_json, true));

                $support_quality = WPS_score_helpers::support_quality_enum($plugin->support_threads, $plugin->support_threads_resolved);

                // dd("wps_installation_growth_score " . $wps_installation_growth_score);
                // dd("wps_update_recency_score " . $wps_update_recency_score);
                // dd("wps_update_frequency_score " . $wps_update_frequency_score);
                // dd("wps_compatibility_with_latest_wp_score " . $wps_compatibility_with_latest_wp_score);
                // dd("wps_support_responsiveness_score " . $wps_support_responsiveness_score);
                // dd("wps_average_rating_score " . $wps_average_rating_score);
                // dd("wps_number_of_ratings_score " . $wps_number_of_ratings_score);
                // dd("wps_maturity_score " . $wps_maturity_score);
                // dd("wps_license_score " . $wps_license_score);
                // dd("wps_has_lifetime_license_score " . $wps_has_lifetime_license_score);
                // dd("wps_php_version_support_score " . $wps_php_version_support_score);
                // dd("wps_localization_languages_score " . $wps_localization_languages_score);
                // dd("wps_active_install_score " . $wps_active_install_score);
                // dd("wps_youtube_tutorials_score " . $wps_youtube_tutorials_score);

                // dd("wps_community_page_score " . $wps_community_page_score);
                // dd("wps_agency_license_score " . $wps_agency_license_score);
                // dd("wps_woocommerce_support_score " . $wps_woocommerce_support_score);
                // dd("wps_multisite_support_score " . $wps_multisite_support_score);
                // dd("wps_performance_impact_score " . $wps_performance_impact_score);
                // dd("performance_impact " . $performance_impact);
                // dd("wps_developer_reputation_score " . $wps_developer_reputation_score);

                // dd("user_review_sentiment " . $user_review_sentiment);
                // dd("support_quality " . $support_quality);
                // dd(WPS_score_helpers::score_to_performance_level_enum($wps_performance_impact_score));
                //exit;

                $wpdb->update(
                    $table_core,
                    [
                        'wps_installation_growth_score'          => $wps_installation_growth_score,
                        'wps_update_recency_score'               => $wps_update_recency_score,
                        'wps_update_frequency_score'             => $wps_update_frequency_score,
                        'wps_compatibility_with_latest_wp_score' => $wps_compatibility_with_latest_wp_score,
                        'wps_support_responsiveness_score'       => $wps_support_responsiveness_score,
                        'wps_average_rating_score'               => $wps_average_rating_score,
                        'wps_number_of_ratings_score'            => $wps_number_of_ratings_score,
                        'wps_maturity_score'                     => $wps_maturity_score,
                        'wps_license_score'                      => $wps_license_score,
                        'wps_has_lifetime_license_score'         => $wps_has_lifetime_license_score,
                        'wps_php_version_support_score'          => $wps_php_version_support_score,
                        'wps_localization_languages_score'       => $wps_localization_languages_score,
                        'wps_active_install_score'               => $wps_active_install_score,
                        'wps_youtube_tutorials_score'            => $wps_youtube_tutorials_score,
                        'wps_community_page_score'               => $wps_community_page_score,
                        'wps_agency_license_score'               => $wps_agency_license_score,
                        'wps_woocommerce_support_score'          => $wps_woocommerce_support_score,
                        'wps_developer_reputation_score'         => round(($wps_developer_reputation_score == 0 ? 1.5 : (float) $wps_developer_reputation_score), 2),
                        'wps_performance_impact_score'           => $wps_performance_impact_score,
                        'performance_impact'                     => (string) $performance_impact,
                        'user_review_sentiment'                  => (string) $user_review_sentiment,
                        'support_quality'                        => (string) $support_quality,
                        'documentation_quality'                  => (string) $performance_impact,
                        'wps_documentation_quality_score'        => $wps_performance_impact_score,
                        'wps_multisite_support_score'            => $wps_multisite_support_score,
                    ],
                    ['id' => $plugin->id],
                );

                $wpdb->update(
                    $table_scraped,
                    [
                        'is_wps_score_field_set' => 1,
                    ],
                    ['plugin_slug' => $plugin->slug],
                );
            }
        } else {
            echo "NO Plugin Found";
        }

        update_option('wps_score_field_set_job_last_run', current_time('mysql'), false);

    }

}

// Instantiate the class
new WPSScoreFieldSetJob();
