<?php
require_once( dirname(__FILE__) . '/index.php' );
class WpPluginDirectoryJSONSeeding
{
    private $base_url = "https://api.wordpress.org/plugins/info/1.2/?action=query_plugins";

    public function __construct()
    {
        // Initialize object properties
        $this->seedingWPOrgPluginJSON();
    }

    private function seedingWPOrgPluginJSON()
    {
        global $wpdb;
        $table_name = $wpdb->prefix."cron_page_visits_log";
        for ($i = 1; $i <= total_pages_wp_org_plugin_api; $i++) {
            $plugin_list_end_point = $this->base_url . "&request[per_page]=" . per_page_wp_org_plugin_api . "&request[page]=" . (int) $i;
            $existing_record = $wpdb->get_row($wpdb->prepare(
                "SELECT * FROM $table_name WHERE endpoint = %s",
                $plugin_list_end_point
            ));

            if ($existing_record) {
                continue;
            } else {
                // Endpoint doesn't exist, insert a new record
                $wpdb->insert(
                    $table_name,
                    [
                        'endpoint' => $plugin_list_end_point,
                        'page_number' => $i,
                        'per_page' => per_page_wp_org_plugin_api,
                    ],
                    [
                        '%s', // endpoint
                        '%d', // page_number
                        '%d', // per_page
                    ]
                );
            }

        }
    }
}

new WpPluginDirectoryJSONSeeding();