<?php
require_once dirname(__FILE__) . '/index.php';

class WpPluginAIDataModificationRecreate
{

    public function __construct()
    {
        if (!new_post_publishing) {
            echo "No plan to Generate New post so no new AI call";
            return; // already running
        }
        // Check & acquire lock
        if (!wp_job_lock()) {
            echo "already running";
            return; // already running
        }

        try {
            // Call core function ONLY after lock
            $this->WpPluginAIDataManagementRecreate();
        } finally {
            // Always release lock
            wp_job_unlock();
        }
    }

    /**
     * Main process — updates active_installs in cron_scraped_plugins_log
     */
    private function WpPluginAIDataManagementRecreate()
    {
        global $wpdb;

        $tbl_plugins_core_information = $wpdb->prefix . "plugins_core_information";
        $category_json = file_get_contents(dirname(__FILE__) . '/possible_category.json');
        // ✅ Job start time
        update_option('wp_plugin_ai_description_recreate_job_last_run', current_time('mysql'), false);

        $plugins_core_information = $wpdb->get_results("
        SELECT
            *
        FROM {$tbl_plugins_core_information}
        WHERE

             is_api_crawled = 1
            AND is_web_crawled = 1
            AND is_ai_long_description_done = 1
            AND is_ai_meta_keywords_done = 1
            AND is_ai_tax_category_done = 1
            AND is_ai_short_description_done = 1
            AND is_recreate_ai_post = 1
        LIMIT 25
    ");

        if (empty($plugins_core_information)) {
            echo "No Plugins found.\n";
            return;
        }

        foreach ($plugins_core_information as $single_plugin_information) {
            //dd($single_plugin_information);
            // $plugin_tags = !empty($single_plugin_information->plugin_tags)
            //     ? explode(',', $single_plugin_information->plugin_tags)
            //     : [];
            $plugin_tags = !empty($single_plugin_information->plugin_tags)
                ? $single_plugin_information->plugin_tags
                : null;

            $get_open_ai_filter_data = $this->get_open_ai_filter_data(
                $single_plugin_information->id,
                $single_plugin_information->short_description,
                $single_plugin_information->description,
                $plugin_tags,
                $category_json,
                $single_plugin_information->name,
                $single_plugin_information->slug
            );
            //dd($get_open_ai_filter_data );
            if (!$get_open_ai_filter_data) {
                continue;
            }

            $json_parsed_data = json_decode($get_open_ai_filter_data, true);
            if (!$json_parsed_data) {
                continue;
            }

            $category_data = [];
            if (!empty($json_parsed_data["category"])) {
                $category_data['category'] = $json_parsed_data["category"];
            }
            if (!empty($json_parsed_data["subcategories"])) {
                $category_data['subcategories'] = implode(',', $json_parsed_data["subcategories"]);
            }

            if (!empty($single_plugin_information->wp_post_id)) {
                wp_delete_post($single_plugin_information->wp_post_id, true);
            }

            $wpdb->update(
                $tbl_plugins_core_information,
                [
                    'plugin_feature_meta_key_word_ai' => implode(',', $json_parsed_data["meta_keywords"]),
                    'plugin_open_ai_long_description' => $json_parsed_data["long_description_html"],
                    'plugin_open_ai_short_description' => $json_parsed_data["short_description"],
                    'plugin_open_ai_category' => $category_data ? json_encode($category_data) : null, // ✅ json_encode fix
                    'plugin_docs_link' => $json_parsed_data["plugin_documentation_link"],
                    'plugin_pro_version_link' => $json_parsed_data["plugin_pro_version_link"],
                    'plugin_live_demo_link' => $json_parsed_data['plugin_live_demo_link'],
                    'license_type' => $json_parsed_data["license_type"],
                    'is_multisite_support' => $json_parsed_data["is_multisite_support"],
                    'woocommerce_support' => $json_parsed_data["woocommerce_support"],
                    'is_ai_short_description_done' => 1,
                    'is_ai_long_description_done' => 1,
                    'is_ai_meta_keywords_done' => 1,
                    'is_ai_tax_category_done' => 1,
                    'is_recreate_ai_post' => 0,
                    'is_wp_post_created' => 0,
                    'wp_post_id' => 0,
                ],
                ['id' => $single_plugin_information->id],
                [
                    '%s', // plugin_feature_meta_key_word_ai
                    '%s', // plugin_open_ai_long_description
                    '%s', // plugin_open_ai_short_description
                    '%s', // plugin_open_ai_category (JSON)
                    '%s', // plugin_docs_link
                    '%s', // plugin_pro_version_link
                    '%s', // plugin_live_demo_link
                    '%s', // license_type (ENUM string)
                    '%s', // is_multisite_support
                    '%s', // woocommerce_support
                    '%d', // is_ai_short_description_done
                    '%d', // is_ai_long_description_done
                    '%d', // is_ai_meta_keywords_done
                    '%d', // is_ai_tax_category_done
                    '%d', // is_recreate_ai_post
                    '%d', // is_wp_post_created
                    '%d', // wp_post_id
                ],
                ['%d']
            );

        }

        // ✅ Job end time
        update_option('wp_plugin_ai_description_recreate_job_last_run', current_time('mysql'), false);
    }
    public function get_output_structure()
    {
        $data = [
            "short_description" => "3-5 line ASCII-only summary of the plugin",
            "long_description_html" => "<p>Multiple ASCII-only HTML paragraphs...</p>",
            "meta_keywords" => ["keyword1", "keyword2", "keyword3"],
            "category" => "Main category selected from provided category list",
            "subcategories" => ["subcategory1", "subcategory2"],
            "plugin_pro_version_link" => "https://example.com",
            "plugin_live_demo_link" => "https://example.com",
            "plugin_documentation_link" => "https://example.com",
            "license_type" => "free",
            "is_multisite_support" => "1",
            "woocommerce_support" => "1",
        ];

        return json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    }
    public function get_open_ai_filter_data($id, $short_description, $plugin_description, $plugin_tags, $category_json, $name, $slug)
    {
        try {
            $OPENAI_API_KEY = YOUR_OPENAI_API_KEY;
            $API_URL = "https://api.openai.com/v1/chat/completions";

            // =====================================================
            // PROMPT WITH YOUR RULES KEPT EXACTLY AS GIVEN
            // =====================================================
            $prompt = <<<EOT
            You are an AI assistant that classifies WordPress plugins and enriches their descriptions.
            The plugin name, slug, and description should be used as primary clues for classification.

            Return ONLY one valid JSON object in the following exact structure:
            {$this->get_output_structure()}

            --------------------------------------------------
            ### LINK DISCOVERY RULES (UPDATED)
            --------------------------------------------------
            You MUST search the full plugin description for any URL that points to:

            1. Pro version / upgrade / premium page
            - Common keywords: "pro", "premium", "upgrade", "buy", "pricing", "paid version"
            - If a pro link is found → set "plugin_pro_version_link" to the URL.
            - If a pro link is found → license_type MUST automatically become "freemium".

            2. Documentation
            - Keywords: "docs", "documentation", "knowledge base", "guide"
            - If found → return the documentation URL.
            - Otherwise return null.

            3. Live demo
            - Keywords: "demo", "live preview", "try it"
            - If found → return the demo URL.
            - Otherwise return null.

            Important:
            - Extract ONLY URLs that appear inside the plugin description or tags.
            - NEVER invent URLs.
            - If a value cannot be confidently extracted → return null.

            --------------------------------------------------
            ### LICENSE TYPE RULES (UPDATED)
            --------------------------------------------------
            license_type rules:
            - If a pro version link is found → "freemium".
            - If text explicitly states the plugin is paid → "paid".
            - If text explicitly states the plugin is free → "free".
            - If unclear → free.

            is_multisite_support:
            - "1" if explicitly supports multisite.
            - "2" if explicitly says NOT multisite-compatible.
            - Default = "1" if unclear.

            --------------------------------------------------
            ### WOOCOMMERCE SUPPORT RULES (NEW)
            --------------------------------------------------
            woocommerce_support:
            - "1" if the plugin description contains ANY wording indicating WooCommerce support or integration.
            Keywords include: "woocommerce", "woo commerce", "wc",
            "woocommerce plugin", "woocommerce integration",
            "woocommerce compatible", "woocommerce addon".
            - "3" if no WooCommerce-related wording is found in the description.
            - NEVER guess WooCommerce support; it must come from actual text content.

            --------------------------------------------------
            ### META & STRUCTURE RULES (UPDATED)
            --------------------------------------------------
            - meta_keywords must be an array of ASCII-only keyword phrases.
            - Keywords must come ONLY from the plugin’s own content:
            - plugin tags
            - short description
            - full description
            - Do NOT invent new keywords not found or strongly implied in the plugin text.
            - Do NOT add generic keywords such as "WordPress plugin", "website plugin", "plugin tools", or any general terms that do not appear in the plugin content.
            - Only include keywords that clearly reflect the plugin’s real functionality.
            - If the relevance of a keyword cannot be confirmed from the plugin’s tags or description, DO NOT include it.
            - Multi-word keywords are allowed.
            - Capitalize ONLY the first letter of the entire keyword phrase unless it begins with a well-known acronym (SMS, API, SEO, SMTP, CRM, ERP). Acronyms must remain fully uppercase.
            Examples:
            - "email delivery" → "Email delivery"
            - "wordpress smtp" → "WordPress smtp"
            - "sms notification" → "SMS notification"
            - "api integration" → "API integration"
            - Do NOT convert full phrases to Title Case.
            - Preserve proper names with correct capitalization (WordPress, WooCommerce, SMTP, API).
            - JSON must match the output structure exactly.



            ==================================================
            ### CATEGORY SELECTION RULES (IMPORTANT)
            ==================================================
            1. You MUST select *exactly ONE main parent category* from the provided category list.
            2. After choosing the parent category:
            - Choose *one or more subcategories ONLY from that parent's subcategory list*.
            3. *NEVER mix*:
            - a parent category from one group
            - with subcategories belonging to another parent.
            4. If a plugin matches several parents, choose the *most relevant one*, but still return only ONE.
            5. Do NOT invent any new category or subcategory.

            ==================================================
            ### ADDITIONAL CLASSIFICATION INSTRUCTIONS (NEW)
            ==================================================
            - *Use the plugin name and slug as strong indicators* to determine the main category.
            - For example, a plugin named WP Mail SMTP is likely related to *SMTP functionality* or *email marketing. Do not categorize it as WooCommerce or Business unless its description suggests so.
            - If the plugin's name or slug suggests a primary function (e.g., "SEO," "SMS," "payment gateway"), *rely on that*.
            - The description can be used to *fine-tune* the categorization but do not override the name and slug unless it explicitly suggests a different function.

            ==================================================
            ### OUTPUT FORMAT RULES
            ==================================================
            - Output MUST be *pure JSON only*.
            - No markdown, no code fences, no comments.
            - JSON MUST be valid, UTF-8, and parsable.

            ==================================================
            ### HTML RULES (UPDATED)
            ==================================================
            For "long_description_html":
            - Completely IGNORE any HTML tags found in the original plugin description.
            - DO NOT copy, reuse, or transform existing HTML from the input.
            - Write a new, clean long description using simple, plain ASCII sentences.
            - Break the content into multiple paragraphs, each wrapped in <p>...</p>.
            - Do not use any HTML formatting other than <p> tags.
            - No Unicode quotes.
            - No smart apostrophes.
            - No em-dash, en-dash, or any Unicode dash characters (—, –, \u2013, \u2014, etc.).
            - Replace ALL dash-like characters with a normal hyphen "-".
            - No markdown, no backticks, no inline CSS, no scripts.

            The final HTML must be:
            <p>First paragraph of ASCII text...</p>
            <p>Second paragraph of ASCII text...</p>
            <p>Third paragraph of ASCII text...</p>

            Each paragraph must contain only human-readable ASCII text.

            ==================================================
            ### ENCODING RULES
            ==================================================
            - Normalize all text to pure ASCII.
            - Do not output escape sequences like \u2013.
            - JSON must be returned unescaped and human-friendly.

            ==================================================
            ### CATEGORY JSON (REFERENCE)
            ==================================================
            {$category_json}

            ==================================================
            ### PLUGIN INPUT DATA
            ==================================================
            Plugin Name: "{$name}"
            Plugin Slug: "{$slug}"
            Short Description: "{$short_description}"
            Full Description: "{$plugin_description}"
            Tags: "{$plugin_tags}"

            ==================================================
            ### FINAL INSTRUCTION
            ==================================================
            Return ONLY the JSON object. No explanation, no comments, no extra text outside JSON.
            EOT;
            // dd($plugin_description);
            // exit;
            // -----------------------------------
            // API PAYLOAD
            // -----------------------------------
            $payload = [
                "model" => "gpt-4o-mini",
                "messages" => [
                    ["role" => "user", "content" => $prompt],
                ],
                "temperature" => 0.4,
                "response_format" => ["type" => "text"],
            ];

            // -----------------------------------
            // CURL REQUEST
            // -----------------------------------
            $ch = curl_init($API_URL);
            curl_setopt_array($ch, [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POST => true,
                CURLOPT_HTTPHEADER => [
                    "Content-Type: application/json",
                    "Authorization: " . "Bearer " . $OPENAI_API_KEY,
                ],
                CURLOPT_POSTFIELDS => json_encode($payload),
            ]);

            $response = curl_exec($ch);

            if (curl_errno($ch)) {
                throw new Exception('cURL Error: ' . curl_error($ch));
            }

            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if ($http_code < 200 || $http_code >= 300) {
                throw new Exception("API request failed with status code {$http_code}. Response: {$response}");
            }

            // -----------------------------------
            // PARSE RESPONSE
            // -----------------------------------
            $data = json_decode($response, true);

            if (json_last_error() !== JSON_ERROR_NONE) {
                throw new Exception('Invalid JSON response from OpenAI.');
            }

            $content = $data['choices'][0]['message']['content'] ?? '';

            // Extract JSON object only
            if (preg_match('/\{.*\}/s', $content, $match)) {
                $content = $match[0];
            }

            $json_output = json_decode($content, true);

            if (!$json_output) {
                throw new Exception('Failed to parse AI JSON output.');
            }

            return json_encode($json_output, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

        } catch (Exception $e) {
            error_log("ChatGPT Error: " . $e->getMessage());

            if (isset($response)) {
                $this->enc_save_error($id, $response);
            }

            return false;
        }
    }

    public function enc_save_error($id, $error_content)
    {
        global $wpdb;
        $plugins_core_information_log = $wpdb->prefix . 'plugins_core_information';

        $info = [
            'error_log_open_ai' => $error_content,
        ];
        $where_condition = [
            'id' => $id,
        ];
        $wpdb->update($plugins_core_information_log, $info, $where_condition);
    }

}

// Instantiate the class
new WpPluginAIDataModificationRecreate();
