<?php
// Database connection settings
$host = "localhost";  // Database host (use localhost for local setups)
$username = "root";  // Your MySQL username
$password = "";  // Your MySQL password
$database = "wp-ai-search";  // Your MySQL database name

// Create a connection to MySQL database
$mysqli = new mysqli($host, $username, $password, $database);

// Check for any connection errors
if ($mysqli->connect_error) {
    die("Connection failed: " . $mysqli->connect_error);
}

// Query to get the database schema
$query = "
SELECT 
    TABLE_NAME, 
    COLUMN_NAME, 
    COLUMN_TYPE, 
    IS_NULLABLE, 
    COLUMN_DEFAULT, 
    CHARACTER_MAXIMUM_LENGTH, 
    NUMERIC_PRECISION, 
    NUMERIC_SCALE 
FROM 
    INFORMATION_SCHEMA.COLUMNS
WHERE 
    TABLE_SCHEMA = '$database'
ORDER BY 
    TABLE_NAME, ORDINAL_POSITION;
";

// Execute the query and get the result
$result = $mysqli->query($query);

// Initialize an array to store the schema data
$schema_data = [];

// Process the result and organize it into JSON format
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $table = $row['TABLE_NAME'];
        $column = [
            'column'        => $row['COLUMN_NAME'],
            'type'          => $row['COLUMN_TYPE'],
            'nullable'      => $row['IS_NULLABLE'],
            'default'       => $row['COLUMN_DEFAULT'],
            'max_length'    => $row['CHARACTER_MAXIMUM_LENGTH'],
            'precision'     => $row['NUMERIC_PRECISION'],
            'scale'         => $row['NUMERIC_SCALE']
        ];

        // Organize data by table
        if (!isset($schema_data[$table])) {
            $schema_data[$table] = [];
        }
        $schema_data[$table][] = $column;
    }

    // Encode the schema data into JSON format
    header('Content-Type: application/json');
    echo json_encode($schema_data, JSON_PRETTY_PRINT);
} else {
    echo json_encode(["message" => "No schema data found."]);
}

// Close the MySQL connection
$mysqli->close();

