<?php

get_header();
$term = get_queried_object();

$category_id = $term->term_id;
$all_level = get_plugin_category_ancestors($category_id);
$sort_by_key_mapping = Helpers::sort_by_key_mapping();
$search_text = $_GET['search_text'] ?? '';
$sort_by = $_GET['sort_by'] ?? '';

$fuzzy_search_plugin_suggestions_with_category_only_post = [];
if ($search_text) {

    $fuzzy_search_plugin_suggestions_with_category_only_post = plugin_cpt_frontend_load::fuzzy_search_plugin_suggestions_with_category_only_post($search_text, $category_id);
}

$taxonomy_ids[] = $category_id;

if (!empty($search_text)) {
    $filter_from_query_param[] = [
        'field' => 'wp_post_id',
        'operator' => 'in',
        'value' => array_values(array_unique($fuzzy_search_plugin_suggestions_with_category_only_post)),
    ];
}
$sort_by_meta = [];
if ($sort_by) {
    $sort_by_meta = Helpers::sort_by_key_mapping($sort_by);
}
//Default Sorting
$order_by = [
    ['field' => 'overall_wpscore', 'direction' => 'desc'],
];
if (!empty($sort_by_meta)) {
    $order_by[] = ['field' => $sort_by_meta["field"], 'direction' => $sort_by_meta["direction"]];
    $order_by = array_reverse($order_by);
}


$overall_wpscore_plugin = (!empty($search_text) && empty($fuzzy_search_plugin_suggestions_with_category_only_post)) ? [] : plugin_cpt_frontend_load::get_plugins_with_category_id_filter($taxonomy_ids, 3, 0, $filter_from_query_param, $order_by);

$is_sponsored_plugin = (!empty($search_text) && empty($fuzzy_search_plugin_suggestions_with_category_only_post)) ? [] : plugin_cpt_frontend_load::get_plugins_with_category_id_filter($taxonomy_ids, 3, 0, $filter_from_query_param, $order_by, 'is_sponsored', 2);

//Default Sorting
$order_by = [
    ['field' => 'active_installs', 'direction' => 'desc'],
];
if (!empty($sort_by_meta)) {
    $order_by[] = ['field' => $sort_by_meta["field"], 'direction' => $sort_by_meta["direction"]];
    $order_by = array_reverse($order_by);
}
//Default Sorting
$based_on_active_install = (!empty($search_text) && empty($fuzzy_search_plugin_suggestions_with_category_only_post)) ? [] : plugin_cpt_frontend_load::get_plugins_with_category_id_filter($taxonomy_ids, 3, 0, $filter_from_query_param, $order_by);
//Default Sorting
$order_by = [
    ['field' => 'performance_impact', 'direction' => 'desc'],
];
if (!empty($sort_by_meta)) {
    $order_by[] = ['field' => $sort_by_meta["field"], 'direction' => $sort_by_meta["direction"]];
    $order_by = array_reverse($order_by);
}
$high_performace_impact = (!empty($search_text) && empty($fuzzy_search_plugin_suggestions_with_category_only_post)) ? [] : plugin_cpt_frontend_load::get_plugins_with_category_id_filter($taxonomy_ids, 3, 0, $filter_from_query_param, $order_by);

?>
<main>

    <?php
    $template = get_template_directory() . '/frontend/category-page-includes/header-part.php';

    if (file_exists($template)) {
        include $template;
    }
    ?>
    <section class="flex items-stretch h-full">
        <?php
        // $template = get_template_directory() . '/frontend/category-page-includes/sidebar-part.php';
        
        // if (file_exists($template)) {
        //     include $template;
        // }
        ?>


        <!-- Right side  -->
        <div class="flex-1">
            <?php
            if (!empty($overall_wpscore_plugin)) {
                ?>
                <div class="container">
                    <div class="py-8 space-y-3">
                        <div class="flex justify-between items-center font-bold">
                            <h4 class="w-[206px] sm:w-auto text-lg lg:text-xl leading-[120%] text-black">
                                <?php echo $overall_wpscore_plugin[0]['overall_wpscore'] ?>+ PMOS Score
                            </h4>
                            <div>
                                <a href="<?php echo Helpers::get_search_url_with_params($term->slug, "overall_wpscore", $overall_wpscore_plugin[0]['overall_wpscore']) ?>"
                                    class="group flex items-center py-[6.3px] px-4 sm:px-6 text-base leading-[160%] text-[#1A2DC9] hover:text-white hover:bg-[#1A2DC9] duration-300 space-x-2.5 border border-[#1B3CD2] rounded-full">
                                    <span>View All</span>
                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path class="group-hover:fill-white"
                                            d="M10.7814 7.33327L7.20539 3.75726L8.14819 2.81445L13.3337 7.99993L8.14819 13.1853L7.20539 12.2425L10.7814 8.6666H2.66699V7.33327H10.7814Z"
                                            fill="#1A2DC9" />
                                    </svg>
                                </a>
                            </div>
                        </div>

                        <div class="-m-3 lg:-m-4">
                            <div class="flex flex-wrap items-stretch">
                                <?php
                                foreach ($overall_wpscore_plugin as $plugin) {
                                    $single_plugin = $plugin; // rename variable for clarity
                                    $template = get_template_directory() . '/frontend/content-single-plugin.php';

                                    if (file_exists($template)) {
                                        include $template;
                                    }
                                }

                                ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
            }
            ?>

            <?php
            if (!empty($is_sponsored_plugin)) {
                ?>
                <div class="bg-[#F8F8F8]">
                    <div class="container">
                        <div class="py-8 space-y-3">
                            <div>
                                <a href=""
                                    class="group w-auto inline-flex items-center py-1 px-2 text-[10px] font-bold leading-[120%] text-[#14243B] hover:text-[#1A2DC9] hover:border-[#1A2DC9] duration-300 space-x-1 border border-[#000000] rounded-full">
                                    <svg width="12" height="12" viewBox="0 0 12 12" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path class="group-hover:fill-[#1A2DC9]"
                                            d="M6 11C3.23857 11 1 8.7614 1 6C1 3.23857 3.23857 1 6 1C8.7614 1 11 3.23857 11 6C11 8.7614 8.7614 11 6 11ZM6 10C8.20915 10 10 8.20915 10 6C10 3.79086 8.20915 2 6 2C3.79086 2 2 3.79086 2 6C2 8.20915 3.79086 10 6 10ZM6.5 5.25V7.5H7V8.5H5V7.5H5.5V6.25H5V5.25H6.5ZM6.75 4C6.75 4.41422 6.4142 4.75 6 4.75C5.5858 4.75 5.25 4.41422 5.25 4C5.25 3.58578 5.5858 3.25 6 3.25C6.4142 3.25 6.75 3.58578 6.75 4Z"
                                            fill="black" />
                                    </svg>

                                    <span>Sponsored</span>
                                </a>
                            </div>

                            <div class="-m-3 lg:-m-4">
                                <div class="flex flex-wrap items-stretch">
                                    <?php
                                    foreach ($is_sponsored_plugin as $plugin) {
                                        $single_plugin = $plugin; // rename variable for clarity
                                        $template = get_template_directory() . '/frontend/content-single-plugin.php';

                                        if (file_exists($template)) {
                                            include $template;
                                        }
                                    }

                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php
            }
            ?>

            <?php
            if (!empty($based_on_active_install)) {
                ?>
                <div class="">
                    <div class="container">
                        <div class="py-8 space-y-3">
                            <div class="flex justify-between items-center font-bold">
                                <h4 class="w-[206px] sm:w-auto text-lg lg:text-xl leading-[120%] text-black">
                                    Over
                                    <?php echo format_active_installs($based_on_active_install[max(array_keys($based_on_active_install))]["active_installs"]) ?>
                                    Installations
                                </h4>
                                <div>
                                    <a href="<?php echo Helpers::get_search_url_with_params($term->slug, "active_installs", $based_on_active_install[max(array_keys($based_on_active_install))]["active_installs"]) ?>"
                                        class="group flex items-center py-[6.3px] px-4 sm:px-6 text-base leading-[160%] text-[#1A2DC9] hover:text-white hover:bg-[#1A2DC9] duration-300 space-x-2.5 border border-[#1B3CD2] rounded-full">
                                        <span>View All</span>
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path class="group-hover:fill-white"
                                                d="M10.7814 7.33327L7.20539 3.75726L8.14819 2.81445L13.3337 7.99993L8.14819 13.1853L7.20539 12.2425L10.7814 8.6666H2.66699V7.33327H10.7814Z"
                                                fill="#1A2DC9" />
                                        </svg>
                                    </a>
                                </div>
                            </div>

                            <div class="-m-3 lg:-m-4">
                                <div class="flex flex-wrap items-stretch">
                                    <?php
                                    foreach ($based_on_active_install as $plugin) {
                                        $single_plugin = $plugin; // rename variable for clarity
                                        $template = get_template_directory() . '/frontend/content-single-plugin.php';

                                        if (file_exists($template)) {
                                            include $template;
                                        }
                                    }

                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
            }

            ?>

            <?php
            if (!empty($high_performace_impact)) {
                ?>
                <div class="">
                    <div class="container">
                        <div class="py-8 space-y-3">
                            <div class="flex justify-between items-center font-bold">
                                <h4 class="w-[206px] sm:w-auto text-lg lg:text-xl leading-[120%] text-black">
                                    High Performance Impact
                                </h4>
                                <div>
                                    <a href="<?php echo Helpers::get_search_url_with_params($term->slug, "performace_impact", "High") ?>"
                                        class="group inline-flex items-center py-[6.3px] px-4 sm:px-6 text-base leading-[160%] text-[#1A2DC9] hover:text-white hover:bg-[#1A2DC9] duration-300 space-x-2.5 border border-[#1B3CD2] rounded-full">
                                        <span>View All</span>
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path class="group-hover:fill-white"
                                                d="M10.7814 7.33327L7.20539 3.75726L8.14819 2.81445L13.3337 7.99993L8.14819 13.1853L7.20539 12.2425L10.7814 8.6666H2.66699V7.33327H10.7814Z"
                                                fill="#1A2DC9" />
                                        </svg>
                                    </a>
                                </div>
                            </div>

                            <div class="-m-3 lg:-m-4">
                                <div class="flex flex-wrap items-stretch">
                                    <?php
                                    foreach ($high_performace_impact as $plugin) {
                                        $single_plugin = $plugin; // rename variable for clarity
                                        $template = get_template_directory() . '/frontend/content-single-plugin.php';

                                        if (file_exists($template)) {
                                            include $template;
                                        }
                                    }

                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
            }

            ?>
            <?php
            if (!empty($search_text) && empty($fuzzy_search_plugin_suggestions_with_category_only_post)) {
                ?>
                <div class="flex justify-center items-center h-screen">No plugin found</div><?php
            }

            ?>

        </div>
    </section>
</main>

<form action="" method="get" id="filter_form">
    <input type="hidden" name="search_text" value="<?php echo $search_text; ?>">
    <input type="hidden" name="sort_by" value="<?php echo $sort_by; ?>">
</form>
<?php
$template = get_template_directory() . '/frontend/taxonomy-search-fuzzy-search-common/javascripts-basic-utility-control.php';
if (file_exists($template)) {
    include $template;
}

require get_template_directory() . '/frontend/content-fuzzy-search.php';
?>

<?php get_footer(); ?>