<?php
get_header();
$post_id = get_the_id();
$comparison_category = get_the_terms(get_the_ID(), 'comparison_category');
$the_title = get_the_title();
$_plugin_comparison_data = get_post_meta($post_id, '_plugin_comparison_data', true);
$_plugin_comparison_data = json_decode($_plugin_comparison_data, true);
$_icons = get_post_meta($post_id, '_comparison_plugin_icons', true);
$_icons_arr = explode(',', $_icons);

$_comparison_plugin_slugs_arr = [];
$_names_by_slug_comparison_plugins = Helpers::get_names_by_slug_comparison_plugins($post_id);



$slug_name_mapping = [];
$post_slugs = explode(',', $_names_by_slug_comparison_plugins["plugin_slugs"]);

foreach ($post_slugs as $k => $single) {
    $slug_name_mapping[$single] = str_replace(['&#8211;', '&amp;'], ['–', '&'], Helpers::get_names_by_slug_wp_org($single));
}

$related_plugin_comparisons = Helpers::get_related_plugin_comparisons($post_id);
?>
<main>
    <section class="border-y lg:border-0 border-[#F2F2F2]">
        <div class="container">
            <div class="flex justify-between items-center text-[13px] font-normal !leading-[120%] text-[#A1A7B1]">
                <div class="flex items-center">
                    <div>
                        <a href="<?= site_url() ?>" class="px-1 py-2.5 inline-block">
                            <img class="w-6 min-w-6 h-6 object-contain object-center"
                                src="<?= asset_image_path_generator() ?>/category-page/home.svg" alt="Home-image" />
                        </a>
                    </div>
                    <div class="flex items-center px-1 space-x-3">
                        <span>/</span>
                        <a href="single-plugin.html" class="py-2.5 inline-block hover:text-black duration-300">
                            <p class="whitespace-nowrap">
                                <?php echo str_replace(['&#8211;', '&amp;'], ['–', '&'], $comparison_category[0]->name); ?>
                            </p>
                        </a>
                    </div>
                    <div class="hidden lg:flex items-center px-1 space-x-3 max-w-[345px]">
                        <span>/</span>
                        <a href="page-search-result.html" class="py-2.5 hover:text-black duration-300">
                            <p class="line-clamp-1 break-all">
                                <?= $the_title ?>
                            </p>
                        </a>
                    </div>
                </div>

                <div class="relative">
                    <button type="button" class="peer flex items-center space-x-1 hover:text-black duration-300">
                        <p class="hidden lg:block">
                            How we conducted this list comparison?
                        </p>
                        <img class="w-6 min-w-6 h-6 object-contain object-center"
                            src="<?= asset_image_path_generator() ?>/exclamation.svg" alt="exclamation" />
                    </button>
                    <div
                        class="customTooltip absolute top-full mt-2 opacity-0 peer-hover:opacity-100 end-0 lg:end-[-30px] left-auto z-10 max-w-[256px] p-4 text-[10px] font-bold !leading-[120%] text-white bg-black rounded-xl min-w-[256px]">
                        <div class="relative">
                            <div class="absolute top-[-21px] end-0 lg:end-[18px]">
                                <svg width="12" height="6" viewBox="0 0 12 6" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M6 0L0 6H12L6 0Z" fill="black" />
                                </svg>
                            </div>
                        </div>
                        We evaluate each WordPress plugin using a consistent
                        <strong>AI framework</strong> based on real-world usage. Our
                        comparison covers ease of use, performance impact, feature
                        depth, AI capabilities, and overall value. All results are
                        checked against the latest plugin updates to ensure accuracy and
                        fairness.
                        <div class="tooltip-arrow" data-popper-arrow></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="pt-[60px] pb-[60px] md:pb-24 lg:pb-[160px] bg-gradient-to-t from-[#A4E4FF] to-[#ffffff]">
        <div class="container">
            <div class="max-w-[392px] sm:max-w-[790px] mx-auto">
                <div class="text-center space-y-6 lg:space-y-8 text-base !leading-[160%] font-bold">
                    <div class="relative">
                        <div class="absolute top-0 sm:top-12 left-[0.5%]">
                            <img class="w-11 lg:min-w-[54px] h-11 lg:min-h-[54px]"
                                src="<?= asset_image_path_generator() ?>/1-after.svg" alt="" />
                        </div>
                        <div class="absolute top-[75%] sm:top-[40%] right-3 md:right-4">
                            <img class="w-8 lg:min-w-[42px] h-8 lg:min-h-[42px]"
                                src="<?= asset_image_path_generator() ?>/2-after.svg" alt="" />
                        </div>
                        <h1 class="text-4xl md:text-5xl lg:text-[61px] !leading-[120%]">
                            <?= $the_title ?>
                        </h1>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="sticky top-[72px] lg:top-[85.49px] z-[5] bg-white">
        <div class="container">
            <div class="border-b border-[#F2F2F2]">
                <div
                    class="comparisonNav flex items-center space-x-6 lg:space-x-[51px] text-base text-[#A1A7B1] font-normal !leading-[160%] overflow-x-auto scrollbarHide">
                    <a href="#intro" class="pt-4 pb-3 border-b-4 border-white whitespace-nowrap">
                        Intro
                    </a>
                    <a href="#overview" class="pt-4 pb-3 border-b-4 border-white whitespace-nowrap">
                        Overview
                    </a>
                    <a href="#feature" class="pt-4 pb-3 border-b-4 border-white whitespace-nowrap">
                        Feature comparison table
                    </a>
                    <a href="#ease" class="pt-4 pb-3 border-b-4 border-white whitespace-nowrap">
                        Ease of use
                    </a>
                    <a href="#performance" class="pt-4 pb-3 border-b-4 border-white whitespace-nowrap">
                        Performance
                    </a>
                    <a href="#pricing" class="pt-4 pb-3 border-b-4 border-white whitespace-nowrap">
                        Pricing
                    </a>
                    <a href="#useCase" class="pt-4 pb-3 border-b-4 border-white whitespace-nowrap">
                        Use-case
                    </a>
                    <a href="#pros" class="pt-4 pb-3 border-b-4 border-white whitespace-nowrap">
                        Pros and cons
                    </a>
                    <a href="#final" class="pt-4 pb-3 border-b-4 border-white whitespace-nowrap">
                        Final verdict
                    </a>
                    <a href="#faq" class="pt-4 pb-3 border-b-4 border-white whitespace-nowrap">
                        FAQ
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section id="intro" class="sectionPadding scroll-mt-32 lg:scroll-mt-36">
        <div class="container">
            <div class="max-w-[789px] mx-auto space-y-4 lg:space-y-8 font-bold text-center text-black">
                <h2 class="text-[31px] md:text-4xl lg:text-[49px] !leading-[120%]">
                    Intro
                </h2>
                <p class="text-base !leading-[160%]">
                    We evaluate each WordPress plugin using a consistent
                    <strong class="relative">
                        <span
                            class="absolute w-full h-[3px] left-0 -bottom-1 bg-gradient-to-r from-[#1650D7] to-[#0EF0AA]"></span>
                        AI framework
                    </strong>
                    based on real-world usage. Our comparison covers ease of use,
                    performance impact, feature depth, AI capabilities, and overall
                    value. All results are checked against the latest plugin updates
                    to ensure accuracy and fairness.
                </p>
            </div>
        </div>
    </section>

    <section id="overview" class="sectionPadding scroll-mt-32 lg:scroll-mt-36">
        <div class="container">
            <div class="sectionWidth">
                <div class="space-y-12 lg:space-y-[60px] font-bold text-center text-black">
                    <div class="max-w-[789px] mx-auto space-y-4 lg:space-y-8">
                        <h2 class="text-[31px] md:text-4xl lg:text-[49px] !leading-[120%]">
                            Overview
                        </h2>
                        <p class="text-base !leading-[160%]">
                            <?= $_plugin_comparison_data["overview"] ?>
                        </p>
                    </div>

                    <div class="scrollSlider overflow-auto scrollbarHide flex justify-between space-x-2 lg:space-x-8">
                        <?php
                        foreach ($_plugin_comparison_data['plugins'] as $key => $single) {
                            $_comparison_plugin_slugs_arr[] = $single["slug"];
                        ?>
                            <div
                                class="group/card relative w-[70%] min-w-[70%] sm:w-[45%] sm:min-w-[45%] md:w-full md:min-w-0 flex flex-col justify-between space-y-7 lg:space-y-8 px-3 lg:px-6 py-4 lg:py-8 text-black text-center text-base !leading-[120%] font-bold bg-gradient-to-b from-[#F2F5FA] to-[#F8F9F980] rounded-3xl">
                                <div class="group-last/card:hidden absolute top-0 -right-1 lg:-right-4 w-px h-full self-stretch bg-[#F2F2F2]"></div>
                                <div
                                    class="w-[72px] min-w-[72px] h-[72px] mx-auto bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-3xl flex items-center justify-center">
                                    <img class="w-[65px] min-w-[65px] h-[65px] object-contain object-center rounded-3xl"
                                        src="<?= $_icons_arr[$key] ?>" alt="wpRocket" />
                                </div>
                                <div class="space-y-2 flex-grow">
                                    <h4 class="text-xl md:text-[22px] lg:text-[25px]">
                                        <?php
                                        echo $slug_name_mapping[$single['slug']]
                                        ?>
                                    </h4>
                                    <p class="text-base !leading-[160%] font-normal">
                                        <?= $_plugin_comparison_data['final_verdict'][$single["slug"]]["verdict"] ?>
                                    </p>
                                </div>

                                <div class="">
                                    <a href="<?= site_url('') . '/plugins/' . $single["slug"] ?>"
                                        class="p-[1px] group inline-block text-[13px] bg-[#EEEEEE] hover:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden rounded-full">
                                        <span
                                            class="flex items-center pl-3 pr-3 hover:pr-[6px] py-1 min-h-[36px] bg-[var(--theme-white)] rounded-full duration-300">
                                            <p class="break-all line-clamp-1">See plugins detail</p>
                                            <span
                                                class="h-6 w-6 min-w-6 flex items-center justify-center -ml-7 group-hover:ml-2 opacity-0 group-hover:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                                <img src="<?= asset_image_path_generator() ?>/angleUp.svg" alt="icon"
                                                    class="w-[10.67px] min-w-[10.67px] h-[10.37px] min-h-[10.37px] object-contain object-center" />
                                            </span>
                                        </span>
                                    </a>
                                </div>
                            </div>
                        <?php
                        }
                        ?>

                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="feature" class="sectionPadding scroll-mt-32 lg:scroll-mt-36">
        <div class="container">
            <div class="sectionWidth">
                <div class="space-y-12 lg:space-y-[60px]">
                    <h2 class="text-[31px] md:text-4xl lg:text-[49px] text-center !leading-[120%] font-bold text-black">
                        Feature comparison table
                    </h2>

                    <div class="comparisonTable">
                        <div class="relative w-full overflow-x-auto scrollbarHide">
                            <table class="w-[800px] min-w-full">
                                <colgroup>
                                    <col class="w-[18%] lg:w-[20%]" />
                                    <col class="w-auto" />
                                    <col class="w-auto" />
                                    <col class="w-auto" />
                                    <col class="w-auto" />
                                    <col class="w-auto" />
                                </colgroup>

                                <thead
                                    class=" bg-white text-black !leading-[120%] divide-y divide-[#EEEEEE] border-b border-[#EEEEEE]">
                                    <tr class="divide-x divide-[#EEEEEE]">
                                        <th class="p-3"></th>
                                        <?php
                                        foreach ($_plugin_comparison_data['plugins'] as $key => $single) {
                                        ?>
                                            <th class="p-3 align-middle">
                                                <div
                                                    class="flex flex-col lg:flex-row items-center justify-center space-y-1 lg:space-y-0 lg:space-x-3">
                                                    <div
                                                        class="w-[42px] min-w-[42px] h-[42px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-xl flex items-center justify-center">
                                                        <img class="w-[38px] min-w-[38px] h-[38px] object-contain object-center rounded-xl"
                                                            src="<?= $_icons_arr[$key] ?>" alt="" />
                                                    </div>

                                                    <div class="">
                                                        <h4 class="text-[13px] lg:text-base font-bold line-clamp-3">
                                                            <?php
                                                            echo $slug_name_mapping[$single['slug']]
                                                            ?>
                                                        </h4>
                                                    </div>
                                                </div>
                                            </th>
                                        <?php
                                        } ?>

                                    </tr>
                                </thead>

                                <tbody class="divide-y divide-[#EEEEEE]">
                                    <?php
                                    foreach ($_plugin_comparison_data['feature_table']['rows'] as $k => $single_feature) {
                                    ?>
                                        <tr
                                            class="divide-x divide-[#EEEEEE] h-[80px] text-[13px] text-black font-normal !leading-[120%]">
                                            <td class="pr-4 py-4 font-bold"><?= $single_feature['feature'] ?></td>
                                            <?php
                                            foreach ($_plugin_comparison_data['plugins'] as $key => $single) {
                                            ?>
                                                <td class="px-4 py-4 text-center bg-[#FCFCFC]">
                                                    <div>
                                                        <img class="mx-auto w-8 min-w-8 h-8 object-contain object-center"
                                                            src="<?= asset_image_path_generator() ?>/<?= $single_feature[$single["slug"]]["is_available"] == 1 ? "tikmark-green.svg" : "close-circle.svg" ?>"
                                                            alt="tickmark" />
                                                        <?php
                                                        if ($single_feature[$single["slug"]]["note"]) {
                                                        ?>
                                                            <p class="font-normal">
                                                                <?php echo $single_feature[$single["slug"]]["note"] ?>
                                                            </p>
                                                        <?php
                                                        }
                                                        ?>

                                                    </div>
                                                </td>
                                            <?php
                                            }
                                            ?>
                                        </tr>
                                    <?php
                                    }
                                    ?>

                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="max-w-[789px] mx-auto">
                        <div
                            class="w-full flex space-x-6 px-3 lg:px-6 py-4 lg:py-8 text-black bg-gradient-to-b from-[#F2F5FA] to-[#F8F9F980] rounded-3xl">
                            <div
                                class="w-[54px] min-w-[54px] h-[54px] mx-auto bg-[#02AAF23D] rounded-3xl flex items-center justify-center">
                                <img class="w-6 min-w-6 h-6 object-contain object-center"
                                    src="<?= asset_image_path_generator() ?>/lightbulb.svg" alt="" />
                            </div>
                            <div class="space-y-2 flex-grow">
                                <h4 class="text-xl !leading-[120%] font-bold">Verdict</h4>
                                <p class="text-base !leading-[160%] font-normal">
                                    <?= $_plugin_comparison_data["feature_table"]["verdict"] ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="ease" class="sectionPadding scroll-mt-32 lg:scroll-mt-36">
        <div class="container">
            <div class="sectionWidth">
                <div class="space-y-12 lg:space-y-[60px]">
                    <h2 class="text-[31px] md:text-4xl lg:text-[49px] text-center !leading-[120%] font-bold text-black">
                        Ease of use
                    </h2>

                    <div class="scrollSlider overflow-auto scrollbarHide flex justify-between space-x-2 lg:space-x-8">
                        <?php
                        foreach ($_plugin_comparison_data['plugins'] as $key => $single) {
                        ?>
                            <div class="group/card relative w-[70%] min-w-[70%] sm:w-[45%] sm:min-w-[45%] md:w-full md:min-w-0">
                                <div class="group-last/card:hidden absolute top-0 -right-1 lg:-right-4 w-px h-full self-stretch bg-[#F2F2F2]"></div>
                                <?php
                                $comparison_level_user = $_plugin_comparison_data['ease_of_use']['comparison_level'][$single["slug"]];
                                if ($comparison_level_user == "win") {
                                ?>
                                    <div
                                        class="absolute top-3 right-3 py-1 px-3 text-[13px] font-bold !leading-[120%] text-black bg-gradient-to-r from-[#48DBD7] to-[#01F4A0] rounded-full">
                                        👍 Win
                                    </div>
                                <?php
                                }
                                ?>

                                <div
                                    class="pt-[40px] lg:pt-8 flex flex-col justify-between space-y-7 lg:space-y-8 px-3 lg:px-6 py-8 text-black text-center text-base !leading-[120%] font-bold bg-gradient-to-b from-[#F2F5FA] to-[#F8F9F980] rounded-3xl">
                                    <img class="mx-auto w-10 min-w-10 h-10 sm:w-12 sm:min-w-12 sm:h-12 object-contain object-center rounded-3xl"
                                        src="<?= asset_image_path_generator() ?>/<?php echo in_array($comparison_level_user, ["win", "high"]) ? "blueTik.svg" : "grayTik.svg" ?>"
                                        alt="" />
                                    <div class="space-y-2 flex-grow">
                                        <h4 class="text-xl md:text-[22px] lg:text-[25px]">
                                            <?php echo ucfirst($_plugin_comparison_data['ease_of_use']['complexity'][$single["slug"]]) ?>
                                        </h4>
                                        <p class="text-base !leading-[160%] font-normal">
                                            <strong class="relative">
                                                <span
                                                    class="absolute w-full h-[3px] left-0 -bottom-1 bg-gradient-to-r from-[#1650D7] to-[#0EF0AA]"></span><?php
                                                                                                                                                            echo $slug_name_mapping[$single['slug']]
                                                                                                                                                            ?></strong>
                                            <?php
                                            echo $_plugin_comparison_data['ease_of_use']['content'][$single["slug"]]

                                            ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        <?php
                        }

                        ?>

                    </div>

                    <div class="max-w-[789px] mx-auto">
                        <div
                            class="w-full flex space-x-6 px-3 lg:px-6 py-4 lg:py-8 text-black bg-gradient-to-b from-[#F2F5FA] to-[#F8F9F980] rounded-3xl">
                            <div
                                class="w-[54px] min-w-[54px] h-[54px] mx-auto bg-[#02AAF23D] rounded-3xl flex items-center justify-center">
                                <img class="w-6 min-w-6 h-6 object-contain object-center"
                                    src="<?php echo asset_image_path_generator() ?>/lightbulb.svg" alt="" />
                            </div>
                            <div class="space-y-2 flex-grow">
                                <h4 class="text-xl !leading-[120%] font-bold">AEO note</h4>
                                <p class="text-base !leading-[160%] font-normal">
                                    <?= $_plugin_comparison_data["ease_of_use"]["verdict"] ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="performance" class="sectionPadding scroll-mt-32 lg:scroll-mt-36">
        <div class="container">
            <div class="sectionWidth">
                <div class="space-y-12 lg:space-y-[60px]">
                    <h2 class="text-[31px] md:text-4xl lg:text-[49px] text-center !leading-[120%] font-bold text-black">
                        Performance
                    </h2>

                    <div class="scrollSlider overflow-auto scrollbarHide flex justify-between space-x-2 lg:space-x-8">
                        <?php
                        foreach ($_plugin_comparison_data['plugins'] as $key => $single) {
                        ?>
                            <div class="group/card relative w-[70%] min-w-[70%] sm:w-[45%] sm:min-w-[45%] md:w-full md:min-w-0">
                                <div class="group-last/card:hidden absolute top-0 -right-1 lg:-right-4 w-px h-full self-stretch bg-[#F2F2F2]"></div>
                                <?php
                                $comparison_level_user = $_plugin_comparison_data['performance']['comparison_level'][$single["slug"]];
                                if ($comparison_level_user == "win") {
                                ?>
                                    <div
                                        class="absolute top-3 right-3 py-1 px-3 text-[13px] font-bold !leading-[120%] text-black bg-gradient-to-r from-[#48DBD7] to-[#01F4A0] rounded-full">
                                        👍 Win
                                    </div>
                                <?php
                                }
                                ?>
                                <div
                                    class="pt-[40px] lg:pt-8 flex flex-col justify-between space-y-7 lg:space-y-8 px-3 lg:px-6 py-8 text-black text-center text-base !leading-[120%] font-bold bg-gradient-to-b from-[#F2F5FA] to-[#F8F9F980] rounded-3xl">
                                    <img class="mx-auto w-10 min-w-10 h-10 sm:w-12 sm:min-w-12 sm:h-12 object-contain object-center rounded-3xl"
                                        src="<?= asset_image_path_generator() ?>/<?php echo in_array($comparison_level_user, ["win", "high"]) ? "blueTik.svg" : "grayTik.svg" ?>"
                                        alt="" />
                                    <div class="space-y-2 flex-grow">
                                        <h4 class="text-xl md:text-[22px] lg:text-[25px]">
                                            <?php echo ucfirst($_plugin_comparison_data['performance']['speed'][$single["slug"]]) ?>
                                        </h4>
                                        <p class="text-base !leading-[160%] font-normal">
                                            <strong class="relative">
                                                <span
                                                    class="absolute w-full h-[3px] left-0 -bottom-1 bg-gradient-to-r from-[#1650D7] to-[#0EF0AA]"></span><?php
                                                                                                                                                            echo $slug_name_mapping[$single['slug']]
                                                                                                                                                            ?></strong>
                                            <?php
                                            echo $_plugin_comparison_data['performance']['content'][$single["slug"]]

                                            ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        <?php
                        }

                        ?>
                    </div>

                    <div class="max-w-[789px] mx-auto">
                        <div
                            class="w-full flex space-x-6 px-3 lg:px-6 py-4 lg:py-8 text-black bg-gradient-to-b from-[#F2F5FA] to-[#F8F9F980] rounded-3xl">
                            <div
                                class="w-[54px] min-w-[54px] h-[54px] mx-auto bg-[#02AAF23D] rounded-3xl flex items-center justify-center">
                                <img class="w-6 min-w-6 h-6 object-contain object-center"
                                    src="<?= asset_image_path_generator() ?>/lightbulb.svg" alt="" />
                            </div>
                            <div class="space-y-2 flex-grow">
                                <h4 class="text-xl !leading-[120%] font-bold">
                                    Technical note
                                </h4>
                                <p class="text-base !leading-[160%] font-normal">
                                    <?php
                                    echo $_plugin_comparison_data['performance']['verdict']

                                    ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="pricing" class="sectionPadding scroll-mt-32 lg:scroll-mt-36">
        <div class="container">
            <div class="sectionWidth">
                <div class="space-y-12 lg:space-y-[60px]">
                    <h2 class="text-[31px] md:text-4xl lg:text-[49px] text-center !leading-[120%] font-bold text-black">
                        Pricing
                    </h2>

                    <div class="scrollSlider overflow-auto scrollbarHide flex justify-between space-x-2 lg:space-x-8">
                        <?php
                        foreach ($_plugin_comparison_data['plugins'] as $key => $single) {

                            $comparison_level_user = $_plugin_comparison_data['pricing']['comparison_level'][$single["slug"]]['pricing'];


                        ?>
                            <div class="group/card relative w-[70%] min-w-[70%] sm:w-[45%] sm:min-w-[45%] md:w-full md:min-w-0">
                                <div class="group-last/card:hidden absolute top-0 -right-1 lg:-right-4 w-px h-full self-stretch bg-[#F2F2F2]"></div>
                                <?php
                                if ($comparison_level_user == "win") {
                                ?>
                                    <div
                                        class="absolute top-3 right-3 py-1 px-3 text-[13px] font-bold !leading-[120%] text-black bg-gradient-to-r from-[#48DBD7] to-[#01F4A0] rounded-full">
                                        👍 Win
                                    </div>
                                <?php
                                }

                                ?>
                                <div
                                    class="pt-[40px] flex flex-col justify-between px-3 lg:px-6 py-8 text-black text-center text-base !leading-[120%] font-bold bg-gradient-to-b from-[#F2F5FA] to-[#F8F9F980] rounded-3xl">
                                    <div class="space-y-2 flex-grow">
                                        <strong class="!leading-[160%]"><?php
                                                                        echo $slug_name_mapping[$single['slug']]
                                                                        ?></strong>
                                        <h2 class="text-3xl lg:text-[39px]">
                                            <?php
                                            echo $_plugin_comparison_data['pricing']['content'][$single["slug"]];
                                            ?>
                                        </h2>
                                        <p class="!leading-[160%] font-normal">
                                            (
                                            <?php echo $_plugin_comparison_data['pricing']['comparison_level'][$single["slug"]]['note'] ?>
                                            )
                                        </p>
                                    </div>
                                </div>
                            </div>
                        <?php
                        }

                        ?>
                    </div>

                    <div class="max-w-[789px] mx-auto">
                        <div
                            class="w-full flex space-x-6 px-3 lg:px-6 py-4 lg:py-8 text-black bg-gradient-to-b from-[#F2F5FA] to-[#F8F9F980] rounded-3xl">
                            <div
                                class="w-[54px] min-w-[54px] h-[54px] mx-auto bg-[#02AAF23D] rounded-3xl flex items-center justify-center">
                                <img class="w-6 min-w-6 h-6 object-contain object-center"
                                    src="<?= asset_image_path_generator() ?>/lightbulb.svg" alt="" />
                            </div>
                            <div class="space-y-2 flex-grow">
                                <h4 class="text-xl !leading-[120%] font-bold">
                                    Recommendation
                                </h4>
                                <p class="text-base !leading-[160%] font-normal">
                                    <?= $_plugin_comparison_data['pricing']['recommendation'] ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="useCase" class="sectionPadding scroll-mt-32 lg:scroll-mt-36">
        <div class="container">
            <div class="sectionWidth">
                <div class="space-y-12 lg:space-y-[60px]">
                    <h2 class="text-[31px] md:text-4xl lg:text-[49px] text-center !leading-[120%] font-bold text-black">
                        Use-case
                    </h2>

                    <div class="scrollSlider overflow-auto scrollbarHide flex justify-between space-x-2 lg:space-x-8">
                        <?php
                        foreach ($_plugin_comparison_data['plugins'] as $key => $single) {
                        ?>
                            <div class="group/card relative w-[70%] min-w-[70%] sm:w-[45%] sm:min-w-[45%] md:w-full md:min-w-0">
                                <div class="group-last/card:hidden absolute top-0 -right-1 lg:-right-4 w-px h-full self-stretch bg-[#F2F2F2]"></div>
                                <div
                                    class="flex flex-col justify-between space-y-7 lg:space-y-8 px-3 lg:px-6 py-8 text-black text-center text-base !leading-[120%] font-bold rounded-3xl">
                                    <img class="mx-auto w-10 min-w-10 h-10 sm:w-12 sm:min-w-12 sm:h-12 object-contain object-center rounded-3xl"
                                        src="<?= asset_image_path_generator() ?>/notis.svg" alt="">
                                    <div class="space-y-2 flex-grow">
                                        <span><?php
                                                echo $slug_name_mapping[$single['slug']]
                                                ?></span>
                                        <h4 class="text-xl md:text-[22px] lg:text-[25px]">
                                            <?php
                                            echo $_plugin_comparison_data['use_case']['content'][$single["slug"]]
                                            ?>
                                        </h4>
                                        <p class="text-base !leading-[160%] font-normal">
                                            (<?php
                                                echo $_plugin_comparison_data['use_case']['comparison_reason'][$single["slug"]]
                                                ?>)
                                        </p>
                                    </div>
                                </div>
                            </div>
                        <?php
                        }

                        ?>
                    </div>

                    <div class="max-w-[789px] mx-auto">
                        <div
                            class="w-full flex space-x-6 px-3 lg:px-6 py-4 lg:py-8 text-black bg-gradient-to-b from-[#F2F5FA] to-[#F8F9F980] rounded-3xl">
                            <div
                                class="w-[54px] min-w-[54px] h-[54px] mx-auto bg-[#02AAF23D] rounded-3xl flex items-center justify-center">
                                <img class="w-6 min-w-6 h-6 object-contain object-center"
                                    src="<?= asset_image_path_generator() ?>/lightbulb.svg" alt="" />
                            </div>
                            <div class="space-y-2 flex-grow">
                                <h4 class="text-xl !leading-[120%] font-bold">For AEO</h4>
                                <p class="text-base !leading-[160%] font-normal">
                                    <?php
                                    echo $_plugin_comparison_data['use_case']['verdict']
                                    ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="pros" class="sectionPadding scroll-mt-32 lg:scroll-mt-36">
        <div class="container">
            <div class="sectionWidth">
                <div class="space-y-12 lg:space-y-[60px]">
                    <h2 class="text-[31px] md:text-4xl lg:text-[49px] text-center !leading-[120%] font-bold text-black">
                        Pros and cons
                    </h2>

                    <div class="scrollSlider overflow-auto scrollbarHide flex justify-between space-x-2 lg:space-x-8">
                        <?php

                        foreach ($_plugin_comparison_data['plugins'] as $key => $single) {
                            $comparison_level_pons = $_plugin_comparison_data['pros_cons']['comparison_level'][$single["slug"]];
                        ?>
                            <div class="group/card relative w-[70%] min-w-[70%] sm:w-[45%] sm:min-w-[45%] md:w-full md:min-w-0 ">
                                <div class="group-last/card:hidden absolute top-0 -right-1 lg:-right-4 w-px h-full self-stretch bg-[#F2F2F2]"></div>
                                <div class="relative pb-1 lg:pb-8 border-b border-[#F2F2F2]">
                                    <?php
                                    if ($comparison_level_pons == "win") {
                                    ?>
                                        <div
                                            class="absolute top-3 right-3 py-1 px-3 text-[13px] font-bold !leading-[120%] text-black bg-gradient-to-r from-[#48DBD7] to-[#01F4A0] rounded-full">
                                            👍 Win
                                        </div>
                                    <?php
                                    }

                                    ?>

                                    <div
                                        class="flex flex-col justify-between px-3 lg:px-6 py-8 text-black/80 text-base !leading-[160%] font-normal bg-gradient-to-b from-[#F2F5FA] to-[#F8F9F980] rounded-3xl">
                                        <div class="space-y-2 flex-grow">
                                            <h4
                                                class="text-xl md:text-[22px] lg:text-[25px] font-bold !leading-[120%] text-center">
                                                Pros
                                            </h4>
                                            <?php
                                            foreach ($_plugin_comparison_data['pros_cons']['content'][$single["slug"]]["pros"] as $single_pros) {
                                            ?>
                                                <div
                                                    class="group flex flex-col lg:flex-row lg:items-center p-3 lg:p-4 hover:text-white bg-white hover:bg-black duration-300 rounded-[12px] border border-[#F2F2F2] space-y-3 lg:space-y-0 lg:space-x-3">
                                                    <div
                                                        class="w-[32px] min-w-[32px] h-[32px] lg:w-[54px] lg:min-w-[54px] lg:h-[54px] bg-[#02AAF23D] group-hover:bg-white flex justify-center items-center rounded-full">
                                                        <img class="w-6 min-w-6 h-6 object-contain object-center"
                                                            src="<?= asset_image_path_generator() ?>/plugin-page/check-fill.svg"
                                                            alt="check-fill" />
                                                    </div>
                                                    <span class="break-words"><?= $single_pros ?></span>
                                                </div>

                                            <?php

                                            }

                                            ?>
                                        </div>
                                    </div>
                                </div>

                                <div
                                    class="mt-1 lg:mt-8 flex flex-col justify-between px-3 lg:px-6 py-8 text-black/80 text-base !leading-[160%] font-normal bg-gradient-to-b from-[#F2F5FA] to-[#F8F9F980] rounded-3xl">
                                    <div class="space-y-2 flex-grow">
                                        <h4
                                            class="text-xl md:text-[22px] lg:text-[25px] font-bold !leading-[120%] text-center">
                                            Cons
                                        </h4>
                                        <?php
                                        foreach ($_plugin_comparison_data['pros_cons']['content'][$single["slug"]]["cons"] as $single_cons) {
                                        ?>
                                            <div
                                                class="group flex flex-col lg:flex-row lg:items-center p-3 lg:p-4 hover:text-white bg-white hover:bg-black duration-300 rounded-[12px] border border-[#F2F2F2] space-y-3 lg:space-y-0 lg:space-x-3">
                                                <div
                                                    class="w-[32px] min-w-[32px] h-[32px] lg:w-[54px] lg:min-w-[54px] lg:h-[54px] bg-[#EB43353D] group-hover:bg-white flex justify-center items-center rounded-full">
                                                    <img class="w-6 min-w-6 h-6 object-contain object-center"
                                                        src="<?= asset_image_path_generator() ?>/close-danjer.svg"
                                                        alt="check-fill" />
                                                </div>
                                                <span class="break-words"><?= $single_cons ?></span>
                                            </div>

                                        <?php

                                        }

                                        ?>



                                    </div>
                                </div>
                            </div>

                        <?php
                        }

                        ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="final" class="sectionPadding scroll-mt-32 lg:scroll-mt-36">
        <div class="container">
            <div class="sectionWidth">
                <div class="space-y-12 lg:space-y-[60px]">
                    <h2 class="text-[31px] md:text-4xl lg:text-[49px] text-center !leading-[120%] font-bold text-black">
                        Final verdict
                    </h2>

                    <div
                        class=" scrollSlider overflow-auto scrollbarHide flex justify-between px-4 py-12 lg:p-[60px] -px-4 bg-[#A5E4FF] rounded-[32px]">
                        <?php

                        foreach ($_plugin_comparison_data['plugins'] as $key => $single) {
                            $comparison_level_final_verdict = $_plugin_comparison_data['final_verdict'][$single["slug"]]['comparison_level'];
                        ?>
                            <div class="px-4  relative w-[70%] min-w-[70%] sm:w-[45%] sm:min-w-[45%] md:w-full md:min-w-0 border-r border-[#F2F2F2] last:border-0 flex flex-col items-center justify-end text-black text-center text-base !leading-[120%] font-bold space-y-8 flex-grow">
                                <!-- <div class="group-last/card:hidden absolute top-0 -right-1 lg:-right-4 w-px h-full self-stretch bg-[#F2F2F2]"></div> -->

                                <?php
                                if ($comparison_level_final_verdict == "win") {
                                ?>
                                    <div
                                        class="max-w-[69px] mx-auto p-1 text-[13px] bg-gradient-to-r from-[#48DBD7] to-[#01F4A0] rounded-full">
                                        👍 Win
                                    </div>
                                <?php
                                }

                                ?>

                                <h4 class="text-xl md:text-[22px] lg:text-[25px] break-all sm:break-normal">
                                    <?php echo $_plugin_comparison_data['final_verdict'][$single["slug"]]["verdict"] ?>
                                </h4>

                                <a href="<?php echo site_url() . '/plugins/' . $single['slug'] ?>"
                                    class="p-[1px] group block text-[13px] bg-[#EEEEEE] hover:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden rounded-full">
                                    <span
                                        class="flex items-center pl-3 pr-3 hover:pr-[6px] py-1 min-h-[36px] bg-[var(--theme-white)] rounded-full duration-300">
                                        <p class="break-all line-clamp-1 duration-300">
                                            Choose <?php echo $slug_name_mapping[$single['slug']] ?>
                                        </p>
                                        <span
                                            class="h-6 w-6 min-w-6 flex items-center justify-center -ml-7 group-hover:ml-2 opacity-0 group-hover:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                            <img src="<?= asset_image_path_generator() ?>/angleUp.svg" alt="icon"
                                                class="w-[10.67px] min-w-[10.67px] h-[10.37px] min-h-[10.37px] object-contain object-center" />
                                        </span>
                                    </span>
                                </a>

                            </div>
                        <?php
                        }

                        ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="faq" class="sectionPadding scroll-mt-32 lg:scroll-mt-36">
        <div class="container">
            <div class="max-w-[789px] mx-auto">
                <div class="space-y-12 lg:space-y-[60px]">
                    <h2 class="text-[31px] md:text-4xl lg:text-[49px] text-center !leading-[120%] font-bold text-black">
                        FAQ
                    </h2>

                    <div id="faqAccordionComparison" class="w-full">
                        <?php
                        foreach ($_plugin_comparison_data['faq'] as $k => $single_faq) {
                        ?>
                            <div class="faq_item text-black rounded-3xl overflow-hidden">
                                <button type="button" data-accordion-target="#faq-<?= ($k + 1) ?>"
                                    class="faq-btn w-full flex justify-between items-center p-4 lg:p-8 outline-none border-none">
                                    <span
                                        class="text-xl !leading-[120%] font-bold text-start"><?= $single_faq["question"] ?></span>

                                    <div class="faq_icon text-2xl font-normal transition-transform duration-300">
                                        +
                                    </div>
                                </button>

                                <div id="faq-<?= ($k + 1) ?>" class="hidden p-4 lg:p-8 !pt-0">
                                    <p class="text-base text-[#727C89] !leading-[160%] font-normal">
                                        <?= $single_faq["answer"] ?>
                                    </p>
                                </div>
                            </div>

                        <?php
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="performance" class="sectionPadding scroll-mt-32 lg:scroll-mt-36">
        <div class="container">
            <div class="sectionWidth">
                <div class="space-y-12 lg:space-y-[60px]">
                    <h2 class="text-[31px] md:text-4xl lg:text-[49px] text-center !leading-[120%] font-bold text-black">
                        You may like
                    </h2>

                    <div class="scrollSlider overflow-auto scrollbarHide flex justify-between space-x-2 lg:space-x-8">
                        <?php
                        foreach ($related_plugin_comparisons as $single) {
                            $icons_csv_related = get_post_meta($single->ID, '_comparison_plugin_icons', true);
                            $icons_related = array_filter(array_map('trim', explode(',', $icons_csv_related)));
                        ?>
                            <a href="<?= get_the_permalink($single->ID) ?>" class="group/card relative w-[70%] min-w-[70%] sm:w-[45%] sm:min-w-[45%] md:w-full md:min-w-0">
                                <div class="group-last/card:hidden absolute top-0 -right-1 lg:-right-4 w-px h-full self-stretch bg-[#F2F2F2]"></div>
                                <div class="absolute top-3 right-3 h-8 w-8 min-w-8 flex items-center justify-center bg-black rounded-full">
                                    <img src="<?= asset_image_path_generator() ?>/angleUp.svg" alt="icon"
                                        class="w-[10.67px] h-[10.37px] object-contain object-center" />
                                </div>
                                <div
                                    class="pt-[50px] flex flex-col justify-between space-y-4 lg:space-y-8 px-3 lg:px-6 py-8 text-black text-center text-base !leading-[120%] font-bold bg-gradient-to-b from-[#F2F5FA] to-[#F8F9F980] rounded-3xl">
                                    <div class="flex justify-between max-w-[240px] mx-auto space-x-1 lg:space-x-3">
                                        <?php
                                        foreach ($icons_related as $single_icon) {
                                        ?>
                                            <div
                                                class="w-[46px] min-w-[46px] h-[46px] sm:w-14 sm:min-w-14 sm:h-14 lg:w-[72px] lg:min-w-[72px] lg:h-[72px] mx-auto bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-xl lg:rounded-3xl flex items-center justify-center">
                                                <img class="w-10 min-w-10 h-10 sm:w-12 sm:min-w-12 sm:h-12 lg:w-[65px] lg:min-w-[65px] lg:h-[65px] object-contain object-center rounded-xl sm:rounded-3xl"
                                                    src="<?= $single_icon ?>" alt="" />
                                            </div>
                                        <?php
                                        }
                                        ?>


                                    </div>

                                    <div class="h-px w-full self-stretch bg-[#F2F2F2]"></div>

                                    <div class="space-y-2 flex-grow">
                                        <p class="text-base !leading-[160%]">
                                            <?php
                                            echo $single->post_title;
                                            ?>
                                        </p>
                                    </div>
                                </div>
                            </a>
                        <?php
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>
<script>
    /* ===============================
       Comparison Nav active border
    ================================ */
    jQuery(function($) {
        const setActive = function() {
            const hash = (window.location.hash || "").substring(1).toLowerCase();

            $(".comparisonNav a").each(function() {
                $(this).toggleClass(
                    "active",
                    $(this).attr("href").substring(1).toLowerCase() === hash
                );
            });
        };

        setActive();
        $(window).on("hashchange", setActive);
    });


    /* ===============================
       Comparison Nav Scroll Slider
    ================================ */
    jQuery(function($) {
        $(".comparisonNav").each(function() {
            const slider = $(this);
            let isDown = false;
            let startX;
            let scrollLeft;

            function canScrollHorizontally() {
                const el = slider[0];
                return el.scrollWidth > el.clientWidth;
            }

            slider.on("mousedown", function(e) {
                if (!canScrollHorizontally()) return;

                isDown = true;
                slider.addClass("dragging");
                startX = e.pageX - slider.offset().left;
                scrollLeft = slider.scrollLeft();
                e.preventDefault();
            });

            slider.on("mouseleave mouseup", function() {
                isDown = false;
                slider.removeClass("dragging");
            });

            slider.on("mousemove", function(e) {
                if (!isDown || !canScrollHorizontally()) return;

                const x = e.pageX - slider.offset().left;
                const walk = (x - startX) * 1.5;
                slider.scrollLeft(scrollLeft - walk);
            });

            slider.on("wheel", function(e) {
                const el = slider[0];
                if (!canScrollHorizontally()) return;

                const maxScroll = el.scrollWidth - el.clientWidth;
                const newScroll = el.scrollLeft + e.originalEvent.deltaY;

                if (newScroll >= 0 && newScroll <= maxScroll) {
                    e.preventDefault();
                    el.scrollLeft = newScroll;
                }
            });
        });
    });


    /* ===============================
       FAQ Accordion (jQuery)
    ================================ */
    jQuery(function($) {
        const faqItems = $(".faq_item");

        // First item open by default
        if (faqItems.length > 0) {
            const firstItem = faqItems.first();
            const firstContent = firstItem.find("[id^='faq']");
            const firstIcon = firstItem.find(".faq_icon");

            firstItem.addClass("open");
            firstContent.removeClass("hidden");
            firstIcon.text("−").addClass("rotate");
        }

        $(".faq-btn").on("click", function() {
            const btn = $(this);
            const parent = btn.closest(".faq_item");
            const targetID = btn.data("accordion-target");
            const target = $(targetID);
            const icon = btn.find(".faq_icon");

            // Close others
            faqItems.not(parent).each(function() {
                const item = $(this);
                item.removeClass("open");
                item.find(".faq_icon").removeClass("rotate").text("+");
                item.find("[id^='faq']").addClass("hidden");
            });

            // Toggle current
            target.toggleClass("hidden");
            parent.toggleClass("open");

            if (parent.hasClass("open")) {
                icon.text("−").addClass("rotate");
            } else {
                icon.text("+").removeClass("rotate");
            }
        });
    });

    jQuery(document).ready(function($) {
        // Check if the .scrollSlider elements exist before executing the script
        $(".scrollSlider").each(function() {
            const slider = $(this); // Each individual .scrollSlider element
            let isDown = false;
            let startX;
            let scrollLeft;

            // Only scroll if content is overflowing
            function canScrollHorizontally() {
                const el = slider[0];
                return el.scrollWidth > el.clientWidth;
            }

            // Drag to scroll
            slider.on("mousedown", function(e) {
                if (!canScrollHorizontally()) return;

                isDown = true;
                slider.addClass("dragging");
                startX = e.pageX - slider.offset().left;
                scrollLeft = slider.scrollLeft();
                e.preventDefault();
            });

            slider.on("mouseleave mouseup", function() {
                isDown = false;
                slider.removeClass("dragging");
            });

            slider.on("mousemove", function(e) {
                if (!isDown || !canScrollHorizontally()) return;

                const x = e.pageX - slider.offset().left;
                const walk = (x - startX) * 1.5; // scroll speed
                slider.scrollLeft(scrollLeft - walk);
            });

            // Scroll with mouse wheel
            slider.on("wheel", function(e) {
                const el = slider[0];
                if (!canScrollHorizontally()) return;

                const maxScroll = el.scrollWidth - el.clientWidth;
                const newScroll = el.scrollLeft + e.originalEvent.deltaY;

                // Only scroll if within bounds
                if (newScroll >= 0 && newScroll <= maxScroll) {
                    e.preventDefault(); // prevent default page scroll
                    el.scrollLeft = newScroll;
                }
            });
        });
    });
</script>

<?php get_footer(); ?>