<?php

function asset_image_path_generator()
{
    return get_bloginfo('stylesheet_directory') . '/assets/images/';
}

function asset_css_path_generator()
{
    return get_bloginfo('stylesheet_directory') . '/assets/styles/';
}
function asset_js_path_generator()
{
    return get_bloginfo('stylesheet_directory') . '/assets/scripts/';
}
// function get_plugin_icon_by_slug($plugin_slug)
// {
//     global $wpdb;

//     // ensure plugin slug is a string
//     $plugin_slug = (string) $plugin_slug;

//     // use $wpdb->prepare to safely inject the value into the query
//     $table = $wpdb->prefix . 'cron_scraped_plugins_log';
//     $sql = $wpdb->prepare("SELECT plugin_icon FROM {$table} WHERE plugin_slug = %s LIMIT 1", $plugin_slug);

//     $icon = $wpdb->get_var($sql);

//     // optional: normalize/validate output (e.g. ensure it's a URL or return empty string)
//     return $icon !== null ? $icon : '';
// }
function dd(...$vars)
{
    // Set header for proper HTML rendering if not in CLI
    if (!in_array(PHP_SAPI, ['cli', 'phpdbg'])) {
        header('Content-Type: text/html; charset=utf-8');
    }

    echo '<pre style="background-color: #1a1a1a; color: #f8f8f2; padding: 10px; border-radius: 5px; font-family: monospace; margin: 10px 0; overflow: auto; max-height: 80vh;">';

    foreach ($vars as $var) {
        // Add a separator between multiple variables
        if ($vars[0] !== $var) {
            echo '<hr style="border: 1px dashed #666; margin: 10px 0;">';
        }

        // Use var_dump with output buffering for more control
        ob_start();
        var_dump($var);
        $output = ob_get_clean();

        // Apply syntax highlighting
        $output = preg_replace(
            [
                '/=>\s+/',
                '/(\w+)(\()/',
                '/\bNULL\b/',
                '/\bbool\(true\)\b/',
                '/\bbool\(false\)\b/',
                '/\bstring\(\d+\)\b/',
                '/\bint\(\d+\)\b/',
                '/\bfloat\(\d+\.\d+\)\b/',
                '/\barray\(\d+\)\b/',
                '/\bobject\([^)]+\)\#\d+\b/'
            ],
            [
                ' <span style="color: #ff79c6;">=></span> ',
                '<span style="color: #8be9fd;">\1</span>\2',
                '<span style="color: #bd93f9;">NULL</span>',
                '<span style="color: #50fa7b;">true</span>',
                '<span style="color: #ff5555;">false</span>',
                '<span style="color: #f1fa8c;">string</span>',
                '<span style="color: #bd93f9;">int</span>',
                '<span style="color: #bd93f9;">float</span>',
                '<span style="color: #ff79c6;">array</span>',
                '<span style="color: #50fa7b;">object</span>'
            ],
            htmlspecialchars($output, ENT_QUOTES, 'UTF-8')
        );

        echo $output;
    }

    echo '</pre>';

    // Show backtrace information (where dd() was called from)
    $trace = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 1);
    $file = $trace[0]['file'] ?? 'Unknown file';
    $line = $trace[0]['line'] ?? 'Unknown line';

    echo '<div style="background-color: #282a36; color: #f8f8f2; padding: 5px 10px; border-radius: 0 0 5px 5px; font-family: monospace; margin-top: -10px;">';
    echo "Called from: <span style=\"color: #8be9fd;\">$file</span> on line <span style=\"color: #bd93f9;\">$line</span>";
    echo '</div>';

    // Terminate script execution
    //die(1);
}

function get_the_feature_image_developer_from_cpt_with_core($post_id)
{
    global $wpdb;
    $tbl_plugins_core_information = $wpdb->prefix . "plugins_core_information";

    // Use prepared statement to avoid SQL injection
    $query = $wpdb->prepare("
    SELECT plugin_feature_image,author_name,author_profile,plugin_icon
    FROM {$tbl_plugins_core_information}
    WHERE wp_post_id = %d
    ", $post_id);

    $row = $wpdb->get_row($query);

    return $row;
}


/**
 * Recursively populate all child menu items
 */
function populate_children_all_levels($menu_items, $parent_item)
{
    $children = array();

    foreach ($menu_items as $item) {
        if ((int) $item->menu_item_parent === (int) $parent_item->ID) {
            $child = array(
                'ID' => $item->ID,
                'title' => $item->title,
                'url' => $item->url,
                'children' => populate_children_all_levels($menu_items, $item), // recursion
            );
            $children[] = $child;
        }
    }

    return $children;
}

/**
 * Build full menu (all levels)
 */
function wp_get_full_menu_array($menu_location = 'primary-menu')
{
    // Get menu name or object by theme location
    $menu_name = wp_get_nav_menu_name($menu_location);
    if (!$menu_name) {
        return [];
    }

    $menu_items = wp_get_nav_menu_items($menu_name);
    if (empty($menu_items)) {
        return [];
    }

    $menu = array();

    foreach ($menu_items as $item) {
        if (empty($item->menu_item_parent)) {
            $menu[] = array(
                'ID' => $item->ID,
                'title' => $item->title,
                'url' => $item->url,
                'children' => populate_children_all_levels($menu_items, $item),
            );
        }
    }

    return $menu;
}

/**
 * Convert a percentage (0–100) to a 5-star rating (0–5).
 *
 * @param float|int $percent  The percentage value (e.g. 90)
 * @param int $maxRating      The max rating value (default 5)
 * @return float              The rating value (e.g. 4.5)
 */
function percent_to_rating($percent, $maxRating = 5)
{
    // Ensure value is numeric and within range
    $percent = max(0, min(100, floatval($percent)));

    // Convert
    $rating = ($percent / 100) * $maxRating;

    // Round to 1 decimal (e.g. 4.5)
    return round($rating, 1);
}
/**
 * Format active installs into human-readable text (e.g. 20000 -> 20k, 2000000 -> 2M)
 *
 * @param int|float $number The number of active installs
 * @return string           Formatted string like "2M", "20k", "200"
 */
function format_active_installs($number)
{
    if (!is_numeric($number)) {
        return '0';
    }

    $number = floatval($number);

    if ($number >= 1000000) {
        // 1,000,000+ → M
        return round($number / 1000000, 1) . 'M';
    } elseif ($number >= 1000) {
        // 1,000–999,999 → K
        return round($number / 1000, 1) . 'k';
    } else {
        // Less than 1,000 → keep as is
        return (string) intval($number);
    }
}
/**
 * Convert a numeric rating (0–10) into a descriptive text.
 *
 * @param float|int $score The rating value (0–10)
 * @return string          The descriptive label
 */
function wps_score_description($score)
{
    $score = floatval($score);

    if ($score > 9) {
        return "Outstanding";
    } elseif ($score > 8.5) {
        return "Excellent";
    } elseif ($score > 7) {
        return "Very Good";
    } elseif ($score >= 5) {
        return "Average";
    } elseif ($score >= 3) {
        return "Below Average";
    } elseif ($score > 0) {
        return "Poor 👎";
    } else {
        return "No Rating";
    }
}
function render_star_rating($rating, $max_stars = 5)
{
    // Clamp between 0 and max_stars
    $rating = max(0, min($rating, $max_stars));

    // 🔹 Round rating to nearest 0.05 step
    $rating = round($rating * 20) / 20;

    $output = '';
    $star_path = 'M10 15.217L4.123 18.507L5.436 11.9L0.49 7.327L7.179 6.534L10 0.417L12.822 6.534L19.511 7.327L14.566 11.9L15.879 18.507L10 15.217Z';

    for ($i = 1; $i <= $max_stars; $i++) {
        $fill_fraction = min(1, max(0, $rating - ($i - 1))); // 0–1

        if ($fill_fraction >= 1) {
            // Full star
            $output .= '<svg width="20" height="20" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                <path fill="#FBBC05" d="' . $star_path . '"/>
            </svg>';
        } elseif ($fill_fraction > 0) {
            // Partial star — ultra-precise gradient
            $gradient_id = 'grad-' . uniqid();
            $percent = round($fill_fraction * 100, 1);

            $output .= '<svg width="20" height="20" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                <defs>
                    <linearGradient id="' . $gradient_id . '" x1="0%" y1="0%" x2="100%" y2="0%">
                        <stop offset="' . $percent . '%" stop-color="#FBBC05"/>
                        <stop offset="' . $percent . '%" stop-color="#E0E0E0"/>
                    </linearGradient>
                </defs>
                <path fill="url(#' . $gradient_id . ')" d="' . $star_path . '"/>
            </svg>';
        } else {
            // Empty star
            $output .= '<svg width="20" height="20" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                <path fill="#E0E0E0" d="' . $star_path . '"/>
            </svg>';
        }
    }

    return '<div class="star-rating" style="display:flex;gap:2px;align-items:center;">' . $output . '</div>';
}

function get_time_since_update($last_updated)
{
    if (empty($last_updated))
        return 'No date available';

    $last = new DateTime($last_updated);
    $now = new DateTime();
    $diff = $now->diff($last);

    // Years
    if ($diff->y > 0) {
        return $diff->y . ' year' . ($diff->y > 1 ? 's' : '') . ' ago';
    }

    // Months
    if ($diff->m > 0) {
        return $diff->m . ' month' . ($diff->m > 1 ? 's' : '') . ' ago';
    }

    // Weeks (if less than a month)
    $weeks = floor($diff->days / 7);
    if ($weeks > 0) {
        return $weeks . ' week' . ($weeks > 1 ? 's' : '') . ' ago';
    }

    // Days
    if ($diff->d > 0) {
        return $diff->d . ' day' . ($diff->d > 1 ? 's' : '') . ' ago';
    }

    // Hours / Minutes fallback
    if ($diff->h > 0) {
        return $diff->h . ' hour' . ($diff->h > 1 ? 's' : '') . ' ago';
    }
    if ($diff->i > 0) {
        return $diff->i . ' minute' . ($diff->i > 1 ? 's' : '') . ' ago';
    }

    return 'Just now';
}
/**
 * Get all plugin_category hierarchy levels (top parent → lowest child),
 * including term links.
 *
 * @param int $post_id The post ID.
 * @return array Array of associative arrays (id, name, slug, link).
 */
function get_plugin_category_hierarchy($term_ids_csv)
{
    global $wpdb;

    $taxonomy = 'plugin_category';
    //$term_ids = json_decode($term_ids_csv, true);
    $term_ids = $term_ids_csv;
    if (empty($term_ids)) {
        return [];
    }

    // ✅ Step 1: Find topmost parent term among given IDs
    $placeholders = implode(',', array_fill(0, count($term_ids), '%d'));
    $query = $wpdb->prepare("
        SELECT term_id, parent 
        FROM {$wpdb->term_taxonomy}
        WHERE taxonomy = %s
        AND term_id IN ($placeholders)
    ", array_merge([$taxonomy], $term_ids));

    $rows = $wpdb->get_results($query);
    if (empty($rows))
        return [];

    // If any term has parent = 0 → that's the top parent
    $top_parent = null;
    foreach ($rows as $row) {
        if ((int) $row->parent === 0) {
            $top_parent = (int) $row->term_id;
            break;
        }
    }

    // Otherwise, find the oldest ancestor among them
    if (!$top_parent) {
        $possible_parents = wp_list_pluck($rows, 'parent');
        $top_parent = (int) min($possible_parents);
    }

    // ✅ Step 2: Get parent term object
    $parent_term = get_term($top_parent, $taxonomy);
    if (is_wp_error($parent_term) || !$parent_term) {
        return [];
    }
    $parent_term = get_term($top_parent, $taxonomy);

    // Step 3: Build 2D array with parent
    $hierarchy = [];
    $hierarchy[] = [
        'id' => $parent_term->term_id,
        'name' => $parent_term->name,
        'slug' => $parent_term->slug,
        'link' => get_term_link($parent_term),
        'count' => $parent_term->count,
    ];

    return $hierarchy;
    // ✅ Step 3: Get all children of parent that are also in the given CSV
    // $children = get_terms([
    //     'taxonomy' => $taxonomy,
    //     'parent' => $top_parent,
    //     'hide_empty' => false,
    //     'include' => $term_ids, // only terms inside CSV
    // ]);

    // Sort children by post count DESC
    // usort($children, function ($a, $b) {
    //     return $b->count - $a->count;
    // });

    // ✅ Step 4: Build final result (parent + filtered children)
    // $hierarchy = [];

    // Parent first
    // $hierarchy[] = [
    //     'id' => $parent_term->term_id,
    //     'name' => $parent_term->name,
    //     'slug' => $parent_term->slug,
    //     'link' => get_term_link($parent_term),
    //     'count' => $parent_term->count,
    //     'is_parent' => true,
    // ];

    // Then children
    // foreach ($children as $child) {
    //     $hierarchy[] = [
    //         'id' => $child->term_id,
    //         'name' => $child->name,
    //         'slug' => $child->slug,
    //         'link' => get_term_link($child),
    //         'count' => $child->count,
    //         'is_parent' => false,
    //     ];
    // }

    // return $hierarchy;
}

/**
 * Get all ancestors (top → current) of a plugin_category term.
 *
 * @param int $term_id The term ID.
 * @return array Array of associative arrays (id, name, slug, link).
 */
function get_plugin_category_ancestors($term_id)
{
    $taxonomy = 'plugin_category';

    $term = get_term($term_id, $taxonomy);
    if (is_wp_error($term) || !$term) {
        return [];
    }

    // ✅ Get all ancestor IDs (parents → grandparents)
    $ancestors = get_ancestors($term_id, $taxonomy);
    $ancestors = array_reverse($ancestors); // top → bottom

    $hierarchy = [];

    // ✅ Add ancestor levels
    foreach ($ancestors as $ancestor_id) {
        $ancestor = get_term($ancestor_id, $taxonomy);
        if (!is_wp_error($ancestor)) {
            $hierarchy[] = [
                'id' => $ancestor->term_id,
                'name' => $ancestor->name,
                'slug' => $ancestor->slug,
                'link' => get_term_link($ancestor),
            ];
        }
    }

    // ✅ Add the current term at the end
    $hierarchy[] = [
        'id' => $term->term_id,
        'name' => $term->name,
        'slug' => $term->slug,
        'link' => get_term_link($term),
    ];

    return $hierarchy;
}

function taxonomy_creation_log($message)
{
    // Get today's date
    $date = date('Y-m-d');

    // File path like: wp-content/taxonomy_creation_log_2025-11-12.log
    $log_file = WP_CONTENT_DIR . "/taxonomy_creation_log_{$date}.log";

    // Add timestamp
    $time = date('Y-m-d H:i:s');
    $formatted = "[$time] $message\n";

    // Create file if not exists, then append log
    if (!file_exists($log_file)) {
        file_put_contents($log_file, $formatted, FILE_APPEND | LOCK_EX);
    } else {
        error_log($formatted, 3, $log_file);
    }
}
function rating_to_percent($rating, $maxRating = 5)
{
    // Ensure numeric + clamp between 0 and maxRating
    $rating = max(0, min($maxRating, floatval($rating)));

    // Convert
    $percent = ($rating / $maxRating) * 100;

    // Round to whole percent or 1 decimal if you want
    return round($percent, 1);
}
function get_plugin_parent_categories()
{
    return get_terms([
        'taxonomy' => 'plugin_category',
        'hide_empty' => false,
        'parent' => 0,
    ]);
}


function get_front_end_for_by_score_filter_searching(float $score, array $mapping): ?string
{
    // Sort rules so higher ranges are checked first
    usort($mapping, function ($a, $b) {
        $aValue = is_array($a['value']) ? max($a['value']) : $a['value'];
        $bValue = is_array($b['value']) ? max($b['value']) : $b['value'];

        return $bValue <=> $aValue;
    });

    foreach ($mapping as $rule) {
        $operator = $rule['operator'];
        $value    = $rule['value'];

        switch ($operator) {
            case '<':
                if ($score < $value) {
                    return $rule['front_end'];
                }
                break;

            case '<=':
                if ($score <= $value) {
                    return $rule['front_end'];
                }
                break;

            case '>':
                if ($score > $value) {
                    return $rule['front_end'];
                }
                break;

            case '>=':
                if ($score >= $value) {
                    return $rule['front_end'];
                }
                break;

            case '=':
            case '==':
                if ($score == $value) {
                    return $rule['front_end'];
                }
                break;

            case 'between':
                if (
                    is_array($value) &&
                    $score >= $value[0] &&
                    $score <= $value[1]
                ) {
                    return $rule['front_end'];
                }
                break;
        }
    }

    return null;
}
function get_the_image_avatar_and_name_from_user_id($user_id, $avatar_size = 100)
{
    $user_info = get_userdata($user_id);

    // Use real first and last name
    $first_name = get_user_meta($user_id, 'first_name', true);
    $last_name = get_user_meta($user_id, 'last_name', true);

    // Build display name: First LastInitial. or fallback to WP display_name
    $the_user_display_name = ($first_name ? ucfirst($first_name) : null) .
        ($last_name ? ' ' . strtoupper($last_name[0]) . '.' : null);
    $the_user_display_name = trim($the_user_display_name) ?: $user_info->display_name;

    // Avatar image map by letter
    $data_of_charecter = [
        'A' => 'https://ui-avatars.com/api/?name=A&background=1abc9c&color=fff&size=' . $avatar_size . '',
        'B' => 'https://ui-avatars.com/api/?name=B&background=2ecc71&color=fff&size=' . $avatar_size . '',
        'C' => 'https://ui-avatars.com/api/?name=C&background=3498db&color=fff&size=' . $avatar_size . '',
        'D' => 'https://ui-avatars.com/api/?name=D&background=9b59b6&color=fff&size=' . $avatar_size . '',
        'E' => 'https://ui-avatars.com/api/?name=E&background=34495e&color=fff&size=' . $avatar_size . '',
        'F' => 'https://ui-avatars.com/api/?name=F&background=16a085&color=fff&size=' . $avatar_size . '',
        'G' => 'https://ui-avatars.com/api/?name=G&background=27ae60&color=fff&size=' . $avatar_size . '',
        'H' => 'https://ui-avatars.com/api/?name=H&background=2980b9&color=fff&size=' . $avatar_size . '',
        'I' => 'https://ui-avatars.com/api/?name=I&background=8e44ad&color=fff&size=' . $avatar_size . '',
        'J' => 'https://ui-avatars.com/api/?name=J&background=2c3e50&color=fff&size=' . $avatar_size . '',
        'K' => 'https://ui-avatars.com/api/?name=K&background=f1c40f&color=fff&size=' . $avatar_size . '',
        'L' => 'https://ui-avatars.com/api/?name=L&background=e67e22&color=fff&size=' . $avatar_size . '',
        'M' => 'https://ui-avatars.com/api/?name=M&background=e74c3c&color=fff&size=' . $avatar_size . '',
        'N' => 'https://ui-avatars.com/api/?name=N&background=95a5a6&color=fff&size=' . $avatar_size . '',
        'O' => 'https://ui-avatars.com/api/?name=O&background=f39c12&color=fff&size=' . $avatar_size . '',
        'P' => 'https://ui-avatars.com/api/?name=P&background=d35400&color=fff&size=' . $avatar_size . '',
        'Q' => 'https://ui-avatars.com/api/?name=Q&background=c0392b&color=fff&size=' . $avatar_size . '',
        'R' => 'https://ui-avatars.com/api/?name=R&background=bdc3c7&color=fff&size=' . $avatar_size . '',
        'S' => 'https://ui-avatars.com/api/?name=S&background=7f8c8d&color=fff&size=' . $avatar_size . '',
        'T' => 'https://ui-avatars.com/api/?name=T&background=ff6f61&color=fff&size=' . $avatar_size . '',
        'U' => 'https://ui-avatars.com/api/?name=U&background=6c5ce7&color=fff&size=' . $avatar_size . '',
        'V' => 'https://ui-avatars.com/api/?name=V&background=00b894&color=fff&size=' . $avatar_size . '',
        'W' => 'https://ui-avatars.com/api/?name=W&background=fd79a8&color=fff&size=' . $avatar_size . '',
        'X' => 'https://ui-avatars.com/api/?name=X&background=e84393&color=fff&size=' . $avatar_size . '',
        'Y' => 'https://ui-avatars.com/api/?name=Y&background=0984e3&color=fff&size=' . $avatar_size . '',
        'Z' => 'https://ui-avatars.com/api/?name=Z&background=636e72&color=fff&size=' . $avatar_size . '',
    ];

    // Determine character for avatar — from first name or display name
    $first_char = strtoupper($first_name[0] ?? $user_info->display_name[0] ?? '');

    // Get the external profile image if it exists


    // Use the external image if available, otherwise fallback to character-based avatar
    $avatar_url = $data_of_charecter[$first_char];

    return [
        'display_name' => $the_user_display_name,
        'avatar' => $avatar_url
    ];
}
function get_the_display_image_user_id($user_id)
{
    $profile_image_url = get_user_meta($user_id, 'profile_image', true);
    $profile_image_url = $profile_image_url ? esc_url(wp_upload_dir()['baseurl'] . $profile_image_url) : get_the_image_avatar_and_name_from_user_id($user_id)['avatar'];
    return $profile_image_url;
}
function wp_stack_to_slug(string $text): string
{
    // Normalize
    $text = trim($text);

    // Convert to lowercase
    $text = strtolower($text);

    // Replace @ with readable token
    $text = str_replace('@', '--at--', $text);

    // Replace dots in emails
    $text = str_replace('.', '--dot--', $text);

    // Replace spaces and dashes
    $text = preg_replace('/[\s\-]+/', '-', $text);

    // Remove unsafe characters
    $text = preg_replace('/[^a-z0-9\-]/', '', $text);

    return trim($text, '-');
}
