<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package wpsearch
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="profile" href="https://gmpg.org/xfn/11">

  <?php wp_head(); ?>
</head>
<?php


$header_menu_left = wp_get_full_menu_array("header_menu_left");
$header_menu_right = wp_get_full_menu_array("header_menu_right");
$top_categories = get_option("top_plugin_categories");



?>


<body <?php body_class(); ?>>
  <div id="preloader">
    <div class="spinner-container">
      <div class="spinner"></div>
      <div class="loading-text">Loading...</div>
    </div>
  </div>
  <?php wp_body_open(); ?>
  <header class="sticky top-0 z-30 bg-white backdrop-blur border-b border-[#F2F2F2] lg:border-0">
    <div class="container">
      <div class="flex items-center justify-between py-4 lg:py-0">
        <!-- Logo -->
        <div class="lg:mr-8 xl:mr-[52px]">
          <a href="<?php echo site_url(); ?>" class="">
            <img class="max-w-[226.99px] object-cover object-center"
              src="<?php echo asset_image_path_generator() . 'logo.webp' ?>" alt="Logo Images" />
          </a>
        </div>

        <!-- Menu -->
        <div
          class="w-[100%] hidden lg:flex justify-between items-center text-base text-[var(--theme-color)] font-bold leading-[160%]">
          <div class="flex">
            <?php
            foreach ($header_menu_left as $single) {
            ?>
              <a href="<?php echo $single['url'] ?>" class="px-2 xl:px-4 py-[30px] hover:opacity-65 duration-500">
                <?php echo $single['title'] ?>
              </a>
            <?php
            }
            ?>
            <!-- Plugin Category Mega Menu -->
            <div class="relative group">
              <a href="#" class="flex items-center space-x-1 px-2 xl:px-4 py-[30px] hover:opacity-65 duration-500">
                <span>Plugin Category</span>
                <div class="w-5 min-w-5 h-5">
                  <img
                    class="object-contain object-center transform transition-transform duration-300 group-hover:rotate-180"
                    src="<?php echo asset_image_path_generator() ?>angleDown.svg" alt="▼" />
                </div>
              </a>

              <div
                class="fixed top-[85px] bg-white opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300 z-30 shadow-[0px_12px_12px_0px_#3941491F] rounded-md">
                <div class="h-96 xl:h-auto overflow-y-auto">
                  <div
                    class="grid grid-cols-1 xl:grid-cols-2 xl:space-x-10 p-6 text-sm md:text-base font-bold leading-[160%]">
                    <?php
                    if (!empty($top_categories)) {
                      $total = count($top_categories);
                      $chunk_size = ceil($total / 2);
                      $parts = array_chunk($top_categories, $chunk_size);

                      foreach ($parts as $index => $group) {
                        $template = get_template_directory() . '/frontend/header-includes/mega-menu-part.php';

                        if (file_exists($template)) {
                          $part_index = $index + 1;
                          $categories = $group;
                          include $template;
                        }
                      }
                    }
                    ?>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="flex items-center">
            <?php
            foreach ($header_menu_right as $single) {
            ?>
              <a href="<?php echo $single['url'] ?>" class="px-2 xl:px-4 py-[30px] hover:opacity-65 duration-500">
                <?php echo $single['title'] ?>
              </a>
            <?php

            }
            if (!is_user_logged_in()) {
            ?>
              <a href="<?= site_url('/sign-up') ?>"
                class="ml-5 xl:ml-6 px-5 lg:px-6 py-2 lg:py-[14px] text-white bg-blue-700 inline-block rounded-[54px] bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] hover:opacity-80 duration-500 whitespace-nowrap">
                Sign in
              </a>
            <?php
            } else {
            ?>
              <a href="<?= site_url('/dashboard') ?>"
                class="ml-6 bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] border-4 border-[#213CCD] hover:opacity-80 rounded-[54px] duration-500 whitespace-nowrap overflow-hidden">
                <img class="w-8 h-8 min-w-8 lg:w-[46px] lg:h-[46px] lg:min-w-[46px] object-contain object-center"
                  src="<?= get_the_display_image_user_id(get_current_user_id()) ?>" alt="" />
              </a>

            <?php
            }
            ?>

          </div>
        </div>

        <div>
          <button id="mobileMenuBtn" class="lg:hidden relative p-2">
            <img id="menuIcon" class="block w-6 min-w-6 h-6 object-contain object-center"
              src="<?php echo asset_image_path_generator() ?>menu.svg" />
            <img id="closeIcon" class="hidden w-6 min-w-6 h-6 object-contain object-center"
              src="<?php echo asset_image_path_generator() ?>close-fill.svg" />
          </button>
        </div>
      </div>
    </div>
  </header>

  <!-- Mobile menu start -->
  <div class="lg:hidden">
    <div id="topDrawer"
      class="fixed left-0 right-0 z-20 top-0 -translate-y-full bg-white rounded-b-xl transition-transform duration-500"
      tabindex="-1">
      <!-- MAIN MENU (default visible inside drawer) -->
      <div id="mobileMenuMain"
        class="p-4 flex flex-col space-y-2 text-base font-bold relative max-h-[80vh] overflow-y-auto scrollbarHide">
        <a href="page-wizard-7.html" class="px-5 py-2 hover:bg-gray-100 rounded-xl">Discover</a>

        <div>
          <button id="pluginCategoryBtn" type="button"
            class="flex justify-between items-center w-full px-5 py-2 hover:bg-gray-100 rounded-xl">
            <span>Plugin Category</span>
            <img class="w-6 min-w-6 h-6 object-contain object-center rotate-[-90deg]"
              src="<?php echo asset_image_path_generator() ?>angleDown.svg" />
          </button>
        </div>
        <?php
        foreach ($header_menu_right as $single) {
        ?>
          <a href="<?php echo $single['url'] ?>" class="px-5 py-2 hover:bg-gray-100 rounded-xl">
            <?php echo $single['title'] ?>
          </a>
        <?php

        }
        if (!is_user_logged_in()) {
        ?>
          <a href="<?= site_url('/sign-up') ?>"
            class="px-5 py-3 text-center text-white rounded-[54px] bg-gradient-to-r from-[#1C37D1] to-[#0E70DD]">
            Sign in
          </a>
        <?php
        } else {
        ?>
          <a href="<?= site_url('/dashboard') ?>"
            class="overflow-hidden flex justify-center items-center w-[40px] min-w-[40px] h-[40px] ml-6 border-4 border-[#213CCD] hover:opacity-80 rounded-[54px] duration-500 whitespace-nowrap">
            <img class="w-8 h-8 min-w-8 lg:w-[46px] lg:h-[46px] lg:min-w-[46px] object-contain object-center rounded-full"
              src="<?= get_the_display_image_user_id(get_current_user_id()) ?>" alt="" />
          </a>

        <?php
        }
        ?>
      </div>

      <!-- SUBMENU (initially hidden, sits on top of main area and slides down) -->
      <div id="mobileSubmenu"
        class="absolute inset-x-0 top-0 -translate-y-full opacity-0 pointer-events-none transition-all duration-500 ease-in-out z-40">
        <div class="space-y-[18px] p-6 text-sm md:text-base font-bold leading-[160%] bg-white rounded-b-xl">
          <!-- Back button -->
          <button id="submenuBackBtn" class="flex items-center">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path
                d="M11.8284 12.0005L14.6569 14.8289L13.2426 16.2431L9 12.0005L13.2426 7.75781L14.6569 9.17203L11.8284 12.0005Z"
                fill="#727C89" />
            </svg>
            <span class="ml-2 text-[#727C89]">Plugin Category</span>
          </button>

          <div class="max-h-[70vh] overflow-y-auto scrollbarHide">
            <?php
            if (!empty($top_categories))
              foreach ($categories as $cat): ?>
              <a href="<?= esc_url($cat['link'] ?? '#') ?>"
                class="px-3 py-2 flex items-center space-x-3 hover:bg-[#1A2DC90A] rounded-xl duration-300">
                <div
                  class="w-9 min-w-9 h-9 object-contain object-center flex justify-center items-center bg-[#1A2DC90A] rounded-xl">
                  <img class="w-5 min-w-5 h-5 object-contain object-center"
                    src="<?php echo get_term_meta($cat['term_id'], 'plugin_category_image', true) ?>"
                    alt="layout-grid-fill" />
                </div>
                <span><?= esc_html($cat['name'] ?? '') ?></span>
              </a>
            <?php endforeach; ?>

          </div>
        </div>
      </div>
    </div>

    <div id="menuOverlay"
      class="fixed inset-0 bg-black bg-opacity-50 z-10 opacity-0 pointer-events-none transition-opacity duration-500">
    </div>
  </div>
  <!-- Mobile menu end -->