
    <script>

    // ------------------------------------------------------------
    // 👆 Button click tick mark toggle add Categories page
    // ------------------------------------------------------------
    jQuery(function ($) {
        function set_unset_with_category(category_id, isLoad = true) {
            // Convert to string to ensure consistent comparison
            category_id = String(category_id);

            let category_ids = $('[name="category_ids"]').val() || '';
            let idArray = category_ids ? category_ids.split(',') : [];

            const index = idArray.indexOf(category_id);

            if (index !== -1) {
                // Already selected → remove it
                idArray.splice(index, 1);
            } else {
                // Not selected → add it
                idArray.push(category_id);
            }

            // Update the hidden input
            $('[name="category_ids"]').val(idArray.join(','));

            // Submit the form
            if (isLoad) {

                $('#filter_form').submit();
            }
        }

        function set_unset_with_tag(tag_id, isLoad = true) {
            // Convert to string to ensure consistent comparison
            tag_id = String(tag_id);

            let tag_ids = $('[name="tag_ids"]').val() || '';
            let idArray = tag_ids ? tag_ids.split(',') : [];

            const index = idArray.indexOf(tag_id);

            if (index !== -1) {
                // Remove tag
                idArray.splice(index, 1);
            } else {
                // Add tag
                idArray.push(tag_id);
            }

            // Update hidden input
            $('[name="tag_ids"]').val(idArray.join(','));

            // Submit form
            if (isLoad) {

                $('#filter_form').submit();
            }
        }

        $(".categoryBtnTickMarkAdd").click(function () {
            var $btn = $(this);
            var $tick = $btn.find(".tickMarkAdd");

            $tick.toggleClass("hidden");
            $btn.toggleClass("border-blue-500 border-gray-300 bg-white bg-[#F8F8F8]");

            const category_id = $btn.attr('data-category_id');
            if (!category_id) return;

            set_unset_with_category(category_id);
        });

        $(".tagBtnTickMarkAdd").click(function () {
            var $btn = $(this);
            var $tick = $btn.find(".tickMarkAddTag");

            $tick.toggleClass("hidden");
            $btn.toggleClass("border-blue-500 border-gray-300 bg-white bg-[#F8F8F8]");

            const tag_id = $btn.attr('data-tag_id');
            if (!tag_id) return;

            set_unset_with_tag(tag_id);
        });

        const dataAttributes = [
            'overall_wpscore',
            'rating',
            'last_update',
            'active_install',
            'support_quality',
            'performace_impact',  // Note: You have a typo here - should be 'performance_impact'
            'user_review_sentiment',
            'multilingual_support'
        ];

        // Loop through the dataAttributes array and set up event handlers dynamically
        dataAttributes.forEach(function (attribute) {
            $(`.${attribute}`).on('click', function () {
                const value = $(this).data(attribute);
                if (value !== undefined) {
                    $(`[name="${attribute}"]`).val(value);
                }
                $('#filter_form').submit();
            });
        });

        $(".close_header_select").on('click', function (e) {
            e.preventDefault();

            const field = $(this).data("field");
            const cat_id_remove = $(this).data("cat_id_remove");
            const tag_id_remove = $(this).data("tag_id_remove");

            if (field) {
                $(`[name="${field}"]`).val('');
                $('#filter_form').submit();
            } else if (tag_id_remove !== undefined) {
                set_unset_with_tag(tag_id_remove);
            } else if (cat_id_remove !== undefined) {
                set_unset_with_category(cat_id_remove);
            }
        });
        $(".clear_all_filter").on('click', function (e) {
            //alert("Ada");
            e.preventDefault();

            // Method 1: Use native JavaScript reset (recommended)
            //$('#filter_form')[0].reset();

            // Method 2: Alternative - clear all inputs manually
            $('#filter_form').find('input, select, textarea').val('');

            // Submit the form after clearing
            $('#filter_form').submit();
        });
        $(".show_results_submit").on('click', function (e) {
            e.preventDefault();
            $('#filter_form').submit();
        })
    });




    //SubCategory Searching //
    jQuery(function ($) {
        // Search functionality for categories
        $("#category_type_area").on("input", function () {
            var searchTerm = $(this).val().toLowerCase();

            // Filter all category labels
            $(".categoryBtnTickMarkAdd").each(function () {
                var categoryText = $(this).find("span").text().toLowerCase();

                // Show or hide the category based on the search term
                if (categoryText.indexOf(searchTerm) !== -1) {
                    $(this).show();  // Show matching category
                } else {
                    $(this).hide();  // Hide non-matching category
                }
            });

            // Hide the "Show more +" button during search
            $("#show_more_sub_categories_button").hide(); // Hide "Show more" when searching

            // Always show additional subcategories during search
            $("#show_more_sub_categories").show();

            // If the search input is empty, trigger the cleaning button
            if (searchTerm.trim() === "") {
                $("#category_cleaning_button").click();  // Automatically trigger category cleaning button
            }
        });

        // Show more subcategories (toggle functionality)
        $("#show_more_sub_categories_button").on("click", function () {
            // Toggle the display of the additional subcategories
            $("#show_more_sub_categories").toggle();

            // Change the text between "Show more +" and "Show less"
            var currentText = $(this).find("span").text();
            if (currentText === "Show more +") {
                $(this).find("span").text("Show less -");
            } else {
                $(this).find("span").text("Show more +");
            }
        });

        // Close search functionality (clear the search input and reset the display)
        $("#category_cleaning_button").on("click", function () {
            $("#category_type_area").val("");  // Clear the search input
            $(".categoryBtnTickMarkAdd").show();  // Show all categories
            $("#show_more_sub_categories_button").show(); // Ensure "Show more +" is visible
            $("#show_more_sub_categories").hide(); // Hide the extra subcategories if not already shown
        });
    });
    //SubCategory Searching //
    //Tag Searching
    jQuery(function ($) {
        // Search functionality for categories
        $("#tag_type_area").on("input", function () {
            var searchTerm = $(this).val().toLowerCase();

            // Filter all tag labels
            $(".tagBtnTickMarkAdd").each(function () {
                var tagText = $(this).find("span").text().toLowerCase();

                // Show or hide the tag based on the search term
                if (tagText.indexOf(searchTerm) !== -1) {
                    $(this).show();  // Show matching tag
                } else {
                    $(this).hide();  // Hide non-matching tag
                }
            });
            $("#show_more_sub_tags").show();
            // If the search input is empty, trigger the cleaning button
            if (searchTerm.trim() === "") {
                $("#tag_cleaning_button").click();  // Automatically trigger tag cleaning button
            }
        });


        // Close search functionality (clear the search input and reset the display)
        $("#tag_cleaning_button").on("click", function () {
            $("#tag_type_area").val("");  // Clear the search input
            $(".tagBtnTickMarkAdd").show();  // Show all categories
        });
    });
    //Tag Searching

</script>
