
    <script>
    // ------------------------------------------------------------
    // Drawer + Sidebar (Desktop & Mobile)
    // ------------------------------------------------------------
    jQuery(function ($) {
        const $drawer = jQuery("#leftSidebarMd");
        let startY = 0,
            endY = 0;

        $("[data-drawer-show='leftSidebarMd']").on("click", function () {
            $drawer.removeClass("translate-y-full").addClass("transform-none");

            // Add custom overlay if not exist
            if (jQuery("[drawer-backdrop]").length === 0) {
                jQuery("body").append(
                    '<div drawer-backdrop class="bg-black/40 fixed inset-0 z-30"></div>'
                );
            }

            // Disable scroll
            jQuery("body").addClass("overflow-hidden");
        });

        function closeDrawer() {
            $drawer
                .removeClass("transform-none")
                .addClass("translate-y-full")
                .css("transform", "");

            // Remove custom overlay
            jQuery("[drawer-backdrop]").remove();

            // Enable scroll
            jQuery("body").removeClass("overflow-hidden");
        }

        jQuery("body").on("click", "[drawer-backdrop]", closeDrawer);

        $drawer.on("click", "[data-drawer-hide='leftSidebarMd']", closeDrawer);

        $drawer.on("touchstart", function (e) {
            startY = e.originalEvent.touches[0].clientY;
        });

        $drawer.on("touchmove", function (e) {
            endY = e.originalEvent.touches[0].clientY;
            let distance = endY - startY;
            if (distance > 0) {
                $drawer.css("transform", "translateY(" + distance + "px)");
            }
        });

        $drawer.on("touchend", function () {
            let drawerHeight = $drawer.outerHeight();
            let distance = endY - startY;

            if (distance > drawerHeight / 3) {
                closeDrawer();
            } else {
                // Snap back
                $drawer
                    .css("transform", "")
                    .css("transition", "transform 0.3s ease");
                setTimeout(() => $drawer.css("transition", ""), 300);
            }

            startY = 0;
            endY = 0;
        });

        // ----------------------------
        // Optional: Toggle Desktop Sidebar (Your previous button)
        // ----------------------------
        if (jQuery("#filterBtnLg").length) {
            jQuery("#filterBtnLg").on("click", function () {
                jQuery(this).toggleClass("active");
                jQuery("#leftSidebarLg").toggleClass("active");
            });
        }
    });

    // ------------------------------------------------------------
    // 🔍 Search Bottom Sheet (Mobile Only)
    // ------------------------------------------------------------
    jQuery(function ($) {
        function isMobile() {
            return $(window).width() <= 1023;
        }

        const $sheet = $("#searchSheet");
        const $overlay = $("#searchOverlay");
        const $content = $("#searchSheet .sheet-body");

        let startY = 0;
        let currentY = 0;
        let dragging = false;

        function lockScroll() {
            $("body").css("overflow", "hidden");
        }

        function unlockScroll() {
            $("body").css("overflow", "");
        }

        function openSheet() {
            if (!isMobile()) return;

            $sheet
                .removeClass("translate-y-full")
                .css("transform", "translateY(0)");
            $overlay.removeClass("hidden");

            setTimeout(() => $overlay.removeClass("opacity-0"), 10);
            lockScroll();
        }

        function closeSheet() {
            $sheet
                .addClass("translate-y-full")
                .css("transform", "translateY(100%)");
            $overlay.addClass("opacity-0");

            setTimeout(() => $overlay.addClass("hidden"), 300);
            setTimeout(() => unlockScroll(), 300);
        }

        // Open/Close triggers
        $("#openSearch").on("click", openSheet);
        $("#closeSearch").on("click", closeSheet);
        $overlay.on("click", closeSheet);

        // TOUCH START
        $sheet.on("touchstart", function (e) {
            if (!isMobile()) return;
            if ($content.scrollTop() > 0) return;

            dragging = true;
            startY = e.touches[0].clientY;
            currentY = startY;
            $sheet.css("transition", "none");
        });

        // TOUCH MOVE
        $sheet.on("touchmove", function (e) {
            if (!dragging) return;

            currentY = e.touches[0].clientY;
            let diff = currentY - startY;

            if (diff > 5) {
                // Ignore very small movement
                let resistance = diff * 0.3;
                $sheet.css("transform", `translateY(${resistance}px)`);
            }
        });

        // TOUCH END
        $sheet.on("touchend", function () {
            if (!dragging) return;
            dragging = false;

            let diff = currentY - startY;
            let sheetHeight = $sheet.outerHeight();
            let threshold = sheetHeight * 0.5;

            $sheet.css("transition", "transform 0.3s ease");

            if (diff > threshold) {
                closeSheet();
            } else {
                // Snap back smoothly
                $sheet.css("transform", "translateY(0)");
            }
        });
    });

    // ------------------------------------------------------------
    // Result Page Sort by Menu (Desktop & Mobile)
    // ------------------------------------------------------------
    jQuery(function ($) {
        let isOpen = false;
        const sortBtn = $("#sortBtn");
        const sortMenu = $("#sortMenu");
        const mobileOverlay = $("#mobileOverlay");
        const sortItems = $(".sortItem");
        const mobileCloseBtn = $("#sortMenu button img[alt='']");
        const dragHandle = $("#sortMenu .lg\\:hidden");

        function closeSortMenu() {
            sortMenu.css({
                animation: "slideDown 0.35s ease forwards",
            });

            setTimeout(() => {
                sortMenu.addClass("hidden");
                mobileOverlay.hide();
                $("body").removeClass("bodyNoScrollSortBy");
                sortMenu.css("animation", "");
                sortMenu.css("transform", "translateY(0)");
                isOpen = false;
            }, 350);
        }

        // Open / Close Button
        sortBtn.on("click", function (e) {
            e.stopPropagation();
            isOpen = !isOpen;

            if (isOpen) {
                sortMenu
                    .removeClass("hidden")
                    .css("animation", "slideUp 0.35s ease forwards");

                mobileOverlay.show();
                $("body").addClass("bodyNoScrollSortBy");
            } else {
                closeSortMenu();
            }
        });

        // Sort Item Active Toggle
        sortItems.on("click", function (e) {
            e.stopPropagation();
            $(this).toggleClass("active");
        });

        // Close when clicking outside
        $(document).on("click", function () {
            if (!isOpen) return;
            closeSortMenu();
        });

        // Prevent closing when clicking inside menu
        sortMenu.on("click", function (e) {
            e.stopPropagation();
        });

        // Mobile Close Button
        mobileCloseBtn.on("click", function (e) {
            e.stopPropagation();
            closeSortMenu();
        });

        // Overlay Close
        mobileOverlay.on("click", function () {
            closeSortMenu();
        });

        // Mobile Drag Down to Close
        let startY = 0;
        let currentY = 0;
        let isDragging = false;

        dragHandle.on("touchstart", function (e) {
            startY = e.originalEvent.touches[0].clientY;
            isDragging = true;
            sortMenu.css("transition", "none");
        });

        dragHandle.on("touchmove", function (e) {
            if (!isDragging) return;

            currentY = e.originalEvent.touches[0].clientY;
            let diff = currentY - startY;

            if (diff > 0) {
                sortMenu.css("transform", `translateY(${diff}px)`);
            }
        });

        dragHandle.on("touchend", function () {
            isDragging = false;
            sortMenu.css("transition", "transform 0.3s ease");

            let diff = currentY - startY;

            if (diff > 100) {
                closeSortMenu();
            } else {
                sortMenu.css("transform", `translateY(0)`);
            }
        });

        // ✅ NEW FEATURE: Auto Close When Screen < 1024px
        $(window).on("resize", function () {
            if (isOpen) {
                const width = $(window).width();
                if (width < 1024) {
                    closeSortMenu();
                }
            }
        });
    });

    // ------------------------------------------------------------
    // Scroll Slider button
    // ------------------------------------------------------------
    jQuery(document).ready(function ($) {
        $(".scrollSlider").each(function () {
            const slider = $(this);
            let isDown = false;
            let startX;
            let scrollLeft;

            function canScrollHorizontally() {
                const el = slider[0];
                return el.scrollWidth > el.clientWidth;
            }

            slider.on("mousedown", function (e) {
                if (!canScrollHorizontally()) return;

                isDown = true;
                slider.addClass("dragging");
                startX = e.pageX - slider.offset().left;
                scrollLeft = slider.scrollLeft();
                e.preventDefault();
            });

            slider.on("mouseleave mouseup", function () {
                isDown = false;
                slider.removeClass("dragging");
            });

            slider.on("mousemove", function (e) {
                if (!isDown || !canScrollHorizontally()) return;

                const x = e.pageX - slider.offset().left;
                const walk = (x - startX) * 1.5;
                slider.scrollLeft(scrollLeft - walk);
            });

            // Scroll with mouse wheel
            slider.on("wheel", function (e) {
                const el = slider[0];
                if (!canScrollHorizontally()) return;

                const maxScroll = el.scrollWidth - el.clientWidth;
                const newScroll = el.scrollLeft + e.originalEvent.deltaY;

                // Only scroll if within bounds
                if (newScroll >= 0 && newScroll <= maxScroll) {
                    e.preventDefault();
                    el.scrollLeft = newScroll;
                }
            });
        });
    });

    // ------------------------------------------------------------
    // ⭐ Custom Accordion Toggle toggle (open by default)
    // ------------------------------------------------------------
    jQuery(function ($) {
        $(".customAccordionToggle").on("click", function () {
            let content = $(this).next();
            let icon = $(this).find("svg");

            // content show/hide
            content.toggleClass("hidden");

            // icon rotate
            icon.toggleClass("rotate-[-90deg]");
        });
    });
</script>
