<!-- Tags -->
<div class="border-b border-[#F2F2F2]">
    <button
        class="customAccordionToggle pl-[30px] lg:pl-12 xl:pl-[60px] pr-[30px] py-[30px] flex items-center justify-between w-full text-gray-800 font-semibold">
        <span class="text-[10px]">Tag</span>

        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" class="transition-transform duration-300 rotate-0"
            xmlns="http://www.w3.org/2000/svg">
            <path
                d="M11.9997 13.1714L16.9495 8.22168L18.3637 9.63589L11.9997 15.9999L5.63574 9.63589L7.04995 8.22168L11.9997 13.1714Z"
                fill="#A1A7B1" />
        </svg>
    </button>

    <div class="pl-[30px] lg:pl-12 xl:pl-[60px] pr-[30px] py-[30px] pt-0 space-y-[18px]">
        <!-- Search Input -->
        <div class="border-b border-[#F2F2F2]">
            <label class="relative w-full">
                <span class="absolute top-1/2 -translate-y-1/2 left-0 w-5 min-w-5 h-5">
                    <img class="w-5 min-w-5 h-5 object-contain object-center"
                        src="<?php echo asset_image_path_generator() ?>search.svg" alt="search-image" />
                </span>
                <button class="absolute top-1/2 -translate-y-1/2 right-0 w-5 min-w-5 h-5" id="tag_cleaning_button">
                    <img class="w-5 min-w-5 h-5 object-contain object-center close_icon"
                        src="<?php echo asset_image_path_generator() ?>close-circle.svg" alt="close-circle-image" />
                </button>
                <input type="text"
                    class="noAutofillBg w-full px-8 py-[14.8px] text-base font-normal leading-[160%] border-none placeholder:text-[#A1A7B1]"
                    placeholder="Search Tags" id="tag_type_area" />
            </label>
        </div>

        <!-- Tags List -->
        <div class="-m-1">
            <div class="flex flex-wrap">
                <?php
                if (!empty($selected_tag_ids_array)) {
                    foreach ($_all_child_tags as $k => $item) {
                        if (in_array($item['id'], $selected_tag_ids_array)) {
                ?>
                            <label for="tag_<?php echo $item['id'] ?>"
                                class="tagBtnTickMarkAdd w-auto m-1 px-3 py-2.5 flex items-center border border-[#F2F2F2] outline-none duration-300 rounded-full cursor-pointer border-blue-500 border-gray-300 bg-white"
                                data-tag_id="<?php echo $item['id'] ?>">
                                <img class="tickMarkAddTag mr-2 w-[13px] min-w-[13px] h-[9px] object-contain object-center"
                                    src="<?php echo asset_image_path_generator() ?>category-page/TickMark.svg" alt="TickMark" />
                                <span><?php echo htmlspecialchars($item["name"]) ?></span>
                            </label>
                    <?php
                        }
                    }
                }
                // Assume $tag_chunk[0] = visible tags, $tag_chunk[1] = hidden ones (Show more)
                foreach ($first_chunk_tag as $key => $tag) {

                    if (in_array($tag['id'], $selected_tag_ids_array)) continue; // your selected tags array
                    ?>
                    <label for="tag_<?php echo $tag['id'] ?>"
                        class="tagBtnTickMarkAdd w-auto m-1 px-3 py-2.5 text-[#727C89]  flex items-center bg-[#F8F8F8] border border-[#F2F2F2] outline-none duration-300 rounded-full cursor-pointer"
                        data-tag_id="<?php echo $tag['id'] ?>">
                        <img class="tickMarkAddTag mr-2 w-[13px] min-w-[13px] h-[9px] object-contain object-center hidden"
                            src="<?php echo asset_image_path_generator() ?>category-page/TickMark.svg" alt="TickMark" />
                        <span><?php echo htmlspecialchars($tag["name"]) ?></span>
                    </label>
                <?php
                }
                ?>
                <div id="show_more_sub_tags" style="display:none">
                    <?php
                    foreach ($second_chunk_tag as $key => $tag) {

                        if (in_array($tag['id'], $selected_tag_ids_array)) continue; // your selected tags array
                    ?>
                        <label for="tag_<?php echo $tag['id'] ?>"
                            class="tagBtnTickMarkAdd w-auto m-1 px-3 py-2.5 text-[#727C89] flex items-center bg-[#F8F8F8] border border-[#F2F2F2] outline-none duration-300 rounded-full cursor-pointer"
                            data-tag_id="<?php echo $tag['id'] ?>">
                            <img class="tickMarkAddTag mr-2 w-[13px] min-w-[13px] h-[9px] object-contain object-center hidden"
                                src="<?php echo asset_image_path_generator() ?>category-page/TickMark.svg" alt="TickMark" />
                            <span><?php echo htmlspecialchars($tag["name"]) ?></span>
                        </label>
                    <?php
                    }

                    ?>
                </div>
            </div>
        </div>
    </div>
</div>