<div class="space-y-8">
    <div
        class="flex flex-col sm:flex-row justify-between items-start sm:items-center space-y-4 sm:space-y-0 sm:space-x-1">
        <h2 class="text-[22px] md:text-[25px] font-bold leading-[120%]">
            Reviews (<?= $the_plugin_information->num_ratings ?>)
        </h2>

        <!-- <div class="overflow-x-auto"></div> -->

        <div
            class="space-y-2 sm:space-y-0 sm:space-x-3 text-[13px] flex flex-col sm:flex-row items-start sm:items-center">
            <h6 class="whitespace-nowrap">Sort by:</h6>

            <!-- Tabs -->
            <div class="">
                <div class="flex space-x-2 font-bold leading-[120%]">
                    <button
                        class="tabBtnPluginReviews px-3 py-[9.5px] text-white bg-[linear-gradient(90deg,_#1C37D1_0%,_#0E70DD_100%)] border border-[#1C37D1] hover:opacity-80 duration-300 rounded-[54px] overflow-hidden"
                        data-tab="relevant">
                        Relevant
                    </button>
                    <button
                        class="tabBtnPluginReviews px-3 py-[9.5px] text-[#1A2DC9] hover:text-white bg-white hover:bg-[linear-gradient(90deg,_#1C37D1_0%,_#0E70DD_100%)] hover:border-[#1C37D1] border border-[#F2F2F2] duration-300 rounded-[54px] overflow-hidden"
                        data-tab="newest">
                        Newest
                    </button>
                    <button
                        class="tabBtnPluginReviews px-3 py-[9.5px] text-[#1A2DC9] hover:text-white bg-white hover:bg-[linear-gradient(90deg,_#1C37D1_0%,_#0E70DD_100%)] hover:border-[#1C37D1] border border-[#F2F2F2] duration-300 rounded-[54px] overflow-hidden"
                        data-tab="highest">
                        Highest
                    </button>
                    <button
                        class="tabBtnPluginReviews px-3 py-[9.5px] text-[#1A2DC9] hover:text-white bg-white hover:bg-[linear-gradient(90deg,_#1C37D1_0%,_#0E70DD_100%)] hover:border-[#1C37D1] border border-[#F2F2F2] duration-300 rounded-[54px] overflow-hidden"
                        data-tab="lowest">
                        Lowest
                    </button>
                </div>
            </div>
        </div>
    </div>

    <div class="tabContentPluginReviews space-y-6 lg:space-y-8" id="relevant">
        <?php
        //$relevent_commets = plugin_cpt_frontend_load::get_the_relevent_comments($the_plugin_information->slug, "relevent");
        if (!empty($all_comments['relevent'])) {
            foreach ($all_comments['relevent'] as $single_comment) {


                ?>
                <div class="p-6 space-y-6 border border-[#F2F2F2] rounded-[30px] overflow-hidden">
                    <strong>
                        <?= $single_comment['comment_title'] ?>
                    </strong>
                    <p>
                        <?= $single_comment['comment_text'] ?>
                    </p>

                    <div class="flex items-center space-x-3 text-black">
                        <img class="w-[46px] min-w-[46px] h-[46px] object-contain object-center rounded-full overflow-hidden"
                            src="<?= $single_comment['commenter_image_link'] ?>" alt="review Profile Image" />
                        <div class="space-y-2">
                            <strong><?= $single_comment['commenter_name'] ?></strong>
                            <div class="flex flex-wrap items-center space-x-2">
                                <div class="flex items-center">
                                    <?= render_star_rating($single_comment['commenter_num_rating']) ?>
                                </div>

                                <p><?= $single_comment['comment_date'] ?></p>
                                <span class="text-[#E0E0E0]">|</span>
                                <p><?= $single_comment['no_of_reply'] ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
            }
        }
        ?>
        <div>
            <a href="https://wordpress.org/support/<?= $the_plugin_information->slug ?>/reviews"
                class="group w-full sm:w-auto px-6 py-1.5 space-x-2.5 font-bold inline-flex justify-center sm:justify-normal items-center text-[#1A2DC9] border border-[#1B3CD2] hover:text-white hover:bg-[linear-gradient(90deg,_#1C37D1_0%,_#0E70DD_100%)] duration-300 rounded-[54px]">
                <span>Read All <?= $the_plugin_information->num_ratings ?> Reviews</span>
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path class="group-hover:fill-white"
                        d="M10.7814 7.33327L7.20539 3.75726L8.14819 2.81445L13.3337 7.99993L8.14819 13.1853L7.20539 12.2425L10.7814 8.6666H2.66699V7.33327H10.7814Z"
                        fill="#1A2DC9" />
                </svg>
            </a>
        </div>
    </div>
    <div class="tabContentPluginReviews space-y-6 lg:space-y-8 hidden" id="newest">
        <?php
        //$relevent_commets = plugin_cpt_frontend_load::get_the_relevent_comments($the_plugin_information->slug, "newest");
        if (!empty($all_comments['newest'])) {
            foreach ($all_comments['newest'] as $single_comment) {


                ?>
                <div class="p-6 space-y-6 border border-[#F2F2F2] rounded-[30px] overflow-hidden">
                    <strong>
                        <?= $single_comment['comment_title'] ?>
                    </strong>
                    <p>
                        <?= $single_comment['comment_text'] ?>
                    </p>

                    <div class="flex items-center space-x-3 text-black">
                        <img class="w-[46px] min-w-[46px] h-[46px] object-contain object-center rounded-full overflow-hidden"
                            src="<?= $single_comment['commenter_image_link'] ?>" alt="review Profile Image" />
                        <div class="space-y-2">
                            <strong><?= $single_comment['commenter_name'] ?></strong>
                            <div class="flex flex-wrap items-center space-x-2">
                                <div class="flex items-center">
                                    <?= render_star_rating($single_comment['commenter_num_rating']) ?>
                                </div>

                                <p><?= $single_comment['comment_date'] ?></p>
                                <span class="text-[#E0E0E0]">|</span>
                                <p><?= $single_comment['no_of_reply'] ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
            }
        }
        ?>
        <div>
            <a href="https://wordpress.org/support/<?= $the_plugin_information->slug ?>/reviews"
                class="group w-full sm:w-auto px-6 py-1.5 space-x-2.5 font-bold inline-flex justify-center sm:justify-normal items-center text-[#1A2DC9] border border-[#1B3CD2] hover:text-white hover:bg-[linear-gradient(90deg,_#1C37D1_0%,_#0E70DD_100%)] duration-300 rounded-[54px]">
                <span>Read All <?= $the_plugin_information->num_ratings ?> Reviews</span>
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path class="group-hover:fill-white"
                        d="M10.7814 7.33327L7.20539 3.75726L8.14819 2.81445L13.3337 7.99993L8.14819 13.1853L7.20539 12.2425L10.7814 8.6666H2.66699V7.33327H10.7814Z"
                        fill="#1A2DC9" />
                </svg>
            </a>
        </div>
    </div>
    <div class="tabContentPluginReviews space-y-6 lg:space-y-8 hidden" id="highest">
        <?php
        //$relevent_commets = plugin_cpt_frontend_load::get_the_relevent_comments($the_plugin_information->slug, "highest");
        if (!empty($all_comments['highest'])) {
            foreach ($all_comments['highest'] as $single_comment) {


                ?>
                <div class="p-6 space-y-6 border border-[#F2F2F2] rounded-[30px] overflow-hidden">
                    <strong>
                        <?= $single_comment['comment_title'] ?>
                    </strong>
                    <p>
                        <?= $single_comment['comment_text'] ?>
                    </p>

                    <div class="flex items-center space-x-3 text-black">
                        <img class="w-[46px] min-w-[46px] h-[46px] object-contain object-center rounded-full overflow-hidden"
                            src="<?= $single_comment['commenter_image_link'] ?>" alt="review Profile Image" />
                        <div class="space-y-2">
                            <strong><?= $single_comment['commenter_name'] ?></strong>
                            <div class="flex flex-wrap items-center space-x-2">
                                <div class="flex items-center">
                                    <?= render_star_rating($single_comment['commenter_num_rating']) ?>
                                </div>

                                <p><?= $single_comment['comment_date'] ?></p>
                                <span class="text-[#E0E0E0]">|</span>
                                <p><?= $single_comment['no_of_reply'] ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
            }
        }
        ?>
        <div>
            <a href="https://wordpress.org/support/<?= $the_plugin_information->slug ?>/reviews"
                class="group w-full sm:w-auto px-6 py-1.5 space-x-2.5 font-bold inline-flex justify-center sm:justify-normal items-center text-[#1A2DC9] border border-[#1B3CD2] hover:text-white hover:bg-[linear-gradient(90deg,_#1C37D1_0%,_#0E70DD_100%)] duration-300 rounded-[54px]">
                <span>Read All <?= $the_plugin_information->num_ratings ?> Reviews</span>
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path class="group-hover:fill-white"
                        d="M10.7814 7.33327L7.20539 3.75726L8.14819 2.81445L13.3337 7.99993L8.14819 13.1853L7.20539 12.2425L10.7814 8.6666H2.66699V7.33327H10.7814Z"
                        fill="#1A2DC9" />
                </svg>
            </a>
        </div>

    </div>
    <div class="tabContentPluginReviews space-y-6 lg:space-y-8 hidden" id="lowest">
        <?php
        //$relevent_commets = plugin_cpt_frontend_load::get_the_relevent_comments($the_plugin_information->slug, "lowest");
        if (!empty($all_comments['lowest'])) {
            foreach ($all_comments['lowest'] as $single_comment) {


                ?>
                <div class="p-6 space-y-6 border border-[#F2F2F2] rounded-[30px] overflow-hidden">
                    <strong>
                        <?= $single_comment['comment_title'] ?>
                    </strong>
                    <p>
                        <?= $single_comment['comment_text'] ?>
                    </p>

                    <div class="flex items-center space-x-3 text-black">
                        <img class="w-[46px] min-w-[46px] h-[46px] object-contain object-center rounded-full overflow-hidden"
                            src="<?= $single_comment['commenter_image_link'] ?>" alt="review Profile Image" />
                        <div class="space-y-2">
                            <strong><?= $single_comment['commenter_name'] ?></strong>
                            <div class="flex flex-wrap items-center space-x-2">
                                <div class="flex items-center">
                                    <?= render_star_rating($single_comment['commenter_num_rating']) ?>
                                </div>

                                <p><?= $single_comment['comment_date'] ?></p>
                                <span class="text-[#E0E0E0]">|</span>
                                <p><?= $single_comment['no_of_reply'] ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
            }
        }
        ?>
        <div>
            <a href="https://wordpress.org/support/<?= $the_plugin_information->slug ?>/reviews"
                class="group w-full sm:w-auto px-6 py-1.5 space-x-2.5 font-bold inline-flex justify-center sm:justify-normal items-center text-[#1A2DC9] border border-[#1B3CD2] hover:text-white hover:bg-[linear-gradient(90deg,_#1C37D1_0%,_#0E70DD_100%)] duration-300 rounded-[54px]">
                <span>Read All <?= $the_plugin_information->num_ratings ?> Reviews</span>
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path class="group-hover:fill-white"
                        d="M10.7814 7.33327L7.20539 3.75726L8.14819 2.81445L13.3337 7.99993L8.14819 13.1853L7.20539 12.2425L10.7814 8.6666H2.66699V7.33327H10.7814Z"
                        fill="#1A2DC9" />
                </svg>
            </a>
        </div>
    </div>
</div>