<div class="mx-4 max-w-xl w-full max-h-[90vh] flex flex-col">
    <div
        class="px-5 sm:px-[30px] py-6 flex items-center justify-between space-x-2 bg-[#F2F2F2] border-b border-[#F2F2F2] rounded-t-3xl overflow-hidden">
        <div class="flex items-center space-x-2">
            <div
                class="w-6 min-w-6 h-6 flex justify-center items-center bg-[linear-gradient(180deg,#F2F2F2_0%,rgba(2,170,242,0.24)_100%)] rounded-lg">
                <img class="w-[21px] min-w-[21px] h-[21px] object-contain object-center rounded-lg overflow-hidden"
                    src="<?php echo asset_image_path_generator() ?>/plugin-page/popup/popup-1.webp" alt="popup-1" />
            </div>
            <h2 class="text-xs md:text-[13px] text-black leading-[120%] font-bold">
                <?php echo get_the_title($plugin_id) ?>
            </h2>
        </div>
        <button id="closeModalBtnWPSScore" class="duration-300 hover:opacity-60">
            <img class="w-5 min-w-5 h-5 object-contain object-center"
                src="<?php echo asset_image_path_generator() ?>/close-fill.svg" alt="" />
        </button>
    </div>

    <div class="scrollbarHide overflow-y-auto bg-white rounded-b-3xl flex-1">
        <div class="px-5 sm:px-[30px] py-[18px] flex items-center space-x-6 bg-[#F6F7FD]">
            <div
                class="w-[72px] min-w-[72px] h-[72px] flex justify-center items-center bg-[#1A2DC91F] border-b-[3px] border-[#1A2DC9]">
                <h3 class="text-2xl md:text-[26px] lg:text-[31px] text-[#1A2DC9] leading-[120%] font-bold">
                    <?php
                    echo $metrice_data["overall_wpscore"];
                    ?>
                </h3>
            </div>
            <div class="space-y-2">
                <div class="flex items-center space-x-1">
                    <span
                        class="p-[5px] text-[10px] leading-[120%] font-bold text-[#A1A7B1] bg-[#A1A7B13D] rounded-full">
                        WPS
                    </span>
                    <p class="text-[13px] text-[#727C89] leading-[120%] font-normal">
                        WPSearch Score
                    </p>
                </div>
                <h3 class="text-xl md:text-[22px] lg:text-[25px] leading-[120%] font-bold text-[#1A2DC9]">
                    <?php
                    echo wps_score_description($metrice_data["overall_wpscore"]);
                    ?>
                </h3>
            </div>
        </div>

        <div class="px-5 sm:px-[30px] py-6 space-y-[18px] bg-white">
            <?php foreach ($metric_information_groups as $group_key => $group_name): ?>
                <?php if (!empty($saved_rows[$group_key])):
                    $total_weight = array_sum(array_column($saved_rows[$group_key], 'weight'));
                ?>
                    <div class="pb-5 space-y-2 border-b broder-[#F2F2F2] font-bold text-black last:border-b-0">
                        <button class="customAccordionToggle flex items-center justify-between w-full">
                            <div class="flex items-center space-x-2">
                                <img class="w-5 min-w-5 h-5 object-contain object-center"
                                    src="<?php echo asset_image_path_generator() ?>/<?= $metric_information_groups_image_icon[$group_key] ?>"
                                    alt="computer-line" />
                                <h4 class="text-base leading-[160%]">
                                    <?= esc_html($group_name) ?> (<?= $total_weight ?>% total)
                                </h4>
                            </div>
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M10.0005 10.9763L14.1254 6.85156L15.3039 8.03007L10.0005 13.3334L4.69727 8.03007L5.87577 6.85156L10.0005 10.9763Z"
                                    fill="#A1A7B1" />
                            </svg>
                        </button>
                        <div class="-m-1.5">
                            <div class="flex flex-wrap">
                                <?php foreach ($saved_rows[$group_key] as $index => $row):
                                    $cal = Helpers::toPercentageFromOneToTen(($metrice_data[$metric_information_attributes_mapping_db_keys[$row['attribute']]] ?? 0), 10);
                                ?>
                                    <div class="w-[calc(50%-12px)] sm:w-[calc(33.333333%-12px)] m-1.5 mt-3 space-y-2">
                                        <div class="flex items-center justify-between space-x-1 text-[13px] leading-[120%]">
                                            <p class="text-[#727C89] font-normal break-all line-clamp-1"><?= $attributes[$row['attribute']] ?></p>
                                            <h5><?php echo $metrice_data[$metric_information_attributes_mapping_db_keys[$row['attribute']]] ?? '' ?></h5>
                                        </div>
                                        <div class="w-full h-1 bg-[#E4E6F8]">
                                            <div class="h-1  <?php echo ($cal > 70) ? 'bg-[#1A2DC9]' : 'bg-[#FBBC05]' ?>" style="width: <?php echo $cal ?>%"></div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
    </div>
</div>