<?php
/*
Template Name:Customized Search Page
 */


$actual_link = $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
$search_in_url = explode('/', $actual_link);
$search_slug = null;
$post_category = $search_in_url[max(array_keys($search_in_url)) - 1];
if ($post_category == "search") {
    $most_used_category = Helpers::get_the_most_used_plugin_category();
    $category_id = $most_used_category['category_id'];
    $name = $most_used_category['name'];
} else {
    $most_used_category = get_term_by('slug', $post_category, 'plugin_category');
    if (!empty($most_used_category)) {
        //dd($most_used_category);
        $category_id = $most_used_category->term_id;
        $name = $most_used_category->name;
    } else {
        $most_used_category = Helpers::get_the_most_used_plugin_category();
        $category_id = $most_used_category['category_id'];
        $name = $most_used_category['name'];
    }
}
$rating_filter_mapping = Helpers::rating_filter_mapping();
$wps_score_filter_mapping = Helpers::wps_score_filter_mapping();
$get_child_categories = Helpers::get_all_subcategory_or_siblings($category_id);

$all_tags_json = Helpers::all_tags_related_category($category_id);

$last_updated_plugin_mapping = Helpers::last_updated_plugin_mapping();
$active_installation_plugin_mapping = Helpers::active_installation_plugin_mapping();
$support_quality_plugin_mapping = Helpers::support_quality_plugin_mapping();
$user_review_sentiment_plugin_mapping = Helpers::user_review_sentiment_plugin_mapping();
$performace_impact_plugin_mapping = Helpers::performace_impact_plugin_mapping();
$multilingual_support_plugin_mapping = Helpers::multilingual_support_plugin_mapping();
$sort_by_key_mapping = Helpers::sort_by_key_mapping();

$_child_categories = json_decode($get_child_categories, true);
$_all_child_tags = json_decode($all_tags_json, true);

// First array with the first 25 elements
$first_chunk_tag = array_slice($_all_child_tags, 0, 20);

// Second array with the remaining elements
$second_chunk_tag = array_slice($_all_child_tags, 20);

$subcategory_chunk = array_chunk($_child_categories, 7);

$category_ids_array = $_GET['category_ids'] ? explode(',', $_GET['category_ids']) : [];
$selected_tag_ids_array = $_GET['tag_ids'] ? explode(',', $_GET['tag_ids']) : [];
$rating = $_GET['rating'] ?? '';
$overall_wpscore = $_GET['overall_wpscore'] ?? '';
$category_ids = $_GET['category_ids'] ?? '';
$tag_ids = $_GET['tag_ids'] ?? '';
$last_update = $_GET['last_update'] ?? '';
$active_install = $_GET['active_install'] ?? '';
$support_quality = $_GET['support_quality'] ?? '';
$performace_impact = $_GET['performace_impact'] ?? '';
$user_review_sentiment = $_GET['user_review_sentiment'] ?? '';
$multilingual_support = $_GET['multilingual_support'] ?? '';
$search_text = $_GET['search_text'] ?? '';
$sort_by = $_GET['sort_by'] ?? '';

$fuzzy_search_plugin_suggestions_with_category_only_post = [];
$filters = [];

$taxonomy_ids = array_merge($category_ids_array, $selected_tag_ids_array);
$taxonomy_ids[] = $category_id;
//dd($_GET);
//dd($taxonomy_ids);
//passing to functions
$filter_from_query_param = [];
if ($rating) {
    $filter_by_rating = Helpers::rating_filter_mapping($rating);
    if (!empty($filter_by_rating)) {
        $filter_from_query_param[] = $filter_by_rating;
    }
}
if ($overall_wpscore) {
    $filter_by_overall_wpscore = Helpers::wps_score_filter_mapping($overall_wpscore);
    if (!empty($filter_by_overall_wpscore)) {
        $filter_from_query_param[] = $filter_by_overall_wpscore;
    }

}
if ($last_update) {
    $filter_by_last_update = Helpers::last_updated_plugin_mapping($last_update);
    if (!empty($filter_by_last_update)) {
        $filter_from_query_param[] = $filter_by_last_update;
    }

}
if ($active_install) {
    $filter_by_active_install = Helpers::active_installation_plugin_mapping($active_install);
    if (!empty($filter_by_active_install)) {
        $filter_from_query_param[] = $filter_by_active_install;
    }

}
if ($support_quality) {
    $filter_by_support_quality = Helpers::support_quality_plugin_mapping($support_quality);
    if (!empty($filter_by_support_quality)) {
        $filter_from_query_param[] = $filter_by_support_quality;
    }

}
if ($performace_impact) {
    $filter_by_performace_impact = Helpers::performace_impact_plugin_mapping($performace_impact);
    if (!empty($filter_by_performace_impact)) {
        $filter_from_query_param[] = $filter_by_performace_impact;
    }

}
if ($user_review_sentiment) {
    $filter_by_user_review_sentiment = Helpers::user_review_sentiment_plugin_mapping($user_review_sentiment);
    if (!empty($filter_by_user_review_sentiment)) {
        $filter_from_query_param[] = $filter_by_user_review_sentiment;
    }

}
if ($multilingual_support) {
    $filter_by_multilingual_support = Helpers::multilingual_support_plugin_mapping($multilingual_support);
    if (!empty($filter_by_multilingual_support)) {
        $filter_from_query_param[] = $filter_by_multilingual_support;
    }
}
if ($search_text) {

    $fuzzy_search_plugin_suggestions_with_category_only_post = plugin_cpt_frontend_load::fuzzy_search_plugin_suggestions_with_category_only_post($search_text, $category_id);
    //dd($fuzzy_search_plugin_suggestions_with_category_only_post);
}
if (!empty($search_text)) {
    $filter_from_query_param[] = [
        'field' => 'wp_post_id',
        'operator' => 'in',
        'value' => array_values(array_unique($fuzzy_search_plugin_suggestions_with_category_only_post)),
    ];
}



// $filters_overall_wpscore_plugin = [
//     ['field' => 'rating', 'operator' => 'between', 'value' => [3, 5]],
//     ['field' => 'active_installs', 'operator' => '>', 'value' => 1000],
//     ['field' => 'overall_wpscore', 'operator' => '>=', 'value' => 50],
// ];
$order_by = [
    ['field' => 'overall_wpscore', 'direction' => 'desc'],
];
if ($sort_by) {
    $sort_by_meta = Helpers::sort_by_key_mapping($sort_by);
    $order_by[] = ['field' => $sort_by_meta["field"], 'direction' => $sort_by_meta["direction"]];
    $order_by = array_reverse($order_by);
}

$overall_wpscore_plugin = (!empty($search_text) && empty($fuzzy_search_plugin_suggestions_with_category_only_post)) ? [] : plugin_cpt_frontend_load::get_plugins_with_category_id_filter($taxonomy_ids, 6, 0, $filter_from_query_param, $order_by, 'is_sponsored', 1);

$is_sponsored_plugin = (!empty($search_text) && empty($fuzzy_search_plugin_suggestions_with_category_only_post)) ? [] :plugin_cpt_frontend_load::get_plugins_with_category_id_filter($taxonomy_ids, 30, 0, $filter_from_query_param, $order_by, 'is_sponsored', 2);

get_header();
?>
<main>
    <?php
    $template = get_template_directory() . '/frontend/search-page-includes/header-part-search.php';

    if (file_exists($template)) {
        include $template;
    }
    ?>
    <section class="flex items-stretch h-full">
        <?php
        $template = get_template_directory() . '/frontend/search-page-includes/sidebar-part.php';

        if (file_exists($template)) {
            include $template;
        }
        ?>


        <!-- Right side  -->
        <div class="flex-1">
            <?php
            if (!empty($is_sponsored_plugin)) {
                $template = get_template_directory() . '/frontend/taxonomy-search-fuzzy-search-common/sponsored-plugins.php';

                if (file_exists($template)) {
                    include $template;
                }
            }
            if (!empty($overall_wpscore_plugin)) {
                $template = get_template_directory() . '/frontend/taxonomy-search-fuzzy-search-common/all-plugins.php';

                if (file_exists($template)) {
                    include $template;
                }
            }
            if (empty($is_sponsored_plugin) && empty($overall_wpscore_plugin)) {
                ?>
                <div class="flex justify-center items-center h-screen">No plugin found</div><?php
            }
            ?>
        </div>

    </section>
</main>
<form action="" method="get" id="filter_form">
    <input type="hidden" name="rating" value="<?php echo esc_attr($rating); ?>">
    <input type="hidden" name="overall_wpscore" value="<?php echo esc_attr($overall_wpscore); ?>">
    <input type="hidden" name="category_ids" value="<?php echo $category_ids; ?>">
    <input type="hidden" name="tag_ids" value="<?php echo $tag_ids; ?>">
    <input type="hidden" name="last_update" value="<?php echo $last_update; ?>">
    <input type="hidden" name="active_install" value="<?php echo $active_install; ?>">
    <input type="hidden" name="support_quality" value="<?php echo $support_quality; ?>">
    <input type="hidden" name="performace_impact" value="<?php echo $performace_impact; ?>">
    <input type="hidden" name="user_review_sentiment" value="<?php echo $user_review_sentiment; ?>">
    <input type="hidden" name="multilingual_support" value="<?php echo $multilingual_support; ?>">
    <input type="hidden" name="search_text" value="<?php echo $search_text; ?>">
    <input type="hidden" name="sort_by" value="<?php echo $sort_by; ?>">
</form>
<?php
$template = get_template_directory() . '/frontend/taxonomy-search-fuzzy-search-common/javascripts-basic-utility-control.php';
if (file_exists($template)) {
    include $template;
}
$template = get_template_directory() . '/frontend/taxonomy-search-fuzzy-search-common/javascripts-search-operations.php';
if (file_exists($template)) {
    include $template;
}

?>
<script>
    jQuery(function ($) {

        let isLoading = false;
        let offset = 6;
        const limit = 6;

        function loadMorePlugins() {

            if (isLoading) return;
            isLoading = true;
            $("#scroll_loader").removeClass("hidden");
            let data = {
                action: "load_more_plugins",
                page_category_id: <?php echo $category_id ?>,
                offset: offset,
                limit: limit
            };

            // 🔥 Automatically read all hidden inputs from filter form
            $("#filter_form input[type='hidden']").each(function () {
                let key = $(this).attr("name");
                let val = $(this).val();
                data[key] = val;
            });

            $.ajax({
                url: "<?php echo admin_url('admin-ajax.php'); ?>",
                type: "POST",
                data: data,
                success: function (response) {
                    $("#scroll_loader").addClass("hidden");
                    if ($.trim(response) !== "") {
                        $("#all_ajax_appear_here").append(response);
                        offset += limit;
                        isLoading = false;
                    } else {
                        // No more items
                        $(window).off("scroll");
                    }
                }
            });

        }

        // 🔥 Trigger load when scroll bottom
        $(window).on("scroll", function () {
            if ($(window).scrollTop() + $(window).height() >= $(document).height() - 300) {
                loadMorePlugins();
            }
        });

        // Load first set automatically
        //loadMorePlugins();

    });
</script>

<?php
require get_template_directory() . '/frontend/content-fuzzy-search.php';
get_footer();