<a href="<?php echo get_the_permalink($single_plugin["wp_post_id"]) ?>"
    class="w-[calc(100%-24px)] sm:w-[calc(50%-24px)] m-3 xl:w-[calc(33.333333%-32px)] xl:m-4 text-black border border-[#F2F2F2] rounded-3xl overflow-hidden flex flex-col justify-between hover:shadow-[0_8px_24px_rgba(149,157,165,0.2)] duration-300 text-[10px] font-bold leading-[120%]">
    <!-- Top Section -->
    <div class="flex items-stretch">
        <div class="flex-1 p-3 xl:p-6 xl:pr-4 flex items-stretch space-x-4">
            <div class="flex justify-center items-center w-14 min-w-14 xl:w-[72px] xl:min-w-[72px]">
                <div
                    class="flex justify-center items-center w-full h-14 xl:h-[72px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-2xl xl:rounded-3xl overflow-hidden">
                    <img class="w-12 xl:w-[65px] min-w-12 xl:min-w-[65px] h-12 xl:h-[65px] object-contain object-center rounded-2xl xl:rounded-3xl"
                        src="<?php echo $single_plugin["plugin_icon"] ? $single_plugin["plugin_icon"] :  wp_get_attachment_url(get_option('site_icon')) ?>" alt="woo-image" />
                </div>
            </div>

            <div class="flex-1 min-h-[108px] w-full space-y-3">
                <h2 class="text-base xl:text-xl line-clamp-3 break-all">
                    <?php echo $single_plugin["post_title"] ?>
                </h2>
                <p class="font-normal">By <?php echo $single_plugin["author_name"] ?></p>
            </div>
        </div>

        <div
            class="openModalBtn relative w-[82px] min-w-[82px] flex flex-col justify-center  bg-[#F6F7FD] border-b-[3px]  p-3 <?php echo $single_plugin["overall_wpscore"] > 7 ? "text-[#1A2DC9] border-[#1A2DC9]":"text-[#FBBC05] border-[#FBBC05]"?>" data-plugin_id="<?= $single_plugin["wp_post_id"] ?>">
            <div class=" absolute top-1.5 right-1.5">
                <img class="w-4 min-w-[16px] h-4 object-contain object-center" src="<?php echo asset_image_path_generator() . 'exclamation.svg' ?>"
                    alt="Exclamation-Image" />
            </div>
            <div class="space-y-1">
                <p class="text-[#14243B3D] uppercase">WPS</p>
                <p class="text-xl md:text-[25px]"><?php echo $single_plugin["overall_wpscore"] ?></p>
                <p><?php echo wps_score_description($single_plugin["overall_wpscore"]); ?></p>
            </div>
        </div>
    </div>

    <!-- Divider Line -->
    <div class="border-t border-[#F2F2F2] w-full break-all">
        <div class="flex items-stretch text-[10px] font-normal leading-[120%]">
            <div class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                <img class="w-5 min-w-5 h-5 object-contain object-center" src="<?php echo asset_image_path_generator() . 'bannerSlider/star.svg' ?>"
                    alt="Star-Image" />
                <div>
                    <strong><?php echo percent_to_rating($single_plugin["rating"]) ?>/5</strong>
                    <p><?php echo format_active_installs($single_plugin["num_ratings"]) ?>+reviews</p>
                </div>
            </div>

            <div class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                <img class="w-5 min-w-5 h-5 object-contain object-center" src="<?php echo asset_image_path_generator() . 'bannerSlider/downlot.svg' ?>"
                    alt="Star-Image" />
                <div>
                    <strong><?php echo format_active_installs($single_plugin["active_installs"]) ?>+</strong>
                    <p>active installation</p>
                </div>
            </div>

            <div class="w-full flex-1 basis-auto flex items-center px-3 py-6 space-x-3">
                <img class="w-5 min-w-5 h-5 object-contain object-center" src="<?php echo asset_image_path_generator() . 'bannerSlider/w.svg' ?>"
                    alt="Star-Image" />
                <div>
                    <p>Tested with</p>
                    <strong><?php echo $single_plugin["tested"] ?></strong>
                </div>
            </div>
        </div>
    </div>
</a>