<script>
    function isCategoryPage() {
        return document.getElementById("term_name") !== null;
    }
    function initSearch(searchInputId, suggestionBoxId) {
        const searchInput = document.getElementById(searchInputId);
        const suggestionBox = document.getElementById(suggestionBoxId);

        if (!searchInput || !suggestionBox) return;

        let suggestions = [];
        let categoryText = "";

        const isCategory = isCategoryPage();

        if (isCategory) {
            const termEl = document.getElementById("term_name");
            categoryText = termEl.innerText.trim();

            const formData = new FormData();
            formData.append("action", "get_plugin_category_suggestions");
            formData.append("category", categoryText);

            fetch("<?php echo admin_url('admin-ajax.php'); ?>", {
                method: "POST",
                body: formData
            })
                .then(res => res.json())
                .then(data => {
                    suggestions = data;
                });
        } else {
            fetch("<?php echo get_template_directory_uri(); ?>/plugins-suggestions.json")
                .then(res => res.json())
                .then(data => {
                    suggestions = data;
                });
        }

        /* ======= YOUR EXISTING FUNCTIONS (UNCHANGED) ======= */

        function fuzzyMatch(str, query) {
            str = str.toLowerCase();
            query = query.toLowerCase();

            const words = query.split(/\s+/).filter(w => w.length);

            return words.every(word => {
                if (word.length <= 2) return str.includes(word);
                const part = word.slice(0, Math.ceil(word.length * 0.6));
                return str.includes(part);
            });
        }

        function highlight(text, query) {
            if (!query.trim()) return text;

            let words = query.split(/\s+/).filter(w => w.length > 1);

            words.forEach(word => {
                const short = word.slice(0, Math.ceil(word.length * 0.6));
                const pattern = text.toLowerCase().includes(word.toLowerCase())
                    ? word
                    : short;

                const reg = new RegExp(`(${pattern})(?!(?:[^<]*?>))`, "gi");

                text = text.replace(
                    reg,
                    '<span class="inline-block bg-yellow-200 text-red-600 px-1 rounded">$1</span>'
                );
            });

            return text;
        }

        function renderSuggestionList(list, query) {
            if (!list.length) {
                suggestionBox.innerHTML =
                    `<div class="px-4 py-3 text-sm text-gray-500">No results found</div>`;
                return;
            }

            const terms = list.filter(item => item.term_id);
            const posts = list.filter(item => item.post_id);

            let html = "";

            // Terms section
            if (terms.length) {
                html += `
            <div class="px-4 py-2 text-xs font-semibold text-gray-400 uppercase">
                Categories
            </div>
        `;

                html += terms.map(item => `
            <a href="${item.link}"
               class="block px-4 py-3 hover:bg-gray-100 cursor-pointer text-sm">
               <span class="font-medium">
                   ${highlight(item.title, query)}
               </span><br>
               <span class="text-gray-500 text-xs">
                   ${highlight(item.text, query)}
               </span>
            </a>
        `).join("");
            }

            // Divider line
            if (terms.length && posts.length) {
                html += `<div class="border-t border-gray-200 my-1"></div>`;
            }

            // Posts section
            if (posts.length) {
                html += `
            <div class="px-4 py-2 text-xs font-semibold text-gray-400 uppercase">
                Plugins
            </div>
        `;

                html += posts.map(item => `
            <a href="${item.link}"
               class="block px-4 py-3 hover:bg-gray-100 cursor-pointer text-sm">
               <span class="font-medium">
                   ${highlight(item.title, query)}
               </span><br>
               <span class="text-gray-500 text-xs">
                   ${highlight(item.text, query)}
               </span>
            </a>
        `).join("");
            }

            suggestionBox.innerHTML = html;
        }


        searchInput.addEventListener("input", () => {
            const q = searchInput.value.trim().toLowerCase();
            if (!q) {
                suggestionBox.classList.add("hidden");
                return;
            }

            const filtered = suggestions.filter(item =>
                fuzzyMatch(item.title, q) ||
                fuzzyMatch(item.text, q)
            );

            renderSuggestionList(filtered, q);
            suggestionBox.classList.toggle("hidden", filtered.length === 0);
        });

        searchInput.addEventListener("focus", () => {
            if (suggestions.length > 0) {
                renderSuggestionList(suggestions, "");
                suggestionBox.classList.remove("hidden");
            }
        });

        document.addEventListener("click", (e) => {
            if (!e.target.closest(".search-wrapper")) {
                suggestionBox.classList.add("hidden");
            }
        });
    }
</script>

<script>

    document.addEventListener("DOMContentLoaded", function () {
        initSearch("searchInput", "suggestionBox");     // Desktop
        initSearch("searchInputM", "suggestionBoxM");   // Mobile
    });

    jQuery(function ($) {

        const isCategory = isCategoryPage();

        function triggerFuzzySearch(inputSelector) {
            var searchText = $(inputSelector).val().trim();
            //if (!searchText) return;

            // Save search history
            let history = JSON.parse(localStorage.getItem('search_history') || '[]');

            if (!history.includes(searchText)) {
                history.push(searchText);
            }

            if (history.length > 20) {
                history = history.slice(-20);
            }

            localStorage.setItem('search_history', JSON.stringify(history));

            if (!isCategory) {
                // NON-category → redirect
                window.location.href =
                    "<?php echo site_url(); ?>/fuzzy-search/?text=" +
                    encodeURIComponent(searchText);
            } else {
                // CATEGORY → submit filter
                $('[name="search_text"]').val(searchText);
                $("#filter_form").submit();
            }
        }

        /* =========================
           CLICK SEARCH BUTTON
        ========================== */

        $('.home_fuzzy_search').on('click', function (e) {
            e.preventDefault();
            const $input = $('#searchInput:visible, #searchInputM:visible').first();
            triggerFuzzySearch($input);

        });

        /* =========================
           ENTER KEY (Desktop + Mobile)
        ========================== */

        $('#searchInput, #searchInputM').on('keydown', function (e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                triggerFuzzySearch(this);
            }
        });

    });
    jQuery(function ($) {

        $(document).on('click', 'img.close_icon', function () {
            $("#searchInput").val('').trigger('input')
            $("#searchInputM").val('').trigger('input')
        }) // optional: update listeners .focus(); });
    });
    jQuery(document).ready(function ($) {

        const $container = $('#search_history_div_show');
        if (!$container.length) return;

        let history = [];

        try {
            history = JSON.parse(localStorage.getItem('search_history')) || [];
        } catch (e) {
            history = [];
        }

        function renderHistory() {
            $container.empty();

            $.each(history, function (index, text) {

                const html = `
                <div class="flex justify-between items-center space-x-3 cursor-pointer">
                    <div class="flex items-center space-x-3 history-search" data-text="${encodeURIComponent(text)}">
                        <img class="w-6 min-w-6 h-6 object-contain object-center"
                             src="<?php echo asset_image_path_generator(); ?>history-line.svg"
                             alt="history-line" />
                        <p>${text}</p>
                    </div>

                    <button class="outline-none remove-history" data-index="${index}">
                        <img class="w-6 min-w-6 h-6 object-contain object-center"
                             src="<?php echo asset_image_path_generator(); ?>close-line.svg"
                             alt="close-line" />
                    </button>
                </div>
            `;

                $container.append(html);
            });
        }

        // Initial render
        renderHistory();

        /* ----------------------------
         * Click history → redirect
         * ---------------------------- */
        $container.on('click', '.history-search', function () {
            const text = $(this).data('text');
            window.location.href =
                "<?php echo site_url(); ?>/fuzzy-search/?text=" + text;
        });

        /* ----------------------------
         * Remove single history item
         * ---------------------------- */
        $container.on('click', '.remove-history', function (e) {
            e.stopPropagation();

            const index = $(this).data('index');

            history.splice(index, 1);
            localStorage.setItem('search_history', JSON.stringify(history));

            renderHistory();
        });

        $(".sortItem").on('click', function (e) {
            $(`[name="sort_by"]`).val($(this).data("short_item"));
            $('#filter_form').submit();
        })

    });


</script>