<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package wpsearch
 */
$top_categories = get_option("top_plugin_categories");
$first_20_top_categories = array_slice($top_categories, 0, 20);
$first_half = [];
$second_half = [];
if (!empty($first_20_top_categories)) {
	// Split the array into two segments
	$half = ceil(count($first_20_top_categories) / 2);
	$first_half = array_slice($first_20_top_categories, 0, $half);
	$second_half = array_slice($first_20_top_categories, $half);
}
$footer_menu_quick_links = wp_get_full_menu_array("footer_menu_quick_links");
$options = get_option('theme_options_custom');
$social_media = $options['social_media'];
?>

<footer class="sectionPadding font-normal text-white/80 bg-black">
	<div class="container">
		<div class="sectionWidth">
			<div class="flex justify-between flex-wrap pb-10 lg:pb-[60px] border-b border-[#FFFFFF1F]">
				<!-- Column 1: Logo / Info -->
				<div class="w-full lg:w-[24.5%] pb-10 border-b border-[#FFFFFF1F] lg:border-none">
					<div class="space-y-6 sm:space-y-8 flex flex-col text-start">
						<a href="<?php echo site_url() ?>" class="">
							<img class="w-[226.99px] object-contain object-center"
								src="<?php echo asset_image_path_generator() . 'footerLogo.webp' ?>" />
						</a>
						<p class="max-w-[600px] text-[13px] text-[#FFFFFFCC] !leading-[120%]">
							<?=$options['footer_description']?>
						</p>
					</div>
				</div>

				<!-- Column 2: Popular -->
				<div class="w-full lg:w-[399px] text-base leading-[160%] border-b border-[#FFFFFF1F] lg:border-none">
					<button
						class="accordionFooter py-6 lg:py-0 flex justify-between w-full lg:cursor-default cursor-pointer lg:pointer-events-none">
						<h3 class="text-white font-bold lg:mb-[21px]">
							Popular Categories
						</h3>
						<span class="text-2xl text-white hidden lg:hidden iconRotateFooter">+</span>
					</button>

					<div class="accordionContentFooter lg:max-h-max lg:overflow-visible">
						<div class="mb-5 lg:mb-0 lg:space-x-5 xl:space-x-8 grid grid-cols-1 lg:grid-cols-2">
							<div class="flex flex-col">
								<?php
								foreach ($first_half as $single) {
									?>
									<a href="<?= $single['link'] ?>"
										class="py-1 md:py-[6px] hover:text-white duration-300 break-words">
										<?= $single['name'] ?>
									</a>
									<?php
								}
								?>
							</div>
							<div class="flex flex-col">
								<?php
								foreach ($second_half as $single) {
									?>
									<a href="<?= $single['link'] ?>"
										class="py-1 md:py-[6px] hover:text-white duration-300 break-words">
										<?= $single['name'] ?>
									</a>
									<?php
								}
								?>
							</div>
						</div>
					</div>
				</div>

				<!-- Column 4: Quick Links -->
				<div
					class="w-full lg:w-[121px] text-base leading-[160%] whitespace-nowrap border-b border-[#FFFFFF1F] lg:border-none">
					<button class="accordionFooter py-6 lg:py-0 flex justify-between w-full lg:pointer-events-none">
						<h3 class="text-white font-bold lg:mb-[21px]">Quick Links</h3>
						<span class="text-2xl text-white hidden lg:hidden iconRotateFooter">+</span>
					</button>

					<div class="accordionContentFooter lg:max-h-max lg:overflow-visible">
						<div class="flex flex-col mb-5 lg:mb-0">
							<?php
							foreach ($footer_menu_quick_links as $single) {
								?>
								<a href="<?= $single['url'] ?>" class="py-1 md:py-[6px] hover:text-white duration-300">
									<?= $single['title'] ?>
								</a>
								<?php
							}
							?>
						</div>
					</div>
				</div>

				<!-- Column 5: Stay Connected -->
				<div class="w-full lg:w-[126px] text-base leading-[160%] whitespace-nowrap">
					<button class="accordionFooter py-6 lg:py-0 flex justify-between w-full lg:pointer-events-none">
						<h3 class="text-white font-bold lg:mb-6">Stay Connected</h3>
						<span class="text-2xl text-white hidden lg:hidden iconRotateFooter">+</span>
					</button>

					<div class="accordionContentFooter lg:max-h-max lg:overflow-visible">
						<div class="space-y-3 mb-5 lg:mb-0">
							<a href="<?=$social_media['twitter']?>" target="_blank" class="flex items-center gap-3 hover:text-white duration-300">
								<img class="w-[18px] h-[18px]"
									src="<?php echo asset_image_path_generator() . 'social/twitter.svg' ?>"
									alt="X icon" />
								<span>X</span>
							</a>

							<a href="<?=$social_media['instagram']?>" target="_blank" class="flex items-center gap-3 hover:text-white duration-300">
								<img class="w-[18px] h-[18px]"
									src="<?php echo asset_image_path_generator() . 'social/Instagram.svg' ?>" alt="" />
								<span>Instagram</span>
							</a>
							<a href="<?=$social_media['facebook']?>" target="_blank" class="flex items-center gap-3 hover:text-white duration-300">
								<img class="w-[18px] h-[18px]"
									src="<?php echo asset_image_path_generator() . 'social/Facebook.svg' ?>" alt="" />
								<span>Facebook</span>
							</a>
							<a href="<?=$social_media['linkedin']?>" target="_blank" class="flex items-center gap-3 hover:text-white duration-300">
								<img class="w-[18px] h-[18px]"
									src="<?php echo asset_image_path_generator() . 'social/LinkedIn.svg' ?>" alt="" />
								<p>LinkedIn</p>
							</a>
						</div>
					</div>
				</div>
			</div>

			<div class="pt-10 md:pt-[60px]">
				<div
					class="flex flex-wrap flex-col sm:flex-row justify-between text-[13px] text-[#FFFFFF66] !leading-[120%] space-x-0 sm:space-x-3 space-y-3 sm:space-y-0">
					<p>© <?= date('Y') ?> WPSearch.ai. All rights reserved.</p>
					<div class="flex flex-wrap space-x-[30px] lg:space-x-[60px]">
						<a href="<?= site_url('/privacy-policy') ?>" class="hover:text-white duration-500">Privacy
							Policy</a>
						<a href="<?= site_url('/terms-conditions') ?>" class="hover:text-white duration-500">Terms of
							Service</a>
					</div>
				</div>
			</div>
		</div>
	</div>
</footer><!-- #colophon -->
</div><!-- #page -->
<div id="infoModal" class="fixed inset-0 bg-black/60 flex items-center justify-center hidden z-50">

</div>
<?php wp_footer(); ?>

</body>

</html>