document.addEventListener("DOMContentLoaded", function () {
  // ------------------------------
  // ⭐ Custom Accordion Toggle (open by default)
  // ------------------------------
  const ratingButtons = document.querySelectorAll(".customAccordionToggle");
  ratingButtons.forEach((btn) => {
    const content = btn.nextElementSibling;
    const icon = btn.querySelector("svg");
    if (!content || !icon) return;

    btn.addEventListener("click", () => {
      content.classList.toggle("hidden");
      icon.classList.toggle("rotate-[-90deg]");
    });
  });

  // -----------------------------
  // 🟪 FAQ single plugin page
  // -----------------------------
  const faqButtons = document.querySelectorAll(".faq-btn");
  if (faqButtons.length > 0) {
    faqButtons.forEach((btn) => {
      btn.addEventListener("click", () => {
        const content = btn.nextElementSibling;
        const icon = btn.querySelector(".icon");
        if (!content || !icon) {
          console.warn("⚠️ FAQ button missing content or icon:", btn);
          return;
        }

        // Close other FAQs
        faqButtons.forEach((b) => {
          if (b !== btn) {
            const otherContent = b.nextElementSibling;
            const otherIcon = b.querySelector(".icon");
            otherContent?.classList.add("hidden");
            if (otherIcon) {
              otherIcon.textContent = "+";
              otherIcon.classList.remove("rotate-180");
            }
          }
        });

        // Toggle clicked FAQ
        const isHidden = content.classList.toggle("hidden");
        if (isHidden) {
          icon.textContent = "+";
          icon.classList.remove("rotate-180");
        } else {
          icon.textContent = "−";
          icon.classList.add("rotate-180");
        }
      });
    });
  } else {
    console.warn("⚠️ No FAQ buttons (.faq-btn) found.");
  }

  // ------------------------------
  // 🧩 Plugin page tabs
  // ------------------------------
  const tabBtns = document.querySelectorAll(".tabBtnPlugin");
  const tabContents = document.querySelectorAll(".tabContentPlugin");

  if (tabBtns.length && tabContents.length) {
    tabBtns.forEach((tab) => {
      tab.addEventListener("click", () => {
        const target = tab.getAttribute("data-tab");
        if (!target) return;

        tabBtns.forEach((t) => {
          t.classList.remove("border-[#1A2DC9]", "text-[#1A1A1A]", "font-bold");
          t.classList.add(
            "border-transparent",
            "text-[#A1A7B1]",
            "font-normal"
          );
        });

        tabContents.forEach((c) => c.classList.add("hidden"));

        tab.classList.add("border-[#1A2DC9]", "text-[#1A1A1A]", "font-bold");
        tab.classList.remove(
          "border-transparent",
          "text-[#A1A7B1]",
          "font-normal"
        );

        document.getElementById(target)?.classList.remove("hidden");

        document.querySelector(".space-y-12")?.scrollIntoView({
          behavior: "smooth",
          block: "start",
        });
      });
    });
  }

  // ------------------------------
  // 💬 Plugin Reviews tabs
  // ------------------------------
  const reviewTabs = document.querySelectorAll(".tabBtnPluginReviews");
  const reviewContents = document.querySelectorAll(".tabContentPluginReviews");

  if (reviewTabs.length && reviewContents.length) {
    reviewTabs.forEach((tab) => {
      tab.addEventListener("click", () => {
        const target = tab.getAttribute("data-tab");
        if (!target) return;

        reviewTabs.forEach((t) => {
          t.classList.remove(
            "bg-[linear-gradient(90deg,_#1C37D1_0%,_#0E70DD_100%)]",
            "text-white",
            "border-[#1C37D1]"
          );
          t.classList.add("bg-white", "text-[#1A2DC9]", "border-[#F2F2F2]");
        });

        reviewContents.forEach((c) => c.classList.add("hidden"));

        tab.classList.add(
          "bg-[linear-gradient(90deg,_#1C37D1_0%,_#0E70DD_100%)]",
          "text-white"
        );
        tab.classList.remove("bg-white", "text-[#1A2DC9]");

        document.getElementById(target)?.classList.remove("hidden");
      });
    });
  }

  // ------------------------------
  // 🖼️ Plugin slider
  // ------------------------------
  const sliderWrapper = document.getElementById("sliderWrapperPlugin");
  const prevBtn = document.getElementById("prevBtn");
  const nextBtn = document.getElementById("nextBtn");
  const dotsContainer = document.getElementById("dotsContainerPlugin");

  if (sliderWrapper && prevBtn && nextBtn && dotsContainer) {
    const slides = sliderWrapper.children;
    const totalSlides = slides.length;
    let currentSlide = 0;

    // Create dots
    for (let i = 0; i < totalSlides; i++) {
      const dot = document.createElement("span");
      dot.className =
        "w-3 h-3 rounded-full cursor-pointer transition-all duration-300 " +
        (i === 0 ? "bg-[#1A2DC9]" : "bg-[#E3E5E7]");
      dot.dataset.index = i;
      dot.addEventListener("click", () => goToSlide(i));
      dotsContainer.appendChild(dot);
    }

    const dots = dotsContainer.querySelectorAll("span");

    function updateSlider() {
      sliderWrapper.style.transform = `translateX(-${currentSlide * 100}%)`;
      dots.forEach((dot, index) => {
        dot.className =
          "w-3 h-3 rounded-full cursor-pointer transition-all duration-300 " +
          (index === currentSlide ? "bg-[#1A2DC9]" : "bg-[#E3E5E7]");
      });
    }

    function goToSlide(index) {
      currentSlide = index;
      updateSlider();
    }

    nextBtn.addEventListener("click", () => {
      currentSlide = (currentSlide + 1) % totalSlides;
      updateSlider();
    });

    prevBtn.addEventListener("click", () => {
      currentSlide = (currentSlide - 1 + totalSlides) % totalSlides;
      updateSlider();
    });
  }
});
