<?php
// Handle form submission
if (
    isset($_POST['openai_api_key_nonce']) &&
    wp_verify_nonce($_POST['openai_api_key_nonce'], 'save_openai_api_key')
) {
    $api_key             = sanitize_text_field($_POST['openai_api_key'] ?? '');
    $google_client_id    = sanitize_text_field($_POST['google_client_id'] ?? '');
    $google_client_secret = sanitize_text_field($_POST['google_client_secret'] ?? '');

    update_option('openai_api_key', $api_key, false);
    update_option('google_client_id', $google_client_id, false);
    update_option('google_client_secret', $google_client_secret, false);

    echo '<div class="updated notice is-dismissible"><p><strong>Settings saved successfully.</strong></p></div>';
}

// Retrieve existing values
$saved_key            = get_option('openai_api_key', '');
$saved_google_id      = get_option('google_client_id', '');
$saved_google_secret  = get_option('google_client_secret', '');
?>

<div class="wrap">
    <h1>API Settings</h1>

    <form method="post">
        <?php wp_nonce_field('save_openai_api_key', 'openai_api_key_nonce'); ?>

        <table class="form-table">

            <!-- OpenAI API Key -->
            <tr valign="top">
                <th scope="row">OpenAI API Key</th>
                <td>
                    <input type="text"
                           name="openai_api_key"
                           value="<?php echo esc_attr($saved_key); ?>"
                           style="width: 400px;" />
                    <p class="description">
                        Enter your OpenAI API key (starts with <code>sk-</code>).
                    </p>
                </td>
            </tr>

            <!-- Google Client ID -->
            <tr valign="top">
                <th scope="row">Google Client ID</th>
                <td>
                    <input type="text"
                           name="google_client_id"
                           value="<?php echo esc_attr($saved_google_id); ?>"
                           style="width: 400px;" />
                    <p class="description">
                        OAuth Client ID from Google Cloud Console.
                    </p>
                </td>
            </tr>

            <!-- Google Client Secret -->
            <tr valign="top">
                <th scope="row">Google Client Secret</th>
                <td>
                    <input type="password"
                           name="google_client_secret"
                           value="<?php echo esc_attr($saved_google_secret); ?>"
                           style="width: 400px;" />
                    <p class="description">
                        Keep this secret secure. Do not share publicly.
                    </p>
                </td>
            </tr>

        </table>

        <?php submit_button('Save Settings'); ?>
    </form>
</div>
