<script src="https://cdn.tailwindcss.com"></script>

<?php
// Metric Groups & Attributes (replace with your actual Helpers if needed)
// Metric Groups (from Helpers)
$metric_information_groups = Helpers::metric_information_groups();

// Attributes (from your example)
$attributes = Helpers::metric_information_attributes();

// === HANDLE FORM SUBMISSIONS ===
$notice = '';

if (isset($_POST['submit_plugin_row'])) {
    $new_row = [
        'attribute'         => sanitize_text_field($_POST['attribute']),
        'category'          => sanitize_text_field($_POST['category']),
        'priority'          => sanitize_text_field($_POST['priority']),
        'weight'            => floatval($_POST['weight']),
        'collection_method' => sanitize_text_field($_POST['collection_method']),
        'effect_on_search'  => sanitize_text_field($_POST['effect_on_search']),
        'reason_for_taking' => sanitize_text_field($_POST['reason_for_taking']),
    ];

    $group = sanitize_text_field($_POST['group']);
    $saved_rows = get_option('plugin_metric_settings', []);
    $saved_rows[$group][] = $new_row;
    update_option('plugin_metric_settings', $saved_rows, false);
    $notice = '<div class="notice-success">Row added successfully!</div>';
}

if (isset($_POST['edit_plugin_row'])) {
    $row_index = intval($_POST['row_index']);
    $old_group = sanitize_text_field($_POST['group']);  // The old group before editing
    $new_group = sanitize_text_field($_POST['new_group']);  // The new group selected in the modal

    $updated_row = [
        'attribute'         => sanitize_text_field($_POST['attribute']),
        'category'          => sanitize_text_field($_POST['category']),
        'priority'          => sanitize_text_field($_POST['priority']),
        'weight'            => floatval($_POST['weight']),
        'collection_method' => sanitize_text_field($_POST['collection_method']),
        'effect_on_search'  => sanitize_text_field($_POST['effect_on_search']),
        'reason_for_taking' => sanitize_text_field($_POST['reason_for_taking']),
    ];

    $saved_rows = get_option('plugin_metric_settings', []);
    
    if (isset($saved_rows[$old_group][$row_index])) {
        // Remove the row from the old group
        unset($saved_rows[$old_group][$row_index]);

        // Reindex the array after deletion
        $saved_rows[$old_group] = array_values($saved_rows[$old_group]);

        // If the new group does not exist, create it
        if (!isset($saved_rows[$new_group])) {
            $saved_rows[$new_group] = [];
        }

        // Add the updated row to the new group
        $saved_rows[$new_group][] = $updated_row;

        // Update the option in the database
        update_option('plugin_metric_settings', $saved_rows, false);

        $notice = '<div class="notice-success">Row updated successfully!</div>';
    } else {
        $notice = '<div class="notice-error">Row not found!</div>';
    }
}

if (isset($_POST['delete_plugin_row'])) {
    $row_index = intval($_POST['row_index']);
    $group = sanitize_text_field($_POST['group']);

    $saved_rows = get_option('plugin_metric_settings', []);
    if (isset($saved_rows[$group][$row_index])) {
        unset($saved_rows[$group][$row_index]);
        $saved_rows[$group] = array_values($saved_rows[$group]);
        update_option('plugin_metric_settings', $saved_rows, false);
        $notice = '<div class="notice-success">Row deleted successfully!</div>';
    } else {
        $notice = '<div class="notice-error">Row not found!</div>';
    }
}

$saved_rows = get_option('plugin_metric_settings', []);
?>

<!-- Toast Notification (appears only when needed) -->
<?php if ($notice): ?>
    <?= $notice ?>
<?php endif; ?>

<div class="max-w-7xl mx-auto p-1">

    <!-- Add New Row Form -->
    <form method="post" action="" class="bg-white shadow rounded-lg p-6 mb-10 space-y-6">
        <h2 class="text-2xl font-bold">Add New Metric Row</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="block font-medium">Group</label>
                <select name="group" required class="w-full p-3 border rounded-lg mt-1">
                    <?php foreach ($metric_information_groups as $key => $name): ?>
                        <option value="<?= esc_attr($key) ?>"><?= esc_html($name) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div>
                <label class="block font-medium">Attribute</label>
                <select name="attribute" required class="w-full p-3 border rounded-lg mt-1">
                    <?php foreach ($attributes as $key => $name): ?>
                        <option value="<?= esc_attr($key) ?>"><?= esc_html($name) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div><label class="block font-medium">Category</label><input type="text" name="category" required class="w-full p-3 border rounded-lg mt-1"></div>
            <div><label class="block font-medium">Priority</label><input type="text" name="priority" required class="w-full p-3 border rounded-lg mt-1"></div>
            <div><label class="block font-medium">Weight</label><input type="number" step="0.1" name="weight" required class="w-full p-3 border rounded-lg mt-1"></div>
            <div><label class="block font-medium">Collection Method</label><input type="text" name="collection_method" required class="w-full p-3 border rounded-lg mt-1"></div>
            <div><label class="block font-medium">Effect on Search</label><input type="text" name="effect_on_search" required class="w-full p-3 border rounded-lg mt-1"></div>
            <div><label class="block font-medium">Reason / Insight</label><input type="text" name="reason_for_taking" required class="w-full p-3 border rounded-lg mt-1"></div>
        </div>
        <button type="submit" name="submit_plugin_row" class="px-6 py-3 bg-blue-600 text-white font-bold rounded-lg hover:bg-blue-700">
            Add Row
        </button>
    </form>

    <!-- Tables by Group -->
    <?php foreach ($metric_information_groups as $group_key => $group_name): ?>
        <?php if (!empty($saved_rows[$group_key])): 
            $total_weight = array_sum(array_column($saved_rows[$group_key], 'weight'));
        ?>
            <div class="mb-10">
                <h2 class="text-2xl font-bold mb-4"><?= esc_html($group_name) ?> <span class="text-lg text-gray-600">(<?= $total_weight ?>% total)</span></h2>
                <div class="overflow-x-auto bg-white shadow rounded-lg">
                    <table class="w-full text-left">
                        <thead class="bg-gray-50 border-b">
                            <tr>
                                <th class="px-4 py-3">Attribute</th>
                                <th class="px-4 py-3">Category</th>
                                <th class="px-4 py-3">Priority</th>
                                <th class="px-4 py-3">Weight</th>
                                <th class="px-4 py-3">Collection</th>
                                <th class="px-4 py-3">Search Effect</th>
                                <th class="px-4 py-3">Reason</th>
                                <th class="px-4 py-3">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($saved_rows[$group_key] as $index => $row): ?>
                                <tr class="border-b hover:bg-gray-50">
                                    <td class="px-4 py-3"><?= esc_html($attributes[$row['attribute']] ?? $row['attribute']) ?></td>
                                    <td class="px-4 py-3"><?= esc_html($row['category']) ?></td>
                                    <td class="px-4 py-3"><?= esc_html($row['priority']) ?></td>
                                    <td class="px-4 py-3 font-medium"><?= esc_html($row['weight']) ?></td>
                                    <td class="px-4 py-3 text-sm"><?= esc_html($row['collection_method']) ?></td>
                                    <td class="px-4 py-3 text-sm"><?= esc_html($row['effect_on_search']) ?></td>
                                    <td class="px-4 py-3 text-sm"><?= esc_html($row['reason_for_taking']) ?></td>
                                    <td class="px-4 py-3">
                                        <button type="button" class="text-blue-600 hover:underline mr-3 edit-row-btn"
                                            data-index="<?= $index ?>"
                                            data-group="<?= esc_attr($group_key) ?>"
                                            data-row='<?= json_encode($row) ?>'>
                                            Edit
                                        </button>
                                        <form method="post" class="inline">
                                            <input type="hidden" name="group" value="<?= esc_attr($group_key) ?>">
                                            <input type="hidden" name="row_index" value="<?= $index ?>">
                                            <button type="submit" name="delete_plugin_row" 
                                                onclick="return confirm('Delete this row?')" 
                                                class="text-red-600 hover:underline">
                                                Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>
    <?php endforeach; ?>
</div>

<!-- Edit Modal -->
<div id="editModal" class="fixed inset-0 bg-black bg-opacity-50 hidden flex items-center justify-center z-50">
    <div class="bg-white rounded-xl shadow-2xl max-w-2xl w-full mx-4 p-6 relative">
        <button onclick="closeModal()" class="absolute top-3 right-3 text-2xl text-gray-500 hover:text-gray-700">&times;</button>
        <h2 class="text-2xl font-bold mb-6">Edit Row</h2>
        <form method="post" id="editForm">
            <input type="hidden" name="edit_plugin_row" value="1">
            <input type="hidden" name="row_index" id="editIndex">
            <input type="hidden" name="group" id="editOldGroup"> <!-- Store the old group -->
            <input type="hidden" name="new_group" id="editNewGroup"> <!-- Store the new group -->

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block font-medium">Group</label>
                    <select name="new_group" id="editGroupSelect" required class="w-full p-3 border rounded-lg mt-1">
                        <?php foreach ($metric_information_groups as $key => $name): ?>
                            <option value="<?= esc_attr($key) ?>"><?= esc_html($name) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div>
                    <label class="block font-medium">Attribute</label>
                    <select name="attribute" id="editAttribute" required class="w-full p-3 border rounded-lg mt-1">
                        <?php foreach ($attributes as $key => $name): ?>
                            <option value="<?= esc_attr($key) ?>"><?= esc_html($name) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div><label class="block font-medium">Category</label><input type="text" name="category" id="editCategory" required class="w-full p-3 border rounded-lg mt-1"></div>
                <div><label class="block font-medium">Priority</label><input type="text" name="priority" id="editPriority" required class="w-full p-3 border rounded-lg mt-1"></div>
                <div><label class="block font-medium">Weight</label><input type="number" step="0.1" name="weight" id="editWeight" required class="w-full p-3 border rounded-lg mt-1"></div>
                <div><label class="block font-medium">Collection Method</label><input type="text" name="collection_method" id="editCollection" required class="w-full p-3 border rounded-lg mt-1"></div>
                <div><label class="block font-medium">Effect on Search</label><input type="text" name="effect_on_search" id="editEffect" required class="w-full p-3 border rounded-lg mt-1"></div>
                <div class="md:col-span-2"><label class="block font-medium">Reason / Insight</label><input type="text" name="reason_for_taking" id="editReason" required class="w-full p-3 border rounded-lg mt-1"></div>
            </div>
            <div class="mt-6 flex justify-end gap-3">
                <button type="button" onclick="closeModal()" class="px-5 py-2 bg-gray-300 rounded-lg hover:bg-gray-400">Cancel</button>
                <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">Save Changes</button>
            </div>
        </form>
    </div>
</div>

<!-- Toast Styles & Auto-Reload Script -->
<style>
    .notice-success, .notice-error {
        position: fixed;
        top: 20px;
        left: 50%;
        transform: translateX(-50%);
        z-index: 9999;
        padding: 14px 28px;
        border-radius: 12px;
        font-weight: bold;
        color: white;
        box-shadow: 0 10px 25px rgba(0,0,0,0.2);
        animation: slideDown 0.4s ease-out;
    }
    .notice-success { background: #10b981; }
    .notice-error   { background: #ef4444; }
    @keyframes slideDown {
        from { transform: translateX(-50%) translateY(-100px); opacity: 0; }
        to   { transform: translateX(-50%) translateY(0); opacity: 1; }
    }
</style>

<script>
    // Edit Modal Logic
    document.querySelectorAll('.edit-row-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const data = JSON.parse(this.dataset.row);
            const index = this.dataset.index;
            const group = this.dataset.group;

            document.getElementById('editIndex').value = index;
            document.getElementById('editOldGroup').value = group; // Pass old group to the modal
            document.getElementById('editNewGroup').value = group; // Set to the current group
            document.getElementById('editGroupSelect').value = group; // Set the group in the dropdown
            document.getElementById('editAttribute').value = data.attribute;
            document.getElementById('editCategory').value = data.category;
            document.getElementById('editPriority').value = data.priority;
            document.getElementById('editWeight').value = data.weight;
            document.getElementById('editCollection').value = data.collection_method;
            document.getElementById('editEffect').value = data.effect_on_search;
            document.getElementById('editReason').value = data.reason_for_taking;

            document.getElementById('editModal').classList.remove('hidden');
        });
    });

    function closeModal() {
        document.getElementById('editModal').classList.add('hidden');
    }

    // Auto-reload page after showing success/error message
    document.addEventListener('DOMContentLoaded', () => {
        const notice = document.querySelector('.notice-success, .notice-error');
        if (notice) {
            setTimeout(() => {
                window.location.reload();
            }, 1500);
        }
    });
</script>
