<div class="wrap">
    <div style="display:flex;align-items:center;justify-content:space-between;">
        <h1 style="display:flex;align-items:center;gap:10px;">
            <img src="<?php echo esc_url(get_plugin_icon_by_slug($slug)); ?>" alt="Help Icon"
                style="width:20px;height:20px;" />
            <?php echo esc_html(ucfirst($slug)) . ' — Reviews'; ?>
        </h1>

    </div>

    <table class="widefat striped" style="margin-top:20px; width:100%;">
        <thead>
            <tr>
                <th style="width:5%;">#</th>
                <th style="width:80px;">Image</th>
                <th style="width:15%;">Name</th>
                <th style="width:15%;">Title</th>
                <th>Details</th>
                <th style="width:10%;">Rating</th>
                <th style="width:12%;">Comment Date</th>
                <th style="width:8%;">No. of Replies</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($comments)): ?>
                <?php foreach ($comments as $index => $comment): ?>
                    <tr>
                        <td><?php echo esc_html($index + 1); ?></td>

                        <!-- ✅ Commenter Image -->
                        <td>
                            <?php if (!empty($comment['commenter_image_link'])): ?>
                                <img src="<?php echo esc_url($comment['commenter_image_link']); ?>"
                                    alt="<?php echo esc_attr($comment['commenter_name']); ?>"
                                    style="width:50px;height:50px;object-fit:cover;border-radius:50%;">
                            <?php else: ?>
                                <span style="color:#999;">No Image</span>
                            <?php endif; ?>
                        </td>

                        <!-- ✅ Commenter Name -->
                        <td><?php echo esc_html($comment['commenter_name']); ?></td>

                        <!-- ✅ Comment Title -->
                        <td><strong><?php echo esc_html($comment['comment_title']); ?></strong></td>

                        <!-- ✅ Comment Text -->
                        <td><?php echo wp_kses_post(nl2br($comment['comment_text'])); ?></td>

                        <!-- ✅ Rating -->
                        <td>
                            <?php
                            $rating = intval($comment['commenter_num_rating']);
                            if ($rating > 0) {
                                for ($i = 1; $i <= 5; $i++) {
                                    echo $i <= $rating
                                        ? '<span style="color:#ffb400;">★</span>'
                                        : '<span style="color:#ddd;">★</span>';
                                }
                            } else {
                                echo '<span style="color:#999;">—</span>';
                            }
                            ?>
                        </td>

                        <!-- ✅ Comment Date -->
                        <td><?php echo esc_html($comment['comment_date']); ?></td>

                        <!-- ✅ Number of Replies -->
                        <td><?php echo esc_html($comment['no_of_reply'] ?? 0); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="8" style="text-align:center;color:#777;">No comments found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>


    <p style="margin-top:25px;">
        <a href="<?php echo esc_url(admin_url("admin.php?page=plugin-scrap-log-details&slug={$slug}")); ?>"
            class="button">←
            Back to Details</a>
    </p>
</div>