<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<div class="wrap">
    <div style="display:flex;align-items:center;justify-content:space-between;">
        <h1 style="display:flex;align-items:center;gap:10px;">
            <span class="dashicons dashicons-admin-plugins"></span>
            <?php echo esc_html($plugin['name'] ?? 'Plugin Details'); ?>
        </h1>
        <div style="
    display: flex;
    gap: 2px;
">
            <!-- ✅ Button group -->
            <button type="button" class="button button-primary" data-bs-toggle="modal" data-bs-target="#editMetaFiled">
                Edit Meta Field Information
            </button>
            <button type="button" class="button button-primary" data-bs-toggle="modal"
                data-bs-target="#editMetricModal">
                Edit Metric Information
            </button>
            <a href="<?php echo esc_url(admin_url("admin.php?page=plugin-faq-log-details&slug={$slug}")); ?>"
                class="button button-secondary">Faq details</a>
            <a href="<?php echo esc_url(admin_url("admin.php?page=plugin-review-log-details&slug={$slug}")); ?>"
                class="button button-secondary">Review details</a>
        </div>
    </div>

    <?php
    $image = !empty($plugin['plugin_feature_image'])
        ? $plugin['plugin_feature_image']
        : get_plugin_icon_by_slug($slug);
    ?>

    <?php if (!empty($image)): ?>
        <div style="margin:20px 0;">
            <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr($plugin['name'] ?? ''); ?>"
                style="width:120px;height:120px;object-fit:contain;border-radius:8px;border:1px solid #ddd;">
        </div>
    <?php else: ?>
        <p style="color:#aaa;">No image available</p>
    <?php endif; ?>

    <table class="widefat striped" style="margin-top:20px; width:100%;">
        <thead>
            <tr>
                <th style="width:20%; min-width:180px;">Field</th>
                <th>Value</th>
            </tr>
        </thead>
        <tbody>
            <?php
            foreach ($plugin as $key => $value) {
                $label = ucwords(str_replace('_', ' ', $key));
                if ($key == "wp_post_id" && !empty($value)) {
                    $value = get_the_permalink($value);
                }
                if (is_null($value) || $value === '') {
                    $display = '<span style="color:#aaa;">—</span>';
                } elseif (filter_var($value, FILTER_VALIDATE_URL)) {
                    $display = '<a href="' . esc_url($value) . '" target="_blank">' . esc_html($value) . '</a>';
                } else {
                    $display = nl2br(esc_html($value));
                }
                echo '<tr>';
                echo '<th style="text-transform:capitalize;">' . esc_html($label) . '</th>';
                echo '<td>' . $display . '</td>';
                echo '</tr>';
            }
            ?>
        </tbody>
    </table>

    <p style="margin-top:25px;">
        <a href="<?php echo esc_url(admin_url('admin.php?page=plugin-scrap-logs')); ?>" class="button">← Back to
            List</a>
    </p>
</div>

<?php
require_once get_stylesheet_directory() . '/admin/plugin-core-information-details/edit-meta-field-information.php'; 
require_once get_stylesheet_directory() . '/admin/plugin-core-information-details/edit-metric-information.php'; 

