<?php

?>

<div class="wrap">
    <div style="display:flex;align-items:center;justify-content:space-between;">
        <h1 style="display:flex;align-items:center;gap:10px;">
            <img src="<?php echo esc_url(get_plugin_icon_by_slug($slug)); ?>" alt="Help Icon"
                style="width:20px;height:20px;" />
            <?php echo esc_html(ucfirst($slug)) . ' — FAQs'; ?>
        </h1>

    </div>

    <table class="widefat striped" style="margin-top:20px; width:100%;">
        <thead>
            <tr>
                <th style="width:50px;">#</th>
                <th>Question</th>
                <th>Answer</th>
                <th style="width:180px;">Created</th>
                <th style="width:180px;">Updated</th>

            </tr>
        </thead>
        <tbody>
            <?php
            foreach ($faqs as $index => $faq):
                ?>
                <tr>
                    <td><?php echo esc_html($index + 1); ?></td>
                    <td><?php echo esc_html($faq['question']); ?></td>
                    <td><?php echo wp_kses_post($faq['answer']); ?></td>
                    <td><?php echo esc_html($faq['created_at']); ?></td>
                    <td><?php echo esc_html($faq['updated_at']); ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <p style="margin-top:25px;">
        <a href="<?php echo esc_url(admin_url("admin.php?page=plugin-scrap-log-details&slug={$slug}")); ?>" class="button">←
            Back to Details</a>
    </p>
</div>

<!-- ✅ Example Modal for Adding FAQ -->
<!-- <div class="modal fade" id="addFaqModal" tabindex="-1" aria-labelledby="addFaqModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="post" action="">
                <div class="modal-header">
                    <h5 class="modal-title" id="addFaqModalLabel">Add New FAQ</h5>
                    <button type="button" class="button close" data-bs-dismiss="modal" aria-label="Close">×</button>
                </div>
                <div class="modal-body">
                    <p><label>Question</label><br>
                        <input type="text" name="question" class="regular-text" required></p>
                    <p><label>Answer</label><br>
                        <textarea name="answer" class="large-text" rows="5" required></textarea></p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="button button-primary">Save FAQ</button>
                    <button type="button" class="button" data-bs-dismiss="modal">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div> -->