<?php
$metric_information_groups = Helpers::metric_information_groups();
$attributes = Helpers::metric_information_attributes();
$saved_rows = get_option('plugin_metric_settings', []);
$metric_information_attributes_mapping_db_keys = Helpers::metric_information_attributes_mapping_db_keys();
?>
<!-- ✅ Bootstrap Modal -->
<div class="modal fade" id="editMetricModal" tabindex="-1" aria-labelledby="editMetricModal" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content">
            <form method="post" id="updateMetricForm">
                <div class="modal-header">
                    <h5 class="modal-title" id="editMetricModal">Edit Metric Information</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-body">

                    <div class="col-md-6 mb-4">
                        <label class="form-label fw-semibold text-capitalize">Overall WPS Score</label>
                        <input type="text" name="overall_wpscore" step="any" value="<?php echo $plugin["overall_wpscore"]?>" class="form-control"
                            placeholder="">
                    </div>

                    <?php foreach ($metric_information_groups as $group_key => $group_name): ?>
                        <?php if (!empty($saved_rows[$group_key])):
                            $total_weight = array_sum(array_column($saved_rows[$group_key], 'weight'));
                            ?>
                            <div class="mb-4">
                                <h2 class="text-2xl font-bold mb-4 text-center"><?= esc_html($group_name) ?> <span
                                        class="text-lg text-gray-600">(<?= $total_weight ?>% total)</span></h2>
                                <div class="overflow-x-auto bg-white border p-4 rounded-lg">
                                    <table class="w-full text-left">
                                        <thead class="bg-gray-50 border-b">
                                            <tr>
                                                <th class="px-1 py-1">Attribute</th>
                                                <th class="px-1 py-1">Category</th>
                                                <th class="px-1 py-1">Priority</th>
                                                <th class="px-1 py-1">Weight</th>
                                                <th class="px-1 py-1">Collection</th>
                                                <th class="px-1 py-1">Search Effect</th>
                                                <th class="px-1 py-1">Reason</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($saved_rows[$group_key] as $index => $row): ?>

                                                <tr class="border-b hover:bg-gray-50">
                                                    <td class="px-1 py-1">
                                                        <?= esc_html($attributes[$row['attribute']] ?? $row['attribute']) ?>
                                                    </td>
                                                    <td class="px-1 py-1"><?= esc_html($row['category']) ?></td>
                                                    <td class="px-1 py-1"><?= esc_html($row['priority']) ?></td>
                                                    <td class="px-1 py-1 font-sm"><input type="number"
                                                            name="<?= $metric_information_attributes_mapping_db_keys[$row['attribute']] ?>"
                                                            value="<?php echo $plugin[$metric_information_attributes_mapping_db_keys[$row['attribute']]] ?? '' ?>" step="any">
                                                    </td>
                                                    <td class="px-1 py-1 text-sm"><?= esc_html($row['collection_method']) ?></td>
                                                    <td class="px-1 py-1 text-sm"><?= esc_html($row['effect_on_search']) ?></td>
                                                    <td class="px-1 py-1 text-sm"><?= esc_html($row['reason_for_taking']) ?></td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    (function ($) {
        $('#updateMetricForm').on('submit', function (e) {
            e.preventDefault();
            const formData = $(this).serialize() + '&action=update_plugin_metrics&slug=<?php echo esc_js($slug); ?>';
            $.post(ajaxurl, formData, function (response) {
                if (response.success) {
                    alert('Metrics updated successfully!');
                    location.reload();
                } else {
                    alert('Update failed: ' + response.data);
                }
            });
        });
    })(jQuery);
</script>
<?php
