<?php
$metric_information_groups = Helpers::metric_information_groups();
$attributes = Helpers::metric_information_attributes();
$saved_rows = get_option('plugin_metric_settings', []);
$metric_information_attributes_mapping_db_keys = Helpers::metric_information_attributes_mapping_db_keys();
?>
<div class="col-md-6">
    <label class="form-label fw-semibold text-capitalize">Overall WPS Score</label>
    <input type="text" name="overall_wpscore" step="any" value="<?php echo $plugin["overall_wpscore"] ?>"
        class="form-control" placeholder="">
</div>
<?php
foreach ($metric_information_groups as $group_key => $group_name): ?>
    <?php if (!empty($saved_rows[$group_key])):
        $total_weight = array_sum(array_column($saved_rows[$group_key], 'weight'));
        ?>

        <div class="mb-5">
            <h2 class="text-2xl font-bold mb-4 textHeading"><?= esc_html($group_name) ?> <span
                    class="text-lg text-gray-600">(<?= $total_weight ?>% total)</span></h2>
            <div class="tableEditPlagin overflow-x-auto bg-white shadow rounded-lg">
                <table class="w-full text-left">
                    <thead class="bg-gray-50 border-b">
                        <tr>
                            <th class="tableHeading px-1 py-1">Attribute</th>
                            <th class="tableHeading px-1 py-1">Category</th>
                            <th class="tableHeading px-1 py-1">Priority</th>
                            <th class="tableHeading px-1 py-1">Weight</th>
                            <th class="tableHeading px-1 py-1">Collection</th>
                            <th class="tableHeading px-1 py-1">Search Effect</th>
                            <th class="tableHeading px-1 py-1">Reason</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($saved_rows[$group_key] as $index => $row): ?>

                            <tr class="tbodyContain border-b hover:bg-gray-50">
                                <td class="tbodyText px-1 py-1">
                                    <?= esc_html($attributes[$row['attribute']] ?? $row['attribute']) ?>
                                </td>
                                <td class="tbodyText px-1 py-1"><?= esc_html($row['category']) ?></td>
                                <td class="tbodyText px-1 py-1"><?= esc_html($row['priority']) ?></td>
                                <td class="tbodyText px-1 py-1 font-sm"><input type="number"
                                        name="<?= $metric_information_attributes_mapping_db_keys[$row['attribute']] ?>"
                                        value="<?php echo $plugin[$metric_information_attributes_mapping_db_keys[$row['attribute']]] ?? '' ?>"
                                        step="any">
                                </td>
                                <td class="tbodyText px-1 py-1 text-sm"><?= esc_html($row['collection_method']) ?></td>
                                <td class="tbodyText px-1 py-1 text-sm"><?= esc_html($row['effect_on_search']) ?></td>
                                <td class="tbodyText px-1 py-1 text-sm"><?= esc_html($row['reason_for_taking']) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif; ?>
<?php endforeach; ?>