<?php
class scrap_log_management
{
    public static function scrap_log_management_menu()
    {
        add_menu_page(
            'Plugin Scrap Log',
            'Plugin Scrap Log',
            'manage_options',
            'plugin-scrap-logs',
            array('scrap_log_management', 'render_table_core_plugin_log'),
            'dashicons-admin-generic',
            26
        );
        add_submenu_page(
            null, // hidden from menu
            'Plugin Scrap Log Details',
            'Plugin Scrap Log Details',
            'manage_options',
            'plugin-scrap-log-details',
            array('scrap_log_management', 'render_table_core_plugin_log_details'),
        );
        add_submenu_page(
            null, // hidden from menu
            'Plugin Faq Log Details',
            'Plugin Faq Log Details',
            'manage_options',
            'plugin-faq-log-details',
            array('scrap_log_management', 'render_table_core_plugin_faq_log_details'),
        );
        add_submenu_page(
            null, // hidden from menu
            'Plugin Review Log Details',
            'Plugin Review Log Details',
            'manage_options',
            'plugin-review-log-details',
            array('scrap_log_management', 'render_table_core_plugin_review_log_details'),
        );
    }
    public static function render_table_core_plugin_log()
    {
        echo '<div class="wrap"><h1>Plugin Scrap Log</h1>';
        $table = new Plugin_Scrap_Log_List_Table();
        $table->prepare_items();

        echo '<form method="get">';
        echo '<input type="hidden" name="page" value="plugin-scrap-logs" />';
        $table->display();
        echo '</form></div>';
    }
    public static function render_table_core_plugin_log_details()
    {
        global $wpdb;
        $table = $wpdb->prefix . 'plugins_core_information';

        // ✅ Get slug from URL
        $slug = isset($_GET['slug']) ? sanitize_text_field($_GET['slug']) : '';

        if (empty($slug)) {
            echo '<div class="notice notice-error"><p>Invalid plugin slug.</p></div>';
            return;
        }

        // ✅ Fetch plugin data by slug
        $plugin = $wpdb->get_row(
            $wpdb->prepare("SELECT * FROM $table WHERE slug = %s LIMIT 1", $slug),
            ARRAY_A
        );

        if (!$plugin) {
            echo '<div class="notice notice-error"><p>No plugin found with this slug.</p></div>';
            return;
        }

        require get_template_directory() . '/admin/plugin-core-information-details/index.php';


    }
    public static function update_plugin_metrics()
    {
        global $wpdb;
        $table = $wpdb->prefix . 'plugins_core_information';

        $slug = sanitize_text_field($_POST['slug'] ?? '');
        if (empty($slug)) {
            wp_send_json_error('Missing slug.');
        }

        $numeric_fields = array_values(Helpers::metric_information_attributes_mapping_db_keys());
        $numeric_fields[] = "overall_wpscore";
        $data = [];
        foreach (array_merge($numeric_fields) as $field) {
            if (isset($_POST[$field])) {
                $data[$field] = sanitize_text_field($_POST[$field]);
            }
        }

        $updated = $wpdb->update($table, $data, ['slug' => $slug]);

        if ($updated !== false) {
            wp_send_json_success();
        } else {
            wp_send_json_error('Database update failed.');
        }
    }
    public static function update_plugin_meta_for_wps()
    {
        global $wpdb;
        $table = $wpdb->prefix . 'plugins_core_information';

        $slug = sanitize_text_field($_POST['slug'] ?? '');
        if (empty($slug)) {
            wp_send_json_error('Missing slug.');
        }

        // $numeric_fields = [
        //     //'plugin_age_days',
        //     'wps_installation_growth_score',
        //     //'package_size_kb',
        //     'wps_update_recency_score',
        //     'wps_update_frequency_score',
        //     'wps_compatibility_with_latest_wp_score',
        //     'wps_support_responsiveness_score',
        //     'wps_average_rating_score',
        //     'wps_number_of_ratings_score',
        //     'wps_maturity_score',
        //     'wps_license_score',
        //     'wps_has_lifetime_license_score',
        //     'wps_performance_impact_score',
        //     'wps_php_version_support_score',
        //     'wps_multisite_support_score',
        //     'wps_localization_languages_score',
        //     'wps_developer_reputation_score',
        //     'wps_documentation_quality_score',
        //     'wps_youtube_tutorials_score',
        //     'wps_community_page_score',
        //     'overall_wpscore'
        // ];
        $select_fields = [
            'license_type',
            'has_lifetime_license',
            'woocommerce_support',
            'has_agency_friendly_license',
            'is_multisite_support',
            'support_quality',
            'performance_impact',
            'user_review_sentiment',
            'seo_impact',
            'is_sponsored',
            'is_recreate_ai_post',
            'is_meta_information_from_ai_search',
            'is_wps_metric_group_done'
        ];
        $text_fields = [
            'best_youtube_tutorials_link',
            'community_page_link',
        ];
        $data = [];
        foreach (array_merge($select_fields, $text_fields) as $field) {
            if (isset($_POST[$field])) {
                $data[$field] = sanitize_text_field($_POST[$field]);
            }
        }

        $updated = $wpdb->update($table, $data, ['slug' => $slug]);

        if ($updated !== false) {
            wp_send_json_success();
        } else {
            wp_send_json_error('Database update failed.');
        }
    }
    public static function render_table_core_plugin_faq_log_details()
    {
        global $wpdb;
        $table = $wpdb->prefix . 'plugin_faqs';

        // ✅ Get slug from URL
        $slug = isset($_GET['slug']) ? sanitize_text_field($_GET['slug']) : '';

        if (empty($slug)) {
            echo '<div class="notice notice-error"><p>Invalid plugin slug.</p></div>';
            return;
        }

        // ✅ Fetch FAQs by plugin slug
        $faqs = $wpdb->get_results(
            $wpdb->prepare("SELECT * FROM $table WHERE plugin_slug = %s ORDER BY id DESC", $slug),
            ARRAY_A
        );

        if (!$faqs) {
            echo '<div class="notice notice-warning"><p>No FAQs found for this plugin.</p></div>';
            return;
        }

        require get_template_directory() . '/admin/plugin-core-information-details/faq.php';
    }
    public static function render_table_core_plugin_review_log_details()
    {
        global $wpdb;
        $table = $wpdb->prefix . 'plugin_comments';

        // ✅ Get slug from URL
        $slug = isset($_GET['slug']) ? sanitize_text_field($_GET['slug']) : '';

        if (empty($slug)) {
            echo '<div class="notice notice-error"><p>Invalid plugin slug.</p></div>';
            return;
        }

        // ✅ Fetch FAQs by plugin slug
        $comments = $wpdb->get_results(
            $wpdb->prepare("SELECT * FROM $table WHERE plugin_slug = %s ORDER BY id DESC", $slug),
            ARRAY_A
        );

        if (!$comments) {
            echo '<div class="notice notice-warning"><p>No Review found for this plugin.</p></div>';
            return;
        }

        require get_template_directory() . '/admin/plugin-core-information-details/review-details.php';
    }
}