<?php
class plugin_pro_info_management
{
    public static function getting_the_json_of_slug_name_pro_version_link()
    {
        //return;
        global $wpdb;

        $table_name = $wpdb->prefix . 'plugins_core_information';
        $per_page = 25;

        // ✅ Fetch all required data
        $results = $wpdb->get_results("
        SELECT slug, name, plugin_docs_link, plugin_pro_version_link, plugin_live_demo_link,homepage,has_lifetime_license,has_agency_friendly_license,best_youtube_tutorials_link,community_page_link
        FROM {$table_name}
        WHERE is_meta_information_from_ai_search = 0 AND is_ai_tax_category_done = 1  
        Limit 200 
    ");

        if (empty($results)) {
            return;
        }

        // ✅ Create directory if not exists
        $theme_dir = get_stylesheet_directory();
        $json_dir = $theme_dir . '/plugins-pro-data-jsons';
        if (!file_exists($json_dir)) {
            wp_mkdir_p($json_dir);
        }

        // ✅ Split into chunks of 25
        $chunks = array_chunk($results, $per_page);
        $total_pages = count($chunks);

        // ✅ Save each chunk as JSON file
        foreach ($chunks as $index => $chunk) {
            $page_number = $index + 1;
            $json_data = json_encode($chunk, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);

            $file_path = "{$json_dir}/plugins-data-page-{$page_number}.json";
            file_put_contents($file_path, $json_data);
        }

        // ✅ Save pagination count in wp_options for control
        //update_option('plugins_data_json_total_pages', $total_pages);

        // Optional logging or debugging
        // error_log("Generated {$total_pages} JSON files in: {$json_dir}");
    }
    public static function plugin_json_files_menu()
    {
        add_management_page(
            'Plugin JSON Files',              // Page title
            'Plugin JSON Files',              // Menu title
            'manage_options',                 // Capability
            'plugin-json-files',              // Menu slug
            ['plugin_pro_info_management', 'render_plugin_json_files_page'],  // Callback
            'dashicons-media-code',           // Icon
            80                                // Position
        );
    }
    public static function render_plugin_json_files_page()
    {
        $dir = get_stylesheet_directory() . '/plugins-pro-data-jsons/';
        $files = glob($dir . '*.json');

        // ---------------------------------------------
        // ✅ SORT FILES BY NUMBER (1,2,3...10)
        // ---------------------------------------------
        usort($files, function ($a, $b) {
            // Extract numeric part
            preg_match('/(\d+)/', basename($a), $matchA);
            preg_match('/(\d+)/', basename($b), $matchB);

            $numA = isset($matchA[1]) ? intval($matchA[1]) : 0;
            $numB = isset($matchB[1]) ? intval($matchB[1]) : 0;

            return $numA <=> $numB;
        });

        $selected_file = isset($_GET['file']) ? sanitize_text_field($_GET['file']) : '';
        $file_path = $dir . $selected_file;

        echo '<div class="wrap"><h1>Plugin JSON Files</h1><hr/>';

        // ---------------------------------------------
        // FILE LIST VIEW
        // ---------------------------------------------
        if (empty($selected_file)) {
            echo '<h2>Available Files</h2><ul>';

            foreach ($files as $file) {
                $basename = basename($file);
                $edit_url = admin_url('admin.php?page=plugin-json-files&file=' . urlencode($basename));
                echo '<li><a href="' . esc_url($edit_url) . '">' . esc_html($basename) . '</a></li>';
            }

            echo '</ul>';
            echo '<p><em>Select a file to edit.</em></p>';
            echo '</div>';
            return;
        }

        // ---------------------------------------------
        // FILE NOT FOUND
        // ---------------------------------------------
        if (!file_exists($file_path)) {
            echo '<p style="color:red;">File not found.</p></div>';
            return;
        }

        // ---------------------------------------------
        // SAVE FILE CONTENT
        // ---------------------------------------------
        if (isset($_POST['save_json_file']) && check_admin_referer('save_json_file_action', 'save_json_file_nonce')) {
            $new_content = wp_unslash($_POST['json_content']);
            file_put_contents($file_path, $new_content);
            echo '<div class="updated notice"><p><strong>File saved successfully!</strong></p></div>';
        }

        $content = file_get_contents($file_path);
        $filename = esc_html($selected_file);

        echo '<h2>Editing: ' . $filename . '</h2>';
        echo '<form method="post">';
        wp_nonce_field('save_json_file_action', 'save_json_file_nonce');

        echo '<textarea name="json_content" rows="30" style="width:100%; font-family:monospace;">'
            . esc_textarea($content)
            . '</textarea>';

        echo '<p><input type="submit" name="save_json_file" class="button button-primary" value="Save File"></p>';
        echo '<p><a href="' . esc_url(admin_url('admin.php?page=plugin-json-files')) . '">← Back to File List</a></p>';
        echo '</form>';
        echo '</div>';
    }

    public static function seeding_the_plugin_pro_version_link_from_json()
    {
        //return;
        global $wpdb;
        $table_name = $wpdb->prefix . 'plugins_core_information';
        $dir = get_stylesheet_directory() . '/plugins-pro-data-jsons/';
        $files = glob($dir . '*.json');

        if (empty($files))
            return false;

        foreach ($files as $file) {
            $content = file_get_contents($file);
            $data = json_decode($content, true);

            if (json_last_error() !== JSON_ERROR_NONE || !is_array($data)) {
                continue; // skip invalid JSON
            }

            foreach ($data as $plugin) {
                if (!isset($plugin['slug']))
                    continue;
                //if (empty($plugin['plugin_docs_link']))
                //    continue;
                if (!isset($plugin['done']))
                    continue;
                $slug = sanitize_text_field($plugin['slug']);
                $docs_link = isset($plugin['plugin_docs_link']) ? esc_url_raw($plugin['plugin_docs_link']) : null;
                $pro_link = isset($plugin['plugin_pro_version_link']) ? esc_url_raw($plugin['plugin_pro_version_link']) : null;
                $demo_link = isset($plugin['plugin_live_demo_link']) ? esc_url_raw($plugin['plugin_live_demo_link']) : null;
                $has_lifetime_license = isset($plugin['has_lifetime_license']) ? (!empty($plugin['has_lifetime_license']) ? $plugin['has_lifetime_license'] : "3") : "3";
                $has_agency_friendly_license = isset($plugin['has_agency_friendly_license']) ? (!empty($plugin['has_agency_friendly_license'] ? $plugin['has_agency_friendly_license'] : "3")) : "3";
                $best_youtube_tutorials_link = isset($plugin['best_youtube_tutorials_link']) ? esc_url_raw($plugin['best_youtube_tutorials_link']) : null;
                $community_page_link = isset($plugin['community_page_link']) ? esc_url_raw($plugin['community_page_link']) : null;
                $documentation_quality = isset($plugin['documentation_quality']) ? esc_url_raw($plugin['documentation_quality']) : "2";

                $wpdb->update(
                    $table_name,
                    [
                        'plugin_docs_link' => $docs_link,
                        'plugin_pro_version_link' => $pro_link,
                        'plugin_live_demo_link' => $demo_link,
                        'has_lifetime_license' => $has_lifetime_license,
                        'has_agency_friendly_license' => $has_agency_friendly_license,
                        'best_youtube_tutorials_link' => $best_youtube_tutorials_link,
                        'community_page_link' => $community_page_link,
                        'documentation_quality' => $documentation_quality,
                        'is_meta_information_from_ai_search' => 1,
                    ],
                    ['slug' => $slug],
                    ['%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%d'],
                    ['%s']
                );
            }

            // ✅ Delete file after processing
            unlink($file);
        }

        return true;
    }
    public static function data_reconsilation_after_meta_info_ai_done()
    {
        global $wpdb;

        $table_name = $wpdb->prefix . 'plugins_core_information';
        $case_free_with_pro = $wpdb->get_results("
        SELECT slug, plugin_docs_link, plugin_pro_version_link, has_lifetime_license, has_agency_friendly_license, license_type
        FROM {$table_name}
        WHERE is_meta_information_from_ai_search = 1
          AND license_type = 'free'
          AND plugin_pro_version_link IS NOT NULL
    ");

        // Query 2: Freemium plugins missing pro link
        $case_freemium_missing_pro = $wpdb->get_results("
        SELECT slug, plugin_docs_link, plugin_pro_version_link, has_lifetime_license, has_agency_friendly_license, license_type
        FROM {$table_name}
        WHERE is_meta_information_from_ai_search = 1
          AND license_type = 'freemium'
          AND plugin_pro_version_link IS NULL
    ");

        // Query 3: Missing documentation link
        $case_missing_docs = $wpdb->get_results("
        SELECT slug, plugin_docs_link, plugin_pro_version_link, has_lifetime_license, has_agency_friendly_license, license_type
        FROM {$table_name}
        WHERE is_meta_information_from_ai_search = 1
          AND plugin_docs_link IS NULL
    ");
        if (!empty($case_free_with_pro)) {
            foreach ($case_free_with_pro as $single) {
                $wpdb->update(
                    $table_name,
                    [
                        'license_type' => "freemium",
                    ],
                    ['slug' => $single->slug],
                    ['%s'],
                    ['%s']
                );
            }
        }
        if (!empty($case_freemium_missing_pro)) {
            foreach ($case_freemium_missing_pro as $single) {
                $wpdb->update(
                    $table_name,
                    [
                        'license_type' => "free",
                    ],
                    ['slug' => $single->slug],
                    ['%s'],
                    ['%s']
                );
            }
        }
        if (!empty($case_missing_docs)) {
            foreach ($case_free_with_pro as $single) {
                $wpdb->update(
                    $table_name,
                    [
                        'plugin_docs_link' => "https://wordpress.org/plugins/" . $single->slug,
                    ],
                    ['slug' => $single->slug],
                    ['%s'],
                    ['%s']
                );
            }
        }
    }
}