<?php
class different_cron_jobs
{
    public static function getting_the_most_used_category()
    {
        $taxonomy = 'plugin_category';
        $option_name = 'top_plugin_categories';

        // Get all parent terms
        $parent_terms = get_terms([
            'taxonomy' => $taxonomy,
            'hide_empty' => true,
            'parent' => 0,
        ]);

        if (is_wp_error($parent_terms) || empty($parent_terms)) {
            return;
        }

        $result = [];

        foreach ($parent_terms as $parent) {
            // Get child terms
            $child_terms = get_terms([
                'taxonomy' => $taxonomy,
                'hide_empty' => true,
                'parent' => $parent->term_id,
            ]);

            // Sum counts
            $total_count = (int) $parent->count;
            if (!is_wp_error($child_terms) && !empty($child_terms)) {
                foreach ($child_terms as $child) {
                    $total_count += (int) $child->count;
                }
            }

            // ✅ Get cached image URL
            $image_url = get_term_meta($parent->term_id, 'plugin_category_image', true);
            if (empty($image_url)) {
                // optional fallback SVG (so no blank space in cache)
                $image_url = 'https://cdn.jsdelivr.net/npm/@tabler/icons@latest/icons/puzzle.svg';
            }

            // Add parent info to result
            $result[] = [
                'term_id' => $parent->term_id,
                'name' => $parent->name,
                'slug' => $parent->slug,
                'link' => get_term_link($parent),
                'count' => $total_count,
                'image_url' => esc_url_raw($image_url),
            ];
        }

        // Sort by total count (descending)
        usort($result, function ($a, $b) {
            return $b['count'] <=> $a['count'];
        });

        // Limit to top 30
        $result = array_slice($result, 0, 30);

        // Store cache in options table (non-autoloaded)
        update_option($option_name, $result, false);
    }
    public static function caching_the_most_usefull_plugins_icons_total_category_plugin_count()
    {
        global $wpdb;


        $total_plugins = $wpdb->get_var("
        SELECT COUNT(*) 
        FROM {$wpdb->posts} AS post_table
        INNER JOIN {$wpdb->prefix}plugins_core_information AS core_table
            ON post_table.ID = core_table.wp_post_id
        WHERE post_table.post_type = 'plugins' 
          AND post_table.post_status = 'publish'
    ");


        $top_plugins = $wpdb->get_results("
        SELECT core_table.plugin_icon,core_table.id 
        FROM {$wpdb->posts} AS post_table
        INNER JOIN {$wpdb->prefix}plugins_core_information AS core_table
            ON post_table.ID = core_table.wp_post_id
        WHERE post_table.post_type = 'plugins' 
          AND post_table.post_status = 'publish'
        ORDER BY core_table.overall_wpscore DESC
        LIMIT 15
    ", ARRAY_A);


        $plugin_icons = array_map(function ($plugin) {
            return $plugin['plugin_icon'];
        }, $top_plugins);

        $plugin_ids = array_map(function ($plugin) {
            return $plugin['id'];
        }, $top_plugins);



        $total_category = $wpdb->get_var("
            SELECT count(term_id) 
            FROM {$wpdb->term_taxonomy} 
            WHERE taxonomy = 'plugin_category'
        ");
        $data_mostly_used_plugin_total_plugins = [
            'total_plugins' => $total_plugins,
            'top_plugin_icons' => $plugin_icons,
            'total_category' => $total_category,
            'plugin_ids' => $plugin_ids

        ];
        update_option('_the_most_usefull_plugins_icons_total_category_plugin_count', $data_mostly_used_plugin_total_plugins, false);
    }
    public static function duplicate_category_management_job()
    {
        global $wpdb;

        // Step 1: Get all duplicate mappings
        $duplicates = $wpdb->get_results("
        SELECT term_id, meta_value 
        FROM {$wpdb->prefix}termmeta 
        WHERE meta_key = '_replaceable_cats'
    ");

        if (!empty($duplicates)) {
            foreach ($duplicates as $dup) {
                $original_term_id = intval($dup->term_id);     // The term to KEEP
                $duplicate_term_id = intval($dup->meta_value);  // The term to DELETE

                // --- Step 2: Move all children of duplicate term to original term ---
                $children = get_terms([
                    'taxonomy' => 'plugin_category',
                    'hide_empty' => false,
                    'parent' => $duplicate_term_id,
                ]);

                if (!empty($children)) {
                    foreach ($children as $child) {
                        wp_update_term($child->term_id, 'plugin_category', [
                            'parent' => $original_term_id,
                        ]);
                    }
                }

                // --- Step 3: Reassign all posts (plugins) from duplicate to original ---
                $posts = get_posts([
                    'post_type' => 'plugins',
                    'posts_per_page' => -1,
                    'tax_query' => [
                        [
                            'taxonomy' => 'plugin_category',
                            'field' => 'term_id',
                            'terms' => $duplicate_term_id,
                        ]
                    ]
                ]);

                if (!empty($posts)) {
                    foreach ($posts as $post) {
                        // Remove duplicate term
                        wp_remove_object_terms($post->ID, $duplicate_term_id, 'plugin_category');
                        // Add original term
                        wp_set_object_terms($post->ID, $original_term_id, 'plugin_category', true);
                    }
                }

                // --- Step 4: Delete the duplicate term ---
                wp_delete_term($duplicate_term_id, 'plugin_category');

                // --- Step 5: Clean up the meta record ---
                $wpdb->delete(
                    "{$wpdb->prefix}termmeta",
                    [
                        'term_id' => $original_term_id,
                        'meta_key' => '_replaceable_cats'
                    ],
                    ['%d', '%s']
                );
            }
        }
    }
    public static function setting_core_table_info_with_taxonomy()
    {
        global $wpdb;

        // Increase GROUP_CONCAT limit
        $wpdb->query("SET SESSION group_concat_max_len = 10000;");

        // Update post_taxonomy_ids as JSON array
        $update_sql = "
    UPDATE {$wpdb->prefix}plugins_core_information AS pci
    JOIN (
        SELECT 
            p.ID AS post_id,
            CONCAT('[', GROUP_CONCAT(t.term_id), ']') AS taxonomy_ids_json
        FROM {$wpdb->posts} AS p
        INNER JOIN {$wpdb->term_relationships} AS tr 
            ON tr.object_id = p.ID
        INNER JOIN {$wpdb->term_taxonomy} AS tt 
            ON tt.term_taxonomy_id = tr.term_taxonomy_id
        INNER JOIN {$wpdb->terms} AS t 
            ON t.term_id = tt.term_id
        WHERE p.post_type = 'plugins'
          AND tt.taxonomy = 'plugin_category'
        GROUP BY p.ID
    ) AS derived ON pci.wp_post_id = derived.post_id
    SET pci.post_taxonomy_ids = derived.taxonomy_ids_json;
    ";

        $result = $wpdb->query($update_sql);

        if ($result !== false) {
            error_log("✅ Successfully updated {$result} plugin rows in wp_plugins_core_information (taxonomy).");
        } else {
            error_log("❌ Failed to update plugin taxonomy data.");
        }
    }

    public static function setting_core_table_info_with_taxonomy_tag()
    {
        global $wpdb;

        // Increase GROUP_CONCAT limit
        $wpdb->query("SET SESSION group_concat_max_len = 10000;");

        // Update post_tag_ids as JSON array
        $update_sql = "
    UPDATE {$wpdb->prefix}plugins_core_information AS pci
    JOIN (
        SELECT 
            p.ID AS post_id,
            CONCAT('[', GROUP_CONCAT(t.term_id), ']') AS tag_ids_json
        FROM {$wpdb->posts} AS p
        INNER JOIN {$wpdb->term_relationships} AS tr 
            ON tr.object_id = p.ID
        INNER JOIN {$wpdb->term_taxonomy} AS tt 
            ON tt.term_taxonomy_id = tr.term_taxonomy_id
        INNER JOIN {$wpdb->terms} AS t 
            ON t.term_id = tt.term_id
        WHERE p.post_type = 'plugins'
          AND tt.taxonomy = 'plugin_tag'
        GROUP BY p.ID
    ) AS derived ON pci.wp_post_id = derived.post_id
    SET pci.post_tag_ids = derived.tag_ids_json;
    ";

        $result = $wpdb->query($update_sql);

        if ($result !== false) {
            error_log("✅ Successfully updated {$result} plugin rows in wp_plugins_core_information (tags).");
        } else {
            error_log("❌ Failed to update plugin tag data.");
        }
    }
    public static function cache_plugin_category_children_data()
    {
        $taxonomy = 'plugin_category';

        $meta_children_ids = '_plugin_category_children_ids';
        $meta_children_data = '_plugin_category_children_data';
        $meta_log = '_plugin_category_meta_log';

        // ✅ Get top-level parents
        $parents = get_terms([
            'taxonomy' => $taxonomy,
            'parent' => 0,
            'hide_empty' => false,
        ]);

        if (empty($parents) || is_wp_error($parents)) {
            return;
        }

        /**
         * 🔁 Recursive function to collect descendants
         */
        $get_descendants = function ($term_id) use (&$get_descendants, $taxonomy) {

            $children = get_terms([
                'taxonomy' => $taxonomy,
                'parent' => $term_id,
                'hide_empty' => false,
            ]);

            $all = [];

            if (!empty($children) && !is_wp_error($children)) {
                foreach ($children as $child) {
                    $all[] = $child;

                    // recursion for deeper levels
                    $all = array_merge($all, $get_descendants($child->term_id));
                }
            }

            return $all;
        };

        foreach ($parents as $parent) {

            $parent_id = (int) $parent->term_id;

            // ✅ Get all descendants (term objects)
            $descendants = $get_descendants($parent_id);

            if (empty($descendants)) {
                update_term_meta($parent_id, $meta_children_ids, []);
                update_term_meta($parent_id, $meta_children_data, wp_json_encode([]));
                update_term_meta($parent_id, $meta_log, "ℹ️ No subcategories found");
                continue;
            }

            /**
             * ✅ Build children data
             */
            $children_data = [];
            $children_ids = [];

            foreach ($descendants as $term) {
                $children_ids[] = $term->term_id;

                $children_data[] = [
                    'id' => $term->term_id,
                    'name' => $term->name,
                    'count' => (int) $term->count, // post count
                    'slug' => $term->slug,         // optional but useful
                ];
            }

            // ✅ Sort by count DESC
            usort($children_data, fn($a, $b) => $b['count'] <=> $a['count']);

            // ✅ Save meta
            update_term_meta($parent_id, $meta_children_ids, $children_ids);
            update_term_meta($parent_id, $meta_children_data, wp_json_encode($children_data));

            update_term_meta(
                $parent_id,
                $meta_log,
                "✅ Cached " . count($children_ids) . " subcategories — " . date('Y-m-d H:i')
            );
        }
    }

    public static function assign_posts_to_parent_and_update_core_table()
    {
        global $wpdb;

        $taxonomy = 'plugin_category';
        $meta_key_children = '_plugin_category_children_ids';
        $post_type = 'plugins'; // your CPT name
        $core_table = "{$wpdb->prefix}plugins_core_information";
        $field_to_update = 'post_taxonomy_ids';

        // === Get parent terms with child cache ===
        $parents = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT term_id, meta_value 
             FROM {$wpdb->termmeta} 
             WHERE meta_key = %s",
                $meta_key_children
            )
        );

        if (empty($parents)) {
            error_log('❌ No parent terms found in termmeta.');
            return;
        }

        foreach ($parents as $row) {
            $parent_id = intval($row->term_id);
            $children_ids = maybe_unserialize($row->meta_value);

            if (empty($children_ids) || !is_array($children_ids)) {
                error_log("ℹ️ No valid children for parent {$parent_id}");
                continue;
            }

            // === Find all posts assigned to child terms ===
            $posts = get_posts([
                'post_type' => $post_type,
                'post_status' => 'any',
                'numberposts' => -1,
                'fields' => 'ids',
                'tax_query' => [
                    [
                        'taxonomy' => $taxonomy,
                        'field' => 'term_id',
                        'terms' => $children_ids,
                    ],
                ],
            ]);

            if (empty($posts)) {
                error_log("ℹ️ No posts found under children of parent {$parent_id}");
                continue;
            }

            $updated_rows = 0;

            foreach ($posts as $post_id) {
                // Get all existing category terms
                $existing_terms = wp_get_post_terms($post_id, $taxonomy, ['fields' => 'ids']);

                // Ensure parent term is also assigned
                if (!in_array($parent_id, $existing_terms, true)) {
                    $new_terms = array_unique(array_merge($existing_terms, [$parent_id]));
                    wp_set_post_terms($post_id, $new_terms, $taxonomy, false);
                    $existing_terms = $new_terms;
                }

                // Update in core information table (not post meta)
                //$taxonomy_ids_csv = implode(',', $existing_terms);
                // $taxonomy_ids_csv = json_encode( $existing_terms);
                // $wpdb->update(
                //     $core_table,
                //     [$field_to_update => $taxonomy_ids_csv],
                //     ['wp_post_id' => $post_id],
                //     ['%s'],
                //     ['%d']
                // );

                $updated_rows++;
            }

            error_log("✅ Parent term {$parent_id} updated {$updated_rows} plugin rows in {$core_table}.");
        }

        error_log("🏁 Finished updating parent-child plugin taxonomy data into core table.");
    }
    public static function manage_post_with_missing_category_sub_category()
    {
        global $wpdb;

        $table_posts = $wpdb->prefix . 'posts';
        $table_info = $wpdb->prefix . 'plugins_core_information';

        $post_type = 'plugins'; // optional filter
        $limit = 50;        // optional limit

        $sql = "
        SELECT 
            p.ID,
            i.wp_post_id,
            i.plugin_open_ai_category
        FROM 
            {$table_posts} AS p
        INNER JOIN 
            {$table_info} AS i
            ON p.ID = i.wp_post_id
        WHERE 
            i.plugin_open_ai_category IS NOT NULL
            AND i.plugin_open_ai_category <> ''
            AND (
                i.post_taxonomy_ids IS NULL
                OR TRIM(i.post_taxonomy_ids) = ''
            )
    ";

        if (!empty($post_type)) {
            $sql .= $wpdb->prepare(" AND p.post_type = %s", $post_type);
        }

        $sql .= $wpdb->prepare(" LIMIT %d", $limit);

        $results = $wpdb->get_results($sql);

        add_option('manage_post_with_missing_category_sub_category', json_encode($results), false);
    }

    public static function create_json_from_exiting_plugin_category()
    {
        $terms = get_terms([
            'taxonomy' => 'plugin_category',
            'parent' => 0, // Only get top-level terms (parent categories)
            'hide_empty' => false,  // Show even if there are no posts
        ]);

        // Initialize the category array
        $categories = [];

        // Loop through each parent term and fetch its immediate subcategories
        foreach ($terms as $term) {
            $subcategories = [];

            // Get the immediate child terms (subcategories) under this parent
            $child_terms = get_terms([
                'taxonomy' => 'plugin_category',
                'parent' => $term->term_id, // Only get child terms for this parent
                'hide_empty' => false, // Show even if there are no posts
            ]);

            // Loop through the child terms (subcategories) and add them to the subcategories array
            foreach ($child_terms as $child) {
                $subcategories[] = [
                    'name' => $child->name,
                    'slug' => $child->slug,
                ];
            }

            // Add the current parent term to the categories array with its subcategories
            $categories[] = [
                'name' => $term->name,
                'slug' => $term->slug,
                'subcategories' => $subcategories,
            ];
        }

        // Create the file name with the current date and save it in the root directory of WordPress
        $file_name = ABSPATH . 'cron-management/plugin_category_exit_in_site_' . '.json';

        // Encode the array into JSON format
        $json_data = json_encode(['categories' => $categories], JSON_PRETTY_PRINT);

        // Save the JSON data to the file
        file_put_contents($file_name, $json_data);
    }

    public static function cashing_data_for_searching()
    {
        global $wpdb;

        $table_name = $wpdb->prefix . 'plugins_core_information';

        // Fetch plugin posts with score ordering
        $results = $wpdb->get_results("
    SELECT wp_post_id, overall_wpscore
    FROM {$table_name}
    WHERE wp_post_id > 0
    ORDER BY overall_wpscore DESC
");

        $final_data = [];
        /**
         *  ADD PARENT CATEGORIES ORDERED BY COUNT DESC
         */
        $parent_categories = get_terms([
            'taxonomy' => 'plugin_category',
            'parent' => 0,
            'orderby' => 'count',
            'order' => 'DESC',
        ]);

        if (!is_wp_error($parent_categories) && !empty($parent_categories)) {
            foreach ($parent_categories as $cat) {

                // Collect children categories for text field
                $children = get_terms([
                    'taxonomy' => 'plugin_category',
                    'parent' => $cat->term_id,
                    'fields' => 'names'
                ]);

                $text_value = implode(', ', is_array($children) ? $children : []);

                $final_data[] = [
                    "title" => $cat->name,
                    "text" => $text_value,
                    "link" => get_term_link($cat),
                    "term_id"=>$cat->term_id
                ];
            }
        }
        if (!empty($results)) {
            foreach ($results as $row) {

                $post_id = intval($row->wp_post_id);
                $post = get_post($post_id);

                if (!$post || $post->post_type !== 'plugins') {
                    continue;
                }

                // CATEGORY NAMES
                $category_names = wp_get_post_terms($post_id, 'plugin_category', ['fields' => 'names']);
                $category_names = is_array($category_names) ? $category_names : [];

                // TAG NAMES
                $tag_names = wp_get_post_terms($post_id, 'plugin_tag', ['fields' => 'names']);
                $tag_names = is_array($tag_names) ? $tag_names : [];

                // MERGE TERMS
                $all_terms = array_merge($category_names, $tag_names);
                $text_value = implode(', ', $all_terms);

                $final_data[] = [
                    "title" => $post->post_title,
                    "text" => $text_value,
                    "link" => get_permalink($post_id),
                    "post_id"=>$post_id
                ];
            }
        }



        // JSON encode
        $json_output = json_encode($final_data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);

        // Save file
        $file_path = get_template_directory() . '/plugins-suggestions.json';
        file_put_contents($file_path, $json_output);

        return true;

    }
}
