<?php

class Custom_post_functionalities
{
    public static function register_plugins_cpt()
    {
        $labels = [
            'name'               => 'Plugins',
            'singular_name'      => 'Plugin',
            'menu_name'          => 'Plugins',
            'name_admin_bar'     => 'Plugin',
            'add_new'            => 'Add New Plugin',
            'add_new_item'       => 'Add New Plugin',
            'new_item'           => 'New Plugin',
            'edit_item'          => 'Edit Plugin',
            'view_item'          => 'View Plugin',
            'all_items'          => 'All Plugins',
            'search_items'       => 'Search Plugins',
            'not_found'          => 'No Plugins found.',
            'not_found_in_trash' => 'No Plugins found in Trash.',
        ];

        $args = [
            'label'              => 'Plugins',
            'labels'             => $labels,
            'public'             => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'menu_icon'          => 'dashicons-admin-generic',
            'supports'           => ['title', 'editor', 'thumbnail', 'excerpt', 'author'],
            'has_archive'        => true,
            'rewrite'            => ['slug' => 'plugins'],
            'show_in_rest'       => true,
            'rest_base'          => 'plugins',
            'publicly_queryable' => true,
            'capability_type'    => 'post',
        ];

        register_post_type('plugins', $args);
    }
    public static function register_plugin_category_taxonomy()
    {
        $labels = [
            'name'          => 'Plugin Categories',
            'singular_name' => 'Plugin Category',
            'search_items'  => 'Search Plugin Categories',
            'all_items'     => 'All Plugin Categories',
            'edit_item'     => 'Edit Plugin Category',
            'update_item'   => 'Update Plugin Category',
            'add_new_item'  => 'Add New Plugin Category',
            'new_item_name' => 'New Plugin Category Name',
            'menu_name'     => 'Plugin Categories',
        ];

        $args = [
            'labels'            => $labels,
            'hierarchical'      => true, // ✅ Works like categories
            'public'            => true,
            'show_ui'           => true,
            'show_admin_column' => true,
            'show_in_nav_menus' => true,
            'rewrite'           => ['slug' => 'plugin-category', 'hierarchical' => true],
            'show_in_rest'      => true, // ✅ Gutenberg + REST API
        ];

        register_taxonomy('plugin_category', ['plugins'], $args);
    }
    public static function manage_plugins_posts_columns($columns)
    {
        $new = [];

        foreach ($columns as $key => $value) {
            $new[$key] = $value;

            // Add plugin_thumb right after checkbox
            if ($key === 'cb') {
                $new['plugin_thumb'] = __('Thumbnail');
            }

            // Add plugin_developer right after title
            if ($key === 'title') {
                $new['plugin_developer'] = __('Developer');
            }
        }

        return $new;
    }
    public static function manage_plugins_posts_custom_column($column, $post_id)
    {
        $feature_image_developer = get_the_feature_image_developer_from_cpt_with_core($post_id);

        $image = $feature_image_developer->plugin_icon ? $feature_image_developer->plugin_icon : $feature_image_developer->plugin_feature_image;

        $developer_name    = $feature_image_developer->author_name ?? '';
        $developer_profile = $feature_image_developer->author_profile ?? '';

        // Thumbnail column
        if ($column === 'plugin_thumb') {

            if (! empty($image)) {
                echo sprintf(
                    '<img src="%s" alt="%s" style="width:50px;height:50px;object-fit:contain;border-radius:6px;">',
                    esc_url($image),
                    esc_attr($developer_name ?: "plugin image")
                );
            } else {
                echo '<span style="color:#aaa;">No image</span>';
            }
        }

        // Developer column
        if ($column === 'plugin_developer') {

            if (! empty($developer_name)) {

                if (! empty($developer_profile)) {
                    // Name clickable with URL
                    echo sprintf(
                        '<a href="%s" target="_blank">%s</a>',
                        esc_url($developer_profile),
                        esc_html($developer_name)
                    );
                } else {
                    // No link, but show name
                    echo esc_html($developer_name);
                }

            } else {
                echo '<span style="color:#aaa;">No Developer</span>';
            }
        }

    }
    public static function plugins_sortable_columns_thum_issue($columns)
    {
        unset($columns['plugin_thumb']);
        unset($columns['plugin_developer']);
        return $columns;
    }
    public static function add_metabox_init_function()
    {
        add_meta_box(
            'my_plugins_meta_box',
            __('Plugin Details Information', 'wpsearch'),
            ['Custom_post_functionalities', 'plugins_cpt_metabox'],
            'plugins', // Target post type
            'normal',
            'default'
        );

    }
    public static function plugins_cpt_metabox()
    {
        wp_nonce_field('my_plugins_save_meta', 'my_plugins_meta_nonce');
        require get_template_directory() . '/admin/metabox-html/plugins-cpt-meta-box-form.php';
    }

    public static function plugins_save_meta($post_id, $post, $update)
    {
        if (empty($_POST)) {
            return;
        }

        if (! $update) {
            return;
        }
        if (wp_doing_ajax() || wp_is_post_autosave($post_id) || wp_is_post_revision($post_id) || ! is_admin()) {
            return;
        }

        // ✅ Only run for our custom post type "plugins"
        if (get_post_type($post_id) !== 'plugins') {
            return;
        }

        global $wpdb;
        $tbl_core_plugin_information = $wpdb->prefix . "plugins_core_information";
        $numeric_fields              = array_values(Helpers::metric_information_attributes_mapping_db_keys());
        $numeric_fields[]            = "overall_wpscore";
        $select_fields               = ['license_type', 'has_lifetime_license', 'woocommerce_support', 'has_agency_friendly_license', 'is_multisite_support', 'support_quality', 'performance_impact', 'user_review_sentiment', 'seo_impact', 'is_sponsored', 'is_recreate_ai_post', 'is_meta_information_from_ai_search', 'is_wps_metric_group_done'];

        $data = [];
        foreach (array_merge($numeric_fields, $select_fields) as $field) {
            if (isset($_POST[$field])) {
                $data[$field] = sanitize_text_field($_POST[$field]);
            }
        }
        //$post_taxonomy_ids = isset($_POST['tax_input']['plugin_category']) ? (array) $_POST['tax_input']['plugin_category'] : [];

        // Remove empty/zero and make sure numeric
        //$post_taxonomy_ids = array_filter($post_taxonomy_ids, function ($value) {
        //return is_numeric($value) && intval($value) > 0;
        //});

        // Convert all to integers and reindex
        //$post_taxonomy_ids = array_values(array_map('intval', $post_taxonomy_ids));

        // =======================
        // ✅ Plugin Tags (names → IDs)
        // =======================
        //$tag_input = $_POST['tax_input']['plugin_tag'] ?? '';

        // Case: Input is comma-separated names
        //$tag_names = array_filter(array_map('trim', explode(',', $tag_input)));

        //$tag_ids = [];

        // foreach ($tag_names as $tag_name) {

        //     if (empty($tag_name))
        //         continue;

        //     // 🔍 Check if tag already exists
        //     $existing = get_term_by('name', $tag_name, 'plugin_tag');

        //     if ($existing && !is_wp_error($existing)) {
        //         // Tag exists → use term_id
        //         $tag_ids[] = $existing->term_id;
        //     } else {
        //         // ➕ Insert new term
        //         $new = wp_insert_term($tag_name, 'plugin_tag');

        //         if (!is_wp_error($new) && isset($new['term_id'])) {
        //             $tag_ids[] = $new['term_id'];
        //         }
        //     }
        // }

        // Ensure unique IDs
        //$tag_ids = array_unique($tag_ids);
        //exit;
        //$data["post_long_descripton"] = sanitize_text_field($_POST["content"]);
        $data["post_short_descripton"] = sanitize_text_field($_POST["excerpt"]);
        $data["post_title"]            = sanitize_text_field($_POST["post_title"]);
        $data["post_meta_keywords"]    = sanitize_text_field($_POST["plugin_keywords"]);

        $data["plugin_pro_version_link"] = esc_url_raw($_POST["plugin_pro_version_link"]);
        $data["plugin_docs_link"]        = esc_url_raw($_POST["plugin_docs_link"]);
        $data["plugin_live_demo_link"]   = esc_url_raw($_POST["plugin_live_demo_link"]);

        $data["best_youtube_tutorials_link"] = esc_url_raw($_POST["best_youtube_tutorials_link"]);
        $data["community_page_link"]         = esc_url_raw($_POST["community_page_link"]);

        //$data["post_taxonomy_ids"] = !empty($post_taxonomy_ids) ? json_encode($post_taxonomy_ids) : null;
        //$data["post_tag_ids"] = !empty($tag_ids) ? json_encode($tag_ids) : null;
        $wpdb->update($tbl_core_plugin_information, $data, ['wp_post_id' => $post_id]);

    }
    public static function plugin_post_deleted($post_id)
    {
        if (get_post_type($post_id) !== 'plugins') {
            return;
        }

        global $wpdb;
        $tbl_core_plugin_information = $wpdb->prefix . "plugins_core_information";

        // Remove from custom table
        $data = [
            'is_wp_post_created' => 0,
        ];
        $wpdb->update($tbl_core_plugin_information, $data, ['wp_post_id' => $post_id]);
    }

    public static function register_faq_cpt()
    {
        $labels = [
            'name'               => 'Home Page FAQs',
            'singular_name'      => 'Home Page FAQ',
            'menu_name'          => 'Home Page FAQs',
            'name_admin_bar'     => 'Home Page FAQ',
            'add_new'            => 'Add New FAQ',
            'add_new_item'       => 'Add New FAQ',
            'new_item'           => 'New FAQ',
            'edit_item'          => 'Edit FAQ',
            'view_item'          => 'View FAQ',
            'all_items'          => 'All FAQs',
            'search_items'       => 'Search FAQs',
            'not_found'          => 'No FAQs found.',
            'not_found_in_trash' => 'No FAQs found in Trash.',
        ];

        $args = [
            'label'              => 'Home Page FAQs',
            'labels'             => $labels,
            'public'             => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'menu_icon'          => 'dashicons-editor-help',
            'supports'           => [
                'title',
                'editor',    // Description
                'thumbnail', // Featured image
            ],
            'has_archive'        => true,
            'rewrite'            => ['slug' => 'home-page-faq'],
            'show_in_rest'       => true, // ✅ Enables Gutenberg + REST API
            'rest_base'          => 'home_page_faq',
            'publicly_queryable' => true,
            'capability_type'    => 'post',
        ];

        register_post_type('home_page_faq', $args);
    }
    public static function faq_meta_box_tabs()
    {
        add_meta_box(
            'faq_meta_box_colmuns',                                          // ID
            'Faq Column',                                                    // Title
            ['Custom_post_functionalities', 'faq_meta_box_column_callback'], // Callback function
            'home_page_faq',                                                 // Post type (change to your custom post type)
            'normal',                                                        // Context
            'high'                                                           // Priority
        );
    }
    public static function faq_meta_box_column_callback()
    {
        require_once get_stylesheet_directory() . '/admin/metabox-html/home_page_faq_column_callback_html.php';
    }
    public static function save_home_page_faq_meta_box_data($post_id, $post, $update)
    {
        // ✅ Verify nonce
        //dd($_POST);
        //exit;
        if (
            ! isset($_POST['_home_page_faq_groups_nonce']) ||
            ! wp_verify_nonce($_POST['_home_page_faq_groups_nonce'], '_home_page_faq_groups_nonce_action')
        ) {
            return;
        }

        // ✅ Skip autosave/revision
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return;
        }

        if (wp_is_post_revision($post_id)) {
            return;
        }

        // ✅ Permission check
        if (! current_user_can('edit_post', $post_id)) {
            return;
        }

        // ✅ Save repeater data
        if (! empty($_POST['_home_page_faq_groups']) && is_array($_POST['_home_page_faq_groups'])) {

            $clean_data = array_map(function ($row) {
                return [
                    'title'    => isset($row['title']) ? sanitize_text_field($row['title']) : '',
                    'textarea' => isset($row['textarea']) ? wp_kses_post($row['textarea']) : '',
                    'image'    => isset($row['image']) ? esc_url_raw($row['image']) : '',
                ];
            }, $_POST['_home_page_faq_groups']);
            //dd($clean_data);
            //exit;
            update_post_meta($post_id, '_home_page_faq_groups', $clean_data);
        } else {
            delete_post_meta($post_id, '_home_page_faq_groups');
        }
    }
    public static function register_customer_review_cpt()
    {
        // Register "Customer Reviews" Custom Post Type

        $labels = [
            'name'               => 'Customer Reviews',
            'singular_name'      => 'Customer Review',
            'menu_name'          => 'Customer Reviews',
            'name_admin_bar'     => 'Customer Review',
            'add_new'            => 'Add New Review',
            'add_new_item'       => 'Add New Customer Review',
            'new_item'           => 'New Review',
            'edit_item'          => 'Edit Review',
            'view_item'          => 'View Review',
            'all_items'          => 'All Reviews',
            'search_items'       => 'Search Reviews',
            'not_found'          => 'No reviews found.',
            'not_found_in_trash' => 'No reviews found in Trash.',
        ];

        $args = [
            'label'              => 'Customer Reviews',
            'labels'             => $labels,
            'public'             => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'menu_icon'          => 'dashicons-testimonial',
            'supports'           => ['title', 'editor', 'thumbnail', 'excerpt'],
            'has_archive'        => true,
            'rewrite'            => ['slug' => 'customer-reviews'],
            'show_in_rest'       => true, // Enables Gutenberg + REST API
            'rest_base'          => 'customer_reviews',
            'publicly_queryable' => true,
            'capability_type'    => 'post',
        ];

        register_post_type('customer_review', $args);

    }
    public static function register_plugin_tag_taxonomy()
    {
        $labels = [
            'name'                       => 'Plugin Tags',
            'singular_name'              => 'Plugin Tag',
            'search_items'               => 'Search Plugin Tags',
            'popular_items'              => 'Popular Plugin Tags',
            'all_items'                  => 'All Plugin Tags',
            'edit_item'                  => 'Edit Plugin Tag',
            'update_item'                => 'Update Plugin Tag',
            'add_new_item'               => 'Add New Plugin Tag',
            'new_item_name'              => 'New Plugin Tag Name',
            'separate_items_with_commas' => 'Separate tags with commas',
            'add_or_remove_items'        => 'Add or remove tags',
            'choose_from_most_used'      => 'Choose from most used tags',
            'menu_name'                  => 'Plugin Tags',
        ];

        $args = [
            'labels'             => $labels,
            'hierarchical'       => false,
            'public'             => false, // ❌ Not public → No frontend URL
            'publicly_queryable' => false, // ❌ Prevents ?plugin_tag=xx queries
            'show_ui'            => true,  // ✔ Show in admin
            'show_admin_column'  => true,
            'show_in_nav_menus'  => false,
            'show_tagcloud'      => false,
            'rewrite'            => false, // ❌ No rewrite slug
            'show_in_rest'       => true,  // ✔ Still usable in REST + Gutenrberg
        ];

        register_taxonomy('plugin_tag', ['plugins'], $args);
    }
    public static function register_plugin_comparison_cpt()
    {
        // Register "Plugin Comparisons" Custom Post Type

        $labels = [
            'name'               => 'Plugin Comparisons',
            'singular_name'      => 'Plugin Comparison',
            'menu_name'          => 'Plugin Comparisons',
            'name_admin_bar'     => 'Plugin Comparison',
            'add_new'            => 'Add New Comparison',
            'add_new_item'       => 'Add New Plugin Comparison',
            'new_item'           => 'New Comparison',
            'edit_item'          => 'Edit Comparison',
            'view_item'          => 'View Comparison',
            'all_items'          => 'All Comparisons',
            'search_items'       => 'Search Comparisons',
            'not_found'          => 'No comparisons found.',
            'not_found_in_trash' => 'No comparisons found in Trash.',
        ];

        $args = [
            'label'              => 'Plugin Comparisons',
            'labels'             => $labels,
            'public'             => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'menu_icon'          => 'dashicons-admin-plugins',
            'supports'           => ['title', 'editor', 'thumbnail', 'excerpt'],
            'has_archive'        => false,
            'rewrite'            => ['slug' => 'plugin-comparison'],
            'show_in_rest'       => true, // Gutenberg + REST API
            'rest_base'          => 'plugin_comparisons',
            'publicly_queryable' => true,
            'capability_type'    => 'post',
        ];

        register_post_type('plugin_comparison', $args);
    }
    public static function register_plugin_comparison_taxonomy()
    {
        $labels = [
            'name'          => 'Comparison Categories',
            'singular_name' => 'Comparison Category',
            'search_items'  => 'Search Comparison Categories',
            'all_items'     => 'All Comparison Categories',
            'edit_item'     => 'Edit Comparison Category',
            'update_item'   => 'Update Comparison Category',
            'add_new_item'  => 'Add New Comparison Category',
            'new_item_name' => 'New Comparison Category Name',
            'menu_name'     => 'Comparison Categories',
        ];

        $args = [
            'labels'            => $labels,
            'hierarchical'      => true, // ✅ Works like categories
            'public'            => false,
            'show_ui'           => true,
            'show_admin_column' => true,
            'show_in_nav_menus' => true,
            //'rewrite'           => ['slug' => 'comparion-category', 'hierarchical' => true],
            'rewrite'           => false,
            'show_in_rest'      => true, // ✅ Gutenberg + REST API
        ];

        register_taxonomy('comparison_category', ['plugin_comparison'], $args);
    }
    public static function plugin_comparison_tabs()
    {
        add_meta_box(
            'my_plugins_meta_box',
            __('Comparison Meta Informations', 'wpsearch'),
            ['Custom_post_functionalities', 'plugin_comparison_tabs_metabox'],
            'plugin_comparison', // Target post type
            'normal',
            'default'
        );
    }
    public static function plugin_comparison_tabs_metabox()
    {
        wp_nonce_field('plugin_comparison_save', 'plugin_comparison_nonce');
        require get_template_directory() . '/admin/metabox-html/plugin-comparison-tabs-meta-box-form.php';
    }
    public static function save_plugin_comparison_save_metabox($post_id, $post, $update)
    {
        // Check nonce
        if (! isset($_POST['plugin_comparison_nonce']) ||
            ! wp_verify_nonce($_POST['plugin_comparison_nonce'], 'plugin_comparison_save')) {
            return;
        }

        // Check autosave
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return;
        }

        // Check permissions
        if (! current_user_can('edit_post', $post_id)) {
            return;
        }

        // Save data
        if (isset($_POST['plugin_comparison_data'])) {
            update_post_meta($post_id, '_plugin_comparison_data', $_POST['plugin_comparison_data']);
        }
    }
    public static function comparison_posts_columns($columns)
    {
        $new = [];

        foreach ($columns as $key => $value) {
            $new[$key] = $value;

            // Add icons column after title
            if ($key === 'title') {
                $new['comparison_plugins'] = __('Plugins');
            }
        }

        return $new;
    }
    public static function comparison_posts_custom_column($column, $post_id)
    {
        if ($column !== 'comparison_plugins') {
            return;
        }

        $icons_csv = get_post_meta($post_id, '_comparison_plugin_icons', true);

        if (empty($icons_csv)) {
            echo '<span style="color:#aaa;">No plugins</span>';
            return;
        }

        $icons = array_filter(array_map('trim', explode(',', $icons_csv)));

        if (empty($icons)) {
            echo '<span style="color:#aaa;">No plugins</span>';
            return;
        }

        echo '<div class="comparison-plugin-icons">';

        foreach ($icons as $icon) {
            echo sprintf(
                '<img src="%s" style="width:28px;height:28px;object-fit:contain;border-radius:4px;margin-right:4px;" />',
                esc_url($icon)
            );
        }

        echo '</div>';
    }
    public static function comparison_sortable_columns_fix($columns)
    {
        unset($columns['comparison_plugins']);
        return $columns;
    }

}
