<?php
class admin_post_query_modification
{
    // Restrict admin filter to plugin categories using slug
    public static function restrict_manage_posts_plugin_cpt_category()
    {
        global $typenow;

        if ($typenow === 'plugins') {
            $taxonomy = 'plugin_category';
            $selected = isset($_GET[$taxonomy]) ? sanitize_text_field($_GET[$taxonomy]) : '';
            $info_taxonomy = get_taxonomy($taxonomy);

            wp_dropdown_categories([
                'show_option_all' => sprintf(__('Show all %s', 'textdomain'), $info_taxonomy->label),
                'taxonomy' => $taxonomy,
                'name' => $taxonomy,
                'orderby' => 'name',
                'selected' => $selected,
                'show_count' => true,
                'hide_empty' => false,
                'value_field' => 'slug', // Use slug for the dropdown
            ]);
        }
    }

    // Parse the query for plugin category using slug
    public static function parse_query_plugin_cpt_category($query)
    {
        global $pagenow;
        $taxonomy = 'plugin_category';
        $q_vars = &$query->query_vars;

        // Only apply to the plugins post type
        if (
            $pagenow === 'edit.php' &&
            isset($q_vars['post_type']) &&
            $q_vars['post_type'] === 'plugins' &&
            !empty($_GET[$taxonomy]) // Ensure we are getting the slug
        ) {
            $term = get_term_by('slug', sanitize_text_field($_GET[$taxonomy]), $taxonomy);

            if ($term && !is_wp_error($term)) {
                $q_vars[$taxonomy] = $term->slug; // Use slug for filtering
            }
        }
    }

    // Modify the query to filter by plugin category using slug
    public static function pre_get_post_query_plugin_cpt_category($query)
    {
        global $pagenow;

        if (
            is_admin() &&
            $pagenow === 'edit.php' &&
            isset($_GET['post_type']) && $_GET['post_type'] === 'plugins' &&
            isset($_GET['plugin_category']) && !empty($_GET['plugin_category'])
        ) {
            $slug = sanitize_text_field($_GET['plugin_category']);

            $query->set('tax_query', [
                [
                    'taxonomy' => 'plugin_category',
                    'field' => 'slug',
                    'terms' => [$slug], // Use slug here
                    'include_children' => false, // Do not include child categories
                ]
            ]);
        }
    }

    // Restrict admin filter to plugin tags using slug
    public static function restrict_manage_posts_plugin_cpt_tag()
    {
        global $typenow;

        if ($typenow === 'plugins') {
            $taxonomy = 'plugin_tag';
            $selected = isset($_GET[$taxonomy]) ? sanitize_text_field($_GET[$taxonomy]) : '';
            $info_taxonomy = get_taxonomy($taxonomy);

            wp_dropdown_categories([
                'show_option_all' => sprintf(__('Show all %s', 'textdomain'), $info_taxonomy->label),
                'taxonomy' => $taxonomy,
                'name' => $taxonomy,
                'orderby' => 'name',
                'selected' => $selected,
                'show_count' => true,
                'hide_empty' => false,
                'value_field' => 'slug', // Use slug for the dropdown
            ]);
        }
    }

    // Parse the query for plugin tags using slug
    public static function parse_query_plugin_cpt_tag($query)
    {
        global $pagenow;
        $taxonomy = 'plugin_tag';
        $q_vars = &$query->query_vars;

        // Only apply to the plugins post type
        if (
            $pagenow === 'edit.php' &&
            isset($q_vars['post_type']) &&
            $q_vars['post_type'] === 'plugins' &&
            !empty($_GET[$taxonomy]) // Ensure we are getting the slug
        ) {
            $term = get_term_by('slug', sanitize_text_field($_GET[$taxonomy]), $taxonomy);

            if ($term && !is_wp_error($term)) {
                $q_vars[$taxonomy] = $term->slug; // Use slug for filtering
            }
        }
    }

    // Modify the query to filter by plugin tags using slug
    public static function pre_get_post_query_plugin_cpt_tag($query)
    {
        global $pagenow;

        if (
            is_admin() &&
            $pagenow === 'edit.php' &&
            isset($_GET['post_type']) && $_GET['post_type'] === 'plugins' &&
            isset($_GET['plugin_tag']) && !empty($_GET['plugin_tag'])
        ) {
            $slug = sanitize_text_field($_GET['plugin_tag']);

            $query->set('tax_query', [
                [
                    'taxonomy' => 'plugin_tag',
                    'field' => 'slug',
                    'terms' => [$slug], // Use slug here
                    'include_children' => false, // Do not include child tags
                ]
            ]);
        }
    }
}

