<?php

get_header();
$term = get_queried_object();

?>

<main>
    <section class="border-b border-[#F2F2F2]">
        <div class="container">
            <div class="space-y-1">
                <div class="flex flex-wrap items-center text-[13px] font-normal leading-[120%] text-[#A1A7B1]">
                    <div>
                        <a href="index.html" class="px-1 py-3 inline-block">
                            <img class="w-6 min-w-6 h-6 object-contain object-center"
                                src="<?php echo asset_image_path_generator() .'category-page/home.svg'?>" alt="Home-image" />
                        </a>
                    </div>
                    <div class="px-1 space-x-3">
                        <span>/</span>
                        <a href="#" class="py-3 inline-block hover:text-black duration-300">Plugin Category</a>
                    </div>
                    <div class="px-1 space-x-3">
                        <span>/</span>
                        <a href="#" class="py-3 inline-block hover:text-black duration-300">E-commerce Tools</a>
                    </div>
                </div>

                <div class="space-y-3">
                    <h1 class="text-3xl md:text-4xl lg:text-[49px] font-bold leading-[120%]">
                        E-commerce Tools
                    </h1>
                    <div class="flex flex-col sm:flex-row items-center space-x-6 lg:space-x-[30px]">
                        <label class="relative w-full">
                            <span class="absolute top-1/2 -translate-y-1/2 left-0 w-5 min-w-5 h-5">
                                <img class="w-full object-contain object-center" src="<?php echo asset_image_path_generator() .'search.svg'?>"
                                    alt="search-image" />
                            </span>
                            <button class="absolute top-1/2 -translate-y-1/2 right-0 w-5 min-w-5 h-5">
                                <img class="w-full object-contain object-center" src="<?php echo asset_image_path_generator() .'close-circle.svg'?>"
                                    alt="close-circle-image" />
                            </button>
                            <input type="text"
                                class="w-full px-8 py-[14.8px] text-base font-normal leading-[160%] border-none placeholder:text-[#A1A7B1]"
                                placeholder="Search plugins" />
                        </label>

                        <div class="w-px self-stretch bg-[#F2F2F2]"></div>

                        <div class="flex items-center space-x-3">
                            <a href="#">
                                <img class="w-5 min-w-5 h-5 object-contain object-center"
                                    src="<?php echo asset_image_path_generator() .'category-page/filter.svg'?>" alt="filter-image" />
                            </a>
                            <div class="space-y-1.5">
                                <span class="text-[10px] font-normal leading-[110%] text-[#727C89]">
                                    Sort by:
                                </span>
                                <select
                                    class="p-0 border-0 outline-none appearance-none bg-transparent cursor-pointer focus:outline-none focus:ring-1 focus:ring-gray-300 text-base font-bold leading-[160%] text-[#000000]">
                                    <option value="relevance">Relevance</option>
                                    <option value="popular">Most Popular</option>
                                    <option value="newest">Newest</option>
                                    <option value="oldest">Oldest</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section>
        <div class="container">
            <div class="py-8 space-y-3">
                <div class="flex justify-between items-center font-bold">
                    <h4 class="w-[206px] sm:w-auto text-lg lg:text-xl leading-[120%] text-black">
                        8+ PMOS Score
                    </h4>
                    <div>
                        <a href=""
                            class="group flex items-center py-[6.3px] px-4 sm:px-6 text-base leading-[160%] text-[#1A2DC9] hover:text-white hover:bg-[#1A2DC9] duration-300 space-x-2.5 border border-[#1B3CD2] rounded-full">
                            <span>View All</span>
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path class="group-hover:fill-white"
                                    d="M10.7814 7.33327L7.20539 3.75726L8.14819 2.81445L13.3337 7.99993L8.14819 13.1853L7.20539 12.2425L10.7814 8.6666H2.66699V7.33327H10.7814Z"
                                    fill="#1A2DC9" />
                            </svg>
                        </a>
                    </div>
                </div>

                <div class="-m-3 lg:-m-4">
                    <div class="flex flex-wrap justify-center items-stretch">
                        <a href="#"
                            class="w-[calc(100%-24px)] sm:w-[calc(50%-24px)] m-3 lg:w-[calc(33.333333%-32px)] lg:m-4 text-black border border-[#F2F2F2] rounded-3xl overflow-hidden flex flex-col justify-between hover:shadow-[0_8px_24px_rgba(149,157,165,0.2)] duration-300 text-[10px] font-bold leading-[120%]">
                            <!-- Top Section -->
                            <div class="flex items-stretch">
                                <div class="flex-1 p-3 xl:p-6 xl:pr-4 flex items-stretch space-x-4">
                                    <div
                                        class="flex justify-center items-center w-14 min-w-14 xl:w-[72px] xl:min-w-[72px]">
                                        <div
                                            class="flex justify-center items-center w-full h-14 xl:h-[72px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-2xl xl:rounded-3xl overflow-hidden">
                                            <img class="w-12 xl:w-[65px] min-w-12 xl:min-w-[65px] h-12 xl:h-[65px] object-contain object-center rounded-2xl xl:rounded-3xl"
                                                src="<?php echo asset_image_path_generator() .'category-page/1.webp'?>" alt="woo-image" />
                                        </div>
                                    </div>

                                    <div class="flex-1 min-h-[108px] w-full space-y-3">
                                        <h2 class="text-base xl:text-xl line-clamp-3">
                                            WooCommerce
                                        </h2>
                                        <p class="font-normal">By Developer name</p>
                                    </div>
                                </div>

                                <div
                                    class="relative w-[82px] min-w-[82px] flex flex-col justify-center text-[#1A2DC9] bg-[#F6F7FD] border-b-[3px] border-[#1A2DC9] p-3">
                                    <div class="absolute top-1.5 right-1.5">
                                        <img class="w-4 min-w-[16px] h-4 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'exclamation.svg'?>" alt="Exclamation-Image" />
                                    </div>
                                    <div class="space-y-1">
                                        <p class="text-[#14243B3D] uppercase">WPS</p>
                                        <p class="text-xl md:text-[25px]">8.5</p>
                                        <p>Exceptional</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Divider Line -->
                            <div class="border-t border-[#F2F2F2] w-full">
                                <div class="flex items-stretch text-[10px] font-normal leading-[120%]">
                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/star.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>4.8/5</strong>
                                            <p>1k+reviews</p>
                                        </div>
                                    </div>

                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/downlot.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>200k+</strong>
                                            <p>active installation</p>
                                        </div>
                                    </div>

                                    <div class="w-full flex-1 basis-auto flex items-center px-3 py-6 space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/w.svg'?>" alt="Star-Image" />
                                        <div>
                                            <p>Tested with</p>
                                            <strong>6.5.5</strong>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>

                        <a href="#"
                            class="w-[calc(100%-24px)] sm:w-[calc(50%-24px)] m-3 lg:w-[calc(33.333333%-32px)] lg:m-4 text-black border border-[#F2F2F2] rounded-3xl overflow-hidden flex flex-col justify-between hover:shadow-[0_8px_24px_rgba(149,157,165,0.2)] duration-300 text-[10px] font-bold leading-[120%]">
                            <!-- Top Section -->
                            <div class="flex items-stretch">
                                <div class="flex-1 p-3 xl:p-6 xl:pr-4 flex items-stretch space-x-4">
                                    <div
                                        class="flex justify-center items-center w-14 min-w-14 xl:w-[72px] xl:min-w-[72px]">
                                        <div
                                            class="flex justify-center items-center w-full h-14 xl:h-[72px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-2xl xl:rounded-3xl overflow-hidden">
                                            <img class="w-12 xl:w-[65px] min-w-12 xl:min-w-[65px] h-12 xl:h-[65px] object-contain object-center rounded-2xl xl:rounded-3xl"
                                                src="<?php echo asset_image_path_generator() .'category-page/2.webp'?>" alt="woo-image" />
                                        </div>
                                    </div>

                                    <div class="flex-1 min-h-[108px] w-full space-y-3">
                                        <h2 class="text-base xl:text-xl line-clamp-3">
                                            Tutor LMS – eLearning and online course solution
                                        </h2>
                                        <p class="font-normal">By Developer name</p>
                                    </div>
                                </div>

                                <div
                                    class="relative w-[82px] min-w-[82px] flex flex-col justify-center text-[#1A2DC9] bg-[#F6F7FD] border-b-[3px] border-[#1A2DC9] p-3">
                                    <div class="absolute top-1.5 right-1.5">
                                        <img class="w-4 min-w-[16px] h-4 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'exclamation.svg'?>" alt="Exclamation-Image" />
                                    </div>
                                    <div class="space-y-1">
                                        <p class="text-[#14243B3D] uppercase">WPS</p>
                                        <p class="text-xl md:text-[25px]">8.5</p>
                                        <p>Exceptional</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Divider Line -->
                            <div class="border-t border-[#F2F2F2] w-full">
                                <div class="flex items-stretch text-[10px] font-normal leading-[120%]">
                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/star.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>4.8/5</strong>
                                            <p>1k+reviews</p>
                                        </div>
                                    </div>

                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/downlot.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>200k+</strong>
                                            <p>active installation</p>
                                        </div>
                                    </div>

                                    <div class="w-full flex-1 basis-auto flex items-center px-3 py-6 space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/w.svg'?>" alt="Star-Image" />
                                        <div>
                                            <p>Tested with</p>
                                            <strong>6.5.5</strong>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>

                        <a href="#"
                            class="w-[calc(100%-24px)] sm:w-[calc(50%-24px)] m-3 lg:w-[calc(33.333333%-32px)] lg:m-4 text-black border border-[#F2F2F2] rounded-3xl overflow-hidden flex flex-col justify-between hover:shadow-[0_8px_24px_rgba(149,157,165,0.2)] duration-300 text-[10px] font-bold leading-[120%]">
                            <!-- Top Section -->
                            <div class="flex items-stretch">
                                <div class="flex-1 p-3 xl:p-6 xl:pr-4 flex items-stretch space-x-4">
                                    <div
                                        class="flex justify-center items-center w-14 min-w-14 xl:w-[72px] xl:min-w-[72px]">
                                        <div
                                            class="flex justify-center items-center w-full h-14 xl:h-[72px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-2xl xl:rounded-3xl overflow-hidden">
                                            <img class="w-12 xl:w-[65px] min-w-12 xl:min-w-[65px] h-12 xl:h-[65px] object-contain object-center rounded-2xl xl:rounded-3xl"
                                                src="<?php echo asset_image_path_generator() .'category-page/3.webp'?>" alt="woo-image" />
                                        </div>
                                    </div>

                                    <div class="flex-1 min-h-[108px] w-full space-y-3">
                                        <h2 class="text-base xl:text-xl line-clamp-3">
                                            DHL eCommerce (Benelux) for WooCommerce
                                        </h2>
                                        <p class="font-normal">By Developer name</p>
                                    </div>
                                </div>

                                <div
                                    class="relative w-[82px] min-w-[82px] flex flex-col justify-center text-[#1A2DC9] bg-[#F6F7FD] border-b-[3px] border-[#1A2DC9] p-3">
                                    <div class="absolute top-1.5 right-1.5">
                                        <img class="w-4 min-w-[16px] h-4 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'exclamation.svg'?>" alt="Exclamation-Image" />
                                    </div>
                                    <div class="space-y-1">
                                        <p class="text-[#14243B3D] uppercase">WPS</p>
                                        <p class="text-xl md:text-[25px]">8.5</p>
                                        <p>Exceptional</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Divider Line -->
                            <div class="border-t border-[#F2F2F2] w-full">
                                <div class="flex items-stretch text-[10px] font-normal leading-[120%]">
                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/star.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>4.8/5</strong>
                                            <p>1k+reviews</p>
                                        </div>
                                    </div>

                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/downlot.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>200k+</strong>
                                            <p>active installation</p>
                                        </div>
                                    </div>

                                    <div class="w-full flex-1 basis-auto flex items-center px-3 py-6 space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/w.svg'?>" alt="Star-Image" />
                                        <div>
                                            <p>Tested with</p>
                                            <strong>6.5.5</strong>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="bg-[#F8F8F8]">
        <div class="container">
            <div class="py-8 space-y-3">
                <div>
                    <a href=""
                        class="group w-auto inline-flex items-center py-1 px-2 text-[10px] font-bold leading-[120%] text-[#14243B] hover:text-[#1A2DC9] hover:border-[#1A2DC9] duration-300 space-x-1 border border-[#000000] rounded-full">
                        <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path class="group-hover:fill-[#1A2DC9]"
                                d="M6 11C3.23857 11 1 8.7614 1 6C1 3.23857 3.23857 1 6 1C8.7614 1 11 3.23857 11 6C11 8.7614 8.7614 11 6 11ZM6 10C8.20915 10 10 8.20915 10 6C10 3.79086 8.20915 2 6 2C3.79086 2 2 3.79086 2 6C2 8.20915 3.79086 10 6 10ZM6.5 5.25V7.5H7V8.5H5V7.5H5.5V6.25H5V5.25H6.5ZM6.75 4C6.75 4.41422 6.4142 4.75 6 4.75C5.5858 4.75 5.25 4.41422 5.25 4C5.25 3.58578 5.5858 3.25 6 3.25C6.4142 3.25 6.75 3.58578 6.75 4Z"
                                fill="black" />
                        </svg>

                        <span>Sponsored</span>
                    </a>
                </div>

                <div class="-m-3 lg:-m-4">
                    <div class="flex flex-wrap justify-center items-stretch">
                        <a href="#"
                            class="w-[calc(100%-24px)] sm:w-[calc(50%-24px)] m-3 lg:w-[calc(33.333333%-32px)] lg:m-4 text-black border border-[#F2F2F2] rounded-3xl overflow-hidden flex flex-col justify-between hover:shadow-[0_8px_24px_rgba(149,157,165,0.2)] duration-300 text-[10px] font-bold leading-[120%]">
                            <!-- Top Section -->
                            <div class="flex items-stretch">
                                <div class="flex-1 p-3 xl:p-6 xl:pr-4 flex items-stretch space-x-4">
                                    <div
                                        class="flex justify-center items-center w-14 min-w-14 xl:w-[72px] xl:min-w-[72px]">
                                        <div
                                            class="flex justify-center items-center w-full h-14 xl:h-[72px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-2xl xl:rounded-3xl overflow-hidden">
                                            <img class="w-12 xl:w-[65px] min-w-12 xl:min-w-[65px] h-12 xl:h-[65px] object-contain object-center rounded-2xl xl:rounded-3xl"
                                                src="<?php echo asset_image_path_generator() .'category-page/2.1.webp'?>" alt="woo-image" />
                                        </div>
                                    </div>

                                    <div class="flex-1 min-h-[108px] w-full space-y-3">
                                        <h2 class="text-base xl:text-xl line-clamp-3">
                                            Cost of Goods: Product Cost & Profit Calculator for
                                            WooCommerce
                                        </h2>
                                        <p class="font-normal">By Developer name</p>
                                    </div>
                                </div>

                                <div
                                    class="relative w-[82px] min-w-[82px] flex flex-col justify-center text-[#1A2DC9] bg-[#F6F7FD] border-b-[3px] border-[#1A2DC9] p-3">
                                    <div class="absolute top-1.5 right-1.5">
                                        <img class="w-4 min-w-[16px] h-4 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'exclamation.svg'?>" alt="Exclamation-Image" />
                                    </div>
                                    <div class="space-y-1">
                                        <p class="text-[#14243B3D] uppercase">WPS</p>
                                        <p class="text-xl md:text-[25px]">8.5</p>
                                        <p>Exceptional</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Divider Line -->
                            <div class="border-t border-[#F2F2F2] w-full">
                                <div class="flex items-stretch text-[10px] font-normal leading-[120%]">
                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/star.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>4.8/5</strong>
                                            <p>1k+reviews</p>
                                        </div>
                                    </div>

                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/downlot.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>200k+</strong>
                                            <p>active installation</p>
                                        </div>
                                    </div>

                                    <div class="w-full flex-1 basis-auto flex items-center px-3 py-6 space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/w.svg'?>" alt="Star-Image" />
                                        <div>
                                            <p>Tested with</p>
                                            <strong>6.5.5</strong>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>

                        <a href="#"
                            class="w-[calc(100%-24px)] sm:w-[calc(50%-24px)] m-3 lg:w-[calc(33.333333%-32px)] lg:m-4 text-black border border-[#F2F2F2] rounded-3xl overflow-hidden flex flex-col justify-between hover:shadow-[0_8px_24px_rgba(149,157,165,0.2)] duration-300 text-[10px] font-bold leading-[120%]">
                            <!-- Top Section -->
                            <div class="flex items-stretch">
                                <div class="flex-1 p-3 xl:p-6 xl:pr-4 flex items-stretch space-x-4">
                                    <div
                                        class="flex justify-center items-center w-14 min-w-14 xl:w-[72px] xl:min-w-[72px]">
                                        <div
                                            class="flex justify-center items-center w-full h-14 xl:h-[72px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-2xl xl:rounded-3xl overflow-hidden">
                                            <img class="w-12 xl:w-[65px] min-w-12 xl:min-w-[65px] h-12 xl:h-[65px] object-contain object-center rounded-2xl xl:rounded-3xl"
                                                src="<?php echo asset_image_path_generator() .'category-page/2.2.webp'?>" alt="woo-image" />
                                        </div>
                                    </div>

                                    <div class="flex-1 min-h-[108px] w-full space-y-3">
                                        <h2 class="text-base xl:text-xl line-clamp-3">
                                            Order Minimum/Maximum Amount Limits for WooCommerce
                                        </h2>
                                        <p class="font-normal">By Developer name</p>
                                    </div>
                                </div>

                                <div
                                    class="relative w-[82px] min-w-[82px] flex flex-col justify-center text-[#1A2DC9] bg-[#F6F7FD] border-b-[3px] border-[#1A2DC9] p-3">
                                    <div class="absolute top-1.5 right-1.5">
                                        <img class="w-4 min-w-[16px] h-4 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'exclamation.svg'?>" alt="Exclamation-Image" />
                                    </div>
                                    <div class="space-y-1">
                                        <p class="text-[#14243B3D] uppercase">WPS</p>
                                        <p class="text-xl md:text-[25px]">8.5</p>
                                        <p>Exceptional</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Divider Line -->
                            <div class="border-t border-[#F2F2F2] w-full">
                                <div class="flex items-stretch text-[10px] font-normal leading-[120%]">
                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/star.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>4.8/5</strong>
                                            <p>1k+reviews</p>
                                        </div>
                                    </div>

                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/downlot.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>200k+</strong>
                                            <p>active installation</p>
                                        </div>
                                    </div>

                                    <div class="w-full flex-1 basis-auto flex items-center px-3 py-6 space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/w.svg'?>" alt="Star-Image" />
                                        <div>
                                            <p>Tested with</p>
                                            <strong>6.5.5</strong>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>

                        <a href="#"
                            class="w-[calc(100%-24px)] sm:w-[calc(50%-24px)] m-3 lg:w-[calc(33.333333%-32px)] lg:m-4 text-black border border-[#F2F2F2] rounded-3xl overflow-hidden flex flex-col justify-between hover:shadow-[0_8px_24px_rgba(149,157,165,0.2)] duration-300 text-[10px] font-bold leading-[120%]">
                            <!-- Top Section -->
                            <div class="flex items-stretch">
                                <div class="flex-1 p-3 xl:p-6 xl:pr-4 flex items-stretch space-x-4">
                                    <div
                                        class="flex justify-center items-center w-14 min-w-14 xl:w-[72px] xl:min-w-[72px]">
                                        <div
                                            class="flex justify-center items-center w-full h-14 xl:h-[72px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-2xl xl:rounded-3xl overflow-hidden">
                                            <img class="w-12 xl:w-[65px] min-w-12 xl:min-w-[65px] h-12 xl:h-[65px] object-contain object-center rounded-2xl xl:rounded-3xl"
                                                src="<?php echo asset_image_path_generator() .'category-page/2.3.webp'?>" alt="woo-image" />
                                        </div>
                                    </div>

                                    <div class="flex-1 min-h-[108px] w-full space-y-3">
                                        <h2 class="text-base xl:text-xl line-clamp-3">
                                            EU/UK VAT Validation Manager for WooCommerce
                                        </h2>
                                        <p class="font-normal">By Developer name</p>
                                    </div>
                                </div>

                                <div
                                    class="relative w-[82px] min-w-[82px] flex flex-col justify-center text-[#1A2DC9] bg-[#F6F7FD] border-b-[3px] border-[#1A2DC9] p-3">
                                    <div class="absolute top-1.5 right-1.5">
                                        <img class="w-4 min-w-[16px] h-4 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'exclamation.svg'?>" alt="Exclamation-Image" />
                                    </div>
                                    <div class="space-y-1">
                                        <p class="text-[#14243B3D] uppercase">WPS</p>
                                        <p class="text-xl md:text-[25px]">8.5</p>
                                        <p>Exceptional</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Divider Line -->
                            <div class="border-t border-[#F2F2F2] w-full">
                                <div class="flex items-stretch text-[10px] font-normal leading-[120%]">
                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/star.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>4.8/5</strong>
                                            <p>1k+reviews</p>
                                        </div>
                                    </div>

                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/downlot.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>200k+</strong>
                                            <p>active installation</p>
                                        </div>
                                    </div>

                                    <div class="w-full flex-1 basis-auto flex items-center px-3 py-6 space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/w.svg'?>" alt="Star-Image" />
                                        <div>
                                            <p>Tested with</p>
                                            <strong>6.5.5</strong>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section>
        <div class="container">
            <div class="py-8 space-y-3">
                <div class="flex justify-between items-center font-bold">
                    <h4 class="w-[206px] sm:w-auto text-lg lg:text-xl leading-[120%] text-black">
                        Over 100k Installations
                    </h4>
                    <div>
                        <a href=""
                            class="group flex items-center py-[6.3px] px-4 sm:px-6 text-base leading-[160%] text-[#1A2DC9] hover:text-white hover:bg-[#1A2DC9] duration-300 space-x-2.5 border border-[#1B3CD2] rounded-full">
                            <span>View All</span>
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path class="group-hover:fill-white"
                                    d="M10.7814 7.33327L7.20539 3.75726L8.14819 2.81445L13.3337 7.99993L8.14819 13.1853L7.20539 12.2425L10.7814 8.6666H2.66699V7.33327H10.7814Z"
                                    fill="#1A2DC9" />
                            </svg>
                        </a>
                    </div>
                </div>

                <div class="-m-3 lg:-m-4">
                    <div class="flex flex-wrap justify-center items-stretch">
                        <a href="#"
                            class="w-[calc(100%-24px)] sm:w-[calc(50%-24px)] m-3 lg:w-[calc(33.333333%-32px)] lg:m-4 text-black border border-[#F2F2F2] rounded-3xl overflow-hidden flex flex-col justify-between hover:shadow-[0_8px_24px_rgba(149,157,165,0.2)] duration-300 text-[10px] font-bold leading-[120%]">
                            <!-- Top Section -->
                            <div class="flex items-stretch">
                                <div class="flex-1 p-3 xl:p-6 xl:pr-4 flex items-stretch space-x-4">
                                    <div
                                        class="flex justify-center items-center w-14 min-w-14 xl:w-[72px] xl:min-w-[72px]">
                                        <div
                                            class="flex justify-center items-center w-full h-14 xl:h-[72px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-2xl xl:rounded-3xl overflow-hidden">
                                            <img class="w-12 xl:w-[65px] min-w-12 xl:min-w-[65px] h-12 xl:h-[65px] object-contain object-center rounded-2xl xl:rounded-3xl"
                                                src="<?php echo asset_image_path_generator() .'category-page/3.1.webp'?>" alt="woo-image" />
                                        </div>
                                    </div>

                                    <div class="flex-1 min-h-[108px] w-full space-y-3">
                                        <h2 class="text-base xl:text-xl line-clamp-3">
                                            Paid Membership Plugin, Ecommerce, User Registration
                                            Form, Login Form, User Profile & Restrict Content –
                                            ProfilePress
                                        </h2>
                                        <p class="font-normal">By Developer name</p>
                                    </div>
                                </div>

                                <div
                                    class="relative w-[82px] min-w-[82px] flex flex-col justify-center text-[#1A2DC9] bg-[#F6F7FD] border-b-[3px] border-[#1A2DC9] p-3">
                                    <div class="absolute top-1.5 right-1.5">
                                        <img class="w-4 min-w-[16px] h-4 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'exclamation.svg'?>" alt="Exclamation-Image" />
                                    </div>
                                    <div class="space-y-1">
                                        <p class="text-[#14243B3D] uppercase">WPS</p>
                                        <p class="text-xl md:text-[25px]">8.5</p>
                                        <p>Exceptional</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Divider Line -->
                            <div class="border-t border-[#F2F2F2] w-full">
                                <div class="flex items-stretch text-[10px] font-normal leading-[120%]">
                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/star.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>4.8/5</strong>
                                            <p>1k+reviews</p>
                                        </div>
                                    </div>

                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/downlot.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>200k+</strong>
                                            <p>active installation</p>
                                        </div>
                                    </div>

                                    <div class="w-full flex-1 basis-auto flex items-center px-3 py-6 space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/w.svg'?>" alt="Star-Image" />
                                        <div>
                                            <p>Tested with</p>
                                            <strong>6.5.5</strong>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>

                        <a href="#"
                            class="w-[calc(100%-24px)] sm:w-[calc(50%-24px)] m-3 lg:w-[calc(33.333333%-32px)] lg:m-4 text-black border border-[#F2F2F2] rounded-3xl overflow-hidden flex flex-col justify-between hover:shadow-[0_8px_24px_rgba(149,157,165,0.2)] duration-300 text-[10px] font-bold leading-[120%]">
                            <!-- Top Section -->
                            <div class="flex items-stretch">
                                <div class="flex-1 p-3 xl:p-6 xl:pr-4 flex items-stretch space-x-4">
                                    <div
                                        class="flex justify-center items-center w-14 min-w-14 xl:w-[72px] xl:min-w-[72px]">
                                        <div
                                            class="flex justify-center items-center w-full h-14 xl:h-[72px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-2xl xl:rounded-3xl overflow-hidden">
                                            <img class="w-12 xl:w-[65px] min-w-12 xl:min-w-[65px] h-12 xl:h-[65px] object-contain object-center rounded-2xl xl:rounded-3xl"
                                                src="<?php echo asset_image_path_generator() .'category-page/3.2.webp'?>" alt="woo-image" />
                                        </div>
                                    </div>

                                    <div class="flex-1 min-h-[108px] w-full space-y-3">
                                        <h2 class="text-base xl:text-xl line-clamp-3">
                                            Mailchimp for WooCommerce
                                        </h2>
                                        <p class="font-normal">By Developer name</p>
                                    </div>
                                </div>

                                <div
                                    class="relative w-[82px] min-w-[82px] flex flex-col justify-center text-[#FBBC05] bg-[#FFFCF5] border-b-[3px] border-[#FBBC05] p-3">
                                    <div class="absolute top-1.5 right-1.5">
                                        <img class="w-4 min-w-[16px] h-4 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'exclamation.svg'?>" alt="Exclamation-Image" />
                                    </div>
                                    <div class="space-y-1">
                                        <p class="text-[#14243B3D] uppercase">WPS</p>
                                        <p class="text-xl md:text-[25px]">8.5</p>
                                        <p>Exceptional</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Divider Line -->
                            <div class="border-t border-[#F2F2F2] w-full">
                                <div class="flex items-stretch text-[10px] font-normal leading-[120%]">
                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/star.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>4.8/5</strong>
                                            <p>1k+reviews</p>
                                        </div>
                                    </div>

                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/downlot.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>200k+</strong>
                                            <p>active installation</p>
                                        </div>
                                    </div>

                                    <div class="w-full flex-1 basis-auto flex items-center px-3 py-6 space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/w.svg'?>" alt="Star-Image" />
                                        <div>
                                            <p>Tested with</p>
                                            <strong>6.5.5</strong>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>

                        <a href="#"
                            class="w-[calc(100%-24px)] sm:w-[calc(50%-24px)] m-3 lg:w-[calc(33.333333%-32px)] lg:m-4 text-black border border-[#F2F2F2] rounded-3xl overflow-hidden flex flex-col justify-between hover:shadow-[0_8px_24px_rgba(149,157,165,0.2)] duration-300 text-[10px] font-bold leading-[120%]">
                            <!-- Top Section -->
                            <div class="flex items-stretch">
                                <div class="flex-1 p-3 xl:p-6 xl:pr-4 flex items-stretch space-x-4">
                                    <div
                                        class="flex justify-center items-center w-14 min-w-14 xl:w-[72px] xl:min-w-[72px]">
                                        <div
                                            class="flex justify-center items-center w-full h-14 xl:h-[72px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-2xl xl:rounded-3xl overflow-hidden">
                                            <img class="w-12 xl:w-[65px] min-w-12 xl:min-w-[65px] h-12 xl:h-[65px] object-contain object-center rounded-2xl xl:rounded-3xl"
                                                src="<?php echo asset_image_path_generator() .'category-page/3.3.webp'?>" alt="woo-image" />
                                        </div>
                                    </div>

                                    <div class="flex-1 min-h-[108px] w-full space-y-3">
                                        <h2 class="text-base xl:text-xl line-clamp-3">
                                            Enhanced Ecommerce Google Analytics for WooCommerce
                                        </h2>
                                        <p class="font-normal">By Developer name</p>
                                    </div>
                                </div>

                                <div
                                    class="relative w-[82px] min-w-[82px] flex flex-col justify-center text-[#1A2DC9] bg-[#F6F7FD] border-b-[3px] border-[#1A2DC9] p-3">
                                    <div class="absolute top-1.5 right-1.5">
                                        <img class="w-4 min-w-[16px] h-4 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'exclamation.svg'?>" alt="Exclamation-Image" />
                                    </div>
                                    <div class="space-y-1">
                                        <p class="text-[#14243B3D] uppercase">WPS</p>
                                        <p class="text-xl md:text-[25px]">8.5</p>
                                        <p>Exceptional</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Divider Line -->
                            <div class="border-t border-[#F2F2F2] w-full">
                                <div class="flex items-stretch text-[10px] font-normal leading-[120%]">
                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/star.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>4.8/5</strong>
                                            <p>1k+reviews</p>
                                        </div>
                                    </div>

                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/downlot.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>200k+</strong>
                                            <p>active installation</p>
                                        </div>
                                    </div>

                                    <div class="w-full flex-1 basis-auto flex items-center px-3 py-6 space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/w.svg'?>" alt="Star-Image" />
                                        <div>
                                            <p>Tested with</p>
                                            <strong>6.5.5</strong>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section>
        <div class="container">
            <div class="py-8 space-y-3">
                <div class="flex justify-between items-center font-bold">
                    <h4 class="w-[206px] sm:w-auto text-lg lg:text-xl leading-[120%] text-black">
                        High Performance Impact
                    </h4>
                    <div>
                        <a href=""
                            class="group inline-flex items-center py-[6.3px] px-4 sm:px-6 text-base leading-[160%] text-[#1A2DC9] hover:text-white hover:bg-[#1A2DC9] duration-300 space-x-2.5 border border-[#1B3CD2] rounded-full">
                            <span>View All</span>
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path class="group-hover:fill-white"
                                    d="M10.7814 7.33327L7.20539 3.75726L8.14819 2.81445L13.3337 7.99993L8.14819 13.1853L7.20539 12.2425L10.7814 8.6666H2.66699V7.33327H10.7814Z"
                                    fill="#1A2DC9" />
                            </svg>
                        </a>
                    </div>
                </div>

                <div class="-m-3 lg:-m-4">
                    <div class="flex flex-wrap justify-center items-stretch">
                        <a href="#"
                            class="w-[calc(100%-24px)] sm:w-[calc(50%-24px)] m-3 lg:w-[calc(33.333333%-32px)] lg:m-4 text-black border border-[#F2F2F2] rounded-3xl overflow-hidden flex flex-col justify-between hover:shadow-[0_8px_24px_rgba(149,157,165,0.2)] duration-300 text-[10px] font-bold leading-[120%]">
                            <!-- Top Section -->
                            <div class="flex items-stretch">
                                <div class="flex-1 p-3 xl:p-6 xl:pr-4 flex items-stretch space-x-4">
                                    <div
                                        class="flex justify-center items-center w-14 min-w-14 xl:w-[72px] xl:min-w-[72px]">
                                        <div
                                            class="flex justify-center items-center w-full h-14 xl:h-[72px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-2xl xl:rounded-3xl overflow-hidden">
                                            <img class="w-12 xl:w-[65px] min-w-12 xl:min-w-[65px] h-12 xl:h-[65px] object-contain object-center rounded-2xl xl:rounded-3xl"
                                                src="<?php echo asset_image_path_generator() .'category-page/3.2.webp'?>" alt="woo-image" />
                                        </div>
                                    </div>

                                    <div class="flex-1 min-h-[108px] w-full space-y-3">
                                        <h2 class="text-base xl:text-xl line-clamp-3">
                                            Mailchimp for WooCommerce
                                        </h2>
                                        <p class="font-normal">By Developer name</p>
                                    </div>
                                </div>

                                <div
                                    class="relative w-[82px] min-w-[82px] flex flex-col justify-center text-[#FBBC05] bg-[#FFFCF5] border-b-[3px] border-[#FBBC05] p-3">
                                    <div class="absolute top-1.5 right-1.5">
                                        <img class="w-4 min-w-[16px] h-4 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'exclamation.svg'?>" alt="Exclamation-Image" />
                                    </div>
                                    <div class="space-y-1">
                                        <p class="text-[#14243B3D] uppercase">WPS</p>
                                        <p class="text-xl md:text-[25px]">8.5</p>
                                        <p>Exceptional</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Divider Line -->
                            <div class="border-t border-[#F2F2F2] w-full">
                                <div class="flex items-stretch text-[10px] font-normal leading-[120%]">
                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/star.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>4.8/5</strong>
                                            <p>1k+reviews</p>
                                        </div>
                                    </div>

                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/downlot.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>200k+</strong>
                                            <p>active installation</p>
                                        </div>
                                    </div>

                                    <div class="w-full flex-1 basis-auto flex items-center px-3 py-6 space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/w.svg'?>" alt="Star-Image" />
                                        <div>
                                            <p>Tested with</p>
                                            <strong>6.5.5</strong>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>

                        <a href="#"
                            class="w-[calc(100%-24px)] sm:w-[calc(50%-24px)] m-3 lg:w-[calc(33.333333%-32px)] lg:m-4 text-black border border-[#F2F2F2] rounded-3xl overflow-hidden flex flex-col justify-between hover:shadow-[0_8px_24px_rgba(149,157,165,0.2)] duration-300 text-[10px] font-bold leading-[120%]">
                            <!-- Top Section -->
                            <div class="flex items-stretch">
                                <div class="flex-1 p-3 xl:p-6 xl:pr-4 flex items-stretch space-x-4">
                                    <div
                                        class="flex justify-center items-center w-14 min-w-14 xl:w-[72px] xl:min-w-[72px]">
                                        <div
                                            class="flex justify-center items-center w-full h-14 xl:h-[72px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-2xl xl:rounded-3xl overflow-hidden">
                                            <img class="w-12 xl:w-[65px] min-w-12 xl:min-w-[65px] h-12 xl:h-[65px] object-contain object-center rounded-2xl xl:rounded-3xl"
                                                src="<?php echo asset_image_path_generator() .'category-page/3.3.webp'?>" alt="woo-image" />
                                        </div>
                                    </div>

                                    <div class="flex-1 min-h-[108px] w-full space-y-3">
                                        <h2 class="text-base xl:text-xl line-clamp-3">
                                            Enhanced Ecommerce Google Analytics for WooCommerce
                                        </h2>
                                        <p class="font-normal">By Developer name</p>
                                    </div>
                                </div>

                                <div
                                    class="relative w-[82px] min-w-[82px] flex flex-col justify-center text-[#1A2DC9] bg-[#F6F7FD] border-b-[3px] border-[#1A2DC9] p-3">
                                    <div class="absolute top-1.5 right-1.5">
                                        <img class="w-4 min-w-[16px] h-4 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'exclamation.svg'?>" alt="Exclamation-Image" />
                                    </div>
                                    <div class="space-y-1">
                                        <p class="text-[#14243B3D] uppercase">WPS</p>
                                        <p class="text-xl md:text-[25px]">8.5</p>
                                        <p>Exceptional</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Divider Line -->
                            <div class="border-t border-[#F2F2F2] w-full">
                                <div class="flex items-stretch text-[10px] font-normal leading-[120%]">
                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/star.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>4.8/5</strong>
                                            <p>1k+reviews</p>
                                        </div>
                                    </div>

                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/downlot.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>200k+</strong>
                                            <p>active installation</p>
                                        </div>
                                    </div>

                                    <div class="w-full flex-1 basis-auto flex items-center px-3 py-6 space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/w.svg'?>" alt="Star-Image" />
                                        <div>
                                            <p>Tested with</p>
                                            <strong>6.5.5</strong>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>

                        <a href="#"
                            class="w-[calc(100%-24px)] sm:w-[calc(50%-24px)] m-3 lg:w-[calc(33.333333%-32px)] lg:m-4 text-black border border-[#F2F2F2] rounded-3xl overflow-hidden flex flex-col justify-between hover:shadow-[0_8px_24px_rgba(149,157,165,0.2)] duration-300 text-[10px] font-bold leading-[120%]">
                            <!-- Top Section -->
                            <div class="flex items-stretch">
                                <div class="flex-1 p-3 xl:p-6 xl:pr-4 flex items-stretch space-x-4">
                                    <div
                                        class="flex justify-center items-center w-14 min-w-14 xl:w-[72px] xl:min-w-[72px]">
                                        <div
                                            class="flex justify-center items-center w-full h-14 xl:h-[72px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-2xl xl:rounded-3xl overflow-hidden">
                                            <img class="w-12 xl:w-[65px] min-w-12 xl:min-w-[65px] h-12 xl:h-[65px] object-contain object-center rounded-2xl xl:rounded-3xl"
                                                src="<?php echo asset_image_path_generator() .'category-page/3.1.webp'?>" alt="woo-image" />
                                        </div>
                                    </div>

                                    <div class="flex-1 min-h-[108px] w-full space-y-3">
                                        <h2 class="text-base xl:text-xl line-clamp-3">
                                            Paid Membership Plugin, Ecommerce, User Registration
                                            Form, Login Form, User Profile & Restrict Content –
                                            ProfilePress
                                        </h2>
                                        <p class="font-normal">By Developer name</p>
                                    </div>
                                </div>

                                <div
                                    class="relative w-[82px] min-w-[82px] flex flex-col justify-center text-[#1A2DC9] bg-[#F6F7FD] border-b-[3px] border-[#1A2DC9] p-3">
                                    <div class="absolute top-1.5 right-1.5">
                                        <img class="w-4 min-w-[16px] h-4 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'exclamation.svg'?>" alt="Exclamation-Image" />
                                    </div>
                                    <div class="space-y-1">
                                        <p class="text-[#14243B3D] uppercase">WPS</p>
                                        <p class="text-xl md:text-[25px]">8.5</p>
                                        <p>Exceptional</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Divider Line -->
                            <div class="border-t border-[#F2F2F2] w-full">
                                <div class="flex items-stretch text-[10px] font-normal leading-[120%]">
                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/star.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>4.8/5</strong>
                                            <p>1k+reviews</p>
                                        </div>
                                    </div>

                                    <div
                                        class="w-full flex-1 basis-auto flex items-center px-3 py-6 border-r border-[#F2F2F2] space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/downlot.svg'?>" alt="Star-Image" />
                                        <div>
                                            <strong>200k+</strong>
                                            <p>active installation</p>
                                        </div>
                                    </div>

                                    <div class="w-full flex-1 basis-auto flex items-center px-3 py-6 space-x-3">
                                        <img class="w-5 min-w-5 h-5 object-contain object-center"
                                            src="<?php echo asset_image_path_generator() .'bannerSlider/w.svg'?>" alt="Star-Image" />
                                        <div>
                                            <p>Tested with</p>
                                            <strong>6.5.5</strong>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>

<?php get_footer(); ?>