import { PackageJson } from 'type-fest';
export interface IsInAlphabeticalOrderResult {
    status: boolean;
    data: {
        invalidNode: string | null;
        validNode: string | null;
    };
}
/**
 * Determines whether an array is in alphabetical order
 *
 * @param packageJsonData Valid JSON
 * @param nodeName Name of a node in the package.json file
 * @return Object containing the status and the dependencies that are out of order, if applicable
 */
export declare const isInAlphabeticalOrder: (packageJsonData: PackageJson | any, nodeName: string) => IsInAlphabeticalOrderResult;
