(function() {
  var Timer;

  exports.Timer = Timer = (function() {
    function Timer(func1) {
      this.func = func1;
      this.running = false;
      this.id = null;
      this._handler = (function(_this) {
        return function() {
          _this.running = false;
          _this.id = null;
          return _this.func();
        };
      })(this);
    }

    Timer.prototype.start = function(timeout) {
      if (this.running) {
        clearTimeout(this.id);
      }
      this.id = setTimeout(this._handler, timeout);
      return this.running = true;
    };

    Timer.prototype.stop = function() {
      if (this.running) {
        clearTimeout(this.id);
        this.running = false;
        return this.id = null;
      }
    };

    return Timer;

  })();

  Timer.start = function(timeout, func) {
    return setTimeout(func, timeout);
  };

}).call(this);
