"use strict";

exports.__esModule = true;
exports.default = void 0;

var _utils = require("../utils");

var _options = require("../options");

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

async function toMatchElement(instance, selector, _ref = {}) {
  let {
    text: searchExpr,
    visible = false
  } = _ref,
      options = _objectWithoutPropertiesLoose(_ref, ["text", "visible"]);

  options = (0, _options.defaultOptions)(options);
  const {
    page,
    handle
  } = await (0, _utils.getContext)(instance, () => document);
  const {
    text,
    regexp
  } = (0, _utils.expandSearchExpr)(searchExpr);

  const getElement = (handle, selector, text, regexp, visible) => {
    function hasVisibleBoundingBox(element) {
      const rect = element.getBoundingClientRect();
      return !!(rect.top || rect.bottom || rect.width || rect.height);
    }

    const isVisible = element => {
      if (visible) {
        const style = window.getComputedStyle(element);
        return style && style.visibility !== 'hidden' && hasVisibleBoundingBox(element);
      }

      return true;
    };

    const elements = [...handle.querySelectorAll(selector)].filter(isVisible);

    if (regexp !== null) {
      const [, pattern, flags] = regexp.match(/\/(.*)\/(.*)?/);
      return elements.find(({
        textContent
      }) => textContent.replace(/\s+/g, ' ').trim().match(new RegExp(pattern, flags)));
    }

    if (text !== null) {
      return elements.find(({
        textContent
      }) => textContent.replace(/\s+/g, ' ').trim().includes(text));
    }

    return elements[0];
  };

  try {
    await page.waitForFunction(getElement, options, handle, selector, text, regexp, visible);
  } catch (error) {
    throw (0, _utils.enhanceError)(error, `Element ${selector}${text !== null || regexp !== null ? ` (text: "${text || regexp}") ` : ' '}not found`);
  }

  const jsHandle = await page.evaluateHandle(getElement, handle, selector, text, regexp, visible);
  return jsHandle.asElement();
}

var _default = toMatchElement;
exports.default = _default;