<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package wpsearch
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="profile" href="https://gmpg.org/xfn/11">

  <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
  <?php wp_body_open(); ?>
  <header class="sticky top-0 z-40 bg-white backdrop-blur">
    <div class="container">
      <div class="flex items-center justify-between py-4 lg:py-0">
        <!-- Logo -->
        <div class="lg:mr-[52px]">
          <a href="index.html" class="">
            <img class="w-[192px] lg:max-w-[226.99px] object-cover object-center"
              src="<?php echo asset_image_path_generator() . 'logo.webp' ?>" alt="Logo Images" />
          </a>
        </div>

        <!-- Menu -->
        <div
          class="w-[100%] hidden lg:flex justify-between items-center text-base text-[var(--theme-color)] font-bold leading-[160%]">
          <div class="flex">
            <a href="#" class="px-4 py-[30px] hover:opacity-65 duration-500">
              Discover
            </a>

            <!-- Plugin Category Menu -->
            <div class="relative group">
              <a href="#" class="flex items-center space-x-1 px-4 py-[30px] hover:opacity-65 duration-500">
                <span>Plugin Category</span>
                <div class="px-[7.76px] py-[9px]">
                  <img class="w-[8.49px] h-[5.66px]" src="<?php echo asset_image_path_generator() . 'angleDown.svg' ?>"
                    alt="" />
                </div>
              </a>

              <!-- Mega Menu -->
              <div
                class="absolute left-0 top-full p-4 w-[300px] bg-white shadow-lg opacity-0 invisible group-hover:opacity-100 group-hover:visible rounded-md transition-all duration-300 z-50">
                <div>
                  <div class="flex flex-col space-y-2 text-sm font-normal">
                    <a href="page-category.html" class="hover:opacity-65 duration-500">
                      Category
                    </a>
                    <a href="single-plugin.html" class="hover:opacity-65 duration-500">
                      single-plugin
                    </a>
                  </div>
                </div>
              </div>

            </div>
          </div>

          <div>
            <a href="#" class="px-4 py-[30px] hover:opacity-65 duration-500">
              FAQs
            </a>
            <a href="#" class="px-4 py-[30px] hover:opacity-65 duration-500">
              About
            </a>
          </div>
        </div>

        <!-- Sign In + Mobile Menu -->
        <div class="flex items-center space-x-1 ml-6">
          <a href=""
            class="px-5 lg:px-6 py-2 lg:py-[14px] text-white bg-blue-700 inline-block rounded-[54px] bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] hover:opacity-80 duration-500 whitespace-nowrap">
            Sign in
          </a>
          <button id="mobileMenuBtn" class="lg:hidden w-8 h-8 outline-none">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640">
              <path
                d="M96 160C96 142.3 110.3 128 128 128L512 128C529.7 128 544 142.3 544 160C544 177.7 529.7 192 512 192L128 192C110.3 192 96 177.7 96 160zM96 320C96 302.3 110.3 288 128 288L512 288C529.7 288 544 302.3 544 320C544 337.7 529.7 352 512 352L128 352C110.3 352 96 337.7 96 320zM544 480C544 497.7 529.7 512 512 512L128 512C110.3 512 96 497.7 96 480C96 462.3 110.3 448 128 448L512 448C529.7 448 544 462.3 544 480z" />
            </svg>
          </button>
        </div>
      </div>
    </div>
  </header>

  <!-- Start: Mobile menu -->
  <div>
    <!-- Sidebar -->
    <div id="mobileSidebar"
      class="fixed top-0 right-0 w-[80%] sm:w-[60%] h-full bg-white shadow-lg z-[60] translate-x-full transition-transform duration-500 overflow-y-auto">
      <div class="flex justify-between items-center p-4 border-b border-gray-200">
        <a href="index.html">
          <div class="w-48">
            <img src="<?php echo asset_image_path_generator() . 'logo.webp' ?>" alt="Logo Image" />
          </div>
        </a>
        <button id="closeSidebar" class="text-gray-600 hover:text-black text-2xl">
          &times;
        </button>
      </div>

      <div class="flex flex-col p-4 space-y-4">
        <a href="#" class="hover:opacity-65 duration-500">Discover</a>

        <!-- Plugin Category with submenu -->
        <div class="">
          <button class="w-full flex justify-between items-center hover:opacity-65 duration-500" data-toggle="submenu">
            <span>Plugin Category</span>
            <svg class="w-4 h-4 transition-transform duration-300" fill="none" stroke="currentColor" stroke-width="2"
              viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7" />
            </svg>
          </button>

          <!-- Submenu -->
          <div class="submenu hidden pl-4 py-2 flex flex-col space-y-2 text-gray-600 text-sm">
            <a href="page-category.html" class="hover:opacity-65 duration-500">
              Category
            </a>
            <a href="single-plugin.html" class="hover:opacity-65 duration-500">
              single-plugin
            </a>
          </div>

        </div>

        <a href="#" class="hover:opacity-65 duration-500">FAQs</a>
        <a href="#" class="hover:opacity-65 duration-500">About</a>
      </div>
    </div>

    <!-- Overlay -->
    <div id="overlay" class="fixed inset-0 bg-black/50 z-50 hidden opacity-0 transition-opacity duration-500"></div>
  </div>
  <!-- End: Mobile menu -->