<?php
/*
Template Name:Customized Home Page
 */
get_header();
?>

<main>
    <section
        class="relative pt-16 md:pt-20 lg:pt-0 pb-[186px] w-full h-full bg-gradient-to-t from-[#A4E4FF] to-[#ffffff]">
        <div
            class="z-20 absolute -bottom-[0.4px] left-0 w-full h-[300px] bg-white [clip-path:polygon(0_100%,100%_1.5%,100%_100%,0_100%)]">
        </div>
        <div class="container">
            <div class="sectionWidth">
                <div class="relative">
                    <!--  Start: Find the best -->
                    <div
                        class="absolute left-0 lg:left-1/2 lg:-translate-x-1/2 bottom-[-28.3%] lg:-bottom-[42%] z-20 w-full lg:w-[993px] mx-auto">
                        <div
                            class="py-8 px-5 sm:px-9 lg:px-[60px] text-[var(--theme-color)] bg-[var(--theme-white)] shadow-[0_12px_24px_0_#1C39D21F] rounded-xl space-y-8">
                            <div class="relative max-w-[560px] mx-auto">
                                <div class="absolute bottom-[10px] sm:bottom-[14px] right-4 sm:right-[77px]">
                                    <img class="w-4 h-4"
                                        src="<?php echo asset_image_path_generator() . 'Vector.webp' ?>" alt="Vector" />
                                </div>
                                <h2 class="text-xl md:text-[22px] lg:text-[25px] text-center font-bold leading-[120%]">
                                    Find the best WordPress plugins tailored to your needs
                                    with the power of AI.
                                </h2>
                            </div>

                            <div class="space-y-3">
                                <!-- Search Bar -->
                                <div
                                    class="flex justify-between space-x-3 py-2 lg:py-[15px] px-4 md:px-6 bg-[#F8F8F8] rounded-[24px] border border-[#EEEEEE]">
                                    <!-- Left: Search Icon + Input -->
                                    <div class="flex items-center w-full">
                                        <img src="<?php echo asset_image_path_generator() . 'search.svg' ?>"
                                            alt="Search Icon" class="w-5 h-5 opacity-100" />
                                        <input for="searchInput" type="text" placeholder="Search wordpress plugins"
                                            class="text-base bg-transparent outline-none border-none placeholder-black/25 text-black w-full" />
                                    </div>

                                    <!-- Right: Filter Icon -->
                                    <button>
                                        <img src="<?php echo asset_image_path_generator() . 'filter.svg' ?>"
                                            alt="Filter Icon"
                                            class="w-5 h-5 outline-none cursor-pointer opacity-100 hover:opacity-70 transition-opacity duration-300" />
                                    </button>
                                </div>

                                <div
                                    class="flex lg:flex-row flex-col lg:items-center space-y-3 lg:space-y-0 lg:space-x-3 text-[13px] font-bold leading-[120%]">
                                    <span class="text-[var(--theme-color)] font-normal">
                                        Suggestions:
                                    </span>
                                    <div class="flex flex-wrap gap-2 font-bold text-[var(--theme-color)]">
                                        <a href="#"
                                            class="p-[1px] group bg-[var(--theme-white)] hover:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden rounded-full">
                                            <span
                                                class="flex items-center pl-3 pr-3 hover:pr-[6px] py-1 min-h-[36px] bg-[var(--theme-white)] rounded-full duration-300">
                                                Improve website speed
                                                <span
                                                    class="h-6 w-6 min-w-6 flex items-center justify-center -ml-7 group-hover:ml-2 opacity-0 group-hover:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                                    <img src="<?php echo asset_image_path_generator() . 'angleUp.svg' ?>"
                                                        alt="icon"
                                                        class="w-[10.67px] min-w-[10.67px] h-[10.37px] min-h-[10.37px] object-contain object-center" />
                                                </span>
                                            </span>
                                        </a>
                                        <a href="#"
                                            class="p-[1px] group bg-[var(--theme-white)] hover:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden rounded-full">
                                            <span
                                                class="flex items-center pl-3 pr-3 hover:pr-[6px] py-1 min-h-[36px] bg-[var(--theme-white)] rounded-full duration-300">
                                                Best SEO tools
                                                <span
                                                    class="h-6 w-6 min-w-6 flex items-center justify-center -ml-7 group-hover:ml-2 opacity-0 group-hover:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                                    <img src="<?php echo asset_image_path_generator() . 'angleUp.svg' ?>"
                                                        alt="icon"
                                                        class="w-[10.67px] min-w-[10.67px] h-[10.37px] min-h-[10.37px] object-contain object-center" />
                                                </span>
                                            </span>
                                        </a>
                                        <a href="#"
                                            class="p-[1px] group bg-[var(--theme-white)] hover:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden rounded-full">
                                            <span
                                                class="flex items-center pl-3 pr-3 hover:pr-[6px] py-1 min-h-[36px] bg-[var(--theme-white)] rounded-full duration-300">
                                                Multilingual site plugins
                                                <span
                                                    class="h-6 w-6 min-w-6 flex items-center justify-center -ml-7 group-hover:ml-2 opacity-0 group-hover:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                                    <img src="<?php echo asset_image_path_generator() . 'angleUp.svg' ?>"
                                                        alt="icon"
                                                        class="w-[10.67px] min-w-[10.67px] h-[10.37px] min-h-[10.37px] object-contain object-center" />
                                                </span>
                                            </span>
                                        </a>
                                        <a href="#"
                                            class="p-[1px] group bg-[var(--theme-white)] hover:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden rounded-full">
                                            <span
                                                class="flex items-center pl-3 pr-3 hover:pr-[6px] py-1 min-h-[36px] bg-[var(--theme-white)] rounded-full duration-300">
                                                Security plugins
                                                <span
                                                    class="h-6 w-6 min-w-6 flex items-center justify-center -ml-7 group-hover:ml-2 opacity-0 group-hover:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                                    <img src="<?php echo asset_image_path_generator() . 'angleUp.svg' ?>"
                                                        alt="icon"
                                                        class="w-[10.67px] min-w-[10.67px] h-[10.37px] min-h-[10.37px] object-contain object-center" />
                                                </span>
                                            </span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--  End: Find the best -->
                    <div
                        class="flex lg:flex-row flex-col justify-between items-center space-y-8 lg:space-y-0 lg:space-x-10 xl:space-x-14">
                        <!-- left side banner -->
                        <div
                            class="w-full lg:w-[584px] text-center lg:text-start text-base text-[var(--theme-color)] space-y-5 md:space-y-6 lg:space-y-8">
                            <div class="relative">
                                <div class="absolute -top-14 left-[46.7%]">
                                    <img class="w-11 lg:min-w-[54px] h-11 lg:min-h-[54px]"
                                        src="<?php echo asset_image_path_generator() . '1-after.svg' ?>" alt="" />
                                </div>
                                <div class="absolute top-[33%] right-0 xl:right-24">
                                    <img class="w-8 lg:min-w-[42px] h-8 lg:min-h-[42px]"
                                        src="<?php echo asset_image_path_generator() . '2-after.svg' ?>" alt="" />
                                </div>
                                <h1 class="text-4xl md:text-5xl lg:text-[61px] font-bold leading-[120%]">
                                    Discover the perfect plugin instantly.
                                </h1>
                            </div>
                            <p class="font-normal leading-[160%]">
                                Find the best WordPress plugins tailored to your needs with
                                the power of AI.
                            </p>
                            <h4 class="font-bold leading-[160%]">
                                Which best describes your website?
                            </h4>

                            <div
                                class="flex justify-center lg:justify-start flex-wrap gap-1 font-semibold text-[var(--theme-color)]">
                                <a href="#"
                                    class="p-[1px] group rounded-full bg-[var(--theme-white)] hover:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden inline-block">
                                    <span
                                        class="flex items-center pl-8 pr-8 hover:pr-2 py-1 min-h-[48px] bg-[var(--theme-white)] rounded-full duration-300">
                                        E-Commerce
                                        <span
                                            class="h-8 w-8 min-w-8 flex items-center justify-center -ml-8 group-hover:ml-2 opacity-0 group-hover:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                            <img src="<?php echo asset_image_path_generator() . 'angleUp.svg' ?>"
                                                alt="icon" class="w-[10.67px] h-[10.37px] object-contain" />
                                        </span>
                                    </span>
                                </a>

                                <a href="#"
                                    class="p-[1px] group rounded-full bg-[var(--theme-white)] hover:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden inline-block">
                                    <span
                                        class="flex items-center pl-8 pr-8 hover:pr-2 py-1 min-h-[48px] bg-[var(--theme-white)] rounded-full duration-300">
                                        Blog
                                        <span
                                            class="h-8 w-8 min-w-8 flex items-center justify-center -ml-8 group-hover:ml-2 opacity-0 group-hover:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                            <img src="<?php echo asset_image_path_generator() . 'angleUp.svg' ?>"
                                                alt="icon" class="w-[10.67px] h-[10.37px] object-contain" />
                                        </span>
                                    </span>
                                </a>

                                <a href="#"
                                    class="p-[1px] group rounded-full bg-[var(--theme-white)] hover:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden inline-block">
                                    <span
                                        class="flex items-center pl-8 pr-8 hover:pr-2 py-1 min-h-[48px] bg-[var(--theme-white)] rounded-full duration-300">
                                        Portfolio
                                        <span
                                            class="h-8 w-8 min-w-8 flex items-center justify-center -ml-8 group-hover:ml-2 opacity-0 group-hover:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                            <img src="<?php echo asset_image_path_generator() . 'angleUp.svg' ?>"
                                                alt="icon" class="w-[10.67px] h-[10.37px] object-contain" />
                                        </span>
                                    </span>
                                </a>

                                <a href="#"
                                    class="p-[1px] group rounded-full bg-[var(--theme-white)] hover:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden inline-block">
                                    <span
                                        class="flex items-center pl-8 pr-8 hover:pr-2 py-1 min-h-[48px] bg-[var(--theme-white)] rounded-full duration-300">
                                        Business
                                        <span
                                            class="h-8 w-8 min-w-8 flex items-center justify-center -ml-8 group-hover:ml-2 opacity-0 group-hover:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                            <img src="<?php echo asset_image_path_generator() . 'angleUp.svg' ?>"
                                                alt="icon" class="w-[10.67px] h-[10.37px] object-contain" />
                                        </span>
                                    </span>
                                </a>

                                <a href="#"
                                    class="p-[1px] group rounded-full bg-[var(--theme-white)] hover:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden inline-block">
                                    <span
                                        class="flex items-center pl-8 pr-8 hover:pr-2 py-1 min-h-[48px] bg-[var(--theme-white)] rounded-full duration-300">
                                        Forum
                                        <span
                                            class="h-8 w-8 min-w-8 flex items-center justify-center -ml-8 group-hover:ml-2 opacity-0 group-hover:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                            <img src="<?php echo asset_image_path_generator() . 'angleUp.svg' ?>"
                                                alt="icon" class="w-[10.67px] h-[10.37px] object-contain" />
                                        </span>
                                    </span>
                                </a>

                                <a href="#"
                                    class="p-[1px] group rounded-full bg-[var(--theme-white)] hover:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden inline-block">
                                    <span
                                        class="flex items-center pl-8 pr-8 hover:pr-2 py-1 min-h-[48px] bg-[var(--theme-white)] rounded-full duration-300">
                                        Educational
                                        <span
                                            class="h-8 w-8 min-w-8 flex items-center justify-center -ml-8 group-hover:ml-2 opacity-0 group-hover:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                            <img src="<?php echo asset_image_path_generator() . 'angleUp.svg' ?>"
                                                alt="icon" class="w-[10.67px] h-[10.37px] object-contain" />
                                        </span>
                                    </span>
                                </a>

                                <a href="#"
                                    class="p-[1px] group rounded-full bg-[var(--theme-white)] hover:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden inline-block">
                                    <span
                                        class="flex items-center pl-8 pr-8 hover:pr-2 py-1 min-h-[48px] bg-[var(--theme-white)] rounded-full duration-300">
                                        Entertainment
                                        <span
                                            class="h-8 w-8 min-w-8 flex items-center justify-center -ml-8 group-hover:ml-2 opacity-0 group-hover:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                            <img src="<?php echo asset_image_path_generator() . 'angleUp.svg' ?>"
                                                alt="icon" class="w-[10.67px] h-[10.37px] object-contain" />
                                        </span>
                                    </span>
                                </a>

                                <a href="#"
                                    class="p-[1px] group rounded-full bg-[var(--theme-white)] hover:bg-gradient-to-r from-[#1C37D1] to-[#0E1C6B] overflow-hidden inline-block">
                                    <span
                                        class="flex items-center pl-8 pr-8 hover:pr-2 py-1 min-h-[48px] bg-[var(--theme-white)] rounded-full duration-300">
                                        Other
                                        <span
                                            class="h-8 w-8 min-w-8 flex items-center justify-center -ml-8 group-hover:ml-2 opacity-0 group-hover:opacity-100 duration-300 bg-[var(--theme-color)] rounded-full">
                                            <img src="<?php echo asset_image_path_generator() . 'angleUp.svg' ?>"
                                                alt="icon" class="w-[10.67px] h-[10.37px] object-contain" />
                                        </span>
                                    </span>
                                </a>
                            </div>
                        </div>

                        <!-- right side banner -->
                        <div
                            class="w-full lg:w-[560px] text-[10px] text-[#14243B] font-plusJakarta font-bold leading-[100%]">
                            <div class="">
                                <div class="relative h-[620px] overflow-hidden">
                                    <div
                                        class="absolute -top-[0.5px] left-0 w-full h-[140px] z-10 bg-gradient-to-b from-white via-white/90 to-white/0">
                                    </div>
                                    <div
                                        class="absolute -bottom-[0.5px] left-0 w-full h-[140px] z-10 bg-gradient-to-t from-[#C8EFFF] via-[#C8EFFF]/90 to-[#C8EFFF]/0">
                                    </div>
                                    <div class="flex flex-col sm:flex-row space-x-5">
                                        <div class="groupHoverStop">
                                            <div class="animate-vertical-loop space-y-5">
                                                <div>
                                                    <a href="">
                                                        <div
                                                            class="px-3 pt-3 pb-7 bg-[var(--theme-white)] rounded-xl space-y-8">
                                                            <div class="p-3 space-y-2">
                                                                <div class="flex justify-between items-center">
                                                                    <h5 class="text-[#14243B3D] tracking-[1.5px]">
                                                                        PMOS
                                                                    </h5>
                                                                    <img class="w-4 h-4"
                                                                        src="<?php echo asset_image_path_generator() . 'exclamation.svg' ?>"
                                                                        alt="Exclamation-Image" />
                                                                </div>
                                                                <div class="flex items-center space-x-[3px]">
                                                                    <span class="text-2xl text-[#1A2DC9]">8.5</span>
                                                                    <p>Highly recommended</p>
                                                                </div>
                                                                <div class="h-[3px] bg-[#1A2DC95C]">
                                                                    <div class="h-[3px] bg-[#1A2DC9] w-[45.95%]"></div>
                                                                </div>
                                                            </div>

                                                            <div class="flex items-center space-x-3">
                                                                <div
                                                                    class="min-w-[72px] min-h-[72px] flex justify-center items-center bg-[linear-gradient(180deg,#F2F2F2_0%,rgba(2,170,242,0.24)_100%)]">
                                                                    <img class="w-[65.45px] h-[65.45px]"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/1.webp' ?>"
                                                                        alt="Image" />
                                                                </div>
                                                                <div class="space-y-2">
                                                                    <h2 class="text-sm line-clamp-2">
                                                                        Fonts Plugin | Use Google Fonts, Adobe
                                                                        Fonts or Upload Fonts
                                                                    </h2>
                                                                    <div class="flex items-center space-x-[10px]">
                                                                        <div class="p-[6px] bg-[#E3E5E7] rounded-full">
                                                                            <img class="min-w-3 min-h-3"
                                                                                src="<?php echo asset_image_path_generator() . 'bannerSlider/user.svg' ?>"
                                                                                alt="User-Image" />
                                                                        </div>
                                                                        <p>
                                                                            <span class="font-normal">By</span>
                                                                            Developer name
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <p class="text-sm font-normal text-[#A1A7B1]">
                                                                The easiest to customize fonts in WordPress.
                                                                Optimized for Speed. 1000+ font choices.
                                                                Supports Google Fonts, Adobe Fonts and
                                                                Upload Fonts.
                                                            </p>

                                                            <div class="flex justify-between">
                                                                <div
                                                                    class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2 border-r border-[#EEEEEE]">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/star.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        4.8/5
                                                                        <span class="font-normal">1k+reviews</span>
                                                                    </p>
                                                                </div>
                                                                <div
                                                                    class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2 border-r border-[#EEEEEE]">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/downlot.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        200k+
                                                                        <span class="font-normal">active
                                                                            installations</span>
                                                                    </p>
                                                                </div>
                                                                <div class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/w.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        <span class="font-normal">Tested with</span>
                                                                        6.5.5
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>

                                                <div>
                                                    <a href="">
                                                        <div
                                                            class="px-3 pt-3 pb-7 bg-[var(--theme-white)] rounded-xl space-y-8">
                                                            <div class="p-3 space-y-2">
                                                                <div class="flex justify-between items-center">
                                                                    <h5 class="text-[#14243B3D] tracking-[1.5px]">
                                                                        PMOS
                                                                    </h5>
                                                                    <img class="w-4 h-4"
                                                                        src="<?php echo asset_image_path_generator() . 'exclamation.svg' ?>"
                                                                        alt="Exclamation-Image" />
                                                                </div>
                                                                <div class="flex items-center space-x-[3px]">
                                                                    <span class="text-2xl text-[#1A2DC9]">8.5</span>
                                                                    <p class="">Highly recommended</p>
                                                                </div>
                                                                <div class="h-[3px] bg-[#1A2DC95C]">
                                                                    <div class="h-[3px] bg-[#1A2DC9] w-[45.95%]"></div>
                                                                </div>
                                                            </div>

                                                            <div class="flex items-center space-x-3">
                                                                <div
                                                                    class="min-w-[72px] min-h-[72px] flex justify-center items-center bg-[linear-gradient(180deg,#F2F2F2_0%,rgba(2,170,242,0.24)_100%)]">
                                                                    <img class="min-w-[65.45px] min-h-[65.45px]"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/2.webp' ?>"
                                                                        alt="Image" />
                                                                </div>
                                                                <div class="space-y-2">
                                                                    <h2 class="text-sm line-clamp-2">
                                                                        Jetpack – WP Security, Backup, Speed, &
                                                                        Growth
                                                                    </h2>
                                                                    <div class="flex items-center space-x-[10px]">
                                                                        <div class="p-[6px] bg-[#E3E5E7] rounded-full">
                                                                            <img class="w-3 h-3"
                                                                                src="<?php echo asset_image_path_generator() . 'bannerSlider/user.svg' ?>"
                                                                                alt="User-Image" />
                                                                        </div>
                                                                        <p>
                                                                            <span class="font-normal">By</span>
                                                                            Developer name
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <p class="text-sm font-normal text-[#A1A7B1]">
                                                                Improve your WP security with powerful
                                                                one-click tools like backup, WAF, and
                                                                malware scan. Includes free tools like
                                                                stats, CDN and social sharing.
                                                            </p>

                                                            <div class="flex justify-between">
                                                                <div
                                                                    class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2 border-r border-[#EEEEEE]">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/star.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        4.8/5
                                                                        <span class="font-normal">1k+reviews</span>
                                                                    </p>
                                                                </div>
                                                                <div
                                                                    class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2 border-r border-[#EEEEEE]">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/downlot.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        200k+
                                                                        <span class="font-normal">active
                                                                            installations</span>
                                                                    </p>
                                                                </div>
                                                                <div class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/w.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        <span class="font-normal">Tested with</span>
                                                                        6.5.5
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>

                                                <div>
                                                    <a href="">
                                                        <div
                                                            class="px-3 pt-3 pb-7 bg-[var(--theme-white)] rounded-xl space-y-8">
                                                            <div class="p-3 space-y-2">
                                                                <div class="flex justify-between items-center">
                                                                    <h5 class="text-[#14243B3D] tracking-[1.5px]">
                                                                        PMOS
                                                                    </h5>
                                                                    <img class="w-4 h-4"
                                                                        src="<?php echo asset_image_path_generator() . 'exclamation.svg' ?>"
                                                                        alt="Exclamation-Image" />
                                                                </div>
                                                                <div class="flex items-center space-x-[3px]">
                                                                    <span class="text-2xl text-[#1A2DC9]">8.5</span>
                                                                    <p>Highly recommended</p>
                                                                </div>
                                                                <div class="h-[3px] bg-[#1A2DC95C]">
                                                                    <div class="h-[3px] bg-[#1A2DC9] w-[45.95%]"></div>
                                                                </div>
                                                            </div>

                                                            <div class="flex items-center space-x-3">
                                                                <div
                                                                    class="min-w-[72px] min-h-[72px] flex justify-center items-center bg-[linear-gradient(180deg,#F2F2F2_0%,rgba(2,170,242,0.24)_100%)]">
                                                                    <img class="w-[65.45px] h-[65.45px]"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/1.webp' ?>"
                                                                        alt="Image" />
                                                                </div>
                                                                <div class="space-y-2">
                                                                    <h2 class="text-sm line-clamp-2">
                                                                        Fonts Plugin | Use Google Fonts, Adobe
                                                                        Fonts or Upload Fonts
                                                                    </h2>
                                                                    <div class="flex items-center space-x-[10px]">
                                                                        <div class="p-[6px] bg-[#E3E5E7] rounded-full">
                                                                            <img class="min-w-3 min-h-3"
                                                                                src="<?php echo asset_image_path_generator() . 'bannerSlider/user.svg' ?>"
                                                                                alt="User-Image" />
                                                                        </div>
                                                                        <p>
                                                                            <span class="font-normal">By</span>
                                                                            Developer name
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <p class="text-sm font-normal text-[#A1A7B1]">
                                                                The easiest to customize fonts in WordPress.
                                                                Optimized for Speed. 1000+ font choices.
                                                                Supports Google Fonts, Adobe Fonts and
                                                                Upload Fonts.
                                                            </p>

                                                            <div class="flex justify-between">
                                                                <div
                                                                    class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2 border-r border-[#EEEEEE]">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/star.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        4.8/5
                                                                        <span class="font-normal">1k+reviews</span>
                                                                    </p>
                                                                </div>
                                                                <div
                                                                    class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2 border-r border-[#EEEEEE]">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/downlot.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        200k+
                                                                        <span class="font-normal">active
                                                                            installations</span>
                                                                    </p>
                                                                </div>
                                                                <div class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/w.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        <span class="font-normal">Tested with</span>
                                                                        6.5.5
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>

                                                <div>
                                                    <a href="">
                                                        <div
                                                            class="px-3 pt-3 pb-7 bg-[var(--theme-white)] rounded-xl space-y-8">
                                                            <div class="p-3 space-y-2">
                                                                <div class="flex justify-between items-center">
                                                                    <h5 class="text-[#14243B3D] tracking-[1.5px]">
                                                                        PMOS
                                                                    </h5>
                                                                    <img class="w-4 h-4"
                                                                        src="<?php echo asset_image_path_generator() . 'exclamation.svg' ?>"
                                                                        alt="Exclamation-Image" />
                                                                </div>
                                                                <div class="flex items-center space-x-[3px]">
                                                                    <span class="text-2xl text-[#1A2DC9]">8.5</span>
                                                                    <p class="">Highly recommended</p>
                                                                </div>
                                                                <div class="h-[3px] bg-[#1A2DC95C]">
                                                                    <div class="h-[3px] bg-[#1A2DC9] w-[45.95%]"></div>
                                                                </div>
                                                            </div>

                                                            <div class="flex items-center space-x-3">
                                                                <div
                                                                    class="min-w-[72px] min-h-[72px] flex justify-center items-center bg-[linear-gradient(180deg,#F2F2F2_0%,rgba(2,170,242,0.24)_100%)]">
                                                                    <img class="min-w-[65.45px] min-h-[65.45px]"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/2.webp' ?>"
                                                                        alt="Image" />
                                                                </div>
                                                                <div class="space-y-2">
                                                                    <h2 class="text-sm line-clamp-2">
                                                                        Jetpack – WP Security, Backup, Speed, &
                                                                        Growth
                                                                    </h2>
                                                                    <div class="flex items-center space-x-[10px]">
                                                                        <div class="p-[6px] bg-[#E3E5E7] rounded-full">
                                                                            <img class="w-3 h-3"
                                                                                src="<?php echo asset_image_path_generator() . 'bannerSlider/user.svg' ?>"
                                                                                alt="User-Image" />
                                                                        </div>
                                                                        <p>
                                                                            <span class="font-normal">By</span>
                                                                            Developer name
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <p class="text-sm font-normal text-[#A1A7B1]">
                                                                Improve your WP security with powerful
                                                                one-click tools like backup, WAF, and
                                                                malware scan. Includes free tools like
                                                                stats, CDN and social sharing.
                                                            </p>

                                                            <div class="flex justify-between">
                                                                <div
                                                                    class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2 border-r border-[#EEEEEE]">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/star.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        4.8/5
                                                                        <span class="font-normal">1k+reviews</span>
                                                                    </p>
                                                                </div>
                                                                <div
                                                                    class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2 border-r border-[#EEEEEE]">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/downlot.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        200k+
                                                                        <span class="font-normal">active
                                                                            installations</span>
                                                                    </p>
                                                                </div>
                                                                <div class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/w.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        <span class="font-normal">Tested with</span>
                                                                        6.5.5
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="groupHoverStop relative translate-y-[100px]">
                                            <div class="animate-vertical-loop space-y-5">
                                                <div>
                                                    <a href="">
                                                        <div
                                                            class="px-3 pt-3 pb-7 bg-[var(--theme-white)] rounded-xl space-y-8">
                                                            <div class="p-3 space-y-2">
                                                                <div class="flex justify-between items-center">
                                                                    <h5 class="text-[#14243B3D] tracking-[1.5px]">
                                                                        PMOS
                                                                    </h5>
                                                                    <img class="w-4 h-4"
                                                                        src="<?php echo asset_image_path_generator() . 'exclamation.svg' ?>"
                                                                        alt="Exclamation-Image" />
                                                                </div>
                                                                <div class="flex items-center space-x-[3px]">
                                                                    <span class="text-2xl text-[#1A2DC9]">8.5</span>
                                                                    <p class="">Highly recommended</p>
                                                                </div>
                                                                <div class="h-[3px] bg-[#1A2DC95C]">
                                                                    <div class="h-[3px] bg-[#1A2DC9] w-[45.95%]"></div>
                                                                </div>
                                                            </div>

                                                            <div class="flex items-center space-x-3">
                                                                <div
                                                                    class="min-w-[72px] min-h-[72px] flex justify-center items-center bg-[linear-gradient(180deg,#F2F2F2_0%,rgba(2,170,242,0.24)_100%)]">
                                                                    <img class="w-[65.45px] h-[65.45px]"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/21.webp' ?>"
                                                                        alt="Image" />
                                                                </div>
                                                                <div class="space-y-2">
                                                                    <h2 class="text-sm line-clamp-2">
                                                                        Akismet Anti-spam: Spam Protection
                                                                    </h2>
                                                                    <div class="flex items-center space-x-[10px]">
                                                                        <div class="p-[6px] bg-[#E3E5E7] rounded-full">
                                                                            <img class="w-3 h-3"
                                                                                src="<?php echo asset_image_path_generator() . 'bannerSlider/user.svg' ?>"
                                                                                alt="User-Image" />
                                                                        </div>
                                                                        <p>
                                                                            <span class="font-normal">By</span>
                                                                            Developer name
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <p class="text-sm font-normal text-[#A1A7B1]">
                                                                The best anti-spam protection to block spam
                                                                comments and spam in a contact form. The
                                                                most trusted antispam solution for WordPress
                                                                and WooCommerce.
                                                            </p>

                                                            <div class="flex justify-between">
                                                                <div
                                                                    class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2 border-r border-[#EEEEEE]">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/star.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        4.8/5
                                                                        <span class="font-normal">1k+reviews</span>
                                                                    </p>
                                                                </div>
                                                                <div
                                                                    class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2 border-r border-[#EEEEEE]">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/downlot.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        200k+
                                                                        <span class="font-normal">active
                                                                            installations</span>
                                                                    </p>
                                                                </div>
                                                                <div class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/w.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        <span class="font-normal">Tested with</span>
                                                                        6.5.5
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>

                                                <div>
                                                    <a href="">
                                                        <div
                                                            class="px-3 pt-3 pb-7 bg-[var(--theme-white)] rounded-xl space-y-8">
                                                            <div class="p-3 space-y-2">
                                                                <div class="flex justify-between items-center">
                                                                    <h5 class="text-[#14243B3D] tracking-[1.5px]">
                                                                        PMOS
                                                                    </h5>
                                                                    <img class="w-4 h-4"
                                                                        src="<?php echo asset_image_path_generator() . 'exclamation.svg' ?>"
                                                                        alt="Exclamation-Image" />
                                                                </div>
                                                                <div class="flex items-center space-x-[3px]">
                                                                    <span class="text-2xl text-[#1A2DC9]">8.5</span>
                                                                    <p class="">Highly recommended</p>
                                                                </div>
                                                                <div class="h-[3px] bg-[#1A2DC95C]">
                                                                    <div class="h-[3px] bg-[#1A2DC9] w-[45.95%]"></div>
                                                                </div>
                                                            </div>

                                                            <div class="flex items-center space-x-3">
                                                                <div
                                                                    class="min-w-[72px] min-h-[72px] flex justify-center items-center bg-[linear-gradient(180deg,#F2F2F2_0%,rgba(2,170,242,0.24)_100%)]">
                                                                    <img class="w-[65.45px] h-[65.45px]"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/22.webp' ?>"
                                                                        alt="Image" />
                                                                </div>
                                                                <div class="space-y-2">
                                                                    <h2 class="text-sm line-clamp-2">
                                                                        Performance Lab
                                                                    </h2>
                                                                    <div class="flex items-center space-x-[10px]">
                                                                        <div class="p-[6px] bg-[#E3E5E7] rounded-full">
                                                                            <img class="w-3 h-3"
                                                                                src="<?php echo asset_image_path_generator() . 'bannerSlider/user.svg' ?>"
                                                                                alt="User-Image" />
                                                                        </div>
                                                                        <p>
                                                                            <span class="font-normal">By</span>
                                                                            Developer name
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <p class="text-sm font-normal text-[#A1A7B1]">
                                                                Performance plugin from the WordPress
                                                                Performance Team, which is a collection of
                                                                standalone performance features.
                                                            </p>

                                                            <div class="flex justify-between">
                                                                <div
                                                                    class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2 border-r border-[#EEEEEE]">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/star.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        4.8/5
                                                                        <span class="font-normal">1k+reviews</span>
                                                                    </p>
                                                                </div>
                                                                <div
                                                                    class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2 border-r border-[#EEEEEE]">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/downlot.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        200k+
                                                                        <span class="font-normal">active
                                                                            installations</span>
                                                                    </p>
                                                                </div>
                                                                <div class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/w.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        <span class="font-normal">Tested with</span>
                                                                        6.5.5
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>

                                                <div>
                                                    <a href="">
                                                        <div
                                                            class="px-3 pt-3 pb-7 bg-[var(--theme-white)] rounded-xl space-y-8">
                                                            <div class="p-3 space-y-2">
                                                                <div class="flex justify-between items-center">
                                                                    <h5 class="text-[#14243B3D] tracking-[1.5px]">
                                                                        PMOS
                                                                    </h5>
                                                                    <img class="w-4 h-4"
                                                                        src="<?php echo asset_image_path_generator() . 'exclamation.svg' ?>"
                                                                        alt="Exclamation-Image" />
                                                                </div>
                                                                <div class="flex items-center space-x-[3px]">
                                                                    <span class="text-2xl text-[#1A2DC9]">8.5</span>
                                                                    <p class="">Highly recommended</p>
                                                                </div>
                                                                <div class="h-[3px] bg-[#1A2DC95C]">
                                                                    <div class="h-[3px] bg-[#1A2DC9] w-[45.95%]"></div>
                                                                </div>
                                                            </div>

                                                            <div class="flex items-center space-x-3">
                                                                <div
                                                                    class="min-w-[72px] min-h-[72px] flex justify-center items-center bg-[linear-gradient(180deg,#F2F2F2_0%,rgba(2,170,242,0.24)_100%)]">
                                                                    <img class="w-[65.45px] h-[65.45px]"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/21.webp' ?>"
                                                                        alt="Image" />
                                                                </div>
                                                                <div class="space-y-2">
                                                                    <h2 class="text-sm line-clamp-2">
                                                                        Akismet Anti-spam: Spam Protection
                                                                    </h2>
                                                                    <div class="flex items-center space-x-[10px]">
                                                                        <div class="p-[6px] bg-[#E3E5E7] rounded-full">
                                                                            <img class="w-3 h-3"
                                                                                src="<?php echo asset_image_path_generator() . 'bannerSlider/user.svg' ?>"
                                                                                alt="User-Image" />
                                                                        </div>
                                                                        <p>
                                                                            <span class="font-normal">By</span>
                                                                            Developer name
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <p class="text-sm font-normal text-[#A1A7B1]">
                                                                The best anti-spam protection to block spam
                                                                comments and spam in a contact form. The
                                                                most trusted antispam solution for WordPress
                                                                and WooCommerce.
                                                            </p>

                                                            <div class="flex justify-between">
                                                                <div
                                                                    class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2 border-r border-[#EEEEEE]">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/star.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        4.8/5
                                                                        <span class="font-normal">1k+reviews</span>
                                                                    </p>
                                                                </div>
                                                                <div
                                                                    class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2 border-r border-[#EEEEEE]">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/downlot.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        200k+
                                                                        <span class="font-normal">active
                                                                            installations</span>
                                                                    </p>
                                                                </div>
                                                                <div class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/w.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        <span class="font-normal">Tested with</span>
                                                                        6.5.5
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>

                                                <div>
                                                    <a href="">
                                                        <div
                                                            class="px-3 pt-3 pb-7 bg-[var(--theme-white)] rounded-xl space-y-8">
                                                            <div class="p-3 space-y-2">
                                                                <div class="flex justify-between items-center">
                                                                    <h5 class="text-[#14243B3D] tracking-[1.5px]">
                                                                        PMOS
                                                                    </h5>
                                                                    <img class="w-4 h-4"
                                                                        src="<?php echo asset_image_path_generator() . 'exclamation.svg' ?>"
                                                                        alt="Exclamation-Image" />
                                                                </div>
                                                                <div class="flex items-center space-x-[3px]">
                                                                    <span class="text-2xl text-[#1A2DC9]">8.5</span>
                                                                    <p class="">Highly recommended</p>
                                                                </div>
                                                                <div class="h-[3px] bg-[#1A2DC95C]">
                                                                    <div class="h-[3px] bg-[#1A2DC9] w-[45.95%]"></div>
                                                                </div>
                                                            </div>

                                                            <div class="flex items-center space-x-3">
                                                                <div
                                                                    class="min-w-[72px] min-h-[72px] flex justify-center items-center bg-[linear-gradient(180deg,#F2F2F2_0%,rgba(2,170,242,0.24)_100%)]">
                                                                    <img class="w-[65.45px] h-[65.45px]"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/22.webp' ?>"
                                                                        alt="Image" />
                                                                </div>
                                                                <div class="space-y-2">
                                                                    <h2 class="text-sm line-clamp-2">
                                                                        Performance Lab
                                                                    </h2>
                                                                    <div class="flex items-center space-x-[10px]">
                                                                        <div class="p-[6px] bg-[#E3E5E7] rounded-full">
                                                                            <img class="w-3 h-3"
                                                                                src="<?php echo asset_image_path_generator() . 'bannerSlider/user.svg' ?>"
                                                                                alt="User-Image" />
                                                                        </div>
                                                                        <p>
                                                                            <span class="font-normal">By</span>
                                                                            Developer name
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <p class="text-sm font-normal text-[#A1A7B1]">
                                                                Performance plugin from the WordPress
                                                                Performance Team, which is a collection of
                                                                standalone performance features.
                                                            </p>

                                                            <div class="flex justify-between">
                                                                <div
                                                                    class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2 border-r border-[#EEEEEE]">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/star.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        4.8/5
                                                                        <span class="font-normal">1k+reviews</span>
                                                                    </p>
                                                                </div>
                                                                <div
                                                                    class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2 border-r border-[#EEEEEE]">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/downlot.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        200k+
                                                                        <span class="font-normal">active
                                                                            installations</span>
                                                                    </p>
                                                                </div>
                                                                <div class="w-[33.333%] pl-2 pr-1 py-[5px] space-y-2">
                                                                    <img class="min-w-5 min-h-5"
                                                                        src="<?php echo asset_image_path_generator() . 'bannerSlider/w.svg' ?>"
                                                                        alt="Star-Image" />
                                                                    <p>
                                                                        <span class="font-normal">Tested with</span>
                                                                        6.5.5
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="sectionPadding mt-32 sm:mt-16 xl:mt-8 bg-[linear-gradient(180deg,#FFFFFF_36.3%,#A4E4FF_178.33%)]">
        <div class="container">
            <div class="max-w-[993px] mx-auto">
                <div class="space-y-8">
                    <h4 class="text-center text-[13px] font-normal leading-[120%]">
                        Trusted by notable big name websites
                    </h4>
                    <div class="flex flex-wrap justify-center items-center gap-x-8 lg:gap-x-12 gap-y-8">
                        <div
                            class="flex-1 min-w-[120px] max-w-[150px] flex justify-center opacity-50 mix-blend-luminosity">
                            <img class="w-auto h-5 md:h-7 object-contain"
                                src="<?php echo asset_image_path_generator() . 'shop/1.webp' ?>" alt="Brand 1" />
                        </div>
                        <div
                            class="flex-1 min-w-[120px] max-w-[150px] flex justify-center opacity-50 mix-blend-luminosity">
                            <img class="w-auto h-5 md:h-7 object-contain"
                                src="<?php echo asset_image_path_generator() . 'shop/2.webp' ?>" alt="Brand 2" />
                        </div>
                        <div
                            class="flex-1 min-w-[120px] max-w-[150px] flex justify-center opacity-50 mix-blend-luminosity">
                            <img class="w-auto object-contain"
                                src="<?php echo asset_image_path_generator() . 'shop/3.webp' ?>" alt="Brand 3" />
                        </div>
                        <div
                            class="flex-1 min-w-[120px] max-w-[150px] flex justify-center opacity-50 mix-blend-luminosity">
                            <img class="w-auto h-5 md:h-7 object-contain"
                                src="<?php echo asset_image_path_generator() . 'shop/4.webp' ?>" alt="Brand 4" />
                        </div>
                        <div
                            class="flex-1 min-w-[120px] max-w-[150px] flex justify-center opacity-50 mix-blend-luminosity">
                            <img class="w-auto h-5 md:h-7 object-contain"
                                src="<?php echo asset_image_path_generator() . 'shop/5.webp' ?>" alt="Brand 5" />
                        </div>
                        <div
                            class="flex-1 min-w-[120px] max-w-[150px] flex justify-center opacity-50 mix-blend-luminosity">
                            <img class="w-auto h-5 md:h-7 object-contain"
                                src="<?php echo asset_image_path_generator() . 'shop/6.webp' ?>" alt="Brand 6" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="pt-[60px] lg:pt-[80px] xl:pt-[120px]">
        <div class="container">
            <div class="space-y-6 lg:space-y-8">
                <div class="flex justify-between items-center font-bold space-x-2">
                    <h4 class="text-lg lg:text-xl leading-[120%]">
                        Browse by Category (100+)
                    </h4>
                    <a href="#"
                        class="text-base leading-[160%] text-[#1A2DC9] hover:opacity-80 duration-300 whitespace-nowrap">
                        View all
                    </a>
                </div>
                <div class="flex lg:flex-row flex-col space-y-4 lg:space-y-0 space-x-0 lg:space-x-4">
                    <div class="w-full flex flex-col sm:flex-row space-y-4 sm:space-y-0 sm:space-x-4">
                        <div class="w-full space-y-4">
                            <div class="w-full">
                                <a href="#">
                                    <div
                                        class="min-h-[154px] w-full flex flex-col group p-6 bg-[#FBBC05] hover:bg-black transition-all duration-300 rounded-xl">
                                        <div class="flex justify-between items-center pb-3.5">
                                            <div class="space-x-3">
                                                <p class="text-base font-normal leading-[160%] group-hover:text-white">
                                                    1,234 plugins
                                                </p>
                                            </div>

                                            <div
                                                class="w-8 h-8 bg-black group-hover:bg-white flex items-center justify-center rounded-full">
                                                <img class="w-4 h-4 block group-hover:hidden"
                                                    src="<?php echo asset_image_path_generator() . 'arrow-right-line.svg' ?>"
                                                    alt="Arrow-Right" />
                                                <img class="w-4 h-4 hidden group-hover:block"
                                                    src="<?php echo asset_image_path_generator() . 'arrow-right-line(b).svg' ?>"
                                                    alt="Arrow-Right" />
                                            </div>
                                        </div>
                                        <div class="mt-auto">
                                            <h2
                                                class="text-xl lg:text-[25px] font-bold leading-[120%] group-hover:text-white">
                                                SEO Optimization
                                            </h2>
                                        </div>
                                    </div>
                                </a>
                            </div>
                            <div class="w-full">
                                <a href="#">
                                    <div
                                        class="min-h-[154px] w-full flex flex-col group p-6 bg-[#01F4A0] hover:bg-black transition-all duration-300 rounded-xl">
                                        <div class="flex justify-between items-center pb-3.5">
                                            <div class="space-x-3">
                                                <p class="text-base font-normal leading-[160%] group-hover:text-white">
                                                    1,234 plugins
                                                </p>
                                            </div>

                                            <div
                                                class="w-8 h-8 bg-black group-hover:bg-white flex items-center justify-center rounded-full">
                                                <img class="w-4 h-4 block group-hover:hidden"
                                                    src="<?php echo asset_image_path_generator() . 'arrow-right-line.svg' ?>"
                                                    alt="Arrow-Right" />
                                                <img class="w-4 h-4 hidden group-hover:block"
                                                    src="<?php echo asset_image_path_generator() . 'arrow-right-line(b).svg' ?>"
                                                    alt="Arrow-Right" />
                                            </div>
                                        </div>
                                        <div class="mt-auto">
                                            <h2
                                                class="text-xl lg:text-[25px] font-bold leading-[120%] group-hover:text-white">
                                                Security Enhancements
                                            </h2>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                        <div class="w-full">
                            <a href="#">
                                <div
                                    class="w-full min-h-[154px] sm:h-full flex flex-col group p-6 bg-[#6ED4FF] hover:bg-black transition-all duration-300 rounded-xl">
                                    <div class="flex justify-between items-center pb-3.5">
                                        <div class="space-x-3">
                                            <p class="text-base font-normal leading-[160%] group-hover:text-white">
                                                1,234 plugins
                                            </p>
                                        </div>

                                        <div
                                            class="w-8 h-8 bg-black group-hover:bg-white flex items-center justify-center rounded-full">
                                            <img class="w-4 h-4 block group-hover:hidden"
                                                src="<?php echo asset_image_path_generator() . 'arrow-right-line.svg' ?>"
                                                alt="Arrow-Right" />
                                            <img class="w-4 h-4 hidden group-hover:block"
                                                src="<?php echo asset_image_path_generator() . 'arrow-right-line(b).svg' ?>"
                                                alt="Arrow-Right" />
                                        </div>
                                    </div>
                                    <div class="mt-auto">
                                        <h2
                                            class="text-xl lg:text-[25px] font-bold leading-[120%] group-hover:text-white">
                                            E-commerce Tools
                                        </h2>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>

                    <div class="w-full space-y-4">
                        <div class="w-full flex flex-col sm:flex-row space-y-4 sm:space-y-0 sm:space-x-4">
                            <div class="w-full">
                                <a href="#">
                                    <div
                                        class="min-h-[154px] w-full flex flex-col group p-6 bg-[#01F4A0] hover:bg-black transition-all duration-300 rounded-xl">
                                        <div class="flex justify-between items-center pb-3.5">
                                            <div class="space-x-3">
                                                <p class="text-base font-normal leading-[160%] group-hover:text-white">
                                                    1,234 plugins
                                                </p>
                                            </div>

                                            <div
                                                class="w-8 h-8 bg-black group-hover:bg-white flex items-center justify-center rounded-full">
                                                <img class="w-4 h-4 block group-hover:hidden"
                                                    src="<?php echo asset_image_path_generator() . 'arrow-right-line.svg' ?>"
                                                    alt="Arrow-Right" />
                                                <img class="w-4 h-4 hidden group-hover:block"
                                                    src="<?php echo asset_image_path_generator() . 'arrow-right-line(b).svg' ?>"
                                                    alt="Arrow-Right" />
                                            </div>
                                        </div>
                                        <div class="mt-auto">
                                            <h2
                                                class="text-xl lg:text-[25px] font-bold leading-[120%] group-hover:text-white">
                                                Performance Boosters
                                            </h2>
                                        </div>
                                    </div>
                                </a>
                            </div>
                            <div class="w-full">
                                <a href="#">
                                    <div
                                        class="min-h-[154px] w-full flex flex-col group p-6 bg-[#ffffff] hover:bg-black transition-all duration-300 rounded-xl">
                                        <div class="flex justify-between items-center pb-3.5">
                                            <div class="space-x-3">
                                                <p class="text-base font-normal leading-[160%] group-hover:text-white">
                                                    1,234 plugins
                                                </p>
                                            </div>

                                            <div
                                                class="w-8 h-8 bg-black group-hover:bg-white flex items-center justify-center rounded-full">
                                                <img class="w-4 h-4 block group-hover:hidden"
                                                    src="<?php echo asset_image_path_generator() . 'arrow-right-line.svg' ?>"
                                                    alt="Arrow-Right" />
                                                <img class="w-4 h-4 hidden group-hover:block"
                                                    src="<?php echo asset_image_path_generator() . 'arrow-right-line(b).svg' ?>"
                                                    alt="Arrow-Right" />
                                            </div>
                                        </div>
                                        <div class="mt-auto">
                                            <h2
                                                class="text-xl lg:text-[25px] font-bold leading-[120%] group-hover:text-white">
                                                Analytics & Reporting
                                            </h2>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                        <div class="w-full">
                            <a href="#">
                                <div
                                    class="min-h-[154px] w-full flex flex-col group p-6 bg-[#48DBD7] hover:bg-black transition-all duration-300 rounded-xl">
                                    <div class="flex justify-between items-center pb-3.5">
                                        <div class="space-x-3">
                                            <p class="text-base font-normal leading-[160%] group-hover:text-white">
                                                1,234 plugins
                                            </p>
                                        </div>

                                        <div
                                            class="w-8 h-8 bg-black group-hover:bg-white flex items-center justify-center rounded-full">
                                            <img class="w-4 h-4 block group-hover:hidden"
                                                src="<?php echo asset_image_path_generator() . 'arrow-right-line.svg' ?>"
                                                alt="Arrow-Right" />
                                            <img class="w-4 h-4 hidden group-hover:block"
                                                src="<?php echo asset_image_path_generator() . 'arrow-right-line(b).svg' ?>"
                                                alt="Arrow-Right" />
                                        </div>
                                    </div>
                                    <div class="mt-auto">
                                        <h2
                                            class="text-xl lg:text-[25px] font-bold leading-[120%] group-hover:text-white">
                                            Social Media Integration
                                        </h2>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="py-[130px] sm:py-[180px] lg:py-[240px]">
        <div class="container">
            <div class="sectionWidth">
                <div class="relative text-center font-bold">
                    <div
                        class="absolute -top-[31px] sm:-top-[80px] left-[8%] sm:left-[23%] w-16 sm:w-[72px] lg:w-28 h-14 sm:h-16 lg:h-28 p-[5px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-3xl flex items-center justify-center">
                        <img class="w-14 sm:w-16 lg:w-[101px] h-14 sm:h-16 lg:h-[101px] rounded-xl sm:rounded-3xl"
                            src="<?php echo asset_image_path_generator() . 'library/1.webp' ?>" alt="" />
                    </div>
                    <div
                        class="absolute top-[25px] sm:top-0 left-[2%] sm:left-[10%] w-11 sm:w-14 lg:w-[72px] h-9 sm:h-14 lg:h-[72px] p-[4px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-3xl flex items-center justify-center">
                        <img class="w-11 sm:w-12 lg:w-16 h-9 sm:h-12 lg:h-16 rounded-xl sm:rounded-3xl"
                            src="<?php echo asset_image_path_generator() . 'library/2.webp' ?>" alt="" />
                    </div>
                    <div
                        class="absolute top-[52%] sm:top-[46%] left-[4%] sm:left-[12%] w-11 sm:w-14 lg:w-[72px] h-9 sm:h-14 lg:h-[72px] p-[4px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-3xl flex items-center justify-center">
                        <img class="w-11 sm:w-12 lg:w-16 h-9 sm:h-12 lg:h-16 rounded-xl sm:rounded-3xl"
                            src="<?php echo asset_image_path_generator() . 'library/3.webp' ?>" alt="" />
                    </div>
                    <div
                        class="absolute -bottom-[24%] left-0 sm:left-[8%] w-11 sm:w-14 lg:w-[72px] h-9 sm:h-14 lg:h-[72px] p-[4px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-3xl flex items-center justify-center">
                        <img class="w-11 sm:w-12 lg:w-16 h-9 sm:h-12 lg:h-16 rounded-xl sm:rounded-3xl"
                            src="<?php echo asset_image_path_generator() . 'library/4.webp' ?>" alt="" />
                    </div>
                    <div
                        class="absolute -bottom-[45%] sm:-bottom-[50%] left-[20%] sm:left-[30%] w-11 sm:w-14 lg:w-[72px] h-9 sm:h-14 lg:h-[72px] p-[4px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-3xl flex items-center justify-center">
                        <img class="w-11 sm:w-12 lg:w-16 h-9 sm:h-12 lg:h-16 rounded-xl sm:rounded-3xl"
                            src="<?php echo asset_image_path_generator() . 'library/5.webp' ?>" alt="" />
                    </div>
                    <div
                        class="absolute -bottom-[52%] sm:-bottom-[70%] left-[42%] sm:left-[46%] w-16 sm:w-[72px] lg:w-28 h-14 sm:h-16 lg:h-28 p-[5px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-3xl flex items-center justify-center">
                        <img class="w-14 sm:w-16 lg:w-[101px] h-14 sm:h-16 lg:h-[101px] rounded-xl sm:rounded-3xl"
                            src="<?php echo asset_image_path_generator() . 'library/6-l.webp' ?>" alt="" />
                    </div>
                    <div
                        class="absolute -bottom-[33%] sm:-bottom-[40%] right-0 sm:right-[3%] w-11 sm:w-14 lg:w-[72px] h-9 sm:h-14 lg:h-[72px] p-[4px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-3xl flex items-center justify-center">
                        <img class="w-11 sm:w-12 lg:w-16 h-9 sm:h-12 lg:h-16 rounded-xl sm:rounded-3xl"
                            src="<?php echo asset_image_path_generator() . 'library/7.webp' ?>" alt="" />
                    </div>
                    <div
                        class="absolute bottom-[10%] right-[2%] sm:right-[7%] w-11 sm:w-14 lg:w-[72px] h-9 sm:h-14 lg:h-[72px] p-[4px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-3xl flex items-center justify-center">
                        <img class="w-11 sm:w-12 lg:w-16 h-9 sm:h-12 lg:h-16 rounded-xl sm:rounded-3xl"
                            src="<?php echo asset_image_path_generator() . 'library/8.webp' ?>" alt="" />
                    </div>
                    <div
                        class="absolute top-8 sm:top-4 right-0 sm:right-[13%] w-16 sm:w-[72px] lg:w-28 h-14 sm:h-16 lg:h-28 p-[5px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-3xl flex items-center justify-center">
                        <img class="w-14 sm:w-16 lg:w-[101px] h-14 sm:h-16 lg:h-[101px] rounded-xl sm:rounded-3xl"
                            src="<?php echo asset_image_path_generator() . 'library/9.webp' ?>" alt="" />
                    </div>
                    <div
                        class="absolute -top-[23%] sm:-top-[30%] right-0 sm:right-[6%] w-11 sm:w-14 lg:w-[72px] h-9 sm:h-14 lg:h-[72px] p-[4px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-3xl flex items-center justify-center">
                        <img class="w-11 sm:w-12 lg:w-16 h-9 sm:h-12 lg:h-16 rounded-xl sm:rounded-3xl"
                            src="<?php echo asset_image_path_generator() . 'library/10.webp' ?>" alt="" />
                    </div>
                    <div
                        class="absolute -top-[23%] sm:-top-[30%] right-[18%] sm:right-[30%] w-11 sm:w-14 lg:w-[72px] h-9 sm:h-14 lg:h-[72px] p-[4px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-3xl flex items-center justify-center">
                        <img class="w-11 sm:w-12 lg:w-16 h-9 sm:h-12 lg:h-16 rounded-xl sm:rounded-3xl"
                            src="<?php echo asset_image_path_generator() . 'library/11.webp' ?>" alt="" />
                    </div>
                    <div
                        class="absolute -top-[62%] right-[50%] w-11 sm:w-14 lg:w-[72px] h-9 sm:h-14 lg:h-[72px] p-[4px] bg-[linear-gradient(180deg,_#F2F2F2_0%,_rgba(2,170,242,0.24)_100%)] rounded-3xl flex items-center justify-center">
                        <img class="w-11 sm:w-12 lg:w-16 h-9 sm:h-12 lg:h-16 rounded-xl sm:rounded-3xl"
                            src="<?php echo asset_image_path_generator() . 'library/12.webp' ?>" alt="" />
                    </div>
                    <div class="space-y-6 sm:space-y-8">
                        <h4 class="text-1xl leading-[165%]">A growing library of</h4>
                        <h2
                            class="max-w-[280px] md:max-w-[350px] lg:max-w-[560px] mx-auto text-3xl md:text-4xl lg:text-6xl leading-[120%]">
                            50,000+ plugins 100+ categories 1M+ active installs
                        </h2>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section>
        <div class="container">
            <div class="sectionWidth">
                <div
                    class="px-4 sm:px-6 md:px-10 lg:px-[49px] py-9 md:py-12 lg:py-[53px] font-bold leading-[120%] bg-[linear-gradient(90deg,#1C37D1_0%,#0E70DD_100%)] rounded-[32px] space-y-6 md:space-y-8 lg:space-y-10">
                    <h2 class="text-center text-3xl md:text-4xl lg:text-[49px] text-white">
                        Why choose WPSearch.ai?
                    </h2>

                    <div id="accordion-flush-6" data-accordion="collapse" data-active-classes="border-b"
                        data-inactive-classes="border-b" class="space-y-10">
                        <!-- Q1 -->
                        <div class="">
                            <h2 id="accordion-flush-heading-1">
                                <button type="button"
                                    class="py-[9px] flex items-center justify-between space-x-4 text-start w-full border-b-[0.5px] border-white/80 cursor-pointer outline-0"
                                    data-accordion-target="#accordion-flush-body-1" aria-expanded="true"
                                    aria-controls="accordion-flush-body-1">
                                    <span class="text-xl sm:text-[22px] lg:text-[25px] font-bold leading-[120%]">
                                        Search method
                                    </span>

                                    <div class="relative w-7 md:min-w-9 lg:min-w-[42px] h-7 md:min-h-9 lg:min-h-[42px]">
                                        <img class="plusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 object-contain"
                                            src="<?php echo asset_image_path_generator() . 'faq/Plus.svg' ?>"
                                            alt="Plus Icon" />
                                        <img class="minusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 object-contain"
                                            src="<?php echo asset_image_path_generator() . 'faq/Minus.svg' ?>"
                                            alt="Minus Icon" />
                                    </div>
                                </button>
                            </h2>

                            <div id="accordion-flush-body-1" aria-labelledby="accordion-flush-heading-1"
                                class="text-sm font-normal leading-[165%] bg-white hidden">
                                <div
                                    class="flex flex-col md:flex-row justify-between md:space-y-0 space-y-[1px] space-x-0 md:space-x-[1px] text-center">
                                    <!-- left site -->
                                    <div
                                        class="px-1 sm:px-4 py-[38px] bg-[#F2F2F2] rounded-t-3xl md:rounded-t-none md:rounded-tl-3xl md:rounded-bl-3xl space-y-6">
                                        <div class="">
                                            <img class="w-[174.45px] mx-auto"
                                                src="<?php echo asset_image_path_generator() . 'faq/wpLogo.webp' ?>"
                                                alt="wpLogo" />
                                        </div>
                                        <div class="">
                                            <img class="aspect-[2.347] object-contain"
                                                src="<?php echo asset_image_path_generator() . 'faq/Frame-1.webp' ?>"
                                                alt="Frame-1" />
                                        </div>
                                        <div class="space-y-6">
                                            <h2
                                                class="text-2xl md:text-[26px] lg:text-[31px] font-extrabold leading-[100%]">
                                                Basic Search Matching
                                            </h2>
                                            <p class="text-base font-bold leading-[145%]">
                                                Exact‑phrase and basic relevancy scoring; uses
                                                Elasticsearch to match metadata such as title,
                                                description and tags.
                                            </p>
                                        </div>
                                    </div>

                                    <!-- Right site -->
                                    <div
                                        class="px-1 sm:px-4 py-[38px] bg-[#F2F2F2] rounded-b-3xl md:rounded-b-none md:rounded-tr-3xl md:rounded-br-3xl space-y-6">
                                        <div class="">
                                            <img class="w-[227px] mx-auto"
                                                src="<?php echo asset_image_path_generator() . 'logo.webp' ?>"
                                                alt="wpLogo" />
                                        </div>
                                        <div class="relative">
                                            <div
                                                class="absolute bottom-3 left-10 text-[13px] font-normal leading-[120%]">
                                                <a href=""
                                                    class="py-2 px-3 lg:p-3 flex items-center space-x-2 bg-white hover:bg-slate-200 duration-300 transition-all shadow-[0_4px_4px_0_#00000040] rounded-full">
                                                    <img class="w-6 h-6"
                                                        src="<?php echo asset_image_path_generator() . 'faq/sparkling-line.svg' ?>"
                                                        alt="" />
                                                    <span>AI Suggestions</span>
                                                </a>
                                            </div>
                                            <img class="aspect-[2.347] object-contain"
                                                src="<?php echo asset_image_path_generator() . 'faq/Frame-2.webp' ?>"
                                                alt="Frame-2" />
                                        </div>
                                        <div class="space-y-6">
                                            <h2
                                                class="text-2xl md:text-[26px] lg:text-[31px] font-extrabold leading-[100%]">
                                                Basic Search Matching
                                            </h2>
                                            <p class="text-base font-bold leading-[145%]">
                                                Exact‑phrase and basic relevancy scoring; uses
                                                Elasticsearch to match metadata such as title,
                                                description and tags.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Q2 -->
                        <div class="">
                            <h2 id="accordion-flush-heading-2">
                                <button type="button"
                                    class="py-[9px] flex items-center justify-between space-x-4 text-start w-full border-b-[0.5px] border-white/80 cursor-pointer outline-0"
                                    data-accordion-target="#accordion-flush-body-2" aria-expanded="false"
                                    aria-controls="accordion-flush-body-2">
                                    <span class="text-xl sm:text-[22px] lg:text-[25px] font-bold leading-[120%]">
                                        Ranking factors
                                    </span>

                                    <div class="relative w-7 md:min-w-9 lg:min-w-[42px] h-7 md:min-h-9 lg:min-h-[42px]">
                                        <img class="plusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 object-contain"
                                            src="<?php echo asset_image_path_generator() . 'faq/Plus.svg' ?>"
                                            alt="Plus Icon" />
                                        <img class="minusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 object-contain"
                                            src="<?php echo asset_image_path_generator() . 'faq/Minus.svg' ?>"
                                            alt="Minus Icon" />
                                    </div>
                                </button>
                            </h2>

                            <div id="accordion-flush-body-2" aria-labelledby="accordion-flush-heading-2"
                                class="text-sm font-normal leading-[165%] bg-white hidden">
                                <div
                                    class="flex flex-col md:flex-row justify-between md:space-y-0 space-y-[1px] space-x-0 md:space-x-[1px] text-center">
                                    <!-- left site -->
                                    <div
                                        class="px-1 sm:px-4 py-[38px] bg-[#F2F2F2] rounded-t-3xl md:rounded-t-none md:rounded-tl-3xl md:rounded-bl-3xl space-y-6">
                                        <div class="">
                                            <img class="w-[174.45px] mx-auto"
                                                src="<?php echo asset_image_path_generator() . 'faq/wpLogo.webp' ?>"
                                                alt="wpLogo" />
                                        </div>
                                        <div class="">
                                            <img class="aspect-[2.347] object-contain"
                                                src="<?php echo asset_image_path_generator() . 'faq/Frame-1.webp' ?>"
                                                alt="Frame-1" />
                                        </div>
                                        <div class="space-y-6">
                                            <h2
                                                class="text-2xl md:text-[26px] lg:text-[31px] font-extrabold leading-[100%]">
                                                Basic Search Matching
                                            </h2>
                                            <p class="text-base font-bold leading-[145%]">
                                                Exact‑phrase and basic relevancy scoring; uses
                                                Elasticsearch to match metadata such as title,
                                                description and tags.
                                            </p>
                                        </div>
                                    </div>

                                    <!-- Right site -->
                                    <div
                                        class="px-1 sm:px-4 py-[38px] bg-[#F2F2F2] rounded-b-3xl md:rounded-b-none md:rounded-tr-3xl md:rounded-br-3xl space-y-6">
                                        <div class="">
                                            <img class="w-[227px] mx-auto"
                                                src="<?php echo asset_image_path_generator() . 'logo.webp' ?>"
                                                alt="wpLogo" />
                                        </div>
                                        <div class="relative">
                                            <div
                                                class="absolute bottom-3 left-10 text-[13px] font-normal leading-[120%]">
                                                <a href=""
                                                    class="py-2 px-3 lg:p-3 flex items-center space-x-2 bg-white hover:bg-slate-200 duration-300 transition-all shadow-[0_4px_4px_0_#00000040] rounded-full">
                                                    <img class="w-6 h-6"
                                                        src="<?php echo asset_image_path_generator() . 'faq/sparkling-line.svg' ?>"
                                                        alt="" />
                                                    <span>AI Suggestions</span>
                                                </a>
                                            </div>
                                            <img class="aspect-[2.347] object-contain"
                                                src="<?php echo asset_image_path_generator() . 'faq/Frame-2.webp' ?>"
                                                alt="Frame-2" />
                                        </div>
                                        <div class="space-y-6">
                                            <h2
                                                class="text-2xl md:text-[26px] lg:text-[31px] font-extrabold leading-[100%]">
                                                Basic Search Matching
                                            </h2>
                                            <p class="text-base font-bold leading-[145%]">
                                                Exact‑phrase and basic relevancy scoring; uses
                                                Elasticsearch to match metadata such as title,
                                                description and tags.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Q3 -->
                        <div class="">
                            <h2 id="accordion-flush-heading-3">
                                <button type="button"
                                    class="py-[9px] flex items-center justify-between space-x-4 text-start w-full border-b-[0.5px] border-white/80 cursor-pointer outline-0"
                                    data-accordion-target="#accordion-flush-body-3" aria-expanded="false"
                                    aria-controls="accordion-flush-body-3">
                                    <span class="text-xl sm:text-[22px] lg:text-[25px] font-bold leading-[120%]">
                                        Filtering & sorting
                                    </span>

                                    <div class="relative w-7 md:min-w-9 lg:min-w-[42px] h-7 md:min-h-9 lg:min-h-[42px]">
                                        <img class="plusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 object-contain"
                                            src="<?php echo asset_image_path_generator() . 'faq/Plus.svg' ?>"
                                            alt="Plus Icon" />
                                        <img class="minusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 object-contain"
                                            src="<?php echo asset_image_path_generator() . 'faq/Minus.svg' ?>"
                                            alt="Minus Icon" />
                                    </div>
                                </button>
                            </h2>

                            <div id="accordion-flush-body-3" aria-labelledby="accordion-flush-heading-3"
                                class="text-sm font-normal leading-[165%] bg-white hidden">
                                <div
                                    class="flex flex-col md:flex-row justify-between md:space-y-0 space-y-[1px] space-x-0 md:space-x-[1px] text-center">
                                    <!-- left site -->
                                    <div
                                        class="px-1 sm:px-4 py-[38px] bg-[#F2F2F2] rounded-t-3xl md:rounded-t-none md:rounded-tl-3xl md:rounded-bl-3xl space-y-6">
                                        <div class="">
                                            <img class="w-[174.45px] mx-auto"
                                                src="<?php echo asset_image_path_generator() . 'faq/wpLogo.webp' ?>"
                                                alt="wpLogo" />
                                        </div>
                                        <div class="">
                                            <img class="aspect-[2.347] object-contain"
                                                src="<?php echo asset_image_path_generator() . 'faq/Frame-1.webp' ?>"
                                                alt="Frame-1" />
                                        </div>
                                        <div class="space-y-6">
                                            <h2
                                                class="text-2xl md:text-[26px] lg:text-[31px] font-extrabold leading-[100%]">
                                                Basic Search Matching
                                            </h2>
                                            <p class="text-base font-bold leading-[145%]">
                                                Exact‑phrase and basic relevancy scoring; uses
                                                Elasticsearch to match metadata such as title,
                                                description and tags.
                                            </p>
                                        </div>
                                    </div>

                                    <!-- Right site -->
                                    <div
                                        class="px-1 sm:px-4 py-[38px] bg-[#F2F2F2] rounded-b-3xl md:rounded-b-none md:rounded-tr-3xl md:rounded-br-3xl space-y-6">
                                        <div class="">
                                            <img class="w-[227px] mx-auto"
                                                src="<?php echo asset_image_path_generator() . 'logo.webp' ?>"
                                                alt="wpLogo" />
                                        </div>
                                        <div class="relative">
                                            <div
                                                class="absolute bottom-3 left-10 text-[13px] font-normal leading-[120%]">
                                                <a href=""
                                                    class="py-2 px-3 lg:p-3 flex items-center space-x-2 bg-white hover:bg-slate-200 duration-300 transition-all shadow-[0_4px_4px_0_#00000040] rounded-full">
                                                    <img class="w-6 h-6"
                                                        src="<?php echo asset_image_path_generator() . 'faq/sparkling-line.svg' ?>"
                                                        alt="" />
                                                    <span>AI Suggestions</span>
                                                </a>
                                            </div>
                                            <img class="aspect-[2.347] object-contain"
                                                src="<?php echo asset_image_path_generator() . 'faq/Frame-2.webp' ?>"
                                                alt="Frame-2" />
                                        </div>
                                        <div class="space-y-6">
                                            <h2
                                                class="text-2xl md:text-[26px] lg:text-[31px] font-extrabold leading-[100%]">
                                                Basic Search Matching
                                            </h2>
                                            <p class="text-base font-bold leading-[145%]">
                                                Exact‑phrase and basic relevancy scoring; uses
                                                Elasticsearch to match metadata such as title,
                                                description and tags.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Q4 -->
                        <div class="">
                            <h2 id="accordion-flush-heading-4">
                                <button type="button"
                                    class="py-[9px] flex items-center justify-between space-x-4 text-start w-full border-b-[0.5px] border-white/80 cursor-pointer outline-0"
                                    data-accordion-target="#accordion-flush-body-4" aria-expanded="false"
                                    aria-controls="accordion-flush-body-4">
                                    <span class="text-xl sm:text-[22px] lg:text-[25px] font-bold leading-[120%]">
                                        Personalisation
                                    </span>

                                    <div class="relative w-7 md:min-w-9 lg:min-w-[42px] h-7 md:min-h-9 lg:min-h-[42px]">
                                        <img class="plusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 object-contain"
                                            src="<?php echo asset_image_path_generator() . 'faq/Plus.svg' ?>"
                                            alt="Plus Icon" />
                                        <img class="minusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 object-contain"
                                            src="<?php echo asset_image_path_generator() . 'faq/Minus.svg' ?>"
                                            alt="Minus Icon" />
                                    </div>
                                </button>
                            </h2>

                            <div id="accordion-flush-body-4" aria-labelledby="accordion-flush-heading-4"
                                class="text-sm font-normal leading-[165%] bg-white hidden">
                                <div
                                    class="flex flex-col md:flex-row justify-between md:space-y-0 space-y-[1px] space-x-0 md:space-x-[1px] text-center">
                                    <!-- left site -->
                                    <div
                                        class="px-1 sm:px-4 py-[38px] bg-[#F2F2F2] rounded-t-3xl md:rounded-t-none md:rounded-tl-3xl md:rounded-bl-3xl space-y-6">
                                        <div class="">
                                            <img class="w-[174.45px] mx-auto"
                                                src="<?php echo asset_image_path_generator() . 'faq/wpLogo.webp' ?>"
                                                alt="wpLogo" />
                                        </div>
                                        <div class="">
                                            <img class="aspect-[2.347] object-contain"
                                                src="<?php echo asset_image_path_generator() . 'faq/Frame-1.webp' ?>"
                                                alt="Frame-1" />
                                        </div>
                                        <div class="space-y-6">
                                            <h2
                                                class="text-2xl md:text-[26px] lg:text-[31px] font-extrabold leading-[100%]">
                                                Basic Search Matching
                                            </h2>
                                            <p class="text-base font-bold leading-[145%]">
                                                Exact‑phrase and basic relevancy scoring; uses
                                                Elasticsearch to match metadata such as title,
                                                description and tags.
                                            </p>
                                        </div>
                                    </div>

                                    <!-- Right site -->
                                    <div
                                        class="px-1 sm:px-4 py-[38px] bg-[#F2F2F2] rounded-b-3xl md:rounded-b-none md:rounded-tr-3xl md:rounded-br-3xl space-y-6">
                                        <div class="">
                                            <img class="w-[227px] mx-auto"
                                                src="<?php echo asset_image_path_generator() . 'logo.webp' ?>"
                                                alt="wpLogo" />
                                        </div>
                                        <div class="relative">
                                            <div
                                                class="absolute bottom-3 left-10 text-[13px] font-normal leading-[120%]">
                                                <a href=""
                                                    class="py-2 px-3 lg:p-3 flex items-center space-x-2 bg-white hover:bg-slate-200 duration-300 transition-all shadow-[0_4px_4px_0_#00000040] rounded-full">
                                                    <img class="w-6 h-6"
                                                        src="<?php echo asset_image_path_generator() . 'faq/sparkling-line.svg' ?>"
                                                        alt="" />
                                                    <span>AI Suggestions</span>
                                                </a>
                                            </div>
                                            <img class="aspect-[2.347] object-contain"
                                                src="<?php echo asset_image_path_generator() . 'faq/Frame-2.webp' ?>"
                                                alt="Frame-2" />
                                        </div>
                                        <div class="space-y-6">
                                            <h2
                                                class="text-2xl md:text-[26px] lg:text-[31px] font-extrabold leading-[100%]">
                                                Basic Search Matching
                                            </h2>
                                            <p class="text-base font-bold leading-[145%]">
                                                Exact‑phrase and basic relevancy scoring; uses
                                                Elasticsearch to match metadata such as title,
                                                description and tags.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Q5 -->
                        <div class="">
                            <h2 id="accordion-flush-heading-5">
                                <button type="button"
                                    class="py-[9px] flex items-center justify-between space-x-4 text-start w-full border-b-[0.5px] border-white/80 cursor-pointer outline-0"
                                    data-accordion-target="#accordion-flush-body-5" aria-expanded="false"
                                    aria-controls="accordion-flush-body-5">
                                    <span class="text-xl sm:text-[22px] lg:text-[25px] font-bold leading-[120%]">
                                        Data insights
                                    </span>

                                    <div class="relative w-7 md:min-w-9 lg:min-w-[42px] h-7 md:min-h-9 lg:min-h-[42px]">
                                        <img class="plusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 object-contain"
                                            src="<?php echo asset_image_path_generator() . 'faq/Plus.svg' ?>"
                                            alt="Plus Icon" />
                                        <img class="minusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 object-contain"
                                            src="<?php echo asset_image_path_generator() . 'faq/Minus.svg' ?>"
                                            alt="Minus Icon" />
                                    </div>
                                </button>
                            </h2>

                            <div id="accordion-flush-body-5" aria-labelledby="accordion-flush-heading-5"
                                class="text-sm font-normal leading-[165%] bg-white hidden">
                                <div
                                    class="flex flex-col md:flex-row justify-between md:space-y-0 space-y-[1px] space-x-0 md:space-x-[1px] text-center">
                                    <!-- left site -->
                                    <div
                                        class="px-1 sm:px-4 py-[38px] bg-[#F2F2F2] rounded-t-3xl md:rounded-t-none md:rounded-tl-3xl md:rounded-bl-3xl space-y-6">
                                        <div class="">
                                            <img class="w-[174.45px] mx-auto"
                                                src="<?php echo asset_image_path_generator() . 'faq/wpLogo.webp' ?>"
                                                alt="wpLogo" />
                                        </div>
                                        <div class="">
                                            <img class="aspect-[2.347] object-contain"
                                                src="<?php echo asset_image_path_generator() . 'faq/Frame-1.webp' ?>"
                                                alt="Frame-1" />
                                        </div>
                                        <div class="space-y-6">
                                            <h2
                                                class="text-2xl md:text-[26px] lg:text-[31px] font-extrabold leading-[100%]">
                                                Basic Search Matching
                                            </h2>
                                            <p class="text-base font-bold leading-[145%]">
                                                Exact‑phrase and basic relevancy scoring; uses
                                                Elasticsearch to match metadata such as title,
                                                description and tags.
                                            </p>
                                        </div>
                                    </div>

                                    <!-- Right site -->
                                    <div
                                        class="px-1 sm:px-4 py-[38px] bg-[#F2F2F2] rounded-b-3xl md:rounded-b-none md:rounded-tr-3xl md:rounded-br-3xl space-y-6">
                                        <div class="">
                                            <img class="w-[227px] mx-auto"
                                                src="<?php echo asset_image_path_generator() . 'logo.webp' ?>"
                                                alt="wpLogo" />
                                        </div>
                                        <div class="relative">
                                            <div
                                                class="absolute bottom-3 left-10 text-[13px] font-normal leading-[120%]">
                                                <a href=""
                                                    class="py-2 px-3 lg:p-3 flex items-center space-x-2 bg-white hover:bg-slate-200 duration-300 transition-all shadow-[0_4px_4px_0_#00000040] rounded-full">
                                                    <img class="w-6 h-6"
                                                        src="<?php echo asset_image_path_generator() . 'faq/sparkling-line.svg' ?>"
                                                        alt="" />
                                                    <span>AI Suggestions</span>
                                                </a>
                                            </div>
                                            <img class="aspect-[2.347] object-contain"
                                                src="<?php echo asset_image_path_generator() . 'faq/Frame-2.webp' ?>"
                                                alt="Frame-2" />
                                        </div>
                                        <div class="space-y-6">
                                            <h2
                                                class="text-2xl md:text-[26px] lg:text-[31px] font-extrabold leading-[100%]">
                                                Basic Search Matching
                                            </h2>
                                            <p class="text-base font-bold leading-[145%]">
                                                Exact‑phrase and basic relevancy scoring; uses
                                                Elasticsearch to match metadata such as title,
                                                description and tags.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Q6 -->
                        <div class="">
                            <h2 id="accordion-flush-heading-6">
                                <button type="button"
                                    class="py-[9px] flex items-center justify-between space-x-4 text-start w-full border-b-[0.5px] border-white/80 cursor-pointer outline-0"
                                    data-accordion-target="#accordion-flush-body-6" aria-expanded="false"
                                    aria-controls="accordion-flush-body-6">
                                    <span class="text-xl sm:text-[22px] lg:text-[25px] font-bold leading-[120%]">
                                        Content & comparisons
                                    </span>

                                    <div class="relative w-7 md:min-w-9 lg:min-w-[42px] h-7 md:min-h-9 lg:min-h-[42px]">
                                        <img class="plusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 object-contain"
                                            src="<?php echo asset_image_path_generator() . 'faq/Plus.svg' ?>"
                                            alt="Plus Icon" />
                                        <img class="minusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 object-contain"
                                            src="<?php echo asset_image_path_generator() . 'faq/Minus.svg' ?>"
                                            alt="Minus Icon" />
                                    </div>
                                </button>
                            </h2>

                            <div id="accordion-flush-body-6" aria-labelledby="accordion-flush-heading-6"
                                class="text-sm font-normal leading-[165%] bg-white hidden">
                                <div
                                    class="flex flex-col md:flex-row justify-between md:space-y-0 space-y-[1px] space-x-0 md:space-x-[1px] text-center">
                                    <!-- left site -->
                                    <div
                                        class="px-1 sm:px-4 py-[38px] bg-[#F2F2F2] rounded-t-3xl md:rounded-t-none md:rounded-tl-3xl md:rounded-bl-3xl space-y-6">
                                        <div class="">
                                            <img class="w-[174.45px] mx-auto"
                                                src="<?php echo asset_image_path_generator() . 'faq/wpLogo.webp' ?>"
                                                alt="wpLogo" />
                                        </div>
                                        <div class="">
                                            <img class="aspect-[2.347] object-contain"
                                                src="<?php echo asset_image_path_generator() . 'faq/Frame-1.webp' ?>"
                                                alt="Frame-1" />
                                        </div>
                                        <div class="space-y-6">
                                            <h2
                                                class="text-2xl md:text-[26px] lg:text-[31px] font-extrabold leading-[100%]">
                                                Basic Search Matching
                                            </h2>
                                            <p class="text-base font-bold leading-[145%]">
                                                Exact‑phrase and basic relevancy scoring; uses
                                                Elasticsearch to match metadata such as title,
                                                description and tags.
                                            </p>
                                        </div>
                                    </div>

                                    <!-- Right site -->
                                    <div
                                        class="px-1 sm:px-4 py-[38px] bg-[#F2F2F2] rounded-b-3xl md:rounded-b-none md:rounded-tr-3xl md:rounded-br-3xl space-y-6">
                                        <div class="">
                                            <img class="w-[227px] mx-auto"
                                                src="<?php echo asset_image_path_generator() . 'logo.webp' ?>"
                                                alt="wpLogo" />
                                        </div>
                                        <div class="relative">
                                            <div
                                                class="absolute bottom-3 left-10 text-[13px] font-normal leading-[120%]">
                                                <a href=""
                                                    class="py-2 px-3 lg:p-3 flex items-center space-x-2 bg-white hover:bg-slate-200 duration-300 transition-all shadow-[0_4px_4px_0_#00000040] rounded-full">
                                                    <img class="w-6 h-6"
                                                        src="<?php echo asset_image_path_generator() . 'faq/sparkling-line.svg' ?>"
                                                        alt="" />
                                                    <span>AI Suggestions</span>
                                                </a>
                                            </div>
                                            <img class="aspect-[2.347] object-contain"
                                                src="<?php echo asset_image_path_generator() . 'faq/Frame-2.webp' ?>"
                                                alt="Frame-2" />
                                        </div>
                                        <div class="space-y-6">
                                            <h2
                                                class="text-2xl md:text-[26px] lg:text-[31px] font-extrabold leading-[100%]">
                                                Basic Search Matching
                                            </h2>
                                            <p class="text-base font-bold leading-[145%]">
                                                Exact‑phrase and basic relevancy scoring; uses
                                                Elasticsearch to match metadata such as title,
                                                description and tags.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Q7 -->
                        <div class="">
                            <h2 id="accordion-flush-heading-7">
                                <button type="button"
                                    class="py-[9px] flex items-center justify-between space-x-4 text-start w-full border-b-[0.5px] border-white/80 cursor-pointer outline-0"
                                    data-accordion-target="#accordion-flush-body-7" aria-expanded="false"
                                    aria-controls="accordion-flush-body-7">
                                    <span class="text-xl sm:text-[22px] lg:text-[25px] font-bold leading-[120%]">
                                        User engagement
                                    </span>

                                    <div class="relative w-7 md:min-w-9 lg:min-w-[42px] h-7 md:min-h-9 lg:min-h-[42px]">
                                        <img class="plusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 object-contain"
                                            src="<?php echo asset_image_path_generator() . 'faq/Plus.svg' ?>"
                                            alt="Plus Icon" />
                                        <img class="minusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 object-contain"
                                            src="<?php echo asset_image_path_generator() . 'faq/Minus.svg' ?>"
                                            alt="Minus Icon" />
                                    </div>
                                </button>
                            </h2>

                            <div id="accordion-flush-body-7" aria-labelledby="accordion-flush-heading-7"
                                class="text-sm font-normal leading-[165%] bg-white hidden">
                                <div
                                    class="flex flex-col md:flex-row justify-between md:space-y-0 space-y-[1px] space-x-0 md:space-x-[1px] text-center">
                                    <!-- left site -->
                                    <div
                                        class="px-1 sm:px-4 py-[38px] bg-[#F2F2F2] rounded-t-3xl md:rounded-t-none md:rounded-tl-3xl md:rounded-bl-3xl space-y-6">
                                        <div class="">
                                            <img class="w-[174.45px] mx-auto"
                                                src="<?php echo asset_image_path_generator() . 'faq/wpLogo.webp' ?>"
                                                alt="wpLogo" />
                                        </div>
                                        <div class="">
                                            <img class="aspect-[2.347] object-contain"
                                                src="<?php echo asset_image_path_generator() . 'faq/Frame-1.webp' ?>"
                                                alt="Frame-1" />
                                        </div>
                                        <div class="space-y-6">
                                            <h2
                                                class="text-2xl md:text-[26px] lg:text-[31px] font-extrabold leading-[100%]">
                                                Basic Search Matching
                                            </h2>
                                            <p class="text-base font-bold leading-[145%]">
                                                Exact‑phrase and basic relevancy scoring; uses
                                                Elasticsearch to match metadata such as title,
                                                description and tags.
                                            </p>
                                        </div>
                                    </div>

                                    <!-- Right site -->
                                    <div
                                        class="px-1 sm:px-4 py-[38px] bg-[#F2F2F2] rounded-b-3xl md:rounded-b-none md:rounded-tr-3xl md:rounded-br-3xl space-y-6">
                                        <div class="">
                                            <img class="w-[227px] mx-auto"
                                                src="<?php echo asset_image_path_generator() . 'logo.webp' ?>"
                                                alt="wpLogo" />
                                        </div>
                                        <div class="relative">
                                            <div
                                                class="absolute bottom-3 left-10 text-[13px] font-normal leading-[120%]">
                                                <a href=""
                                                    class="py-2 px-3 lg:p-3 flex items-center space-x-2 bg-white hover:bg-slate-200 duration-300 transition-all shadow-[0_4px_4px_0_#00000040] rounded-full">
                                                    <img class="w-6 h-6"
                                                        src="<?php echo asset_image_path_generator() . 'faq/sparkling-line.svg' ?>"
                                                        alt="" />
                                                    <span>AI Suggestions</span>
                                                </a>
                                            </div>
                                            <img class="aspect-[2.347] object-contain"
                                                src="<?php echo asset_image_path_generator() . 'faq/Frame-2.webp' ?>"
                                                alt="Frame-2" />
                                        </div>
                                        <div class="space-y-6">
                                            <h2
                                                class="text-2xl md:text-[26px] lg:text-[31px] font-extrabold leading-[100%]">
                                                Basic Search Matching
                                            </h2>
                                            <p class="text-base font-bold leading-[145%]">
                                                Exact‑phrase and basic relevancy scoring; uses
                                                Elasticsearch to match metadata such as title,
                                                description and tags.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Q8 -->
                        <div class="">
                            <h2 id="accordion-flush-heading-8">
                                <button type="button"
                                    class="py-[9px] flex items-center justify-between space-x-4 text-start w-full border-b-[0.5px] border-white/80 cursor-pointer outline-0"
                                    data-accordion-target="#accordion-flush-body-8" aria-expanded="false"
                                    aria-controls="accordion-flush-body-8">
                                    <span class="text-xl sm:text-[22px] lg:text-[25px] font-bold leading-[120%]">
                                        Business model
                                    </span>

                                    <div class="relative w-7 md:min-w-9 lg:min-w-[42px] h-7 md:min-h-9 lg:min-h-[42px]">
                                        <img class="plusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 object-contain"
                                            src="<?php echo asset_image_path_generator() . 'faq/Plus.svg' ?>"
                                            alt="Plus Icon" />
                                        <img class="minusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 object-contain"
                                            src="<?php echo asset_image_path_generator() . 'faq/Minus.svg' ?>"
                                            alt="Minus Icon" />
                                    </div>
                                </button>
                            </h2>

                            <div id="accordion-flush-body-8" aria-labelledby="accordion-flush-heading-8"
                                class="text-sm font-normal leading-[165%] bg-white hidden">
                                <div
                                    class="flex flex-col md:flex-row justify-between md:space-y-0 space-y-[1px] space-x-0 md:space-x-[1px] text-center">
                                    <!-- left site -->
                                    <div
                                        class="px-1 sm:px-4 py-[38px] bg-[#F2F2F2] rounded-t-3xl md:rounded-t-none md:rounded-tl-3xl md:rounded-bl-3xl space-y-6">
                                        <div class="">
                                            <img class="w-[174.45px] mx-auto"
                                                src="<?php echo asset_image_path_generator() . 'faq/wpLogo.webp' ?>"
                                                alt="wpLogo" />
                                        </div>
                                        <div class="">
                                            <img class="aspect-[2.347] object-contain"
                                                src="<?php echo asset_image_path_generator() . 'faq/Frame-1.webp' ?>"
                                                alt="Frame-1" />
                                        </div>
                                        <div class="space-y-6">
                                            <h2
                                                class="text-2xl md:text-[26px] lg:text-[31px] font-extrabold leading-[100%]">
                                                Basic Search Matching
                                            </h2>
                                            <p class="text-base font-bold leading-[145%]">
                                                Exact‑phrase and basic relevancy scoring; uses
                                                Elasticsearch to match metadata such as title,
                                                description and tags.
                                            </p>
                                        </div>
                                    </div>

                                    <!-- Right site -->
                                    <div
                                        class="px-1 sm:px-4 py-[38px] bg-[#F2F2F2] rounded-b-3xl md:rounded-b-none md:rounded-tr-3xl md:rounded-br-3xl space-y-6">
                                        <div class="">
                                            <img class="w-[227px] mx-auto"
                                                src="<?php echo asset_image_path_generator() . 'logo.webp' ?>"
                                                alt="wpLogo" />
                                        </div>
                                        <div class="relative">
                                            <div
                                                class="absolute bottom-3 left-10 text-[13px] font-normal leading-[120%]">
                                                <a href=""
                                                    class="py-2 px-3 lg:p-3 flex items-center space-x-2 bg-white hover:bg-slate-200 duration-300 transition-all shadow-[0_4px_4px_0_#00000040] rounded-full">
                                                    <img class="w-6 h-6"
                                                        src="<?php echo asset_image_path_generator() . 'faq/sparkling-line.svg' ?>"
                                                        alt="" />
                                                    <span>AI Suggestions</span>
                                                </a>
                                            </div>
                                            <img class="aspect-[2.347] object-contain"
                                                src="<?php echo asset_image_path_generator() . 'faq/Frame-2.webp' ?>"
                                                alt="Frame-2" />
                                        </div>
                                        <div class="space-y-6">
                                            <h2
                                                class="text-2xl md:text-[26px] lg:text-[31px] font-extrabold leading-[100%]">
                                                Basic Search Matching
                                            </h2>
                                            <p class="text-base font-bold leading-[145%]">
                                                Exact‑phrase and basic relevancy scoring; uses
                                                Elasticsearch to match metadata such as title,
                                                description and tags.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="sectionPadding">
        <div class="container">
            <div class="sectionWidth">
                <div class="-m-3 lg:-m-4">
                    <div class="flex flex-wrap justify-center">
                        <div
                            class="w-[calc(100%_-_24px)] sm:w-[calc(50%_-_24px)] lg:w-[calc(33.333333%_-_32px)] m-3 lg:m-4 space-y-6 md:space-y-8 text-base text-center font-normal leading-[160%]">
                            <div class="aspect-[1/1] bg-[#F8F8F8] rounded-3xl overflow-hidden">
                                <img src="<?php echo asset_image_path_generator() . 'works/1.png' ?>" alt="" />
                            </div>
                            <div class="space-y-2">
                                <h2 class="text-[25px] font-bold leading-[120%]">Search</h2>
                                <p>Enter your query or describe your need.</p>
                            </div>
                        </div>

                        <div
                            class="w-[calc(100%_-_24px)] sm:w-[calc(50%_-_24px)] lg:w-[calc(33.333333%_-_32px)] m-3 lg:m-4 space-y-6 md:space-y-8 text-base text-center font-normal leading-[160%]">
                            <div class="aspect-[1/1] bg-[#F8F8F8] rounded-3xl overflow-hidden">
                                <img src="<?php echo asset_image_path_generator() . 'works/2.png' ?>" alt="" />
                            </div>
                            <div class="space-y-2">
                                <h2 class="text-[25px] font-bold leading-[120%]">
                                    Discover
                                </h2>
                                <p>
                                    Let AI suggest the most relevant plugins for your website.
                                </p>
                            </div>
                        </div>

                        <div
                            class="w-[calc(100%_-_24px)] sm:w-[calc(50%_-_24px)] lg:w-[calc(33.333333%_-_32px)] m-3 lg:m-4 space-y-6 md:space-y-8 text-base text-center font-normal leading-[160%]">
                            <div class="aspect-[1/1] bg-[#F8F8F8] rounded-3xl overflow-hidden">
                                <img src="<?php echo asset_image_path_generator() . 'works/3.png' ?>" alt="" />
                            </div>
                            <div class="space-y-2">
                                <h2 class="text-[25px] font-bold leading-[120%]">
                                    Download
                                </h2>
                                <p>Click through to WordPress.org for easy installation.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="sectionPadding w-full h-full bg-gradient-to-b from-[#A4E4FF] to-[#ffffff]">
        <div class="space-y-10 lg:space-y-[60px]">
            <h2 class="text-3xl md:text-4xl lg:text-[49px] text-center font-bold leading-[120%] px-4">
                Everyone was happy
            </h2>

            <div class="space-y-6 lg:space-y-8 text-base font-normal leading-[160%]">
                <!-- top slider -->
                <div class="slider-wrapper w-full relative overflow-hidden">
                    <div class="slider-track flex items-end space-x-6 lg:space-x-8 will-change-transform">
                        <div class="slide">
                            <div class="p-8 space-y-8 bg-[var(--theme-white)] border border-[#F8F8F8] rounded-[12px]">
                                <p>
                                    "Before WPSearch.ai, I wasted hours researching plugins.
                                    Now I can get accurate suggestions in seconds."
                                </p>
                                <div class="flex space-x-3">
                                    <div
                                        class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] bg-[#02AAF2] rounded-full overflow-hidden">
                                        <img class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] object-contain object-center"
                                            src="<?php echo asset_image_path_generator() . 'profile/1.webp' ?>"
                                            alt="Profile-Image" />
                                    </div>

                                    <div class="space-y-2">
                                        <h2 class="font-bold">Sarah T.</h2>
                                        <p class="text-[13px] leading-[120%]">
                                            WordPress Developer at CNN
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="slide">
                            <div class="p-8 space-y-8 bg-[var(--theme-white)] border border-[#F8F8F8] rounded-[12px]">
                                <p>
                                    "I described what I needed in plain language, and
                                    WPSearch.ai nailed it. This is the future of WordPress
                                    plugin discovery."
                                </p>
                                <div class="flex space-x-3">
                                    <div
                                        class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] bg-gray-500 rounded-full overflow-hidden">
                                        <img class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] object-contain object-center"
                                            src="<?php echo asset_image_path_generator() . 'profile/profile-1.webp' ?>"
                                            alt="Profile-Image" />
                                    </div>

                                    <div class="space-y-2">
                                        <h2 class="font-bold">Tony Michael</h2>
                                        <p class="text-[13px] leading-[120%]">
                                            Web Developer at TNW
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="slide">
                            <div class="p-8 space-y-8 bg-[var(--theme-white)] border border-[#F8F8F8] rounded-[12px]">
                                <p>
                                    "As someone new to WordPress, this tool has been a
                                    lifesaver. It’s so intuitive and easy to use."
                                </p>
                                <div class="flex space-x-3">
                                    <div
                                        class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] bg-[#EB4335] rounded-full overflow-hidden">
                                        <img class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] object-contain object-center"
                                            src="<?php echo asset_image_path_generator() . 'profile/3.webp' ?>"
                                            alt="Profile-Image" />
                                    </div>

                                    <div class="space-y-2">
                                        <h2 class="font-bold">Lookman</h2>
                                        <p class="text-[13px] leading-[120%]">
                                            Senior Web Developer at Meta
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="slide">
                            <div class="p-8 space-y-8 bg-[var(--theme-white)] border border-[#F8F8F8] rounded-[12px]">
                                <p>
                                    "I’ve been a WordPress user for years, and WPSearch.ai is
                                    by far the quickest way to find the plugins I need."
                                </p>
                                <div class="flex space-x-3">
                                    <div
                                        class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] bg-[#FBBC05] rounded-full overflow-hidden">
                                        <img class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] object-contain object-center"
                                            src="<?php echo asset_image_path_generator() . 'profile/4.webp' ?>"
                                            alt="Profile-Image" />
                                    </div>

                                    <div class="space-y-2">
                                        <h2 class="font-bold">Sydney S.</h2>
                                        <p class="text-[13px] leading-[120%]">
                                            WordPress Developer at CNN
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- bottom slider -->
                <div class="slider-wrapper slider-wrapper2 w-full relative overflow-hidden">
                    <div class="slider-track flex items-start space-x-6 lg:space-x-8 will-change-transform">
                        <div class="slide">
                            <div class="p-8 space-y-8 bg-[var(--theme-white)] border border-[#F8F8F8] rounded-[12px]">
                                <p>
                                    "I’ve tried other search tools, but WPSearch.ai stands out
                                    for its precision and AI-powered insights."
                                </p>
                                <div class="flex space-x-3">
                                    <div
                                        class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] bg-gray-500 rounded-full overflow-hidden">
                                        <img class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] object-contain object-center"
                                            src="<?php echo asset_image_path_generator() . 'profile/1.webp' ?>"
                                            alt="Profile-Image" />
                                    </div>

                                    <div class="space-y-2">
                                        <h2 class="font-bold">Sarah T.</h2>
                                        <p class="text-[13px] leading-[120%]">
                                            WordPress Developer at CNN
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="slide">
                            <div class="p-8 space-y-8 bg-[var(--theme-white)] border border-[#F8F8F8] rounded-[12px]">
                                <p>
                                    "This platform has redefined how I find plugins. It’s
                                    fast, accurate, and super easy to navigate."
                                </p>
                                <div class="flex space-x-3">
                                    <div
                                        class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] bg-[#A1A7B1] rounded-full overflow-hidden">
                                        <img class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] object-contain object-center"
                                            src="<?php echo asset_image_path_generator() . 'profile/b2.webp' ?>"
                                            alt="Profile-Image" />
                                    </div>

                                    <div class="space-y-2">
                                        <h2 class="font-bold">Aisyah M.</h2>
                                        <p class="text-[13px] leading-[120%]">
                                            CTO at AWWWARDS
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="slide">
                            <div class="p-8 space-y-8 bg-[var(--theme-white)] border border-[#F8F8F8] rounded-[12px]">
                                <p>
                                    "I had a very specific requirement, and WPSearch.ai found
                                    the exact plugin I needed. Highly recommend it."
                                </p>
                                <div class="flex space-x-3">
                                    <div
                                        class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] bg-[#FBBC05] rounded-full overflow-hidden">
                                        <img class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] object-contain object-center"
                                            src="<?php echo asset_image_path_generator() . 'profile/b3.webp' ?>"
                                            alt="Profile-Image" />
                                    </div>

                                    <div class="space-y-2">
                                        <h2 class="font-bold">Niang</h2>
                                        <p class="text-[13px] leading-[120%]">
                                            WordPress Developer at TechCrunch
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="slide">
                            <div class="p-8 space-y-8 bg-[var(--theme-white)] border border-[#F8F8F8] rounded-[12px]">
                                <p>
                                    "Outstanding platform with powerful tools. I love how
                                    user-friendly WPSearch.ai is. Whether you’re technical or
                                    not, it just works."
                                </p>
                                <div class="flex space-x-3">
                                    <div
                                        class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] bg-[#02AAF2] rounded-full overflow-hidden">
                                        <img class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] object-contain object-center"
                                            src="<?php echo asset_image_path_generator() . 'profile/b4.webp' ?>"
                                            alt="Profile-Image" />
                                    </div>

                                    <div class="space-y-2">
                                        <h2 class="font-bold">Benny Dolo</h2>
                                        <p class="text-[13px] leading-[120%]">
                                            Software Engineer at Spotify
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="slide">
                            <div class="p-8 space-y-8 bg-[var(--theme-white)] border border-[#F8F8F8] rounded-[12px]">
                                <p>
                                    "WPSearch.ai not only helps me find plugins but also
                                    provides useful insights that save me from trial and
                                    error."
                                </p>
                                <div class="flex space-x-3">
                                    <div
                                        class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] bg-[#EB4335] rounded-full overflow-hidden">
                                        <img class="w-[46px] h-[46px] min-w-[46px] min-h-[46px] object-contain object-center"
                                            src="<?php echo asset_image_path_generator() . 'profile/b4.webp' ?>"
                                            alt="Profile-Image" />
                                    </div>

                                    <div class="space-y-2">
                                        <h2 class="font-bold">Harry J.</h2>
                                        <p class="text-[13px] leading-[120%]">
                                            Digital Marketer at Playstation
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="sectionPaddingBottom">
        <div class="container">
            <div class="sectionWidth">
                <div
                    class="px-7 p-10 lg:p-[60px] flex lg:flex-row flex-col justify-between items-center text-center lg:text-start bg-[#A5E4FF] rounded-[32px] space-y-6 lg:space-y-0 lg:space-x-8">
                    <div class="space-y-3">
                        <h2 class="text-3xl lg:text-[39px] font-bold leading-[120%]">
                            Join thousands of wordpress enthusiasts
                        </h2>
                        <p class="text-base font-normal leading-[160%]">
                            Find the best WordPress plugins tailored to your needs with
                            the power of AI.
                        </p>
                    </div>
                    <a href=""
                        class="py-4 lg:py-[21px] px-8 text-base leading-[160%] font-bold text-[var(--theme-white)] bg-gradient-to-r from-[#1C37D1] to-[#0E70DD] hover:opacity-80 duration-300 rounded-[54px] whitespace-nowrap">
                        Start Searching Now
                    </a>
                </div>
            </div>
        </div>
    </section>
</main>
<?php
get_footer();