<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package wpsearch
 */

?>

<footer class="sectionPadding font-normal text-white/80 bg-black">
	<div class="container">
		<div class="sectionWidth">
			<div
				class="flex justify-between flex-wrap pb-10 md:pb-[60px] border-b border-[#FFFFFF1F] sm:space-y-10 lg:space-y-0">
				<!-- Column 1: Logo / Info -->
				<div class="w-full lg:w-[24.5%] mb-12 sm:mb-0">
					<div class="space-y-6 sm:space-y-8 flex flex-col text-center lg:text-start">
						<a href="index.html" class="mx-auto lg:mx-0">
							<img class="w-[226.99px] object-contain object-center"
								src="<?php echo asset_image_path_generator().'footerLogo.webp'?>" />
						</a>
						<p class="max-w-[600px] mx-auto text-[13px] text-[#FFFFFFCC] leading-[120%]">
							With AI and comprehensive index of plugins from WordPress.org,
							we provide tailored recommendations to help you build the
							perfect WordPress site effortlessly.
						</p>
					</div>
				</div>

				<!-- Column 2: Popular -->
				<div class="w-full sm:w-[50%] md:w-[191px] text-sm md:text-base leading-[160%] whitespace-nowrap">
					<h3 class="text-white font-bold mb-[21px]">Popular Categories</h3>
					<div class="flex flex-col">
						<a href="#" class="py-1 md:py-[6px] hover:text-white duration-300">
							SEO
						</a>
						<a href="#" class="py-1 md:py-[6px] hover:text-white duration-300">
							Security Tools
						</a>
						<a href="#" class="py-1 md:py-[6px] hover:text-white duration-300">
							E-commerce
						</a>
						<a href="#" class="py-1 md:py-[6px] hover:text-white duration-300">
							Page Builders
						</a>
						<a href="#" class="py-1 md:py-[6px] hover:text-white duration-300">
							Social Media Integrations
						</a>
					</div>
				</div>

				<!-- Column 3:  -->
				<div
					class="w-full sm:w-[50%] md:w-[208px] text-sm md:text-base leading-[160%] whitespace-nowrap mb-12 sm:mb-0">
					<h3 class="text-white font-bold mb-[21px]">&nbsp;</h3>
					<div class="flex flex-col">
						<a href="#" class="py-1 md:py-[6px] hover:text-white duration-300">Analytics & Reporting</a>
						<a href="#" class="py-1 md:py-[6px] hover:text-white duration-300">Image Optimization</a>
						<a href="#" class="py-1 md:py-[6px] hover:text-white duration-300">Contact Form Builders</a>
						<a href="#" class="py-1 md:py-[6px] hover:text-white duration-300">Membership & Subscription</a>
						<a href="#" class="py-1 md:py-[6px] hover:text-white duration-300">Backup & Restore Tools</a>
					</div>
				</div>

				<!-- Column 4: Quick Links -->
				<div
					class="w-full sm:w-[50%] md:w-[121px] text-sm md:text-base leading-[160%] whitespace-nowrap mb-12 sm:mb-0">
					<h3 class="text-white font-bold mb-[21px]">Quick Links</h3>
					<div class="flex flex-col">
						<a href="#" class="py-1 md:py-[6px] hover:text-white duration-300">Home</a>
						<a href="#" class="py-1 md:py-[6px] hover:text-white duration-300">Discover</a>
						<a href="#" class="py-1 md:py-[6px] hover:text-white duration-300">Plugin Category</a>
						<a href="#" class="py-1 md:py-[6px] hover:text-white duration-300">FAQs</a>
						<a href="#" class="py-1 md:py-[6px] hover:text-white duration-300">About</a>
					</div>
				</div>

				<!-- Column 5: Stay Connected -->
				<div class="w-full sm:w-[50%] md:w-[126px] text-sm md:text-base leading-[160%] whitespace-nowrap">
					<h3 class="text-white font-bold mb-6">Stay Connected</h3>
					<div class="space-y-3">
						<a href="#" class="flex items-center gap-3 hover:text-white duration-300">
							<img class="w-[18px] h-[18px]" src="<?php echo asset_image_path_generator().'social/twitter.svg'?>" alt="X icon" />
							<span>X</span>
						</a>

						<a href="#" class="flex items-center gap-3 hover:text-white duration-300">
							<img class="w-[18px] h-[18px]" src="<?php echo asset_image_path_generator().'social/Instagram.svg'?>" alt="" />
							<span>Instagram</span>
						</a>
						<a href="#" class="flex items-center gap-3 hover:text-white duration-300">
							<img class="w-[18px] h-[18px]" src="<?php echo asset_image_path_generator().'social/Facebook.svg'?>" alt="" />
							<span>Facebook</span>
						</a>
						<a href="#" class="flex items-center gap-3 hover:text-white duration-300">
							<img class="w-[18px] h-[18px]" src="<?php echo asset_image_path_generator().'social/LinkedIn.svg'?>" alt="" />
							<p>LinkedIn</p>
						</a>
					</div>
				</div>
			</div>

			<div class="pt-10 md:pt-[60px]">
				<div
					class="flex flex-wrap flex-col sm:flex-row justify-between items-center text-[13px] text-[#FFFFFF66] leading-[120%] space-x-0 sm:space-x-3 space-y-3 sm:space-y-0">
					<p>© 2024 WPSearch.ai. All rights reserved.</p>
					<div class="flex flex-wrap space-x-[30px] lg:space-x-[60px]">
						<a href="#" class="hover:text-white duration-500">Privacy Policy</a>
						<a href="#" class="hover:text-white duration-500">Terms of Service</a>
					</div>
				</div>
			</div>
		</div>
	</div>
</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>