document.addEventListener("DOMContentLoaded", function () {
  // ----- MOBILE SIDEBAR -----
  const menuBtn = document.getElementById("mobileMenuBtn");
  const sidebar = document.getElementById("mobileSidebar");
  const closeBtn = document.getElementById("closeSidebar");
  const overlay = document.getElementById("overlay");

  function openSidebar() {
    if (!sidebar || !overlay) return;
    sidebar.classList.remove("translate-x-full");
    overlay.classList.remove("hidden");
    setTimeout(() => (overlay.style.opacity = "1"), 10);
    document.body.style.overflow = "hidden";
  }

  function closeSidebar() {
    if (!sidebar || !overlay) return;
    sidebar.classList.add("translate-x-full");
    overlay.style.opacity = "0";
    setTimeout(() => overlay.classList.add("hidden"), 500);
    document.body.style.overflow = "";
  }

  menuBtn?.addEventListener("click", openSidebar);
  closeBtn?.addEventListener("click", closeSidebar);
  overlay?.addEventListener("click", closeSidebar);

  // Submenu toggle
  document.querySelectorAll("[data-toggle='submenu']").forEach((btn) => {
    btn.addEventListener("click", () => {
      const submenu = btn.nextElementSibling;
      const arrow = btn.querySelector("svg");
      submenu?.classList.toggle("hidden");
      arrow?.classList.toggle("rotate-180");
    });
  });

  // Auto close sidebar on large screens
  window.addEventListener("resize", () => {
    if (window.innerWidth >= 1024 && sidebar && !sidebar.classList.contains("translate-x-full")) {
      closeSidebar();
    }
  });

  // ----- SLIDER 2: "Everyone was happy" -----
  const allWrappers = document.querySelectorAll(".slider-wrapper");
  allWrappers.forEach((wrapper) => {
    const track = wrapper.querySelector(".slider-track");
    if (!track) return;

    let paused = false;
    let speed = 0.7;
    let position = 0;

    function ensureClones() {
      const wrapperWidth = wrapper.offsetWidth;
      let totalWidth = track.scrollWidth;
      while (totalWidth < wrapperWidth * 2) {
        track.innerHTML += track.innerHTML;
        totalWidth = track.scrollWidth;
      }
    }

    ensureClones();

    function animate() {
      if (!paused) {
        position -= speed;
        if (Math.abs(position) >= track.scrollWidth / 2) position = 0;
        track.style.transform = `translateX(${position}px)`;
      }
      requestAnimationFrame(animate);
    }

    wrapper.addEventListener("mouseenter", () => (paused = true));
    wrapper.addEventListener("mouseleave", () => (paused = false));

    window.addEventListener("resize", () => {
      position = 0;
      track.style.transform = "";
      const allSlides = track.querySelectorAll(".slide");
      const unique = Array.from(allSlides)
        .slice(0, allSlides.length / 2)
        .map((s) => s.outerHTML)
        .join("");
      track.innerHTML = unique;
      ensureClones();
    });

    animate();
  });

  // ----- TABS -----
  const tabs = document.querySelectorAll(".tabBtnPlugin");
  const contents = document.querySelectorAll(".tabContentPlugin");

  if (tabs.length && contents.length) {
    tabs.forEach((tab) => {
      tab.addEventListener("click", () => {
        const target = tab.getAttribute("data-tab");
        if (!target) return;

        tabs.forEach((t) => {
          t.classList.remove("border-[#1A2DC9]", "text-[#1A1A1A]", "font-bold");
          t.classList.add("border-transparent", "text-[#A1A7B1]", "font-normal");
        });

        contents.forEach((c) => c.classList.add("hidden"));

        tab.classList.add("border-[#1A2DC9]", "text-[#1A1A1A]", "font-bold");
        tab.classList.remove("border-transparent", "text-[#A1A7B1]", "font-normal");

        const contentEl = document.getElementById(target);
        contentEl?.classList.remove("hidden");
      });
    });
  }

  // ----- SINGLE PLUGIN PAGE SLIDER -----
  const sliderWrapperPlugin = document.getElementById("sliderWrapperPlugin");
  if (sliderWrapperPlugin) {
    const slides = sliderWrapperPlugin.children;
    const totalSlides = slides.length;
    if (totalSlides === 0) return;

    const prevBtn = document.getElementById("prevBtn");
    const nextBtn = document.getElementById("nextBtn");
    const dotsContainerPlugin = document.getElementById("dotsContainerPlugin");
    if (!dotsContainerPlugin) return;

    let currentSlide = 0;

    // Create dots dynamically
    for (let i = 0; i < totalSlides; i++) {
      const dot = document.createElement("span");
      dot.className =
        "w-3 h-3 rounded-full cursor-pointer transition-all duration-300 " +
        (i === 0 ? "bg-[#1A2DC9]" : "bg-[#E3E5E7]");
      dot.dataset.index = i;
      dot.addEventListener("click", () => goToSlide(i));
      dotsContainerPlugin.appendChild(dot);
    }

    const dots = dotsContainerPlugin.querySelectorAll("span");

    function updateSlider() {
      sliderWrapperPlugin.style.transform = `translateX(-${currentSlide * 100}%)`;
      dots.forEach((dot, index) => {
        dot.className =
          "w-3 h-3 rounded-full cursor-pointer transition-all duration-300 " +
          (index === currentSlide ? "bg-[#1A2DC9]" : "bg-[#E3E5E7]");
      });
    }

    function goToSlide(index) {
      currentSlide = index;
      updateSlider();
    }

    function nextSlide() {
      currentSlide = (currentSlide + 1) % totalSlides;
      updateSlider();
    }

    function prevSlide() {
      currentSlide = (currentSlide - 1 + totalSlides) % totalSlides;
      updateSlider();
    }

    nextBtn?.addEventListener("click", nextSlide);
    prevBtn?.addEventListener("click", prevSlide);

    // Optional: auto-slide every 5 seconds
    // const autoSlide = setInterval(nextSlide, 5000);
  }
});
