<?php
global $wpdb;
$table_cron_page_visits = $wpdb->prefix . "cron_page_visits_log";
$table_cron_scraped_plugins = $wpdb->prefix . "cron_scraped_plugins_log";
$tbl_plugins_core_information = $wpdb->prefix . "plugins_core_information";

$latest_last_visited_from_cron_page_visits_log = $wpdb->get_var(
    "SELECT last_visited_at FROM {$table_cron_page_visits} ORDER BY last_visited_at DESC LIMIT 1"
);

$latest_last_scraped_at_from_cron_scraped_plugins_log = $wpdb->get_var(
    "SELECT last_scraped_at FROM {$table_cron_scraped_plugins} ORDER BY last_scraped_at DESC LIMIT 1"
);


?>
<style>
    <style>

    /* Cron Job List Table Styling */
    .wrap {
        font-family: "Open Sans", Arial, sans-serif;
        max-width: 900px;
        margin-top: 20px;
    }

    .wrap h1 {
        margin-bottom: 25px;
        font-size: 24px;
        color: #23282d;
    }

    /* Table base */
    .wrap table {
        width: 100%;
        border-collapse: collapse;
        background: #fff;
        border: 1px solid #ccd0d4;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
    }

    /* Header */
    .wrap table thead {
        background: #f6f7f7;
    }

    .wrap table thead th {
        text-align: left;
        padding: 12px 15px;
        font-weight: 600;
        color: #23282d;
        border-bottom: 1px solid #ccd0d4;
    }

    /* Table body rows */
    .wrap table tbody tr:nth-child(even) {
        background-color: #fbfbfb;
    }

    .wrap table tbody th {
        padding: 12px 15px;
        font-weight: 400;
        border-bottom: 1px solid #eee;
        vertical-align: middle;
    }

    /* Links */
    .wrap table a {
        color: #2271b1;
        text-decoration: none;
        font-weight: 500;
    }

    .wrap table a:hover {
        color: #135e96;
        text-decoration: underline;
    }

    /* Highlight "Run Now" links as buttons */
    .wrap table tbody a {
        display: inline-block;
        background: #2271b1;
        color: #fff;
        padding: 6px 12px;
        border-radius: 4px;
        font-weight: 500;
        text-decoration: none;
        transition: background 0.2s ease;
    }

    .wrap table tbody a:hover {
        background: #135e96;
    }
</style>
<div class="wrap">
    <h1>Cron Job List</h1>
    <table>
        <tr>
            <th>Job Purpose</th>
            <th>Job Manual link</th>
            <th>Job last run</th>
        </tr>
        <tbody>
            <tr>
                <th>Update the plugin Active installation Work in Chunk data</th>
                <th><a target="_blank"
                        href="<?php echo site_url() . '/cron-management/wp-active-installation-count-json-chunk.php' ?>">Run
                        Now</a></th>
                <th><?php echo $latest_last_visited_from_cron_page_visits_log ?></th>
            </tr>
            <tr>
                <th>Checking Cron Flag, Update the Flag , Ensure every plugin Run Once in 7 days</th>
                <th><a target="_blank"
                        href="<?php echo site_url() . '/cron-management/wp-manage-scrapp-flag.php' ?>">Run Now</a></th>
                <th><?php echo get_option('reset_cron_flag_job_run'); ?></th>
            </tr>
            <tr>
                <th>API scrapp and Web Scrapp Every Single Plugin</th>
                <th><a target="_blank"
                        href="<?php echo site_url() . '/cron-management/wp-plugin-directory-single-plugin-api-call.php' ?>">Run
                        Now</a></th>
                <th><?php echo $latest_last_scraped_at_from_cron_scraped_plugins_log ?></th>
            </tr>
            <tr>
                <th>Update Plugin Last update day count and Age of the plugin</th>
                <th><a target="_blank"
                        href="<?php echo site_url() . '/cron-management/wp-plugin-age-calculation-job.php' ?>">Run
                        Now</a></th>
                <th><?php echo get_option('wp_plugin_age_calculation_job_last_run') ?></th>
            </tr>
            <tr>
                <th>Update Plugin Package Size in KB plugin</th>
                <th><a target="_blank"
                        href="<?php echo site_url() . '/cron-management/wp-plugin-size-getting-job.php' ?>">Run
                        Now</a></th>
                <th><?php echo get_option('wp_plugin_size_getting_job_last_run') ?></th>
            </tr>
            <tr>
                <th>Generate AI description</th>
                <th><a target="_blank"
                        href="<?php echo site_url() . '/cron-management/wp-plugin-ai-description.php' ?>">Run
                        Now</a></th>
                <th><?php echo get_option('wp_plugin_size_getting_job_last_run') ?></th>
            </tr>
            <tr>
                <th>Wordpress Post Create</th>
                <th><a target="_blank"
                        href="<?php echo site_url() . '/cron-management/wp-generate-post.php' ?>">Run
                        Now</a></th>
                <th><?php echo get_option('wp_plugin_size_getting_job_last_run') ?></th>
            </tr>
        </tbody>
    </table>