<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<div class="wrap">
    <div style="display:flex;align-items:center;justify-content:space-between;">
        <h1 style="display:flex;align-items:center;gap:10px;">
            <span class="dashicons dashicons-admin-plugins"></span>
            <?php echo esc_html($plugin['name'] ?? 'Plugin Details'); ?>
        </h1>
        <div>
            <!-- ✅ Button group -->
            <button type="button" class="button button-primary" data-bs-toggle="modal"
                data-bs-target="#editMetricModal">
                Edit Metric Information
            </button>
            <a href="<?php echo esc_url(admin_url("admin.php?page=plugin-faq-log-details&slug={$slug}")); ?>"
                class="button button-secondary">Faq details</a>
            <a href="<?php echo esc_url(admin_url("admin.php?page=plugin-review-log-details&slug={$slug}")); ?>"
                class="button button-secondary">Review details</a>
        </div>
    </div>

    <?php
    $image = !empty($plugin['plugin_feature_image'])
        ? $plugin['plugin_feature_image']
        : get_plugin_icon_by_slug($slug);
    ?>

    <?php if (!empty($image)): ?>
        <div style="margin:20px 0;">
            <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr($plugin['name'] ?? ''); ?>"
                style="width:120px;height:120px;object-fit:contain;border-radius:8px;border:1px solid #ddd;">
        </div>
    <?php else: ?>
        <p style="color:#aaa;">No image available</p>
    <?php endif; ?>

    <table class="widefat striped" style="margin-top:20px; width:100%;">
        <thead>
            <tr>
                <th style="width:20%; min-width:180px;">Field</th>
                <th>Value</th>
            </tr>
        </thead>
        <tbody>
            <?php
            foreach ($plugin as $key => $value) {
                $label = ucwords(str_replace('_', ' ', $key));
                if ($key == "wp_post_id" && !empty($value)) {
                    $value = get_the_permalink($value);
                }
                if (is_null($value) || $value === '') {
                    $display = '<span style="color:#aaa;">—</span>';
                } elseif (filter_var($value, FILTER_VALIDATE_URL)) {
                    $display = '<a href="' . esc_url($value) . '" target="_blank">' . esc_html($value) . '</a>';
                } else {
                    $display = nl2br(esc_html($value));
                }
                echo '<tr>';
                echo '<th style="text-transform:capitalize;">' . esc_html($label) . '</th>';
                echo '<td>' . $display . '</td>';
                echo '</tr>';
            }
            ?>
        </tbody>
    </table>

    <p style="margin-top:25px;">
        <a href="<?php echo esc_url(admin_url('admin.php?page=plugin-scrap-logs')); ?>" class="button">← Back to
            List</a>
    </p>
</div>

<!-- ✅ Bootstrap Modal -->
<div class="modal fade" id="editMetricModal" tabindex="-1" aria-labelledby="editMetricLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <form method="post" id="updateMetricForm">
                <div class="modal-header">
                    <h5 class="modal-title" id="editMetricLabel">Edit Metric Information</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-body">
                    <div class="row g-3">
                        <?php
                        $numeric_fields = [
                            'update_activity_score',
                            //'plugin_age_days',
                            'maturity_score',
                            //'package_size_kb',
                            'size_penalty_score',
                            'localization_score',
                            'gutenberg_bonus_score',
                            'vulnerability_count',
                            'avg_patch_response_days',
                            'security_score',
                            'code_quality_score',
                            'cyclomatic_complexity_avg',
                            'developer_reputation_score',
                            'license_clarity_score',
                            'overall_wpscore'
                        ];
                        $select_fields = [
                            'gutenberg_support' => ['1' => 'Yes', '0' => 'No'],
                            'license_type' => [
                                'free' => 'Free',
                                'freemium' => 'Freemium',
                                'paid' => 'Paid',
                                'unknown' => 'Unknown'
                            ],
                            'support_quality' => [
                                '1' => 'Excellent',
                                '2' => 'Good',
                                '3' => 'Fair',
                                '4' => 'Poor',
                            ],
                            'performance_impact' => [
                                '1' => 'Low',
                                '2' => 'Medium',
                                '3' => 'High',
                            ],
                            'user_review_sentiment' => [
                                '1' => 'Negative',
                                '2' => 'Neutral',
                                '3' => 'Positive',
                            ],
                            'seo_impact' => [
                                '1' => 'Positive',
                                '2' => 'Neutral',
                                '3' => 'Negative',
                            ],
                            'is_sponsored' => [
                                '1' => 'Default',
                                '2' => 'Sponsored'
                            ],
                            'is_recreate_ai_post' => [
                                '0' => 'No',
                                '1' => 'Yes'
                            ],
                        ];

                        foreach ($numeric_fields as $field) {
                            $value = esc_attr($plugin[$field] ?? '');
                            echo '
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold text-capitalize">' . str_replace('_', ' ', $field) . '</label>
                                    <input type="number" step="any" name="' . esc_attr($field) . '" value="' . $value . '" class="form-control" placeholder="Enter ' . str_replace('_', ' ', $field) . '">
                                </div>';
                        }

                        foreach ($select_fields as $field => $options) {
                            $current = $plugin[$field] ?? '';
                            echo '<div class="col-md-6">
                                    <label class="form-label fw-semibold text-capitalize">' . str_replace('_', ' ', $field) . '</label>
                                    <select name="' . esc_attr($field) . '" class="form-select">';
                            foreach ($options as $val => $label) {
                                printf('<option value="%s" %s>%s</option>', esc_attr($val), selected($current, $val, false), esc_html($label));
                            }
                            echo '</select></div>';
                        }
                       
                        ?>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    (function ($) {
        $('#updateMetricForm').on('submit', function (e) {
            e.preventDefault();
            const formData = $(this).serialize() + '&action=update_plugin_metrics&slug=<?php echo esc_js($slug); ?>';
            $.post(ajaxurl, formData, function (response) {
                if (response.success) {
                    alert('Metrics updated successfully!');
                    location.reload();
                } else {
                    alert('Update failed: ' + response.data);
                }
            });
        });
    })(jQuery);
</script>
<?php

