<style>
    /* Reset box-sizing for consistency */
    *,
    *::before,
    *::after {
        box-sizing: border-box;
    }

    /* Container with flex */
    .wpaisearch-row {
        display: flex;
        flex-wrap: wrap;
        margin-left: -0.5rem;
        margin-right: -0.5rem;
    }

    /* Base column styles */
    .wpaisearch-col-md-6,
    .wpaisearch-col-md-12 {
        padding-left: 0.5rem;
        padding-right: 0.5rem;
        width: 100%;
        box-sizing: border-box;
    }

    /* Medium screens and up - side by side */
    @media (min-width: 768px) {
        .wpaisearch-col-md-6 {
            width: 50%;
            max-width: 50%;
        }

        .wpaisearch-col-md-12 {
            width: 100%;
            max-width: 100%;
        }
    }

    /* Spacing */
    .wpaisearch-mb-3 {
        margin-bottom: 1rem;
    }

    .wpaisearch-g-3>* {
        margin-top: 1rem;
    }

    /* Form elements */
    .wpaisearch-form-label {
        margin-bottom: 0.5rem;
        display: block;
        font-weight: 600;
    }

    .wpaisearch-fw-semibold {
        font-weight: 600;
    }

    .wpaisearch-text-capitalize {
        text-transform: capitalize;
    }

    .wpaisearch-form-control,
    .wpaisearch-form-select {
        display: block;
        width: 100%;
        padding: 0.375rem 0.75rem;
        font-size: 1rem;
        font-weight: 400;
        line-height: 1.5;
        color: #212529;
        background-color: #fff;
        border: 1px solid #ced4da;
        border-radius: 0.375rem;
        box-sizing: border-box;
    }

    .wpaisearch-form-control:focus,
    .wpaisearch-form-select:focus {
        color: #212529;
        background-color: #fff;
        border-color: #86b7fe;
        outline: 0;
        box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, .25);
    }

    .wpaisearch-form-control::placeholder {
        color: #6c757d;
        opacity: 1;
    }

    .wpaisearch-form-control:disabled,
    .wpaisearch-form-control[readonly] {
        background-color: #e9ecef;
        opacity: 1;
    }

    .wpaisearch-form-select {
        padding-right: 2.25rem;
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m2 5 6 6 6-6'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 0.75rem center;
        background-size: 16px 12px;
        appearance: none;
        -webkit-appearance: none;
        -moz-appearance: none;
    }
</style>
<?php
global $wpdb;
$table = $wpdb->prefix . 'plugins_core_information';
$plugin = $wpdb->get_row(
    $wpdb->prepare("SELECT * FROM $table WHERE wp_post_id = %d LIMIT 1", get_the_ID()),
    ARRAY_A
);

?>


<div class="wpaisearch-row wpaisearch-g-3">
    <?php
    $readonly_numeric = ["active_installs", "rating", "num_ratings", "support_threads", "support_threads_resolved", "plugin_age_days", "package_size_kb"];
    $numeric_fields = [
        'update_activity_score',
        'maturity_score',
        'size_penalty_score',
        'localization_score',
        'gutenberg_bonus_score',
        'vulnerability_count',
        'avg_patch_response_days',
        'security_score',
        'code_quality_score',
        'cyclomatic_complexity_avg',
        'developer_reputation_score',
        'license_clarity_score',
        'overall_wpscore'
    ];
    $select_fields = [
        'gutenberg_support' => ['1' => 'Yes', '0' => 'No'],
        // 'is_ai_meta_keywords_done' => ['1' => 'Yes', '0' => 'No'],
        'license_type' => [
            'free' => 'Free',
            'freemium' => 'Freemium',
            'paid' => 'Paid',
            'unknown' => 'Unknown'
        ],
        'support_quality' => [
            '1' => 'Excellent',
            '2' => 'Good',
            '3' => 'Fair',
            '4' => 'Poor',
        ],
        'performance_impact' => [
            '1' => 'Low',
            '2' => 'Medium',
            '3' => 'High',
        ],
        'user_review_sentiment' => [
            '1' => 'Negative',
            '2' => 'Neutral',
            '3' => 'Positive',
        ],
        'seo_impact' => [
            '1' => 'Positive',
            '2' => 'Neutral',
            '3' => 'Negative',
        ],
        'is_sponsored' => [
            '1' => 'Default',
            '2' => 'Sponsored'
        ],
    ];


    $plugin_icon = get_plugin_icon_by_slug($plugin["slug"]);
    $plugin_image = $plugin["plugin_feature_image"];
    $plugin_video = $plugin["plugin_video"];
    $plugin_author_name = $plugin["author_name"];
    $plugin_profile_url = $plugin["author_profile"];
    $plugin_tags = $plugin["plugin_tags"];
    $plugin_keywords = $plugin["plugin_feature_meta_key_word_ai"];
    ?>
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Icon</label>
        <input type="text" class="wpaisearch-form-control" name="" value="<?php echo esc_attr($plugin_icon); ?>"
            placeholder="Image URL" readonly>
        <?php if ($plugin_icon): ?>
            <img src="<?php echo esc_url($plugin_icon); ?>"
                style="max-width:80px;margin-top:10px;border:1px solid #ddd;padding:4px;">
        <?php endif; ?>
    </div>

    <!-- Plugin Feature Image -->
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Feature Image</label>
        <input type="text" class="wpaisearch-form-control" name="" value="<?php echo esc_attr($plugin_image); ?>"
            placeholder="Image URL" readonly>
        <?php if ($plugin_image): ?>
            <img src="<?php echo esc_url($plugin_image); ?>"
                style="max-width:400px;margin-top:10px;border:1px solid #ddd;padding:4px;">
        <?php endif; ?>
    </div>

    <!-- Video -->
    <div class="wpaisearch-col-md-12 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Feature Video (YouTube URL)</label>
        <input type="text" class="wpaisearch-form-control" name="" value="<?php echo esc_attr($plugin_video); ?>"
            placeholder="YouTube URL" readonly>

        <?php if ($plugin_video):
            $yt_id = preg_replace('/^.*(youtu.be\/|v=)([^#\&\?]*).*/', '$2', $plugin_video);
            ?>
            <iframe style="width:100%;height:300px;border:1px solid #ddd;" src="<?php echo esc_url($plugin_video); ?>"
                allowfullscreen>
            </iframe>
        <?php endif; ?>
    </div>

    <!-- Ratings JSON -->
    <div class="wpaisearch-col-md-12 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Individual Ratings</label>
        <?php
        $json_ratings = json_decode($plugin['plugin_ratings_json'], true);
        if (!empty($json_ratings)) {
            foreach ($json_ratings as $k => $v) {
                ?>
                <p><?php echo $k ?> : <?php echo $v ?></p>
                <?php
            }
        }
        ?>
    </div>

    <!-- Plugin Author -->
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Author Name</label>
        <input type="text" class="wpaisearch-form-control" name="" value="<?php echo esc_attr($plugin_author_name); ?>"
            readonly>
    </div>

    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Author Profile URL</label>
        <input type="text" class="wpaisearch-form-control" name="" value="<?php echo esc_attr($plugin_profile_url); ?>"
            readonly>
    </div>

    <!-- Plugin Tags -->
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Tags (comma separated)</label>
        <input type="text" class="wpaisearch-form-control" name="" value="<?php echo esc_attr($plugin_tags); ?>"
            placeholder="SEO, SEO Plugin, WP SEO" readonly>
    </div>

    <!-- Plugin Keyword AI -->
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Feature Meta Keywords AI (comma
            separated)</label>
        <input type="text" class="wpaisearch-form-control" name="plugin_keywords" value="<?php echo esc_attr($plugin_keywords); ?>"
            placeholder="Keyword1, Keyword2...">
    </div>


    <?php
    foreach ($readonly_numeric as $field) {
        $value = esc_attr($plugin[$field] ?? '');
        echo '
         <div class="wpaisearch-col-md-6">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold wpaisearch-text-capitalize">' . str_replace('_', ' ', $field) . '</label>
        <input type="number" step="any" name="" value="' . $value . '" class="wpaisearch-form-control" placeholder="Enter ' . str_replace('_', ' ', $field) . '" readonly>
        </div>';
    }
    foreach ($numeric_fields as $field) {

        $value = esc_attr($plugin[$field] ?? '');
        echo '<div class="wpaisearch-col-md-6">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold wpaisearch-text-capitalize">' . str_replace('_', ' ', $field) . '</label>
         <input type="number" step="any" name="' . esc_attr($field) . '" value="' . $value . '" class="wpaisearch-form-control" placeholder="Enter ' . str_replace('_', ' ', $field) . '">
        </div>';
    }

    foreach ($select_fields as $field => $options) {
        $current = $plugin[$field] ?? '';
        echo '<div class="wpaisearch-col-md-6">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold wpaisearch-text-capitalize">' . str_replace('_', ' ', $field) . '</label>
        <select name="' . esc_attr($field) . '" class="wpaisearch-form-select">';
        foreach ($options as $val => $label) {
            printf('<option value="%s" %s>%s</option>', esc_attr($val), selected($current, $val, false), esc_html($label));
        }
        echo '</select></div>';
    }
    ?>
    <?php
    $plugin_scrap_log_details_url = add_query_arg([
        'page' => 'plugin-scrap-log-details',
        'slug' => $plugin['slug']
    ], admin_url('admin.php'));

    $plugin_faq_log_details_url = add_query_arg([
        'page' => 'plugin-faq-log-details',
        'slug' => $plugin['slug']
    ], admin_url('admin.php'));

    $plugin_review_log_details_url = add_query_arg([
        'page' => 'plugin-review-log-details',
        'slug' => $plugin['slug']
    ], admin_url('admin.php'));

    ?>
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Log Details</label>
        <a href="<?php echo $plugin_scrap_log_details_url ?>" class="button" target="_blank">Here</a>
    </div>
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Faq Details</label>
        <a href="<?php echo $plugin_faq_log_details_url ?>" class="button" target="_blank">Here</a>
    </div>
    <div class="wpaisearch-col-md-6 wpaisearch-mb-3">
        <label class="wpaisearch-form-label wpaisearch-fw-semibold">Plugin Review Details</label>
        <a href="<?php echo $plugin_review_log_details_url ?>" class="button" target="_blank">Here</a>
    </div>
</div>