<?php
class scrap_log_management
{
    public static function scrap_log_management_menu()
    {
        add_menu_page(
            'Plugin Scrap Log',
            'Plugin Scrap Log',
            'manage_options',
            'plugin-scrap-logs',
            array('scrap_log_management', 'render_table_core_plugin_log'),
            'dashicons-admin-generic',
            26
        );
        add_submenu_page(
            null, // hidden from menu
            'Plugin Scrap Log Details',
            'Plugin Scrap Log Details',
            'manage_options',
            'plugin-scrap-log-details',
            array('scrap_log_management', 'render_table_core_plugin_log_details'),
        );
        add_submenu_page(
            null, // hidden from menu
            'Plugin Faq Log Details',
            'Plugin Faq Log Details',
            'manage_options',
            'plugin-faq-log-details',
            array('scrap_log_management', 'render_table_core_plugin_faq_log_details'),
        );
        add_submenu_page(
            null, // hidden from menu
            'Plugin Review Log Details',
            'Plugin Review Log Details',
            'manage_options',
            'plugin-review-log-details',
            array('scrap_log_management', 'render_table_core_plugin_review_log_details'),
        );
    }
    public static function render_table_core_plugin_log()
    {
        echo '<div class="wrap"><h1>Plugin Scrap Log</h1>';
        $table = new Plugin_Scrap_Log_List_Table();
        $table->prepare_items();

        echo '<form method="get">';
        echo '<input type="hidden" name="page" value="plugin-scrap-logs" />';
        $table->display();
        echo '</form></div>';
    }
    public static function render_table_core_plugin_log_details()
    {
        global $wpdb;
        $table = $wpdb->prefix . 'plugins_core_information';

        // ✅ Get slug from URL
        $slug = isset($_GET['slug']) ? sanitize_text_field($_GET['slug']) : '';

        if (empty($slug)) {
            echo '<div class="notice notice-error"><p>Invalid plugin slug.</p></div>';
            return;
        }

        // ✅ Fetch plugin data by slug
        $plugin = $wpdb->get_row(
            $wpdb->prepare("SELECT * FROM $table WHERE slug = %s LIMIT 1", $slug),
            ARRAY_A
        );

        if (!$plugin) {
            echo '<div class="notice notice-error"><p>No plugin found with this slug.</p></div>';
            return;
        }

        require get_template_directory() . '/admin/plugin-core-information-details/index.php';


    }
    public static function update_plugin_metrics()
    {
        global $wpdb;
        $table = $wpdb->prefix . 'plugins_core_information';

        $slug = sanitize_text_field($_POST['slug'] ?? '');
        if (empty($slug)) {
            wp_send_json_error('Missing slug.');
        }

        $numeric_fields = [
            'update_activity_score',
            'maturity_score',
            'size_penalty_score',
            'localization_score',
            'gutenberg_bonus_score',
            'vulnerability_count',
            'avg_patch_response_days',
            'security_score',
            'code_quality_score',
            'cyclomatic_complexity_avg',
            'developer_reputation_score',
            'license_clarity_score',
            'overall_wpscore'
        ];
        $select_fields = ['gutenberg_support', 'license_type', 'is_ai_meta_keywords_done','support_quality','performance_impact','user_review_sentiment','seo_impact','is_sponsored','is_recreate_ai_post'];

        $data = [];
        foreach (array_merge($numeric_fields, $select_fields) as $field) {
            if (isset($_POST[$field])) {
                $data[$field] = sanitize_text_field($_POST[$field]);
            }
        }

        $updated = $wpdb->update($table, $data, ['slug' => $slug]);

        if ($updated !== false) {
            wp_send_json_success();
        } else {
            wp_send_json_error('Database update failed.');
        }
    }
    public static function render_table_core_plugin_faq_log_details()
    {
        global $wpdb;
        $table = $wpdb->prefix . 'plugin_faqs';

        // ✅ Get slug from URL
        $slug = isset($_GET['slug']) ? sanitize_text_field($_GET['slug']) : '';

        if (empty($slug)) {
            echo '<div class="notice notice-error"><p>Invalid plugin slug.</p></div>';
            return;
        }

        // ✅ Fetch FAQs by plugin slug
        $faqs = $wpdb->get_results(
            $wpdb->prepare("SELECT * FROM $table WHERE plugin_slug = %s ORDER BY id DESC", $slug),
            ARRAY_A
        );

        if (!$faqs) {
            echo '<div class="notice notice-warning"><p>No FAQs found for this plugin.</p></div>';
            return;
        }

        require get_template_directory() . '/admin/plugin-core-information-details/faq.php';
    }
    public static function render_table_core_plugin_review_log_details()
    {
        global $wpdb;
        $table = $wpdb->prefix . 'plugin_comments';

        // ✅ Get slug from URL
        $slug = isset($_GET['slug']) ? sanitize_text_field($_GET['slug']) : '';

        if (empty($slug)) {
            echo '<div class="notice notice-error"><p>Invalid plugin slug.</p></div>';
            return;
        }

        // ✅ Fetch FAQs by plugin slug
        $comments = $wpdb->get_results(
            $wpdb->prepare("SELECT * FROM $table WHERE plugin_slug = %s ORDER BY id DESC", $slug),
            ARRAY_A
        );

        if (!$comments) {
            echo '<div class="notice notice-warning"><p>No Review found for this plugin.</p></div>';
            return;
        }

        require get_template_directory() . '/admin/plugin-core-information-details/review-details.php';
    }
}