<?php

class Custom_table_creation
{
    public static function create_custom_table()
    {
        self::create_table_cron_page_visits_log();
        self::create_table_cron_scraped_plugins_log();
        self::create_table_core_plugins_informations();
        self::create_table_plugin_contributors();
        self::create_table_plugin_faqs();
        //self::create_table_plugin_all_versions();
        //self::create_table_comment_page_links();
        self::create_table_plugin_comments();
    }
    public static function create_table_cron_page_visits_log()
    {
        global $wpdb;

        $table_name = $wpdb->prefix . 'cron_page_visits_log'; // your custom table name

        $charset_collate = $wpdb->get_charset_collate();

        $sql = "
        CREATE TABLE IF NOT EXISTS $table_name (
            id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            page_number INT(10) UNSIGNED NOT NULL,
            endpoint VARCHAR(255) NOT NULL COMMENT 'API endpoint or query URL for this page',
            per_page INT(10) UNSIGNED DEFAULT NULL COMMENT 'Number of items per page',
            visited TINYINT(1) DEFAULT 0 COMMENT '0 = not visited, 1 = visited',
            visit_count INT(10) UNSIGNED DEFAULT 0 COMMENT 'How many times this page was visited',
            last_visited_at DATETIME DEFAULT NULL COMMENT 'Timestamp of last visit',
            created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY  (id),
            UNIQUE KEY unique_page (page_number, endpoint)
        ) $charset_collate;
        ";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
    public static function create_table_cron_scraped_plugins_log()
    {
        global $wpdb;

        $table_name = $wpdb->prefix . 'cron_scraped_plugins_log'; // your custom table name

        $charset_collate = $wpdb->get_charset_collate();

        $sql = "
        CREATE TABLE IF NOT EXISTS $table_name (
            id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            plugin_slug VARCHAR(191) NOT NULL COMMENT 'Unique plugin slug identifier from WordPress.org',
            plugin_name VARCHAR(255) DEFAULT NULL,
            plugin_icon VARCHAR(255) DEFAULT NULL,
            page_number INT(10) UNSIGNED DEFAULT NULL COMMENT 'From which page it was scraped',
            api_scrapped TINYINT(1) NOT NULL DEFAULT 0 COMMENT '0 = not scraped yet, 1 = successfully scraped',
            scrapped TINYINT(1) DEFAULT 0 COMMENT '0 = not scraped yet, 1 = successfully scraped',
            scrape_attempts INT(10) UNSIGNED DEFAULT 0 COMMENT 'How many times scraping was attempted',
            last_scraped_at DATETIME DEFAULT NULL,
            created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY  (id),
            UNIQUE KEY unique_slug (plugin_slug)
        ) $charset_collate;
        ";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
    public static function create_table_core_plugins_informations()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'plugins_core_information';
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "
            CREATE TABLE IF NOT EXISTS $table_name (
                id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                slug VARCHAR(255) NOT NULL COMMENT 'Data From API',
                name VARCHAR(255) NOT NULL COMMENT 'Data From API',
                version VARCHAR(50) DEFAULT NULL COMMENT 'Data From API',
                author_name VARCHAR(255) DEFAULT NULL COMMENT 'Data From API',
                author_profile VARCHAR(500) DEFAULT NULL COMMENT 'Data From API',
                requires_plugins VARCHAR(255) DEFAULT NULL COMMENT 'Data From API',
                tested VARCHAR(50) DEFAULT NULL COMMENT 'Data From API',
                requires_php VARCHAR(50) DEFAULT NULL COMMENT 'Data From API',
                active_installs BIGINT DEFAULT NULL COMMENT 'Data From API',
                downloaded BIGINT DEFAULT NULL COMMENT 'Data From API',
                rating INT DEFAULT NULL COMMENT 'Data From API',
                num_ratings INT DEFAULT NULL COMMENT 'Data From API',
                support_threads INT DEFAULT NULL COMMENT 'Data From API',
                support_threads_resolved INT DEFAULT NULL COMMENT 'Data From API',
                short_description LONGTEXT COMMENT 'Data From API',
                description LONGTEXT COMMENT 'Data From API',
                description_stip_tag LONGTEXT COMMENT 'Data From API',
                homepage VARCHAR(500) DEFAULT NULL COMMENT 'Data From API',
                download_link VARCHAR(500) DEFAULT NULL COMMENT 'Data From API',
                donate_link VARCHAR(500) DEFAULT NULL COMMENT 'Data From API',
                last_updated DATETIME DEFAULT NULL COMMENT 'Data From API',
                added DATE DEFAULT NULL COMMENT 'Data From API',
                plugin_tags VARCHAR(500) DEFAULT NULL COMMENT 'Data From API',
                plugin_installation LONGTEXT DEFAULT NULL COMMENT 'Data From API',
                plugin_changelog LONGTEXT DEFAULT NULL COMMENT 'Data From API',
                plugin_feature_image VARCHAR(500) DEFAULT NULL COMMENT 'Data From Scrapp',
                plugin_video VARCHAR(500) DEFAULT NULL COMMENT 'Data From Scrapp',
                plugin_screenshots JSON DEFAULT NULL COMMENT 'Data From API',
                plugin_ratings_json JSON DEFAULT NULL COMMENT 'Data From API',
                version_release_count INT DEFAULT 0 COMMENT 'Data From API',
                version_json_link JSON DEFAULT NULL COMMENT 'Data From API',
                plugin_feature_meta_key_word LONGTEXT DEFAULT NULL COMMENT 'Data From Scrapp',
                plugin_open_ai_short_description LONGTEXT DEFAULT NULL COMMENT 'Data From AI',
                plugin_open_ai_long_description LONGTEXT DEFAULT NULL COMMENT 'Data From AI',
                plugin_open_ai_category JSON DEFAULT NULL COMMENT 'Data From AI',
                plugin_open_ai_industry JSON DEFAULT NULL COMMENT 'Data From AI',
                is_api_crawled TINYINT(1) DEFAULT 0,
                is_web_crawled TINYINT(1) DEFAULT 0,
                is_ai_short_description_done TINYINT(1) DEFAULT 0,
                is_ai_long_description_done TINYINT(1) DEFAULT 0,
                is_ai_meta_keywords_done TINYINT(1) DEFAULT 0,
                is_ai_tax_category_done TINYINT(1) DEFAULT 0,
                is_ai_tax_industry_done TINYINT(1) DEFAULT 0,
                is_wp_post_created TINYINT(1) DEFAULT 0 COMMENT '1 = WP post created',
                is_wp_post_updated TINYINT(1) DEFAULT 0 COMMENT '1 = WP post updated',
                wp_post_id BIGINT DEFAULT NULL,
                last_update_days INT DEFAULT 0 COMMENT 'Days since last update',
                update_activity_score FLOAT DEFAULT 0 COMMENT 'Activity score penalising long inactivity',
                plugin_age_days INT DEFAULT 0 COMMENT 'Days since first release',
                maturity_score FLOAT DEFAULT 0 COMMENT 'Combined score of age and activity',
                package_size_mb FLOAT DEFAULT 0 COMMENT 'Download ZIP size in MB',
                size_penalty_score FLOAT DEFAULT 0 COMMENT 'Penalty if package >10MB',
                localization_count INT DEFAULT 0 COMMENT 'Number of available translations',
                localization_score FLOAT DEFAULT 0 COMMENT 'Normalized 0–100 localization metric',
                gutenberg_support TINYINT(1) DEFAULT 0 COMMENT '1 = Supports Gutenberg/Blocks',
                gutenberg_bonus_score FLOAT DEFAULT 0 COMMENT 'Bonus for block support',
                vulnerability_count INT DEFAULT 0 COMMENT 'Number of vulnerabilities found',
                avg_patch_response_days INT DEFAULT NULL COMMENT 'Average days to patch vulnerabilities',
                security_score FLOAT DEFAULT 0 COMMENT 'Computed 0–10 security score',
                code_quality_score FLOAT DEFAULT NULL COMMENT 'PHP_CodeSniffer quality score (0–100)',
                cyclomatic_complexity_avg FLOAT DEFAULT NULL COMMENT 'Avg cyclomatic complexity per file',
                developer_reputation_score FLOAT DEFAULT 0 COMMENT 'Average WPScore across author’s plugins',
                license_type ENUM('free','freemium','paid','unknown') DEFAULT 'unknown' COMMENT 'Detected pricing model',
                license_clarity_score FLOAT DEFAULT 0 COMMENT 'Clarity/confidence of license categorization',
                overall_wpscore FLOAT DEFAULT 0 COMMENT 'Aggregated plugin performance index',
                created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                PRIMARY KEY (id),
                UNIQUE KEY slug (slug),
                INDEX idx_api_crawled (is_api_crawled),
                INDEX idx_web_crawled (is_web_crawled)
            ) $charset_collate;
            ";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);

    }
    public static function create_table_plugin_contributors()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'plugin_contributors';
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "
            CREATE TABLE IF NOT EXISTS $table_name (
                    id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                    plugin_slug VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    name VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    profile_url VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    profile_image VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                    updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                    PRIMARY KEY (id),
                    INDEX idx_plugin_slug (plugin_slug)
            ) $charset_collate;
            ";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
    public static function create_table_plugin_faqs()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'plugin_faqs';
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "
            CREATE TABLE IF NOT EXISTS $table_name (
                  id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                  plugin_slug VARCHAR(255) NULL COMMENT 'Data From Scrap',
                  question VARCHAR(255) NULL COMMENT 'Data From Scrap',
                  answer LONGTEXT NULL COMMENT 'Data From Scrap',
                  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                  updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                  PRIMARY KEY (id),
                  INDEX idx_plugin_slug (plugin_slug)
            ) $charset_collate;
            ";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
    // public static function create_table_plugin_all_versions()
    // {
    //     global $wpdb;
    //     $table_name = $wpdb->prefix . 'plugin_all_versions';
    //     $charset_collate = $wpdb->get_charset_collate();

    //     $sql = "
    //         CREATE TABLE IF NOT EXISTS $table_name (
    //               id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
    //               plugin_slug VARCHAR(255) NULL COMMENT 'Data From API',
    //               version VARCHAR(255) NULL COMMENT 'Data From API',
    //               link VARCHAR(255) NULL COMMENT 'Data From API',
    //               created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    //               updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    //               PRIMARY KEY (id),
    //               INDEX idx_plugin_slug (plugin_slug)
    //         ) $charset_collate;
    //         ";

    //     require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    //     dbDelta($sql);
    // }
    public static function create_table_plugin_comments()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'plugin_comments';
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "
            CREATE TABLE IF NOT EXISTS $table_name (
                    id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                    plugin_slug VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    comment_title VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    comment_text LONGTEXT NULL COMMENT 'Data From Scrap',
                    commenter_name LONGTEXT NULL COMMENT 'Data From Scrap',
                    commenter_image_link VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    commenter_num_rating VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    comment_date VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    no_of_reply VARCHAR(255) NULL COMMENT 'Data From Scrap',
                    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                    updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                    PRIMARY KEY (id),
                    INDEX idx_plugin_slug (plugin_slug)
            ) $charset_collate;
            ";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
    public static function manage_add_management_page()
    {
        add_management_page(
            'Custom Table Sync',           // Page title
            'Custom Table Sync',           // Menu title
            'manage_options',       // Capability
            'custom-table-sync',           // Menu slug
            ['Custom_table_creation', 'custom_table_sync_management'] // Callback
        );
    }
    public static function manage_clear_scrap_flag_to_recrawl()
    {
        add_management_page(
            'Clear Scrap Flag',           // Page title
            'Clear Scrap Flag',           // Menu title
            'manage_options',       // Capability
            'clear-scrap-flag',           // Menu slug
            ['Custom_table_creation', 'clear_scrap_flag'] // Callback
        );
    }
    public static function clear_scrap_flag()
    {
        echo '<div class="wrap"><h1>Clear Scrap Flag Synchronization</h1>';

        if (!current_user_can('manage_options')) {
            echo '<p>You do not have permission to access this page.</p></div>';
            return;
        }
        global $wpdb;
        $cron_scraped_plugins_log_table_name = $wpdb->prefix . 'cron_scraped_plugins_log';
        $table_cron_page_visits = $wpdb->prefix . "cron_page_visits_log";
        $wpdb->query("
            UPDATE `$cron_scraped_plugins_log_table_name` SET `api_scrapped`=0,`scrapped`=0,`scrape_attempts`=0 WHERE 1
        ");
        $wpdb->query("
            UPDATE `$table_cron_page_visits` SET `visited`=0 WHERE 1
        ");
        echo '<p>Sync Done</p></div>';
    }
    public static function custom_table_sync_management()
    {
        echo '<div class="wrap"><h1>Custom Table Structure Synchronization</h1>';

        if (!current_user_can('manage_options')) {
            echo '<p>You do not have permission to access this page.</p></div>';
            return;
        }

        global $wpdb;
        $cron_scraped_plugins_log_table_name = $wpdb->prefix . 'cron_scraped_plugins_log';
        $core_plugins_information_table = $wpdb->prefix . 'plugins_core_information';

        // Helper function to check if a column exists
        $column_exists_cron_scraped_plugins_log_table = function ($column_name) use ($wpdb, $cron_scraped_plugins_log_table_name) {
            return $wpdb->get_var(
                $wpdb->prepare("SHOW COLUMNS FROM `$cron_scraped_plugins_log_table_name` LIKE %s", $column_name)
            );
        };

        $column_exists_core_plugins_information_table = function ($column_name) use ($wpdb, $core_plugins_information_table) {
            return $wpdb->get_var(
                $wpdb->prepare("SHOW COLUMNS FROM `$core_plugins_information_table` LIKE %s", $column_name)
            );
        };

        try {
            // Check and add active_installs column
            if (!$column_exists_cron_scraped_plugins_log_table('active_installs')) {
                $result = $wpdb->query("
            ALTER TABLE `$cron_scraped_plugins_log_table_name` 
            ADD `active_installs` BIGINT NULL DEFAULT NULL AFTER `plugin_icon`
        ");

                if ($result === false) {
                    throw new Exception('Failed to alter table: ' . $wpdb->last_error);
                }
            }

            //    Check and add short_description column

            if (!$column_exists_cron_scraped_plugins_log_table('short_description')) {
                $result = $wpdb->query("
            ALTER TABLE `$cron_scraped_plugins_log_table_name` 
            ADD `short_description` LONGTEXT NULL DEFAULT NULL AFTER `active_installs`
        ");

                if ($result === false) {
                    throw new Exception('Failed to alter table: ' . $wpdb->last_error);
                }
            }

            //  package_size_mb column alter to package_size_kb



            if (!$column_exists_core_plugins_information_table('error_log_open_ai')) {
                $result = $wpdb->query("
            ALTER TABLE `$core_plugins_information_table` 
            ADD `error_log_open_ai` LONGTEXT NULL DEFAULT NULL AFTER `is_ai_tax_industry_done`
        ");

                if ($result === false) {
                    throw new Exception('Failed to alter table: ' . $wpdb->last_error);
                }
            }
            if (!$column_exists_core_plugins_information_table('is_recreate_ai_post')) {
                $result = $wpdb->query("
            ALTER TABLE `$core_plugins_information_table` 
            ADD `is_recreate_ai_post` TINYINT(1) DEFAULT 0 COMMENT '0 = not required, 1 = required' AFTER `is_wp_post_updated`
        ");

                if ($result === false) {
                    throw new Exception('Failed to alter table: ' . $wpdb->last_error);
                }
            }

            $columns = [
                'post_title' => "LONGTEXT NULL DEFAULT NULL COMMENT 'Data From WP POST' AFTER `overall_wpscore`",
                'post_short_descripton' => "LONGTEXT NULL DEFAULT NULL COMMENT 'Data From WP POST' AFTER `post_title`",
                'post_long_descripton' => "LONGTEXT NULL DEFAULT NULL COMMENT 'Data From WP POST' AFTER `post_short_descripton`",
                'post_meta_keywords' => "LONGTEXT NULL DEFAULT NULL COMMENT 'Data From WP POST' AFTER `post_long_descripton`",
                'post_taxonomy_ids' => "LONGTEXT NULL DEFAULT NULL COMMENT 'Data From WP POST' AFTER `post_meta_keywords`",
                'support_quality' => "ENUM('1','2','3','4') DEFAULT '3' COMMENT '1=Excellent, 2=Good, 3=Fair, 4=Poor' AFTER `post_taxonomy_ids`",
                'performance_impact' => "ENUM('1','2','3') DEFAULT '3' COMMENT '1=Low, 2=Medium, 3=High' AFTER `support_quality`",
                'user_review_sentiment' => "ENUM('1','2','3') DEFAULT '2' COMMENT '1=Negative, 2=Neutral, 3=Positive' AFTER `performance_impact`",
                'seo_impact' => "ENUM('1','2','3') DEFAULT '2' COMMENT '1=Positive, 2=Neutral, 3=Negative' AFTER `user_review_sentiment`",
                'is_sponsored' => "ENUM('1','2') DEFAULT '1' COMMENT '1=Default, 2=Sponsored' AFTER `seo_impact`"
            ];

            foreach ($columns as $column => $definition) {
                if (!$column_exists_core_plugins_information_table($column)) {
                    $query = "ALTER TABLE `$core_plugins_information_table` ADD `$column` $definition;";
                    $result = $wpdb->query($query);

                    if ($result === false) {
                        throw new Exception("Failed to add column `$column`: " . $wpdb->last_error);
                    }
                }
            }

            // ✅ Add indexes for faster search (for LONGTEXT we use FULLTEXT)
            $index_columns = [
                'post_title',
                'post_short_descripton',
                'post_long_descripton',
                'post_meta_keywords',
                'post_taxonomy_ids'
            ];

            foreach ($index_columns as $idx) {
                // check if index exists first
                $index = $wpdb->get_var("
        SHOW INDEX FROM `$core_plugins_information_table`
        WHERE Column_name = '$idx'
    ");

                if (!$index) {
                    $result = $wpdb->query("
            ALTER TABLE `$core_plugins_information_table`
            ADD FULLTEXT (`$idx`)
        ");

                    if ($result === false) {
                        throw new Exception("Failed to create FULLTEXT index for `$idx`: " . $wpdb->last_error);
                    }
                }
            }
            echo '<p>Sync Done</p></div>';

        } catch (Exception $e) {
            echo '<p style="color: red;">Error: ' . esc_html($e->getMessage()) . '</p></div>';
        }
        self::column_defination_change();
    }
    public static function column_defination_change()
    {
        try {
            global $wpdb;
            $cron_scraped_plugins_log_table_name = $wpdb->prefix . 'cron_scraped_plugins_log';
            $core_plugins_information_table = $wpdb->prefix . 'plugins_core_information';

            $column_exists_core_plugins_information_table = function ($column_name) use ($wpdb, $core_plugins_information_table) {
                return $wpdb->get_var(
                    $wpdb->prepare("SHOW COLUMNS FROM `$core_plugins_information_table` LIKE %s", $column_name)
                );
            };

            if (!$column_exists_core_plugins_information_table('package_size_mb')) {
                throw new Exception('Column package_size_mb does not exist in the table.');
            } else {
                $result = $wpdb->query("
                    ALTER TABLE `$core_plugins_information_table`
                    CHANGE `package_size_mb` `package_size_kb` FLOAT DEFAULT 0 COMMENT 'Download ZIP size in KB'
                ");


                if ($result === false) {
                    throw new Exception('Failed to alter table: ' . $wpdb->last_error);
                }
            }
            if (!$column_exists_core_plugins_information_table('plugin_feature_meta_key_word')) {
                throw new Exception('Column plugin_feature_meta_key_word does not exist in the table.');
            }

            // ✅ Column exists → rename it
            $result = $wpdb->query("
            ALTER TABLE `$core_plugins_information_table`
            CHANGE `plugin_feature_meta_key_word` `plugin_feature_meta_key_word_ai` LONGTEXT NULL DEFAULT NULL COMMENT 'Data From AI'
        ");

            if ($result === false) {
                throw new Exception('Failed to alter table: ' . $wpdb->last_error);
            }
        } catch (Exception $e) {
            echo '<p style="color: red;">Error: ' . esc_html($e->getMessage()) . '</p></div>';
        }
    }
}