<?php

class Custom_post_functionalities
{
    public static function register_plugins_cpt()
    {
        $labels = [
            'name' => 'Plugins',
            'singular_name' => 'Plugin',
            'menu_name' => 'Plugins',
            'name_admin_bar' => 'Plugin',
            'add_new' => 'Add New Plugin',
            'add_new_item' => 'Add New Plugin',
            'new_item' => 'New Plugin',
            'edit_item' => 'Edit Plugin',
            'view_item' => 'View Plugin',
            'all_items' => 'All Plugins',
            'search_items' => 'Search Plugins',
            'not_found' => 'No Plugins found.',
            'not_found_in_trash' => 'No Plugins found in Trash.',
        ];

        $args = [
            'label' => 'Plugins',
            'labels' => $labels,
            'public' => true,
            'show_ui' => true,
            'show_in_menu' => true,
            'menu_icon' => 'dashicons-admin-generic',
            'supports' => [
                'title',
                'editor',
                'thumbnail',       // Featured Image
                'excerpt',
                'custom-fields',
                'author',
                'revisions'
            ],
            'has_archive' => true,
            'rewrite' => ['slug' => 'plugins'],
            'show_in_rest' => true, // ✅ Gutenberg + REST API
            'rest_base' => 'plugins',
            'publicly_queryable' => true,
            'capability_type' => 'post',
        ];

        register_post_type('plugins', $args);
    }
    public static function register_plugin_category_taxonomy()
    {
        $labels = [
            'name' => 'Plugin Categories',
            'singular_name' => 'Plugin Category',
            'search_items' => 'Search Plugin Categories',
            'all_items' => 'All Plugin Categories',
            'edit_item' => 'Edit Plugin Category',
            'update_item' => 'Update Plugin Category',
            'add_new_item' => 'Add New Plugin Category',
            'new_item_name' => 'New Plugin Category Name',
            'menu_name' => 'Plugin Categories',
        ];

        $args = [
            'labels' => $labels,
            'hierarchical' => true,  // ✅ Works like categories
            'public' => true,
            'show_ui' => true,
            'show_admin_column' => true,
            'rewrite' => ['slug' => 'plugin-category', 'hierarchical' => true,],
            'show_in_rest' => true, // ✅ Gutenberg + REST API
        ];

        register_taxonomy('plugin_category', ['plugins'], $args);
    }
    public static function manage_plugins_posts_columns($columns)
    {
        $new = [];

        foreach ($columns as $key => $value) {
            $new[$key] = $value;

            // Place image column right after checkbox (cb)
            if ($key == 'cb') {
                $new['plugin_thumb'] = __('Thumbnail');
                $new['plugin_developer'] = __('Developer');
            }
        }

        return $new;
    }
    public static function manage_plugins_posts_custom_column($column, $post_id)
    {
        $feature_image_developer = get_the_feature_image_developer_from_cpt_with_core($post_id);

        $image = $feature_image_developer->plugin_feature_image ?? '';
        $developer_name = $feature_image_developer->author_name ?? '';
        $developer_profile = $feature_image_developer->author_profile ?? '';

        // Thumbnail column
        if ($column === 'plugin_thumb') {

            if (!empty($image)) {
                echo sprintf(
                    '<img src="%s" alt="%s" style="width:50px;height:50px;object-fit:contain;border-radius:6px;">',
                    esc_url($image),
                    esc_attr($developer_name ?: "plugin image")
                );
            } else {
                echo '<span style="color:#aaa;">No image</span>';
            }
        }

        // Developer column
        if ($column === 'plugin_developer') {

            if (!empty($developer_name)) {

                if (!empty($developer_profile)) {
                    // Name clickable with URL
                    echo sprintf(
                        '<a href="%s" target="_blank">%s</a>',
                        esc_url($developer_profile),
                        esc_html($developer_name)
                    );
                } else {
                    // No link, but show name
                    echo esc_html($developer_name);
                }

            } else {
                echo '<span style="color:#aaa;">No Developer</span>';
            }
        }

    }
    public static function plugins_sortable_columns_thum_issue($columns)
    {
        unset($columns['plugin_thumb']);
        unset($columns['plugin_developer']);
        return $columns;
    }
    public static function add_metabox_init_function()
    {
        add_meta_box(
            'my_plugins_meta_box',
            __('Plugin Details Information', 'wpsearch'),
            ['Custom_post_functionalities', 'plugins_cpt_metabox'],
            'plugins', // Target post type
            'normal',
            'default'
        );
    }
    public static function plugins_cpt_metabox()
    {
        wp_nonce_field('my_plugins_save_meta', 'my_plugins_meta_nonce');
        require get_template_directory() . '/admin/metabox-html/plugins-cpt-meta-box-form.php';
    }
    public static function plugins_save_meta($post_id, $post, $update)
    {
        if (empty($_POST))
            return;

        if (!$update) {
            return;
        }
        if (wp_doing_ajax() || wp_is_post_autosave($post_id) || wp_is_post_revision($post_id) || !is_admin()) {
            return;
        }

        // ✅ Only run for our custom post type "plugins"
        if (get_post_type($post_id) !== 'plugins') {
            return;
        }

        global $wpdb;
        $tbl_core_plugin_information = $wpdb->prefix . "plugins_core_information";
        $numeric_fields = [
            'update_activity_score',
            'maturity_score',
            'size_penalty_score',
            'localization_score',
            'gutenberg_bonus_score',
            'vulnerability_count',
            'avg_patch_response_days',
            'security_score',
            'code_quality_score',
            'cyclomatic_complexity_avg',
            'developer_reputation_score',
            'license_clarity_score',
            'overall_wpscore'
        ];
        $select_fields = ['gutenberg_support', 'license_type', 'support_quality', 'performance_impact', 'user_review_sentiment', 'seo_impact', 'is_sponsored'];

        $data = [];
        foreach (array_merge($numeric_fields, $select_fields) as $field) {
            if (isset($_POST[$field])) {
                $data[$field] = sanitize_text_field($_POST[$field]);
            }
        }
        $post_taxonomy_ids = $_POST['tax_input']['plugin_category'];

        $post_taxonomy_ids = array_filter($post_taxonomy_ids, function ($value) {
            return $value !== '0' && $value !== 0;
        });

        $post_taxonomy_ids = array_values($post_taxonomy_ids);
        //exit;
        //$data["post_long_descripton"] = sanitize_text_field($_POST["content"]);
        $data["post_short_descripton"] = sanitize_text_field($_POST["excerpt"]);
        $data["post_title"] = sanitize_text_field($_POST["post_title"]);
        $data["post_meta_keywords"] = sanitize_text_field($_POST["plugin_keywords"]);
        $data["post_taxonomy_ids"] = implode(',', $post_taxonomy_ids);
        $wpdb->update($tbl_core_plugin_information, $data, ['wp_post_id' => $post_id]);

    }
    public static function plugin_post_deleted($post_id)
    {
        if (get_post_type($post_id) !== 'plugins')
            return;

        global $wpdb;
        $tbl_core_plugin_information = $wpdb->prefix . "plugins_core_information";

        // Remove from custom table
        $data = [
            'is_wp_post_created' => 0
        ];
        $wpdb->update($tbl_core_plugin_information, $data, ['wp_post_id' => $post_id]);
    }
}