<?php
require_once dirname(__FILE__) . '/index.php';
class WpPluginDirectorySinglePluginAPICallManagement
{

    public function __construct()
    {

        // Check & acquire lock
        if (!wp_job_lock()) {
            echo "already running";
            return; // already running
        }

        try {
            // Call core function ONLY after lock
            $this->WPPluginDirectorySinglePluginAPICall();
        } finally {
            // Always release lock
            wp_job_unlock();
        }
    }

    private function WPPluginDirectorySinglePluginAPICall()
    {
        global $wpdb;

        $table_cron_page_visits = $wpdb->prefix . "cron_page_visits_log";     // Make sure to use the prefix for table names
        $cron_scraped_plugins = $wpdb->prefix . "cron_scraped_plugins_log"; // Use table prefix for scraped plugins
        $plugins_core_information = $wpdb->prefix . "plugins_core_information";

        if (new_post_publishing) {
            // Get all the pages that haven't been visited
            $cron_scraped_plugins = $wpdb->get_results($wpdb->prepare(
                "SELECT active_installs, plugin_slug, short_description,scrape_attempts,plugin_icon FROM $cron_scraped_plugins WHERE api_scrapped = 0 AND scrapped = 0 AND active_installs > 10000 LIMIT 50"
            ));
        } else {
            // FIXED ELSE QUERY
            $cron_scraped_plugins = $wpdb->get_results("
                SELECT 
                    c.active_installs,
                    c.plugin_slug,
                    c.short_description,
                    c.scrape_attempts,
                    c.plugin_icon
                FROM {$cron_scraped_plugins} AS c
                INNER JOIN {$plugins_core_information} AS p 
                    ON c.plugin_slug = p.slug
                WHERE 
                    c.api_scrapped = 0
                    AND c.scrapped = 0
                    AND c.active_installs > 10000
                    AND p.is_wp_post_created = 1
                LIMIT 50
            ");
        }
        if (empty($cron_scraped_plugins)) {
            echo "No Plugins found.\n";
            return;
        }
        foreach ($cron_scraped_plugins as $single_plugin_slug) {
            // Initial Set flag to Zero //
            $this->intial_api_scrapped_flag_set_false_to_core_plugin_table($single_plugin_slug->plugin_slug);

            $dynamic_single_plugin_url = "https://api.wordpress.org/plugins/info/1.0/" . $single_plugin_slug->plugin_slug . ".json";
            $response_data = $this->apiGet($dynamic_single_plugin_url);
            if (isset($response_data["slug"]) && !empty($response_data["slug"])) {
                $slug_in_exits_in_core_plugin_info_table = $this->is_already_exits_by_slug_core_information_table($response_data["slug"]);

                // core plugin not exits , so seeding information start
                if (empty($slug_in_exits_in_core_plugin_info_table)) {

                    // Seeding by API

                    $is_api_seeding = $this->seeding_plugin_data_api($response_data, $single_plugin_slug->active_installs, $single_plugin_slug->short_description, $single_plugin_slug->plugin_icon);

                    if ($is_api_seeding) {
                        //update flag core inforamtion table helpers function from index

                        // update core table is_api_crawled flag set to 1 by slug
                        $table_name = $wpdb->prefix . "plugins_core_information";
                        $flag_name = "is_api_crawled";
                        $flag_value = 1;
                        $where_name = "slug";
                        $where_value = $response_data["slug"];
                        update_flag_in_table_index_load($table_name, $flag_name, $flag_value, $where_name, $where_value);

                        // Seeding by Scrap
                        $is_scrapp_seeding = $this->seeding_plugin_data_scrapp($single_plugin_slug->plugin_slug);
                        if ($is_scrapp_seeding) {
                            $table_name = $wpdb->prefix . "plugins_core_information";
                            $flag_name = "is_web_crawled";
                            $flag_value = 1;
                            $where_name = "slug";
                            $where_value = $response_data["slug"];
                            update_flag_in_table_index_load($table_name, $flag_name, $flag_value, $where_name, $where_value);
                        } else {
                            continue;
                        }
                        if ($is_api_seeding && $is_scrapp_seeding) {
                            $table_name = $wpdb->prefix . "cron_scraped_plugins_log";
                            $flag_name = "api_scrapped";
                            $flag_value = 1;
                            $where_name = "plugin_slug";
                            $where_value = $response_data["slug"];
                            update_flag_in_table_index_load($table_name, $flag_name, $flag_value, $where_name, $where_value);
                            // web scrapped flag
                            $flag_name = "scrapped";
                            update_flag_in_table_index_load($table_name, $flag_name, $flag_value, $where_name, $where_value);

                            //Final update scrappcount and last scapping time

                            $wpdb->update(
                                $wpdb->prefix . "cron_scraped_plugins_log",
                                [
                                    "scrape_attempts" => (int) ($single_plugin_slug->scrape_attempts + 1),
                                    "last_scraped_at" => current_time('mysql'),
                                ],
                                [$where_name => $where_value]
                            );
                        }
                    } else {
                        continue;
                    }
                }
                // core plugin information update
                else {
                    // Seeding by API

                    $is_api_seeding = $this->update_seeding_plugin_data_api($response_data, $single_plugin_slug->active_installs, $single_plugin_slug->short_description, $single_plugin_slug->plugin_icon);

                    if ($is_api_seeding) {
                        //update flag core inforamtion table helpers function from index

                        // update core table is_api_crawled flag set to 1 by slug
                        $table_name = $wpdb->prefix . "plugins_core_information";
                        $flag_name = "is_api_crawled";
                        $flag_value = 1;
                        $where_name = "slug";
                        $where_value = $response_data["slug"];
                        update_flag_in_table_index_load($table_name, $flag_name, $flag_value, $where_name, $where_value);

                        // Seeding by Scrap
                        $is_scrapp_seeding = $this->seeding_plugin_data_scrapp($single_plugin_slug->plugin_slug);
                        if ($is_scrapp_seeding) {
                            $table_name = $wpdb->prefix . "plugins_core_information";
                            $flag_name = "is_web_crawled";
                            $flag_value = 1;
                            $where_name = "slug";
                            $where_value = $response_data["slug"];
                            update_flag_in_table_index_load($table_name, $flag_name, $flag_value, $where_name, $where_value);
                        } else {
                            continue;
                        }
                        if ($is_api_seeding && $is_scrapp_seeding) {
                            $table_name = $wpdb->prefix . "cron_scraped_plugins_log";
                            $flag_name = "api_scrapped";
                            $flag_value = 1;
                            $where_name = "plugin_slug";
                            $where_value = $response_data["slug"];
                            update_flag_in_table_index_load($table_name, $flag_name, $flag_value, $where_name, $where_value);
                            // web scrapped flag
                            $flag_name = "scrapped";
                            update_flag_in_table_index_load($table_name, $flag_name, $flag_value, $where_name, $where_value);

                            //Final update scrappcount and last scapping time

                            $wpdb->update(
                                $wpdb->prefix . "cron_scraped_plugins_log",
                                [
                                    "scrape_attempts" => (int) ($single_plugin_slug->scrape_attempts + 1),
                                    "last_scraped_at" => current_time('mysql'),
                                ],
                                [$where_name => $where_value]
                            );

                        }
                    } else {
                        continue;
                    }
                }
            }
        }
    }

    private function seeding_plugin_data_scrapp($plugin_slug)
    {
        try {
            global $wpdb;
            $plugins_core_information = $wpdb->prefix . "plugins_core_information";

            $scrapp_url = "https://wordpress.org/plugins/" . $plugin_slug;
            $ch = curl_init($scrapp_url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)');
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 15);
            $html_data = curl_exec($ch);
            curl_close($ch);

            if ($html_data) {
                $html = str_get_html($html_data);
            } else {
                $html = false;
            }
            if (!$html) {
                return false;
            }
            $youtube_url = $this->scrapp_the_feature_video($html) ?? null;
            $feature_image_url = $this->scrapp_the_feature_image($html) ?? null;

            $faqs = $this->scrapp_the_faq_data($html) ?? null;
            $developers = $this->scrapp_the_developers_data($html) ?? null;
            $reviews = $this->scrapp_the_review_data($html) ?? null;
            $lanuage_count = $this->scrapp_the_language_count($html) ?? null;

            $plugin_developememt_with_changelog = $this->scrapp_plugin_developememt_with_changelog($html) ?? null;
            $plugin_changelog = $this->scrapp_plugin_changelog($html) ?? null;

            $core_plugin_update_data_scrapp = [];
            if (!empty($lanuage_count)) {
                $core_plugin_update_data_scrapp['localization_count'] = $lanuage_count;
            }
            if (!empty($feature_image_url)) {
                $core_plugin_update_data_scrapp['plugin_feature_image'] = $feature_image_url;
            }
            if (!empty($youtube_url)) {
                $core_plugin_update_data_scrapp['plugin_video'] = $youtube_url;
            }
            if (!empty($plugin_developememt_with_changelog)) {
                $core_plugin_update_data_scrapp['plugin_developememt_with_changelog'] = $plugin_developememt_with_changelog;
            }
            if (!empty($plugin_changelog)) {
                $core_plugin_update_data_scrapp['plugin_changelog'] = $plugin_changelog;
            }
            if (!empty($core_plugin_update_data_scrapp)) {
                $wpdb->update($plugins_core_information, $core_plugin_update_data_scrapp, [
                    'slug' => $plugin_slug,
                ]);
            }
            if (!empty($faqs)) {
                $this->update_faq_table_information($faqs, $plugin_slug);
            }
            if (!empty($developers)) {
                $this->update_contibutors_table_information($developers, $plugin_slug);
            }
            if (!empty($reviews)) {
                $this->update_reviews_table_information($reviews, $plugin_slug);
            }
            return true;

        } catch (Exception $e) {
            return false;
        }

    }
    private function update_reviews_table_information($comments, $plugin_slug)
    {
        global $wpdb;
        $plugin_comments_table = $wpdb->prefix . "plugin_comments";

        foreach ($comments as $single_comment) {
            $plugin_slug = trim($plugin_slug);
            $comment_title = trim($single_comment["comment_title"]);
            $comment_text = $single_comment["comment_text"];
            $commenter_name = $single_comment["commenter_name"];
            $commenter_image_link = $single_comment["commenter_image_link"];
            $commenter_num_rating = $single_comment["commenter_num_rating"];
            $comment_date = $single_comment["comment_date"];
            $no_of_reply = $single_comment["no_of_reply"];

            // Check if the comment already exists
            $existing = $wpdb->get_row(
                $wpdb->prepare(
                    "SELECT id FROM {$plugin_comments_table}
             WHERE plugin_slug = %s
             AND comment_date = %s
             AND comment_title = %s
             AND commenter_num_rating = %s
             LIMIT 1",
                    $plugin_slug,
                    $comment_date,
                    $comment_title,
                    $commenter_num_rating
                )
            );

            if ($existing) {
                // ✅ Corrected update syntax
                $wpdb->update(
                    $plugin_comments_table,
                    [
                        'plugin_slug' => $plugin_slug,
                        'comment_title' => $comment_title,
                        'comment_text' => $comment_text,
                        'commenter_name' => $commenter_name,
                        'commenter_image_link' => $commenter_image_link,
                        'commenter_num_rating' => $commenter_num_rating,
                        'comment_date' => $comment_date,
                        'no_of_reply' => $no_of_reply,
                    ],
                    ['id' => $existing->id]
                );
            } else {
                // Insert new comment
                $wpdb->insert(
                    $plugin_comments_table,
                    [
                        'plugin_slug' => $plugin_slug,
                        'comment_title' => $comment_title,
                        'comment_text' => $comment_text,
                        'commenter_name' => $commenter_name,
                        'commenter_image_link' => $commenter_image_link,
                        'commenter_num_rating' => $commenter_num_rating,
                        'comment_date' => $comment_date,
                        'no_of_reply' => $no_of_reply,
                    ]
                );
            }
        }

    }
    private function update_contibutors_table_information($developers, $plugin_slug)
    {
        global $wpdb;
        $plugin_contributors = $wpdb->prefix . "plugin_contributors";

        foreach ($developers as $single_developer) {
            $plugin_slug = trim($plugin_slug);
            $name = trim($single_developer["name"]);
            $profile_url = $single_developer["url"];
            $profile_image = $single_developer["image"];

            // Check if contributor already exists (fast check)
            $existing = $wpdb->get_row(
                $wpdb->prepare(
                    "SELECT id FROM {$plugin_contributors} WHERE plugin_slug = %s AND name = %s LIMIT 1",
                    $plugin_slug,
                    $name
                )
            );

            if ($existing) {
                // ✅ Corrected update syntax
                $wpdb->update(
                    $plugin_contributors,
                    [
                        'plugin_slug' => $plugin_slug,
                        'name' => $name,
                        'profile_url' => $profile_url,
                        'profile_image' => $profile_image,
                    ],
                    ['id' => $existing->id]
                );
            } else {
                // Insert new record
                $wpdb->insert(
                    $plugin_contributors,
                    [
                        'plugin_slug' => $plugin_slug,
                        'name' => $name,
                        'profile_url' => $profile_url,
                        'profile_image' => $profile_image,
                    ]
                );
            }
        }

    }
    private function update_faq_table_information($faqs, $plugin_slug)
    {
        global $wpdb;
        $plugin_faqs_information = $wpdb->prefix . "plugin_faqs";

        foreach ($faqs as $single_faq) {

            $question = trim($single_faq["question"]);
            $answer = $single_faq["answer"];

            // Check if record already exists (faster than COUNT)
            $existing = $wpdb->get_row(
                $wpdb->prepare(
                    "SELECT id FROM {$plugin_faqs_information} WHERE plugin_slug = %s AND question = %s LIMIT 1",
                    $plugin_slug,
                    $question
                )
            );

            if ($existing) {
                // ✅ Corrected update syntax
                $wpdb->update(
                    $plugin_faqs_information,
                    [
                        'plugin_slug' => $plugin_slug,
                        'question' => $question,
                        'answer' => $answer,
                    ],
                    ['id' => $existing->id]
                );
            } else {
                // Insert new record
                $wpdb->insert(
                    $plugin_faqs_information,
                    [
                        'plugin_slug' => $plugin_slug,
                        'question' => $question,
                        'answer' => $answer,
                    ]
                );
            }
        }

    }
    private function scrapp_the_developers_data($html)
    {

        try {
            $developers = [];
            $desired_size = 256;
            foreach ($html->find('#contributors-list li') as $li) {
                $img = $li->find('img', 0);
                $a = $li->find('a', 0);

                if ($img && $a) {
                    $image_src = $img->src;

                    // ✅ Replace ?s=32 or ?s=64 or any s= value with new size
                    $image_src = preg_replace('/s=\d+/', 's=' . $desired_size, $image_src);

                    $developers[] = [
                        'name' => trim($a->plaintext ?? ''),
                        'url' => $a->href ?? '',
                        'image' => $image_src,
                    ];
                }
            }
            return $developers;
        } catch (Exception $e) {
            return null;
        }
    }
    private function scrapp_the_feature_video($html)
    {
        try {
            $youtube_url = null;
            $iframe = $html->find('#tab-description iframe', 0);
            if ($iframe && strpos($iframe->src, 'youtube.com') !== false) {
                $youtube_url = $iframe->src;
            }
            return $youtube_url;
        } catch (Exception $e) {
            return null;
        }

    }
    private function scrapp_the_feature_image($html)
    {
        try {
            $high_res_banner = null;
            $img = $html->find('.plugin-banner img', 0);
            if ($img) {
                $srcset = $img->getAttribute('srcset');

                if ($srcset) {
                    // split multiple URLs by comma
                    $sources = array_map('trim', explode(',', $srcset));

                    // usually the last one is the highest resolution
                    $last = end($sources);

                    // extract the actual URL before the size (like 1544w)
                    if (preg_match('/(https?:\/\/[^\s]+)\s+\d+w/', $last, $matches)) {
                        $high_res_banner = $matches[1];
                    }
                }

                // fallback if srcset not available
                if (!$high_res_banner && $img->src) {
                    $high_res_banner = $img->src;
                }
            }
            return $high_res_banner;
        } catch (Exception $e) {
            return null;
        }

    }
    private function scrapp_the_faq_data($html)
    {
        try {
            $faqs = [];
            foreach ($html->find('#faq dl dt') as $dt) {
                $question = trim($dt->plaintext); // get question text

                // find the next <dd> sibling for the answer
                $dd = $dt->next_sibling();

                // skip whitespace/text nodes until we find a <dd>
                while ($dd && $dd->tag !== 'dd') {
                    $dd = $dd->next_sibling();
                }

                if ($dd) {
                    // Extract the full HTML or plain text of the answer
                    $answer = trim($dd->innertext); // use innertext for HTML content
                    // $answer = trim($dd->plaintext); // or plaintext for text only

                    $faqs[] = [
                        'question' => $question,
                        'answer' => $answer,
                    ];
                }
            }
            return $faqs;
        } catch (Exception $e) {
            return null;
        }

    }
    private function scrapp_the_review_data($html)
    {
        try {
            $reviews = [];
            $desired_size = 256;
            foreach ($html->find('article.plugin-review') as $review) {
                // reviewer image
                $avatar = $review->find('.review-avatar img', 0);
                $commenter_image_link = $avatar ? trim($avatar->src) : null;

                // reviewer name
                $author = $review->find('.review-author a', 0);
                $commenter_name = $author ? trim($author->plaintext) : null;

                // rating (data-rating attribute)
                $rating_div = $review->find('.wporg-ratings', 0);
                $commenter_num_rating = $rating_div ? trim($rating_div->getAttribute('data-rating')) : null;

                // review title
                $title = $review->find('.review-title a', 0);
                $comment_title = $title ? trim($title->plaintext) : null;

                // review content
                $content = $review->find('.review-content', 0);
                $comment_text = $content ? trim($content->innertext) : null; // keep HTML for formatting

                // date
                $date = $review->find('.review-date', 0);
                $comment_date = $date ? trim($date->plaintext) : null;

                // number of replies (optional)
                $replies = $review->find('.review-replies', 0);
                $no_of_reply = $replies ? trim($replies->plaintext) : null;

                // Push into array
                $reviews[] = [
                    'comment_title' => $comment_title,
                    'comment_text' => $comment_text,
                    'commenter_name' => $commenter_name,
                    'commenter_image_link' => preg_replace('/s=\d+/', 's=' . $desired_size, $commenter_image_link),
                    'commenter_num_rating' => $commenter_num_rating,
                    'comment_date' => $comment_date,
                    'no_of_reply' => $no_of_reply,
                ];
            }
            return $reviews;
        } catch (Exception $e) {
            return null;
        }
    }
    private function scrapp_the_language_count($html)
    {
        try {
            $languageCount = 0;
            $metaWidget = $html->find('div.widget.plugin-meta', 0);
            if ($metaWidget) {
                // Step 2: find the div.languages inside any li > ul
                $languagesDiv = $metaWidget->find('ul li div.languages', 0);
                if ($languagesDiv) {

                    // Step 3: try to read number from button text ("See all 38")
                    $button = $languagesDiv->find('button.popover-trigger', 0);
                    if ($button && preg_match('/See all\s+(\d+)/', $button->plaintext, $matches)) {
                        $languageCount = (int) $matches[1];
                    }

                    // Step 4 (fallback): count language <a> tags if number not found
                    if ($languageCount === 0) {
                        $languageLinks = $languagesDiv->find('#popover-languages .popover-inner a');
                        $languageCount = count($languageLinks);
                    }
                }
            }
            return $languageCount;
        } catch (Exception $e) {
            return null;
        }
    }
    private function intial_api_scrapped_flag_set_false_to_core_plugin_table($slug)
    {
        global $wpdb;
        $plugins_core_information = $wpdb->prefix . "plugins_core_information";
        $wpdb->update($plugins_core_information, [
            'is_api_crawled' => 0,
            'is_web_crawled' => 0,
            'is_wps_metric_group_done' => 0,
        ], [
            'slug' => $slug,
        ]);
    }
    private function seeding_plugin_data_api($json_data, $active_installs, $short_description, $plugin_icon)
    {
        global $wpdb;
        $plugins_core_information = $wpdb->prefix . "plugins_core_information";
        $data_preparation = [];
        $data_preparation['slug'] = $json_data["slug"];
        $data_preparation['name'] = $json_data["name"];
        $data_preparation['plugin_icon'] = $plugin_icon;
        $data_preparation['version'] = $json_data["version"];
        $data_preparation['author_name'] = getLinkInnerText($json_data["author"]);
        $data_preparation['author_profile'] = $json_data["author_profile"];
        $data_preparation['requires_plugins'] = empty($json_data["requires_plugins"])
            ? null
            : implode(',', $json_data["requires_plugins"]);

        $data_preparation['tested'] = $json_data["tested"];
        $data_preparation['requires_php'] = $json_data["requires_php"];
        $data_preparation['active_installs'] = $active_installs;
        $data_preparation['downloaded'] = $json_data["downloaded"];
        $data_preparation['installation_growth'] = self::generate_installation_growth($data_preparation['slug'], $json_data["downloaded"]);
        $data_preparation['rating'] = $json_data["rating"];
        $data_preparation['num_ratings'] = $json_data["num_ratings"];
        $data_preparation['support_threads'] = $json_data["support_threads"];
        $data_preparation['support_threads_resolved'] = $json_data["support_threads_resolved"];
        $data_preparation['short_description'] = $short_description;
        $data_preparation['description'] = $json_data["sections"]["description"];
        $data_preparation['description_stip_tag'] = html_to_plain_text($json_data["sections"]["description"]);
        $data_preparation['homepage'] = $json_data["homepage"];
        $data_preparation['download_link'] = $json_data["download_link"];
        $data_preparation['donate_link'] = $json_data["donate_link"];
        $data_preparation['last_updated'] = to_mysql_datetime($json_data["last_updated"]);
        $data_preparation['added'] = $json_data["added"];
        $data_preparation['plugin_tags'] = plugin_tag_handle_convert_to_comma_separated($json_data["tags"]);
        $data_preparation['plugin_installation'] = $json_data["sections"]["installation"];

        $data_preparation['plugin_screenshots'] = plugin_screenshots_parsing($json_data["screenshots"]);
        $data_preparation['plugin_ratings_json'] = json_encode($json_data["ratings"]);
        $data_preparation['version_release_count'] = count($json_data["versions"]);
        $data_preparation['version_json_link'] = json_encode($json_data["versions"]);
        $data_preparation['is_api_crawled'] = 1;
        $result = $wpdb->insert($plugins_core_information, $data_preparation);
        if ($result) {
            return true;
        }
        return false;
    }

    private function is_already_exits_by_slug_core_information_table($slug)
    {
        global $wpdb;
        $plugins_core_information = $wpdb->prefix . "plugins_core_information";

        // ✅ Use %s placeholder properly for string escaping
        $slug_exits = $wpdb->get_row(
            $wpdb->prepare(
                "SELECT slug FROM $plugins_core_information WHERE slug = %s",
                $slug
            )
        );

        if (!empty($slug_exits)) {
            return $slug_exits->slug;
        }

        return null;
    }
    private function update_seeding_plugin_data_api($json_data, $active_installs, $short_description, $plugin_icon)
    {
        global $wpdb;
        $plugins_core_information = $wpdb->prefix . "plugins_core_information";
        $data_preparation = [];
        $data_preparation['slug'] = $json_data["slug"];
        $data_preparation['name'] = $json_data["name"];
        $data_preparation['plugin_icon'] = $plugin_icon;
        $data_preparation['version'] = $json_data["version"];
        $data_preparation['author_name'] = getLinkInnerText($json_data["author"]);
        $data_preparation['author_profile'] = $json_data["author_profile"];
        $data_preparation['requires_plugins'] = empty($json_data["requires_plugins"])
            ? null
            : implode(',', $json_data["requires_plugins"]);

        $data_preparation['tested'] = $json_data["tested"];
        $data_preparation['requires_php'] = $json_data["requires_php"];
        $data_preparation['active_installs'] = $active_installs;
        $data_preparation['downloaded'] = $json_data["downloaded"];
        $data_preparation['installation_growth'] = self::generate_installation_growth($data_preparation['slug'], $json_data["downloaded"]);
        $data_preparation['rating'] = $json_data["rating"];
        $data_preparation['num_ratings'] = $json_data["num_ratings"];
        $data_preparation['support_threads'] = $json_data["support_threads"];
        $data_preparation['support_threads_resolved'] = $json_data["support_threads_resolved"];
        $data_preparation['description_stip_tag'] = html_to_plain_text($json_data["sections"]["description"]);
        $data_preparation['homepage'] = $json_data["homepage"];
        $data_preparation['download_link'] = $json_data["download_link"];
        $data_preparation['donate_link'] = $json_data["donate_link"];
        $data_preparation['last_updated'] = to_mysql_datetime($json_data["last_updated"]);
        $data_preparation['added'] = $json_data["added"];
        $data_preparation['plugin_tags'] = plugin_tag_handle_convert_to_comma_separated($json_data["tags"]);
        $data_preparation['plugin_installation'] = $json_data["sections"]["installation"];

        $data_preparation['plugin_screenshots'] = plugin_screenshots_parsing($json_data["screenshots"]);
        $data_preparation['plugin_ratings_json'] = json_encode($json_data["ratings"]);
        $data_preparation['version_release_count'] = count($json_data["versions"]);
        $data_preparation['version_json_link'] = json_encode($json_data["versions"]);
        $data_preparation['is_api_crawled'] = 1;
        $result = $wpdb->update(
            $plugins_core_information,
            $data_preparation,
            ["slug" => $data_preparation['slug']]
        );
        if ($result) {
            return true;
        }
        return false;
    }
    private function apiGet($url)
    {
        try {
            $curl = curl_init();

            curl_setopt_array($curl, [
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
            ]);

            $response = curl_exec($curl);

            if (curl_errno($curl)) {
                $error = curl_error($curl);
                curl_close($curl);

                throw new Exception("cURL Error: " . $error);
            }

            $statusCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            curl_close($curl);

            if ($statusCode !== 200) {
                throw new Exception("HTTP {$statusCode}: {$response}");
            }

            $decoded = json_decode($response, true);

            if (json_last_error() !== JSON_ERROR_NONE) {
                throw new Exception("JSON Decode Error: " . json_last_error_msg());
            }

            return $decoded;

        } catch (Exception $e) {

            // Log error message in error_log()
            error_log("[apiGet ERROR] " . $e->getMessage());

            // Return a consistent error response
            return [
                'success' => false,
                'error' => $e->getMessage(),
            ];
        }
    }
    public static function scrapp_plugin_developememt_with_changelog($html)
    {
        try {
            $developersDiv = $html->find('div#tab-developers div.plugin-development', 0);
            //dd($developersDiv);
            if ($developersDiv) {
                return $developersDiv->outertext; // full HTML of the entire div
            } else {
                return null;
            }
        } catch (Exception $e) {
            return null;
        }
    }
    public static function scrapp_plugin_changelog($html)
    {
        try {
            $changelog = $html->find('div#tab-changelog', 0);
            if (!$changelog) {
                return null;
            }

            $changelog_result = [];

            foreach ($changelog->find('h4') as $heading) {
                $version_text = trim($heading->plaintext ?? '');
                if ($version_text === '') {
                    continue;
                }

                // Normalize possible dash variants
                $version_text = str_replace(['&#8211;', '&ndash;', '–'], '-', $version_text);

                $version = '';
                $version_date = '';

                // Match "4.6.0 - 2025-08-26" or "10.3.4 2025-10-31"
                if (preg_match('/^([\d\.]+)\s*[-]?\s*([0-9]{4}-[0-9]{2}-[0-9]{2})$/', $version_text, $m)) {
                    $version = trim($m[1]);
                    $date_raw = trim($m[2]);
                    $dt = \DateTime::createFromFormat('Y-m-d', $date_raw);
                    $version_date = $dt ? $dt->format('F j, Y') : $date_raw;
                } else {
                    $version = $version_text;
                }

                if ($version === '') {
                    continue;
                }

                $changes = [];
                $next = $heading->next_sibling();

                // Traverse all siblings until next h4
                while ($next && strtolower($next->tag ?? '') !== 'h4') {
                    if (strtolower($next->tag ?? '') === 'p') {
                        // Extract <strong> label (e.g., Added, Fixed, Improved)
                        $label = null;
                        $strong = $next->find('strong', 0);
                        if ($strong) {
                            $label = trim($strong->plaintext);
                        }

                        // Next sibling may be <ul> with items for that label
                        $ul = $next->next_sibling();
                        if ($ul && strtolower($ul->tag ?? '') === 'ul') {
                            foreach ($ul->find('li') as $li) {
                                $text = trim($li->plaintext ?? '');
                                if ($text === '') {
                                    continue;
                                }
                                $changes[] = [
                                    'label' => $label ?: null,
                                    'value' => $text,
                                ];
                            }
                        }
                    }

                    // Case: <ul> immediately after <h4> without <p><strong>
                    if (strtolower($next->tag ?? '') === 'ul') {
                        foreach ($next->find('li') as $li) {
                            $text = trim($li->plaintext ?? '');
                            if ($text === '') {
                                continue;
                            }
                            $changes[] = [
                                'label' => null,
                                'value' => $text,
                            ];
                        }
                    }

                    $next = $next->next_sibling();
                }

                if (!empty($changes)) {
                    $changelog_result[] = [
                        'version' => $version,
                        'date' => $version_date ?: null,
                        'changes' => $changes,
                    ];
                }
            }

            return !empty($changelog_result)
                ? json_encode($changelog_result, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES)
                : null;

        } catch (\Throwable $e) {
            return null;
        }
    }
    public static function generate_installation_growth($slug, $downloaded)
    {
        global $wpdb;
        $table_name = $wpdb->prefix . "plugins_core_information";

        // Fetch plugin row safely
        $last_downloaded = $wpdb->get_row(
            $wpdb->prepare(
                "SELECT downloaded, updated_at, installation_growth FROM $table_name WHERE slug = %s",
                $slug
            )
        );

        // Today date
        $today = date('Y-m-d');

        // Start array
        $installation_growth_json = [];

        // If previous JSON exists
        if (!empty($last_downloaded->installation_growth)) {

            $installation_growth_json = json_decode($last_downloaded->installation_growth, true);

            // Add today value
            $installation_growth_json[$today] = $downloaded;

            return json_encode($installation_growth_json);
        }

        // If no JSON, but downloaded already exists → create first entry
        if (!empty($last_downloaded->downloaded)) {

            // Extract date from updated_at
            $previous_date = explode(' ', $last_downloaded->updated_at)[0];

            $installation_growth_json[$previous_date] = (int) $last_downloaded->downloaded;
            $installation_growth_json[$today] = (int) $downloaded;

            return json_encode($installation_growth_json);
        }

        // If no previous data exists at all
        $installation_growth_json[$today] = (int) $downloaded;
        return json_encode($installation_growth_json);

    }
}
new WpPluginDirectorySinglePluginAPICallManagement();
