<?php
// Load WordPress environment safely
require_once dirname(__FILE__) . '/index.php';
require_once dirname(__FILE__) . '/wps-score-helpers.php';

class WPCreateSameGroupPluginMetricMinMax
{

    public function __construct()
    {
         
        // Check & acquire lock
        if (! wp_job_lock()) {
            echo "already running";
            return; // already running
        }

        try {
            // Call core function ONLY after lock
            $this->setWPCreateSameGroupPluginMetricMinMax();
        } finally {
            // Always release lock
            wp_job_unlock();
        }
    }

    /**
     * Main process — updates active_installs in cron_scraped_plugins_log
     */
    private function setWPCreateSameGroupPluginMetricMinMax()
    {
        $wp_latest_version = WPS_score_helpers::get_latest_wordpress_version();

        global $wpdb;

        $table_post  = $wpdb->prefix . "posts";
        $table_core  = $wpdb->prefix . "plugins_core_information";
        $table_terms = $wpdb->prefix . "term_relationships";

        $metric_plugin_info = $wpdb->get_results($wpdb->prepare("
        SELECT l.ID AS post_id, p.id AS core_id
        FROM {$table_post} AS l
        INNER JOIN {$table_core} AS p
            ON p.wp_post_id = l.ID
        WHERE l.post_status = %s
        AND p.is_wps_metric_group_done = %d
        LIMIT 100
    ", 'publish', 0));

        if (empty($metric_plugin_info)) {
            echo "No Plugin found";
            return;
        }

        // 2️⃣ Process each result
        if (! empty($metric_plugin_info)) {

            foreach ($metric_plugin_info as $single_info) {
                $target_post_id = $single_info->post_id;
                $core_row_id    = $single_info->core_id;

                $term_tax_ids = $wpdb->get_col(
                    $wpdb->prepare("
                SELECT tr.term_taxonomy_id
                FROM {$wpdb->term_relationships} AS tr
                INNER JOIN {$wpdb->term_taxonomy} AS tt
                    ON tt.term_taxonomy_id = tr.term_taxonomy_id
                WHERE tr.object_id = %d
                  AND tt.taxonomy = %s
            ", $target_post_id, 'plugin_category')
                );
                //dd($term_tax_ids);

                $placeholders = implode(',', array_fill(0, count($term_tax_ids), '%d'));

                // 2️⃣ Get all plugin groups related to these categories
                $query = "
                SELECT *
                FROM {$table_core}
                WHERE wp_post_id IN (
                    SELECT object_id
                    FROM {$wpdb->term_relationships}
                    WHERE term_taxonomy_id IN ($placeholders)
                )
            ";
                $plugin_groups = $wpdb->get_results(
                    $wpdb->prepare($query, ...$term_tax_ids)
                );
                // dd($plugin_groups);
                // exit;
                $total_plugins = count($plugin_groups);
                //dd($total_plugins);

                $active_installs_data               = [];
                $downloaded_data                    = [];
                $installation_growth_data           = [];
                $update_regency_data                = [];
                $update_frequency_data              = [];
                $wp_compatibility_data              = [];
                $support_threads_resolved_data      = [];
                $number_rating_data                 = [];
                $age_data                           = [];
                $pricing_model_data                 = [];
                $lifetime_license                   = [];
                $woocommerce_support_data           = [];
                $agency_license_data                = [];
                $performace_impact_size_data        = [];
                $performace_impact_avg_ratings_data = [];
                $php_version_data                   = [];
                $multisite_support_data             = [];
                $localization_data                  = [];
                $documentation_quality_data         = [];
                $youtube_tutorials_data             = [];
                $community_page_link_data           = [];

                foreach ($plugin_groups as $single_plugin_data) {

                    $active_installs_data[] = $single_plugin_data->active_installs;
                    $downloaded_data[]      = $single_plugin_data->downloaded;

                    $installation_growth_data[] = ! empty($single_plugin_data->installation_growth)
                        ? WPS_score_helpers::calculateRMSGrowthDownloaded($single_plugin_data->installation_growth)
                        : 0;

                    $update_regency_data[] = $single_plugin_data->last_update_days;

                    $update_frequency_data[] = $single_plugin_data->version_release_count;

                    $wp_compatibility_data[] = ($single_plugin_data->tested == $wp_latest_version) ? 1 : 0;

                    $support_threads_resolved_data[] =
                    WPS_score_helpers::calculate_support_responsiveness(
                        $single_plugin_data->support_threads,
                        $single_plugin_data->support_threads_resolved
                    );

                    $number_rating_data[] = $single_plugin_data->num_ratings;

                    $age_data[] = $single_plugin_data->plugin_age_days;

                    $pricing_model_data[] = $single_plugin_data->license_type;

                    $lifetime_license[] = $single_plugin_data->has_lifetime_license;

                    $woocommerce_support_data[] = $single_plugin_data->woocommerce_support;

                    $agency_license_data[] = $single_plugin_data->has_agency_friendly_license;

                    $performace_impact_size_data[] = $single_plugin_data->package_size_kb;

                    $performace_impact_avg_ratings_data[] = $single_plugin_data->rating;

                    $php_version_data[] = empty(trim($single_plugin_data->requires_php)) ? null : $single_plugin_data->requires_php;

                    $localization_data[] = $single_plugin_data->localization_count;

                    $documentation_quality_data[] = $single_plugin_data->documentation_quality;

                    $youtube_tutorials_data[] = ! empty($single_plugin_data->best_youtube_tutorials_link) ? 1 : 0;

                    $community_page_link_data[] = ! empty($single_plugin_data->community_page_link) ? 1 : 0;

                    $multisite_support_data[] = $single_plugin_data->is_multisite_support;
                }

                // Build Final JSON cleanly
                // $final_json = [
                //     'active_installs' => $active_installs_data, //
                //     'downloaded' => $downloaded_data, //
                //     'installation_growth' => $installation_growth_data, //
                //     'update_regency' => $update_regency_data, //
                //     'update_frequency' => $update_frequency_data, //
                //     'wp_compatibility' => $wp_compatibility_data,
                //     'support_resolved_score' => $support_threads_resolved_data, //
                //     'ratings_count' => $number_rating_data, //
                //     'plugin_age' => $age_data, //
                //     'license_type' => $pricing_model_data,//
                //     'lifetime_license' => $lifetime_license,//
                //     'woocommerce_support' => $woocommerce_support_data,//
                //     'agency_license' => $agency_license_data, //
                //     'performance_package_size_kb' => $performace_impact_size_data, //
                //     'performance_avg_rating' => $performace_impact_avg_ratings_data, //
                //     'required_php' => $php_version_data, //
                //     'localization_count' => $localization_data, //
                //     'documentation_quality' => $documentation_quality_data,//will calculate later
                //     'youtube_tutorials' => $youtube_tutorials_data,//
                //     'community_page_present' => $community_page_link_data,//
                //     'multisite_support' => $multisite_support_data,
                // ];

                // $active_stats = WPS_score_helpers::calculateMetricStats($active_installs_data);
                // $downloaded_stats = WPS_score_helpers::calculateMetricStats($downloaded_data);
                // $update_regency_stats = WPS_score_helpers::calculateMetricStats($update_regency_data);
                // $update_frequency_stats = WPS_score_helpers::calculateMetricStats($update_frequency_data);
                // $support_resolved_score_stats = WPS_score_helpers::calculateMetricStats($support_threads_resolved_data);
                // $ratings_count_stats = WPS_score_helpers::calculateMetricStats($number_rating_data);
                // $plugin_age_stats = WPS_score_helpers::calculateMetricStats($age_data);
                // $installation_growth_stats = WPS_score_helpers::calculateMetricStats($installation_growth_data);
                // $performance_package_size_kb_stats = WPS_score_helpers::calculateMetricStats($performace_impact_size_data);
                // $performance_avg_rating_stats = WPS_score_helpers::calculateMetricStats($performace_impact_avg_ratings_data);
                // $localization_count_stats = WPS_score_helpers::calculateMetricStats($localization_data);
                // $php_count_stats = WPS_score_helpers::calculateMetricStats(array_map(function ($n) {
                //     return WPS_score_helpers::count_supported_php_versions($n);
                // }, $php_version_data));
                // $license_type_stats = WPS_score_helpers::count_dynamic_keys([
                //     'free' => 'Free',
                //     'freemium' => 'Freemium',
                //     'paid' => 'Paid',
                //     'unknown' => 'Unknown'
                // ], $pricing_model_data);
                // $has_lifetime_license_stats = WPS_score_helpers::count_dynamic_keys(['1' => 'Yes', '2' => 'No', '3' => 'Nothing'], $lifetime_license);
                // $woocommerce_support_data_stats = WPS_score_helpers::count_dynamic_keys(['1' => 'Yes', '2' => 'No', '3' => 'Nothing'], $woocommerce_support_data);
                // $agency_license_stats = WPS_score_helpers::count_dynamic_keys(['1' => 'Yes', '2' => 'No', '3' => 'Nothing'], $agency_license_data);
                // $youtube_tutorials_stats = WPS_score_helpers::countValuesOfElementOn1DArray($youtube_tutorials_data);
                // $community_page_link_stats = WPS_score_helpers::countValuesOfElementOn1DArray($community_page_link_data);
                // $multisite_support_stats = WPS_score_helpers::ensure_zero_key(WPS_score_helpers::countValuesOfElementOn1DArray($multisite_support_data));

                // ======== BUILD STATS FOR EACH METRIC =========
                $all_stats = [
                    'active_installs'             => WPS_score_helpers::calculateMetricStats($active_installs_data),
                    'downloaded'                  => WPS_score_helpers::calculateMetricStats($downloaded_data),
                    'installation_growth'         => WPS_score_helpers::calculateMetricStats($installation_growth_data),
                    'update_regency'              => WPS_score_helpers::calculateMetricStats($update_regency_data),
                    'update_frequency'            => WPS_score_helpers::calculateMetricStats($update_frequency_data),
                    'wp_compatibility'            => WPS_score_helpers::countValuesOfElementOn1DArray($wp_compatibility_data),
                    'support_resolved_score'      => WPS_score_helpers::calculateMetricStats($support_threads_resolved_data),
                    'ratings_count'               => WPS_score_helpers::calculateMetricStats($number_rating_data),
                    'plugin_age'                  => WPS_score_helpers::calculateMetricStats($age_data),
                    'license_type'                => WPS_score_helpers::count_dynamic_keys([
                        'free'     => 'Free',
                        'freemium' => 'Freemium',
                        'paid'     => 'Paid',
                        'unknown'  => 'Unknown',
                    ], $pricing_model_data),
                    'lifetime_license'            => WPS_score_helpers::count_dynamic_keys(['1' => 'Yes', '2' => 'No', '3' => 'Nothing'], $lifetime_license),
                    'woocommerce_support'         => WPS_score_helpers::count_dynamic_keys(['1' => 'Yes', '2' => 'No', '3' => 'Nothing'], $woocommerce_support_data),
                    'agency_license'              => WPS_score_helpers::count_dynamic_keys(['1' => 'Yes', '2' => 'No', '3' => 'Nothing'], $agency_license_data),
                    'performance_package_size_kb' => WPS_score_helpers::calculateMetricStats($performace_impact_size_data),
                    'performance_avg_rating'      => WPS_score_helpers::calculateMetricStats($performace_impact_avg_ratings_data),
                    'required_php'                => WPS_score_helpers::calculateMetricStats(array_map(function ($n) {
                        return WPS_score_helpers::count_supported_php_versions($n);
                    }, $php_version_data)),
                    'localization_count'          => WPS_score_helpers::calculateMetricStats($localization_data),
                    'documentation_quality'       => WPS_score_helpers::calculateMetricStats($documentation_quality_data),
                    'youtube_tutorials'           => WPS_score_helpers::countValuesOfElementOn1DArray($youtube_tutorials_data),
                    'community_page_present'      => WPS_score_helpers::countValuesOfElementOn1DArray($community_page_link_data),
                    'multisite_support'           => WPS_score_helpers::ensure_zero_key(
                        WPS_score_helpers::countValuesOfElementOn1DArray($multisite_support_data)
                    ),
                ];

                // Encode final JSON
                $final_json_encoded = json_encode($all_stats);

                // Save into database
                $wpdb->update(
                    $table_core,
                    [
                        'wps_metric_group_info'    => $final_json_encoded,
                        'is_wps_metric_group_done' => 1,
                    ],
                    ['id' => $core_row_id],
                    ['%s', '%d'],
                    ['%d']
                );

            }

        }

        update_option('create_same_group_plugin_metric_min_max_last_run', current_time('mysql'), false);

    }

}

// Instantiate the class
new WPCreateSameGroupPluginMetricMinMax();
