<?php
//Custom table creation Hook
add_action('switch_theme', array('Custom_table_creation', 'create_custom_table'));
//Custom table defination Sync
add_action('admin_menu', array('Custom_table_creation', 'manage_add_management_page'));
//Custom table clear scrap flag
add_action('admin_menu', array('Custom_table_creation', 'manage_clear_scrap_flag_to_recrawl'));




// Enque Scripts
add_action('wp_enqueue_scripts', array('css_js_loader_frontend', 'wpsearch_scripts'));


// Settings
add_action('admin_menu', array('site_settings', 'wpsearch_custom_settings_menu'));

// theme option
add_action('admin_menu', array('theme_option_management', 'theme_option_management_menu'));

// Scrap Log

add_action('admin_menu', array('scrap_log_management', 'scrap_log_management_menu'));

// custom post functionalities plugins cpt
add_action('init', ['Custom_post_functionalities', 'register_plugins_cpt'], 0);
add_action('init', ['Custom_post_functionalities', 'register_plugin_category_taxonomy'], 1);
add_action('init', ['Custom_post_functionalities', 'register_plugin_tag_taxonomy'], 2);
add_filter('manage_plugins_posts_columns', ['Custom_post_functionalities', 'manage_plugins_posts_columns']);
add_action('manage_plugins_posts_custom_column', ['Custom_post_functionalities', 'manage_plugins_posts_custom_column'], 10, 2);
add_action('manage_edit-plugins_sortable_columns', ['Custom_post_functionalities', 'plugins_sortable_columns_thum_issue'], 10, 2);



// custom faq functionalities
add_action('init', ['Custom_post_functionalities', 'register_faq_cpt']);

// custom customer review functionalities
add_action('init', ['Custom_post_functionalities', 'register_customer_review_cpt']);

// custom customer review functionalities
add_action('init', ['Custom_post_functionalities', 'register_plugin_comparison_cpt']);
add_action('init', ['Custom_post_functionalities', 'register_plugin_comparison_taxonomy'], 1);
add_filter('manage_plugin_comparison_posts_columns', ['Custom_post_functionalities', 'comparison_posts_columns']);

add_action('manage_plugin_comparison_posts_custom_column', ['Custom_post_functionalities', 'comparison_posts_custom_column'], 10, 2);

// NOT sortable (icons only)
add_filter('manage_edit-plugin_comparison_sortable_columns', ['Custom_post_functionalities', 'comparison_sortable_columns_fix']);


//MetaBox pluguins
add_action('add_meta_boxes', ['Custom_post_functionalities', 'add_metabox_init_function']);
add_action('save_post_plugins', ['Custom_post_functionalities', 'plugins_save_meta'], 10, 3);
add_action('before_delete_post', ['Custom_post_functionalities', 'plugin_post_deleted']);

//MetaBox faq pluguins
add_action('add_meta_boxes', array('Custom_post_functionalities', 'faq_meta_box_tabs'));
add_action('save_post_home_page_faq', array('Custom_post_functionalities', 'save_home_page_faq_meta_box_data'), 10, 3);


//MetaBox faq pluguins
add_action('add_meta_boxes', array('Custom_post_functionalities', 'plugin_comparison_tabs'));
add_action('save_post_plugin_comparison', array('Custom_post_functionalities', 'save_plugin_comparison_save_metabox'), 10, 3);
//add_action('save_post_home_page_faq', array('Custom_post_functionalities', 'save_home_page_faq_meta_box_data'), 10, 3);

//Duplicate Category Mapping
//add_action('admin_menu', array('duplicate_category_managemnt', 'duplicate_category_managemnt'));
//Plugin Comparison Management
add_action('admin_menu', array('plugin_comparison_managemnt', 'plugin_comparison_managemnt'));

//admin common callback
add_action('admin_enqueue_scripts', ['admin_common_hooks', 'admin_enqueue_scripts_callback']);
//register menu
add_action('after_setup_theme', ['admin_common_hooks', 'wpsearch_register_menus']);





/**
 * Add the plugin_category dropdown filter in the admin list
 */
add_action('restrict_manage_posts', ['admin_post_query_modification', 'restrict_manage_posts_plugin_cpt_category']);
/**
 * Filter posts by selected taxonomy in admin
 */
add_filter('parse_query', ['admin_post_query_modification', 'parse_query_plugin_cpt_category']);
/**
 * Ensure plugin_category filtering in admin only shows posts in that category (not children)
 */
add_action('pre_get_posts', ['admin_post_query_modification', 'pre_get_post_query_plugin_cpt_category']);

/**
 * Add the plugin_tag dropdown filter in the admin list
 */
add_action('restrict_manage_posts', ['admin_post_query_modification', 'restrict_manage_posts_plugin_cpt_tag']);
/**
 * Filter posts by selected taxonomy in admin
 */
add_filter('parse_query', ['admin_post_query_modification', 'parse_query_plugin_cpt_tag']);
/**
 * Ensure plugin_category filtering in admin only shows posts in that category (not children)
 */
add_action('pre_get_posts', ['admin_post_query_modification', 'pre_get_post_query_plugin_cpt_tag']);

//plugin docs information , pro information

add_action('admin_menu', ['plugin_pro_info_management', 'plugin_json_files_menu']);




//Taxonomy Feature Image
add_action('plugin_category_add_form_fields', ['PluginCategoryTaxonomyManagement', 'plugin_category_add_form_fields']);
add_action('plugin_category_edit_form_fields', ['PluginCategoryTaxonomyManagement', 'plugin_category_edit_form_fields']);
add_action('created_plugin_category', ['PluginCategoryTaxonomyManagement', 'plugin_category_save_image']);
add_action('edited_plugin_category', ['PluginCategoryTaxonomyManagement', 'plugin_category_save_image']);
add_filter('manage_edit-plugin_category_columns', ['PluginCategoryTaxonomyManagement', 'plugin_category_add_image_column']);
add_filter('manage_plugin_category_custom_column', ['PluginCategoryTaxonomyManagement', 'plugin_category_image_column_content'], 10, 3);
//add_action('admin_menu', ['PluginCategoryTaxonomyManagement', 'add_json_manager_menu']);




//rewrite_rules
add_filter('rewrite_rules_array', array('Rewrite_rules', 'add_rewrite_rules_search'));
add_filter('rewrite_rules_array', array('Rewrite_rules', 'add_rewrite_rules_saved_plugin_recommendation'));



//all hooks related magic login
add_action('init', array("User_login_registration", "handle_magic_login"),1);
add_action('init', array('User_login_registration', 'handle_google_login'),1);
add_action('wp_login',array("User_login_registration", "wps_ai_guest_recommendation"),10, 2);
add_action('after_setup_theme',array("Rewrite_rules", "handle_adminbar"));

add_action('login_errors', function($errors) {
    if (isset($_GET['login_error']) && $_GET['login_error'] === 'google_oauth') {
        $message = isset($_GET['error_message']) ? urldecode($_GET['error_message']) : 'Google login failed.';
        $errors .= '<strong>Error:</strong> ' . esc_html($message) . '<br>';
    }
    return $errors;
});