<script>
    jQuery(function ($) {
        let currentWizard = 1;
        const totalWizards = 6;
        /* ------------------------------------------------------------
         * Modal wizard button click & tick mark toggle
         * ------------------------------------------------------------ */
        // $(".toggleButton").each(function () {
        //     const $button = $(this);
        //     const $tick = $button.find(".tickMark");
        //     const $text = $button.find(".buttonText");
        //     const $outer = $button.find(".outerBorder");

        //     $button.on("click", function (e) {
        //         e.preventDefault();

        //         $tick.toggleClass("opacity-100 translate-x-0 translate-x-full");
        //         $text.toggleClass("translate-x-3");
        //         $outer.toggleClass("opacity-100");
        //         add_features_need_in_site($(this).data("features_need_in_site"));
        //     });
        // });

        /* ------------------------------------------------------------
         * Modal open / close logic
         * ------------------------------------------------------------ */
        const $openModal = $("#openModal, #openModal1,.open-home-page-modal");
        const $closeModal = $("#closeModal");
        const $blogModal = $("#blogModal");
        const $body = $("body");

        // Open modal
        $openModal.on("click", function (e) {
            e.preventDefault();

            $blogModal
                .removeClass("opacity-0 pointer-events-none")
                .addClass("opacity-100");

            $body.addClass("overflow-hidden");
        });

        // Close modal
        $closeModal.on("click", function () {
            closeModal();
        });

        // Click outside modal
        $blogModal.on("click", function (e) {
            if ($(e.target).is("#blogModal")) {
                closeModal();
            }
        });

        function closeModal() {
            $blogModal
                .addClass("opacity-0 pointer-events-none")
                .removeClass("opacity-100");

            $body.removeClass("overflow-hidden");
        }

        /* ------------------------------------------------------------
         * Wizard navigation logic
         * ------------------------------------------------------------ */
        $(".wizard-link").on("click", function (e) {
            e.preventDefault();
            const wizardNumber = parseInt($(this).data("wizard"), 10);
            goToWizard(wizardNumber);
        });

        // Default wizard on load

        $("#wizard-" + currentWizard).removeClass("hidden");

        $(".wizard-link").each(function () {
            const btnNumber = parseInt($(this).data("wizard"), 10);

            if (btnNumber <= currentWizard) {
                $(this).addClass("active");
            } else {
                $(this).removeClass("active");
            }
        });

        // Handle Prev button visibility
        if (currentWizard === 1) {
            $("#sticky-button-prev").addClass("hidden");
        } else {
            $("#sticky-button-prev").removeClass("hidden");
        }

        $("#sticky-button").addClass("hidden");

        /* ------------------------------------------------------------
         * Dashboard tabs (pure JS but safe inside wrapper)
         * ------------------------------------------------------------ */
        const tabBtns = document.querySelectorAll(".tabBtnPlugin");
        const tabContents = document.querySelectorAll(".tabContentPlugin");

        tabBtns.forEach((tab) => {
            tab.addEventListener("click", () => {
                const target = tab.getAttribute("data-tab");

                tabBtns.forEach((t) => {
                    t.classList.remove("border-[#1A2DC9]", "text-[#1A1A1A]", "font-bold");
                    t.classList.add("border-transparent", "text-[#A1A7B1]", "font-normal");
                });

                tabContents.forEach((c) => c.classList.add("hidden"));

                tab.classList.add("border-[#1A2DC9]", "text-[#1A1A1A]", "font-bold");
                tab.classList.remove("border-transparent", "text-[#A1A7B1]", "font-normal");

                document.getElementById(target)?.classList.remove("hidden");

                document
                    .querySelector(".space-y-12")
                    ?.scrollIntoView({
                        behavior: "smooth",
                        block: "start"
                    });
            });
        });

        function add_features_need_in_site(item) {
            let field = $("#features_need_in_site");

            // Get existing value
            let current = field.val().trim();

            // Convert to array
            let features = current ? current.split(",") : [];

            // Normalize (trim & remove empty)
            features = features.map(v => v.trim()).filter(v => v !== "");

            let index = features.indexOf(item);

            if (index !== -1) {
                // Remove if already exists
                features.splice(index, 1);
            } else {
                // Add if not exists
                features.push(item);
            }

            // Save back as comma separated string
            field.val(features.join(","));
        }

        function goToWizard(wizardNumber) {
            wizardNumber = Math.max(1, Math.min(totalWizards, wizardNumber));
            currentWizard = wizardNumber;

            $(".wizard-content").addClass("hidden");
            $("#wizard-" + wizardNumber).removeClass("hidden");

            $(".wizard-link").each(function () {
                const btnNumber = parseInt($(this).data("wizard"), 10);
                $(this).toggleClass("active", btnNumber <= wizardNumber);
            });

            // Sticky button only on step 3
            $("#sticky-button").toggleClass("hidden", wizardNumber !== 3);

            // Back button
            $("#sticky-button-prev").toggleClass("hidden", wizardNumber === 1);
        }
        $("#sticky-button-prev").on("click", function () {
            goToWizard(currentWizard - 1);
        });
        $(".type_website_building").on("click", function (e) {
            e.preventDefault();

            // Set hidden input value
            $("#type_website_building").val($(this).data("type_website_building"));

            // Remove active from all
            $(".type_website_building").removeClass("active");

            // Add active to clicked one
            $(this).addClass("active");
            $(".open-home-page-modal").removeClass("active");
            const typeValue = $(this).data("type_website_building");
            $('.open-home-page-modal[data-type_website_building="' + typeValue + '"]').addClass("active");
            // Move wizard programmatically
            goToWizard(2);
        });
        $(".open-home-page-modal").on("click", function (e) {
            e.preventDefault();

            // get clicked value
            const typeValue = $(this).data("type_website_building");

            // set hidden input
            $("#type_website_building").val(typeValue);

            // remove active from all
            $(".type_website_building").removeClass("active");

            // find matching element and add active
            $('.type_website_building[data-type_website_building="' + typeValue + '"]').addClass("active");
            $(".open-home-page-modal").removeClass("active");
            $(this).addClass("active");
            // move wizard
            goToWizard(2);
        });

        $(".builder_theme_using").on("click", function (e) {
            e.preventDefault();

            // Set hidden input value
            $("#builder_theme_using").val($(this).data("builder_theme_using"));

            // Remove active from all
            $(".builder_theme_using").removeClass("active");

            // Add active to clicked one
            $(this).addClass("active");

            // Move wizard programmatically
            goToWizard(3);
        });
        $(".budget_level_plugins").on("click", function (e) {
            e.preventDefault();

            // Set hidden input value
            $("#budget_level_plugins").val($(this).data("budget_level_plugins"));

            // Remove active from all
            $(".budget_level_plugins").removeClass("active");

            // Add active to clicked one
            $(this).addClass("active");

            // Move wizard programmatically
            goToWizard(5);
        });
        $(".monthly_traffic").on("click", function (e) {
            e.preventDefault();

            // Set hidden input value
            $("#monthly_traffic").val($(this).data("monthly_traffic"));

            // Remove active from all
            $(".monthly_traffic").removeClass("active");

            // Add active to clicked one
            $(this).addClass("active");

            // Move wizard programmatically
            goToWizard(6);
        });
        $(".comfortable_configuration_settings").on("click", function (e) {
            e.preventDefault();

            // Set hidden input value
            $("#comfortable_configuration_settings").val($(this).data("comfortable_configuration_settings"));

            // Remove active from all
            $(".comfortable_configuration_settings").removeClass("active");

            // Add active to clicked one
            $(this).addClass("active");

            // Move wizard programmatically
            $("#form_recommandation").submit();
        });
        $("#sticky-button").on('click', function (e) {
            goToWizard(4);
        })
        // const selectedFeatures = $("#features_need_in_site").val().split(',').map(f => f.trim());

        // Get selected features from hidden input


        let selectedFeatures = $("#features_need_in_site").val() ?
            $("#features_need_in_site").val().split(',').map(f => f.trim()).filter(f => f) : [];

        $(".toggleButton").each(function () {
            const $button = $(this);
            const feature = $button.data("features_need_in_site"); // <-- read data attribute
            const $tick = $button.find(".tickMark");
            const $text = $button.find(".buttonText");
            const $outer = $button.find(".outerBorder");

            // Initialize button state on page load
            if (selectedFeatures.includes(feature)) {
                $tick
                    .removeClass("translate-x-full opacity-0")
                    .addClass("translate-x-0 opacity-100");
                $text.addClass("translate-x-3");
                $outer.addClass("opacity-100");
            } else {
                $tick
                    .removeClass("translate-x-0 opacity-100")
                    .addClass("translate-x-full opacity-0");
                $text.removeClass("translate-x-3");
                $outer.removeClass("opacity-100");
            }

            // Click toggle
            $button.off("click").on("click", function (e) {
                e.preventDefault();

                // Toggle tickMark
                if ($tick.hasClass("opacity-100")) {
                    $tick.removeClass("translate-x-0 opacity-100")
                        .addClass("translate-x-full opacity-0");
                } else {
                    $tick.removeClass("translate-x-full opacity-0")
                        .addClass("translate-x-0 opacity-100");
                }

                // Toggle buttonText
                $text.toggleClass("translate-x-3");

                // Toggle outerBorder
                $outer.toggleClass("opacity-100");

                // Update hidden input using data attribute
                add_features_need_in_site(feature);
            });
        });
        $("#blogRecommandationModalClose").on("click", function (e) {
            e.preventDefault();
            $blogModal
                .removeClass("opacity-100")
                .addClass("opacity-0 pointer-events-none");

            $body.removeClass("overflow-hidden");
        })
    });
</script>