<?php
$already_saved_wizard_results = multistep_plugin_select_wizard::already_saved_wizard_results();
?>

<!-- Dashboard -->
<div id="Dashboard" class="tabContentPlugin space-y-5">
    <div class="space-y-3 md:space-y-0 flex flex-col md:flex-row justify-between items-center font-bold">
        <h2 class="text-lg lg:text-xl text-black !leading-[120%]">
            Saved wizard results
        </h2>
        <a href="javascript:void(0)" id="openModal"
            class="text-base text-[#1A2DC9] !leading-[160%] duration-300 hover:opacity-75">
            Start a new wizard
        </a>
    </div>

    <div class="-m-1.5 sm:-m-2.5 md:-m-3">
        <div class="flex flex-wrap">
            <?php
            foreach ($already_saved_wizard_results as $single => $value) {
                ?>
                <div class="w-[calc(100%-12px)] sm:w-[calc(50%-20px)] md:w-[calc(33.3333%-24px)] lg:w-[calc(25%-24px)] m-1.5 sm:m-2.5 md:m-3 group relative bg-white hover:bg-black border border-[#F2F2F2] rounded-xl duration-300"
                    id="single_entry_<?= $value["id"] ?>">
                    <a href="<?php echo site_url() . "/saved-plugin-recommendation/" . $value["questions_hash"] ?>"
                        class="w-[calc(100%-42px)] p-5 md:p-6 space-y-3.5 inline-block">
                        <div class="flex items-center space-x-2.5">
                            <p class="flex items-center space-x-2">
                                <img class="<?php echo esc_html($value['is_pinned'] == 1 ? 'yellow_filter' : ''); ?> w-6 min-w-6 h-6 object-contain object-center"
                                    src="<?php echo asset_image_path_generator() ?>/pin.svg" alt="pin image" />
                                <span
                                    class="text-base text-black/80 group-hover:text-white/80 !leading-[160%] font-normal"><?php echo date('M d, Y', strtotime($value["created_at"])) ?></span>
                            </p>
                        </div>
                        <h2 class="text-xl md:text-[22px] lg:text-[25px] text-black group-hover:text-white font-bold !leading-[120%] line-clamp-3"
                            id="title_show_<?= $value["id"] ?>">
                            <?php echo $value["recommendation_title"] ?>
                        </h2>
                    </a>
                    <div class="absolute top-6 right-6">
                        <button id="dashboardDropdown_<?php echo $single ?>"
                            data-dropdown-toggle="dropdown_<?php echo $single ?>"
                            class="w-8 min-w-8 h-8 outline-none flex justify-center items-center bg-black group-hover:bg-white duration-300 rounded-full"
                            type="button">
                            <img class="black_filter w-4 min-w-4 h-4 object-contain object-center invert-[0%] sepia-[100%] saturate-[5000%] hue-rotate-[20deg]"
                                src="<?php echo asset_image_path_generator() ?>/more-fill.svg" alt="more-fill" />
                        </button>

                        <!-- Dropdown menu -->
                        <div id="dropdown_<?php echo $single ?>"
                            class="w-36 z-10 hidden bg-white border border-[#F2F2F2] shadow-[12px_12px_24px_0px_#0000001F] rounded-md">
                            <ul class="pt-2.5 pb-1.5 text-[13px] !leading-[120%] text-black font-bold"
                                aria-labelledby="dashboardDropdown_<?php echo $single ?>">
                                <li>
                                    <a href="#"
                                        class="w-full px-3 py-2.5 hover:bg-slate-100 inline-block duration-300 rename_button"
                                        data-current_title="<?= $value["recommendation_title"] ?>"
                                        data-tid="<?php echo $value["id"] ?>">Rename</a>
                                </li>
                                <li>
                                    <a href="#"
                                        class="w-full px-3 py-2.5 hover:bg-slate-100 inline-block duration-300 make_this_pinned"
                                        data-tid="<?php echo $value["id"] ?>"><?php echo esc_html($value['is_pinned'] == 0 ? 'Pin this' : 'Unpin this'); ?></a>
                                </li>
                                <li>
                                    <a href="<?php echo site_url() . "/saved-plugin-recommendation/" . $value["questions_hash"] ?>"
                                        class="w-full px-3 py-2.5 hover:bg-slate-100 inline-block duration-300">Change
                                        answer</a>
                                </li>
                                <li>
                                    <a href="#"
                                        class="w-full px-3 py-2.5 text-[#EB4335] hover:bg-slate-100 inline-block duration-300 delete"
                                        data-id="<?= $value["id"] ?>">Delete</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <?php
            }
            ?>




            <div
                class="group w-[calc(100%-12px)] sm:w-[calc(50%-20px)] md:w-[calc(33.3333%-24px)] lg:w-[calc(25%-24px)] m-1.5 sm:m-2.5 md:m-3 bg-[#F2F2F2] border border-dashed border-[#CCCCCC] rounded-xl duration-300">
                <a href="javascript:void(0)" id="openModal1"
                    class="h-full w-full flex justify-center items-center p-5 md:p-6 space-y-3.5">
                    <div
                        class="w-[54px] min-w-[54px] h-[54px] flex justify-center items-center bg-[#A1A7B1] group-hover:bg-slate-400 rounded-full group-hover:rotate-180 duration-500">
                        <img class="w-6 min-w-6 h-6 object-contain object-center"
                            src="<?php echo asset_image_path_generator() ?>/plus.svg" alt="plus" />
                    </div>
                </a>
            </div>
        </div>
    </div>
</div>
<script>
    jQuery(function ($) {
        $(".make_this_pinned").on('click', function (e) {
            e.preventDefault();
            $.ajax({
                url: '<?php echo admin_url('admin-ajax.php'); ?>',
                type: "POST",
                dataType: "json",
                data: {
                    action: "pin_the_recomandation",
                    id: $(this).data('tid')
                },
                success: function (data) {
                    location.reload();
                }
            });
        })

        $(".rename_button").on("click", function () {

            const currentTitle = $(this).data("current_title");
            const tid = $(this).data("tid");

            const formHtml = `
    <div class="fixed inset-0 bg-black/60 flex items-center justify-center z-50">
        <div class="bg-white w-full max-w-md rounded-xl shadow-lg p-6 relative">

            <button id="closeModalBtnWPSScore" class="absolute top-3 right-3 text-gray-500 hover:text-black text-xl">&times;</button>

            <h2 class="text-xl font-semibold mb-4">Rename Title</h2>

            <form id="renameForm" class="space-y-4">

                <input type="hidden" id="recommandation_id" value="${tid}">

                <div>
                    <label class="block text-sm font-medium mb-1">Title</label>
                    <input 
                        id="title_rename"
                        type="text"
                        value="${currentTitle}"
                        class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring focus:ring-blue-300 focus:outline-none"
                        required
                    >
                </div>

                <div class="flex justify-end gap-3 pt-4">
                    <button type="button" id="cancelRename" class="px-4 py-2 rounded-lg border">Cancel</button>
                    <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-5 py-2 rounded-lg">
                        Save
                    </button>
                </div>

            </form>
        </div>
    </div>
    `;

            $("#infoModal").html(formHtml).removeClass("hidden");
            $("body").addClass("overflow-hidden");

        });
        $(document).on("click", "#closeModalBtnWPSScore, #cancelRename", function () {
            $("#infoModal").addClass("hidden").html("");
            $("body").removeClass("overflow-hidden");
        });
        $(document).on("submit", "#renameForm", function (e) {
            e.preventDefault();

            $.ajax({
                url: '<?php echo admin_url('admin-ajax.php'); ?>',
                type: "POST",
                dataType: "json",
                data: {
                    action: "rename_the_title",
                    title: $("#title_rename").val(),
                    id: $("#recommandation_id").val()
                },
                success: function (data) {
                    const newTitle = $("#title_rename").val();
                    const id = $("#recommandation_id").val();

                    // 🔥 Update the H1 live without reload
                    $("#title_show_" + id).text(newTitle);
                    Swal.fire({
                        icon: 'success',
                        text: 'Title updated successfully',
                        showConfirmButton: false,
                        timer: 2000
                    });

                    // Close modal after success
                    $("#infoModal").addClass("hidden").html("");
                    $("body").removeClass("overflow-hidden");

                }
            });
        });
        $(document).on("click", ".delete", function (e) {
            e.preventDefault();

            const id = $(this).data("id");

            Swal.fire({
                title: "Are you sure?",
                text: "This will permanently delete this entry.",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Yes, delete it",
                cancelButtonText: "Cancel",
                confirmButtonColor: "#d33",
            }).then((result) => {

                if (!result.isConfirmed) return;

                Swal.showLoading();

                $.ajax({
                    url: '<?php echo admin_url("admin-ajax.php"); ?>',
                    type: "POST",
                    dataType: "json",
                    data: {
                        action: "delete_recommendation",
                        id: id
                    },
                    success: function (response) {

                        if (response.success) {

                            // 🔥 Remove from DOM with animation
                            $("#single_entry_" + id).fadeOut(300, function () {
                                $(this).remove();
                            });

                            Swal.fire({
                                icon: "success",
                                title: "Deleted!",
                                text: "Entry has been removed.",
                                timer: 2000,
                                showConfirmButton: false
                            });

                        } else {
                            Swal.fire("Error", response.data || "Delete failed",
                                "error");
                        }
                    },
                    error: function () {
                        Swal.fire("Error", "Server error occurred", "error");
                    }
                });

            });
        });

    });
</script>